/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*M!100616 SET @OLD_NOTE_VERBOSITY=@@NOTE_VERBOSITY, NOTE_VERBOSITY=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int(11) NOT NULL,
  `type` enum('debit','credit') NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int(11) NOT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `transaction_payment_id` int(11) DEFAULT NULL,
  `transfer_transaction_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
INSERT INTO `account_transactions` VALUES
(1,1,'debit',NULL,31399.0000,NULL,'2025-05-25 23:46:00',3,5,1,NULL,NULL,NULL,'2025-05-25 23:46:54','2025-05-25 23:46:54'),
(2,1,'debit',NULL,21140.2000,NULL,'2025-05-26 00:11:00',3,6,2,NULL,NULL,NULL,'2025-05-26 00:11:21','2025-05-26 00:11:21'),
(3,1,'debit',NULL,600.0000,NULL,'2025-05-26 00:23:00',3,7,3,NULL,NULL,NULL,'2025-05-26 00:23:09','2025-05-26 00:23:09'),
(4,1,'debit',NULL,23860.7500,NULL,'2025-05-26 00:34:00',3,8,4,NULL,NULL,NULL,'2025-05-26 00:34:53','2025-05-26 00:34:53'),
(5,1,'debit',NULL,7554.0000,NULL,'2025-05-26 00:44:00',3,9,5,NULL,NULL,NULL,'2025-05-26 00:44:11','2025-05-26 00:44:11'),
(6,1,'credit',NULL,220.0000,NULL,'2025-05-26 07:53:13',6,10,6,NULL,NULL,NULL,'2025-05-26 07:53:13','2025-05-26 07:53:13'),
(7,1,'credit',NULL,650.0000,NULL,'2025-05-26 08:43:09',6,11,7,NULL,NULL,NULL,'2025-05-26 08:43:09','2025-05-26 08:43:09'),
(8,1,'credit',NULL,13.0000,NULL,'2025-05-26 09:27:22',6,12,8,NULL,NULL,NULL,'2025-05-26 09:27:22','2025-05-26 09:27:22'),
(9,1,'credit',NULL,30.0000,NULL,'2025-05-26 09:29:35',6,13,9,NULL,NULL,NULL,'2025-05-26 09:29:35','2025-05-26 09:29:35'),
(10,1,'credit',NULL,120.0000,NULL,'2025-05-26 09:37:43',6,14,10,NULL,NULL,NULL,'2025-05-26 09:37:43','2025-05-26 09:37:43'),
(11,1,'credit',NULL,72.0000,NULL,'2025-05-26 12:02:42',3,18,12,NULL,NULL,NULL,'2025-05-26 12:02:43','2025-05-26 12:02:43'),
(12,1,'credit',NULL,90.0000,NULL,'2025-05-26 12:57:09',3,19,13,NULL,NULL,NULL,'2025-05-26 12:57:09','2025-05-26 12:57:09'),
(13,1,'credit',NULL,120.0000,NULL,'2025-05-26 14:19:40',3,22,14,NULL,NULL,NULL,'2025-05-26 14:19:40','2025-05-26 14:19:40'),
(14,1,'credit',NULL,75.0000,NULL,'2025-05-26 16:50:45',6,26,15,NULL,NULL,NULL,'2025-05-26 16:50:45','2025-05-26 16:50:45');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `parent_account_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
INSERT INTO `account_types` VALUES
(1,'Expense',NULL,1,'2021-04-04 07:44:43','2021-04-04 07:44:43'),
(2,'Revenue',NULL,1,'2021-04-04 07:45:29','2021-04-04 07:45:29');
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `account_number` varchar(191) NOT NULL,
  `account_details` text DEFAULT NULL,
  `account_type_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES
(1,1,'Sales Account','ACC001',NULL,2,NULL,1,0,NULL,'2021-11-08 09:48:35','2021-11-08 09:48:35'),
(2,1,'Expense Acount','ACC002',NULL,1,NULL,1,0,NULL,'2021-11-08 09:49:39','2022-06-16 11:16:02');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) DEFAULT NULL,
  `description` text NOT NULL,
  `subject_id` int(11) DEFAULT NULL,
  `subject_type` varchar(191) DEFAULT NULL,
  `event` varchar(191) DEFAULT NULL,
  `business_id` int(11) DEFAULT NULL,
  `causer_id` int(11) DEFAULT NULL,
  `causer_type` varchar(191) DEFAULT NULL,
  `properties` text DEFAULT NULL,
  `batch_uuid` char(36) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=88 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES
(1,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-23 06:14:53','2025-05-23 06:14:53'),
(2,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-05-23 06:15:15','2025-05-23 06:15:15'),
(3,'default','edited',2,'App\\User',NULL,1,2,'App\\User','{\"name\":\" Developer \"}',NULL,'2025-05-23 06:16:24','2025-05-23 06:16:24'),
(4,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-05-23 06:16:41','2025-05-23 06:16:41'),
(5,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2025-05-23 06:16:55','2025-05-23 06:16:55'),
(6,'default','edited',2,'App\\User',NULL,1,2,'App\\User','{\"name\":\" Developer \"}',NULL,'2025-05-23 06:22:31','2025-05-23 06:22:31'),
(7,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-23 08:01:23','2025-05-23 08:01:23'),
(8,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-23 08:05:23','2025-05-23 08:05:23'),
(9,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-23 08:46:47','2025-05-23 08:46:47'),
(10,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-23 08:47:24','2025-05-23 08:47:24'),
(11,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-23 08:47:41','2025-05-23 08:47:41'),
(12,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-23 13:15:29','2025-05-23 13:15:29'),
(13,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-23 14:04:08','2025-05-23 14:04:08'),
(14,'default','added',1,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-23 14:25:01','2025-05-23 14:25:01'),
(15,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-23 14:25:09','2025-05-23 14:25:09'),
(16,'default','edited',1,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-23 14:46:46','2025-05-23 14:46:46'),
(17,'default','added',2,'App\\Transaction',NULL,1,6,'App\\User','[]',NULL,'2025-05-23 15:03:22','2025-05-23 15:03:22'),
(18,'default','added',3,'App\\Transaction',NULL,1,6,'App\\User','[]',NULL,'2025-05-23 15:51:30','2025-05-23 15:51:30'),
(19,'default','edited',2,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-23 16:11:19','2025-05-23 16:11:19'),
(20,'default','edited',2,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-23 16:28:06','2025-05-23 16:28:06'),
(21,'default','added',4,'App\\Transaction',NULL,1,6,'App\\User','[]',NULL,'2025-05-23 16:37:39','2025-05-23 16:37:39'),
(22,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 10:30:16','2025-05-24 10:30:16'),
(23,'default','edited',3,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 11:13:08','2025-05-24 11:13:08'),
(24,'default','edited',1,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 11:25:32','2025-05-24 11:25:32'),
(25,'default','edited',4,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 13:40:10','2025-05-24 13:40:10'),
(26,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-24 14:39:10','2025-05-24 14:39:10'),
(27,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-24 15:08:01','2025-05-24 15:08:01'),
(28,'default','logout',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-24 15:48:14','2025-05-24 15:48:14'),
(29,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 15:48:26','2025-05-24 15:48:26'),
(30,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 18:20:09','2025-05-24 18:20:09'),
(31,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-24 18:20:39','2025-05-24 18:20:39'),
(32,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 23:10:10','2025-05-24 23:10:10'),
(33,'default','edited',2,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 23:15:01','2025-05-24 23:15:01'),
(34,'default','edited',1,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 23:17:53','2025-05-24 23:17:53'),
(35,'default','edited',3,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 23:22:58','2025-05-24 23:22:58'),
(36,'default','edited',4,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-24 23:28:34','2025-05-24 23:28:34'),
(37,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-25 12:09:46','2025-05-25 12:09:46'),
(38,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-25 14:04:42','2025-05-25 14:04:42'),
(39,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-25 14:57:03','2025-05-25 14:57:03'),
(40,'default','login',4,'App\\User',NULL,1,4,'App\\User','[]',NULL,'2025-05-25 18:31:22','2025-05-25 18:31:22'),
(41,'default','logout',4,'App\\User',NULL,1,4,'App\\User','[]',NULL,'2025-05-25 18:31:56','2025-05-25 18:31:56'),
(42,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-25 22:20:54','2025-05-25 22:20:54'),
(43,'default','edited',4,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-25 22:29:54','2025-05-25 22:29:54'),
(44,'default','added',5,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":31399}}',NULL,'2025-05-25 23:43:56','2025-05-25 23:43:56'),
(45,'default','payment_edited',5,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"31399.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"31399.0000\"}}',NULL,'2025-05-25 23:46:54','2025-05-25 23:46:54'),
(46,'default','added',6,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":21140.2}}',NULL,'2025-05-26 00:09:51','2025-05-26 00:09:51'),
(47,'default','payment_edited',6,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"21140.2000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"21140.2000\"}}',NULL,'2025-05-26 00:11:21','2025-05-26 00:11:21'),
(48,'default','edited',6,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":21140.2},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"21140.2000\"}}',NULL,'2025-05-26 00:13:20','2025-05-26 00:13:20'),
(49,'default','added',7,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2025-05-26 00:23:00','2025-05-26 00:23:00'),
(50,'default','payment_edited',7,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2025-05-26 00:23:09','2025-05-26 00:23:09'),
(51,'default','added',8,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":23860.75}}',NULL,'2025-05-26 00:34:38','2025-05-26 00:34:38'),
(52,'default','payment_edited',8,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"23860.7500\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"23860.7500\"}}',NULL,'2025-05-26 00:34:53','2025-05-26 00:34:53'),
(53,'default','added',9,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7554}}',NULL,'2025-05-26 00:43:53','2025-05-26 00:43:53'),
(54,'default','payment_edited',9,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"7554.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"7554.0000\"}}',NULL,'2025-05-26 00:44:11','2025-05-26 00:44:11'),
(55,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 00:46:57','2025-05-26 00:46:57'),
(56,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-26 07:50:55','2025-05-26 07:50:55'),
(57,'default','added',10,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":220}}',NULL,'2025-05-26 07:53:13','2025-05-26 07:53:13'),
(58,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 08:21:47','2025-05-26 08:21:47'),
(59,'default','added',11,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2025-05-26 08:43:09','2025-05-26 08:43:09'),
(60,'default','added',12,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13}}',NULL,'2025-05-26 09:27:22','2025-05-26 09:27:22'),
(61,'default','added',13,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":30}}',NULL,'2025-05-26 09:29:35','2025-05-26 09:29:35'),
(62,'default','added',14,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2025-05-26 09:37:43','2025-05-26 09:37:43'),
(63,'default','added',293,'App\\Contact',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 10:57:39','2025-05-26 10:57:39'),
(64,'default','added',15,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 11:02:03','2025-05-26 11:02:03'),
(65,'default','added',16,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 11:09:26','2025-05-26 11:09:26'),
(66,'default','so_deleted',15,'App\\Transaction',NULL,1,3,'App\\User','{\"id\":15,\"invoice_no\":\"SO2025\\/0001\"}',NULL,'2025-05-26 11:10:59','2025-05-26 11:10:59'),
(67,'default','edited',16,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 11:12:14','2025-05-26 11:12:14'),
(68,'default','added',17,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1452}}',NULL,'2025-05-26 11:13:13','2025-05-26 11:13:13'),
(69,'default','added',18,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":72}}',NULL,'2025-05-26 12:02:43','2025-05-26 12:02:43'),
(70,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-26 12:28:02','2025-05-26 12:28:02'),
(71,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-26 12:35:02','2025-05-26 12:35:02'),
(72,'default','login',4,'App\\User',NULL,1,4,'App\\User','[]',NULL,'2025-05-26 12:49:41','2025-05-26 12:49:41'),
(73,'default','added',19,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":90}}',NULL,'2025-05-26 12:57:09','2025-05-26 12:57:09'),
(74,'default','logout',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-26 13:07:06','2025-05-26 13:07:06'),
(75,'default','login',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 13:07:52','2025-05-26 13:07:52'),
(76,'default','added',20,'App\\Transaction',NULL,1,4,'App\\User','[]',NULL,'2025-05-26 13:30:48','2025-05-26 13:30:48'),
(77,'default','added',21,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 13:38:40','2025-05-26 13:38:40'),
(78,'default','added',22,'App\\Transaction',NULL,1,3,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2025-05-26 14:19:40','2025-05-26 14:19:40'),
(79,'default','added',23,'App\\Transaction',NULL,1,4,'App\\User','[]',NULL,'2025-05-26 14:20:49','2025-05-26 14:20:49'),
(80,'default','added',24,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 14:53:26','2025-05-26 14:53:26'),
(81,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2025-05-26 16:12:46','2025-05-26 16:12:46'),
(82,'default','added',25,'App\\Transaction',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 16:14:22','2025-05-26 16:14:22'),
(83,'default','logout',3,'App\\User',NULL,1,3,'App\\User','[]',NULL,'2025-05-26 16:14:43','2025-05-26 16:14:43'),
(84,'default','login',6,'App\\User',NULL,1,6,'App\\User','[]',NULL,'2025-05-26 16:15:06','2025-05-26 16:15:06'),
(85,'default','added',26,'App\\Transaction',NULL,1,6,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":75}}',NULL,'2025-05-26 16:50:46','2025-05-26 16:50:46'),
(86,'default','logout',4,'App\\User',NULL,1,4,'App\\User','[]',NULL,'2025-05-26 17:02:16','2025-05-26 17:02:16'),
(87,'default','login',14,'App\\User',NULL,1,14,'App\\User','[]',NULL,'2025-05-26 17:02:48','2025-05-26 17:02:48');
/*!40000 ALTER TABLE `activity_log` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `barcodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `barcodes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `width` double(22,4) DEFAULT NULL,
  `height` double(22,4) DEFAULT NULL,
  `paper_width` double(22,4) DEFAULT NULL,
  `paper_height` double(22,4) DEFAULT NULL,
  `top_margin` double(22,4) DEFAULT NULL,
  `left_margin` double(22,4) DEFAULT NULL,
  `row_distance` double(22,4) DEFAULT NULL,
  `col_distance` double(22,4) DEFAULT NULL,
  `stickers_in_one_row` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_continuous` tinyint(1) NOT NULL DEFAULT 0,
  `stickers_in_one_sheet` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `barcodes_business_id_foreign` (`business_id`),
  CONSTRAINT `barcodes_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `barcodes` WRITE;
/*!40000 ALTER TABLE `barcodes` DISABLE KEYS */;
INSERT INTO `barcodes` VALUES
(1,'20 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 4\" x 1\"\\r\\nLabels per sheet: 20',3.7500,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.1562,2,0,0,20,NULL,'2017-12-18 14:13:44','2017-12-18 14:13:44'),
(2,'30 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2.625\" x 1\"\\r\\nLabels per sheet: 30',2.6250,1.0000,8.5000,11.0000,0.5000,0.2198,0.0000,0.1400,3,0,0,30,NULL,'2017-12-18 14:04:39','2017-12-18 14:10:40'),
(3,'32 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1.25\"\\r\\nLabels per sheet: 32',2.0000,1.2500,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,32,NULL,'2017-12-18 13:55:40','2017-12-18 13:55:40'),
(4,'40 Labels per sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 2\" x 1\"\\r\\nLabels per sheet: 40',2.0000,1.0000,8.5000,11.0000,0.5000,0.2500,0.0000,0.0000,4,0,0,40,NULL,'2017-12-18 13:58:40','2017-12-18 13:58:40'),
(5,'50 Labels per Sheet - (8.5\" x 11\")','Sheet Size: 8.5\" x 11\"\\r\\nLabel Size: 1.5\" x 1\"\\r\\nLabels per sheet: 50',1.5000,1.0000,8.5000,11.0000,0.5000,0.5000,0.0000,0.0000,5,0,0,50,NULL,'2017-12-18 13:51:10','2017-12-18 13:51:10'),
(6,'Continuous Rolls - 31.75mm x 25.4mm','Label Size: 31.75mm x 25.4mm\\r\\nGap: 3.18mm',1.2500,1.0000,1.2500,0.0000,0.1250,0.0000,0.1250,0.0000,1,0,1,NULL,NULL,'2017-12-18 13:51:10','2017-12-18 13:51:10');
/*!40000 ALTER TABLE `barcodes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bookings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bookings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contact_id` int(10) unsigned NOT NULL,
  `waiter_id` int(10) unsigned DEFAULT NULL,
  `table_id` int(10) unsigned DEFAULT NULL,
  `correspondent_id` int(11) DEFAULT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `booking_start` datetime NOT NULL,
  `booking_end` datetime NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `booking_status` varchar(191) NOT NULL,
  `booking_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bookings_contact_id_foreign` (`contact_id`),
  KEY `bookings_business_id_foreign` (`business_id`),
  KEY `bookings_created_by_foreign` (`created_by`),
  KEY `bookings_table_id_index` (`table_id`),
  KEY `bookings_waiter_id_index` (`waiter_id`),
  KEY `bookings_location_id_index` (`location_id`),
  KEY `bookings_booking_status_index` (`booking_status`),
  KEY `bookings_correspondent_id_index` (`correspondent_id`),
  CONSTRAINT `bookings_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_contact_id_foreign` FOREIGN KEY (`contact_id`) REFERENCES `contacts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `bookings_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bookings` WRITE;
/*!40000 ALTER TABLE `bookings` DISABLE KEYS */;
/*!40000 ALTER TABLE `bookings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_business_id_foreign` (`business_id`),
  KEY `brands_created_by_foreign` (`created_by`),
  CONSTRAINT `brands_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `brands_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
INSERT INTO `brands` VALUES
(1,1,'INGCO',NULL,1,NULL,'2024-11-30 00:06:53','2024-11-30 00:06:53'),
(2,1,'WADFOW',NULL,1,NULL,'2024-11-30 00:06:53','2024-11-30 00:06:53');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `start_date` date DEFAULT NULL,
  `tax_number_1` varchar(100) DEFAULT NULL,
  `tax_label_1` varchar(10) DEFAULT NULL,
  `tax_number_2` varchar(100) DEFAULT NULL,
  `tax_label_2` varchar(10) DEFAULT NULL,
  `code_label_1` varchar(191) DEFAULT NULL,
  `code_1` varchar(191) DEFAULT NULL,
  `code_label_2` varchar(191) DEFAULT NULL,
  `code_2` varchar(191) DEFAULT NULL,
  `default_sales_tax` int(10) unsigned DEFAULT NULL,
  `default_profit_percent` double(5,2) NOT NULL DEFAULT 0.00,
  `owner_id` int(10) unsigned NOT NULL,
  `time_zone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `fy_start_month` tinyint(4) NOT NULL DEFAULT 1,
  `accounting_method` enum('fifo','lifo','avco') NOT NULL DEFAULT 'fifo',
  `default_sales_discount` decimal(5,2) DEFAULT NULL,
  `sell_price_tax` enum('includes','excludes') NOT NULL DEFAULT 'includes',
  `logo` varchar(191) DEFAULT NULL,
  `sku_prefix` varchar(191) DEFAULT NULL,
  `enable_product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `expiry_type` enum('add_expiry','add_manufacturing') NOT NULL DEFAULT 'add_expiry',
  `on_product_expiry` enum('keep_selling','stop_selling','auto_delete') NOT NULL DEFAULT 'keep_selling',
  `stop_selling_before` int(11) NOT NULL COMMENT 'Stop selling expied item n days before expiry',
  `enable_tooltip` tinyint(1) NOT NULL DEFAULT 1,
  `purchase_in_diff_currency` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Allow purchase to be in different currency then the business currency',
  `purchase_currency_id` int(10) unsigned DEFAULT NULL,
  `p_exchange_rate` decimal(20,3) NOT NULL DEFAULT 1.000,
  `transaction_edit_days` int(10) unsigned NOT NULL DEFAULT 30,
  `stock_expiry_alert_days` int(10) unsigned NOT NULL DEFAULT 30,
  `keyboard_shortcuts` text DEFAULT NULL,
  `pos_settings` text DEFAULT NULL,
  `essentials_settings` longtext DEFAULT NULL,
  `weighing_scale_setting` text NOT NULL COMMENT 'used to store the configuration of weighing scale',
  `enable_brand` tinyint(1) NOT NULL DEFAULT 1,
  `enable_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_sub_category` tinyint(1) NOT NULL DEFAULT 1,
  `enable_price_tax` tinyint(1) NOT NULL DEFAULT 1,
  `enable_purchase_status` tinyint(1) DEFAULT 1,
  `enable_lot_number` tinyint(1) NOT NULL DEFAULT 0,
  `default_unit` int(11) DEFAULT NULL,
  `enable_sub_units` tinyint(1) NOT NULL DEFAULT 0,
  `enable_racks` tinyint(1) NOT NULL DEFAULT 0,
  `enable_row` tinyint(1) NOT NULL DEFAULT 0,
  `enable_position` tinyint(1) NOT NULL DEFAULT 0,
  `enable_editing_product_from_purchase` tinyint(1) NOT NULL DEFAULT 1,
  `sales_cmsn_agnt` enum('logged_in_user','user','cmsn_agnt') DEFAULT NULL,
  `item_addition_method` tinyint(1) NOT NULL DEFAULT 1,
  `enable_inline_tax` tinyint(1) NOT NULL DEFAULT 1,
  `currency_symbol_placement` enum('before','after') NOT NULL DEFAULT 'before',
  `enabled_modules` text DEFAULT NULL,
  `date_format` varchar(191) NOT NULL DEFAULT 'm/d/Y',
  `time_format` enum('12','24') NOT NULL DEFAULT '24',
  `currency_precision` tinyint(4) NOT NULL DEFAULT 2,
  `quantity_precision` tinyint(4) NOT NULL DEFAULT 2,
  `ref_no_prefixes` text DEFAULT NULL,
  `theme_color` char(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `enable_rp` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `rp_name` varchar(191) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `amount_for_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `max_rp_per_order` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `redeem_amount_per_unit_rp` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_order_total_for_redeem` decimal(22,4) NOT NULL DEFAULT 1.0000 COMMENT 'rp is the short form of reward points',
  `min_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `max_redeem_point` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_period` int(11) DEFAULT NULL COMMENT 'rp is the short form of reward points',
  `rp_expiry_type` enum('month','year') NOT NULL DEFAULT 'year' COMMENT 'rp is the short form of reward points',
  `email_settings` text DEFAULT NULL,
  `sms_settings` text DEFAULT NULL,
  `custom_labels` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_owner_id_foreign` (`owner_id`),
  KEY `business_currency_id_foreign` (`currency_id`),
  KEY `business_default_sales_tax_foreign` (`default_sales_tax`),
  CONSTRAINT `business_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`),
  CONSTRAINT `business_default_sales_tax_foreign` FOREIGN KEY (`default_sales_tax`) REFERENCES `tax_rates` (`id`),
  CONSTRAINT `business_owner_id_foreign` FOREIGN KEY (`owner_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business` WRITE;
/*!40000 ALTER TABLE `business` DISABLE KEYS */;
INSERT INTO `business` VALUES
(1,'ROYAL EFANS Enterprise',42,'2025-05-10',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.00,1,'Africa/Accra',1,'fifo',0.00,'excludes','1636371411_favicon.png',NULL,0,'add_expiry','stop_selling',10,1,0,NULL,1.000,30,30,'{\"pos\":{\"express_checkout\":\"shift+e\",\"pay_n_ckeckout\":\"shift+p\",\"draft\":\"shift+d\",\"cancel\":\"shift+c\",\"recent_product_quantity\":\"f2\",\"weighing_scale\":null,\"edit_discount\":\"shift+i\",\"edit_order_tax\":\"shift+t\",\"add_payment_row\":\"shift+r\",\"finalize_payment\":\"shift+f\",\"add_new_product\":\"f4\"}}','{\"amount_rounding_method\":\"0.5\",\"enable_sales_order\":\"1\",\"cmmsn_calculation_type\":\"invoice_value\",\"razor_pay_key_id\":null,\"razor_pay_key_secret\":null,\"stripe_public_key\":null,\"stripe_secret_key\":null,\"disable_express_checkout\":\"1\",\"hide_product_suggestion\":\"1\",\"disable_suspend\":\"1\",\"enable_transaction_date\":\"1\",\"show_invoice_layout\":\"1\",\"show_pricing_on_product_sugesstion\":\"1\",\"customer_display_screen\":\"1\",\"display_screen_heading\":\"<p>WELCOME TO ROYAL EFANS ENTERPRISE<\\/p>\",\"cash_denominations\":null,\"enable_cash_denomination_on\":\"pos_screen\",\"disable_pay_checkout\":0,\"disable_draft\":0,\"hide_recent_trans\":0,\"disable_discount\":0,\"disable_order_tax\":0,\"is_pos_subtotal_editable\":0}',NULL,'{\"label_prefix\":null,\"product_sku_length\":\"4\",\"qty_length\":\"3\",\"qty_length_decimal\":\"2\"}',1,1,1,1,1,0,1,0,0,0,0,1,NULL,0,0,'before','[\"purchases\",\"add_sale\",\"pos_sale\",\"stock_transfers\",\"stock_adjustment\",\"expenses\",\"account\"]','d-m-Y','12',2,2,'{\"purchase\":\"PO\",\"purchase_return\":\"PR\",\"purchase_requisition\":null,\"purchase_order\":\"PY\",\"stock_transfer\":\"ST\",\"stock_adjustment\":\"SA\",\"sell_return\":\"CN\",\"expense\":\"EP\",\"contacts\":\"CO\",\"purchase_payment\":\"PP\",\"sell_payment\":\"SP\",\"expense_payment\":\"XP\",\"business_location\":\"BL\",\"username\":null,\"subscription\":null,\"draft\":\"DR\",\"sales_order\":\"SO\"}','yellow',NULL,0,NULL,1.0000,1.0000,NULL,1.0000,1.0000,NULL,NULL,NULL,'year','{\"mail_driver\":\"smtp\",\"mail_host\":\"mail.royalefansenterprise.com\",\"mail_port\":\"465\",\"mail_username\":\"info@royalefansenterprise.com\",\"mail_password\":\"cH2*Qt1Ot6Z-4z\",\"mail_encryption\":\"ssl\",\"mail_from_address\":\"info@royalefansenterprise.com\",\"mail_from_name\":\"EFANS ENTERPRISE\"}','{\"sms_service\":\"other\",\"nexmo_key\":null,\"nexmo_secret\":null,\"nexmo_from\":null,\"twilio_sid\":null,\"twilio_token\":null,\"twilio_from\":null,\"url\":\"https:\\/\\/sms.arkesel.com\\/sms\\/api\",\"send_to_param_name\":\"to\",\"msg_param_name\":\"sms\",\"request_method\":\"get\",\"header_1\":null,\"header_val_1\":null,\"header_2\":null,\"header_val_2\":null,\"header_3\":null,\"header_val_3\":null,\"param_1\":\"action\",\"param_val_1\":\"send-sms\",\"param_2\":\"api_key\",\"param_val_2\":\"OlhaRURQT0JBenFPcjVPYW8=\",\"param_3\":\"to\",\"param_val_3\":null,\"param_4\":\"from\",\"param_val_4\":\"EFANS\",\"param_5\":\"sms\",\"param_val_5\":null,\"param_6\":null,\"param_val_6\":null,\"param_7\":null,\"param_val_7\":null,\"param_8\":null,\"param_val_8\":null,\"param_9\":null,\"param_val_9\":null,\"param_10\":null,\"param_val_10\":null}','{\"payments\":{\"custom_pay_1\":null,\"custom_pay_2\":null,\"custom_pay_3\":null,\"custom_pay_4\":null,\"custom_pay_5\":null,\"custom_pay_6\":null,\"custom_pay_7\":null},\"contact\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null},\"product\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null,\"custom_field_7\":null,\"custom_field_8\":null,\"custom_field_9\":null,\"custom_field_10\":null,\"custom_field_11\":null,\"custom_field_12\":null,\"custom_field_13\":null,\"custom_field_14\":null,\"custom_field_15\":null,\"custom_field_16\":null,\"custom_field_17\":null,\"custom_field_18\":null,\"custom_field_19\":null,\"custom_field_20\":null},\"product_cf_details\":{\"1\":{\"type\":null,\"dropdown_options\":null},\"2\":{\"type\":null,\"dropdown_options\":null},\"3\":{\"type\":null,\"dropdown_options\":null},\"4\":{\"type\":null,\"dropdown_options\":null},\"5\":{\"type\":null,\"dropdown_options\":null},\"6\":{\"type\":null,\"dropdown_options\":null},\"7\":{\"type\":null,\"dropdown_options\":null},\"8\":{\"type\":null,\"dropdown_options\":null},\"9\":{\"type\":null,\"dropdown_options\":null},\"10\":{\"type\":null,\"dropdown_options\":null},\"11\":{\"type\":null,\"dropdown_options\":null},\"12\":{\"type\":null,\"dropdown_options\":null},\"13\":{\"type\":null,\"dropdown_options\":null},\"14\":{\"type\":null,\"dropdown_options\":null},\"15\":{\"type\":null,\"dropdown_options\":null},\"16\":{\"type\":null,\"dropdown_options\":null},\"17\":{\"type\":null,\"dropdown_options\":null},\"18\":{\"type\":null,\"dropdown_options\":null},\"19\":{\"type\":null,\"dropdown_options\":null},\"20\":{\"type\":null,\"dropdown_options\":null}},\"location\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"user\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"purchase_shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"sell\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null},\"shipping\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null},\"types_of_service\":{\"custom_field_1\":null,\"custom_field_2\":null,\"custom_field_3\":null,\"custom_field_4\":null,\"custom_field_5\":null,\"custom_field_6\":null}}','{\"default_credit_limit\":null,\"enable_purchase_order\":\"1\",\"default_datatable_page_entries\":\"50\"}',1,'2021-04-03 13:19:32','2099-12-31 00:00:00','2025-05-26 00:43:53');
/*!40000 ALTER TABLE `business` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `business_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `business_locations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` varchar(191) DEFAULT NULL,
  `name` varchar(256) NOT NULL,
  `landmark` text DEFAULT NULL,
  `country` varchar(100) NOT NULL,
  `state` varchar(100) NOT NULL,
  `city` varchar(100) NOT NULL,
  `zip_code` char(7) NOT NULL,
  `invoice_scheme_id` int(10) unsigned NOT NULL,
  `sale_invoice_scheme_id` int(11) DEFAULT NULL,
  `invoice_layout_id` int(10) unsigned NOT NULL,
  `sale_invoice_layout_id` int(11) DEFAULT NULL,
  `selling_price_group_id` int(11) DEFAULT NULL,
  `print_receipt_on_invoice` tinyint(1) DEFAULT 1,
  `receipt_printer_type` enum('browser','printer') NOT NULL DEFAULT 'browser',
  `printer_id` int(11) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `featured_products` text DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `default_payment_accounts` text DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `business_locations_business_id_index` (`business_id`),
  KEY `business_locations_invoice_scheme_id_foreign` (`invoice_scheme_id`),
  KEY `business_locations_invoice_layout_id_foreign` (`invoice_layout_id`),
  KEY `business_locations_sale_invoice_layout_id_index` (`sale_invoice_layout_id`),
  KEY `business_locations_selling_price_group_id_index` (`selling_price_group_id`),
  KEY `business_locations_receipt_printer_type_index` (`receipt_printer_type`),
  KEY `business_locations_printer_id_index` (`printer_id`),
  CONSTRAINT `business_locations_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_layout_id_foreign` FOREIGN KEY (`invoice_layout_id`) REFERENCES `invoice_layouts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `business_locations_invoice_scheme_id_foreign` FOREIGN KEY (`invoice_scheme_id`) REFERENCES `invoice_schemes` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `business_locations` WRITE;
/*!40000 ALTER TABLE `business_locations` DISABLE KEYS */;
INSERT INTO `business_locations` VALUES
(1,1,'BL0001','INGCO SHOP','Zongo One Way','GH','Bono','Sunyani','00233',1,1,3,3,0,1,'browser',NULL,'0542181580','0246046310','boatengfrancis941@yahoo.com',NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\",\"account\":\"1\"},\"card\":{\"is_enabled\":\"1\",\"account\":\"1\"},\"cheque\":{\"account\":null},\"bank_transfer\":{\"account\":null},\"other\":{\"is_enabled\":\"1\",\"account\":\"1\"},\"custom_pay_1\":{\"account\":null},\"custom_pay_2\":{\"account\":null},\"custom_pay_3\":{\"account\":null},\"custom_pay_4\":{\"account\":null},\"custom_pay_5\":{\"account\":null},\"custom_pay_6\":{\"account\":null},\"custom_pay_7\":{\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2021-04-03 13:19:33','2025-05-22 18:06:16'),
(2,1,'BL0002','ROYAL EFANS TOOLS','Main Market','GH','Bono','Sunyani','00233',1,1,3,3,0,1,'browser',NULL,'0542181580','0246046310','boatengfrancis941@yahoo.com',NULL,NULL,1,'{\"cash\":{\"is_enabled\":\"1\",\"account\":\"1\"},\"card\":{\"is_enabled\":\"1\",\"account\":\"1\"},\"cheque\":{\"account\":null},\"bank_transfer\":{\"account\":null},\"other\":{\"is_enabled\":\"1\",\"account\":\"1\"},\"custom_pay_1\":{\"account\":null},\"custom_pay_2\":{\"account\":null},\"custom_pay_3\":{\"account\":null},\"custom_pay_4\":{\"account\":null},\"custom_pay_5\":{\"account\":null},\"custom_pay_6\":{\"account\":null},\"custom_pay_7\":{\"account\":null}}',NULL,NULL,NULL,NULL,NULL,'2025-05-22 18:04:36','2025-05-22 18:05:47');
/*!40000 ALTER TABLE `business_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_denominations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_denominations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `total_count` int(11) NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_denominations_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_denominations` WRITE;
/*!40000 ALTER TABLE `cash_denominations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cash_denominations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_register_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_register_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_register_id` int(10) unsigned NOT NULL,
  `amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `pay_method` varchar(191) DEFAULT NULL,
  `type` enum('debit','credit') NOT NULL,
  `transaction_type` varchar(191) DEFAULT NULL,
  `transaction_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_register_transactions_cash_register_id_foreign` (`cash_register_id`),
  KEY `cash_register_transactions_transaction_id_index` (`transaction_id`),
  KEY `cash_register_transactions_type_index` (`type`),
  KEY `cash_register_transactions_transaction_type_index` (`transaction_type`),
  CONSTRAINT `cash_register_transactions_cash_register_id_foreign` FOREIGN KEY (`cash_register_id`) REFERENCES `cash_registers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_register_transactions` WRITE;
/*!40000 ALTER TABLE `cash_register_transactions` DISABLE KEYS */;
INSERT INTO `cash_register_transactions` VALUES
(1,5,220.0000,'cash','credit','sell',10,'2025-05-26 07:53:13','2025-05-26 07:53:13'),
(2,5,650.0000,'cash','credit','sell',11,'2025-05-26 08:43:09','2025-05-26 08:43:09'),
(3,5,13.0000,'cash','credit','sell',12,'2025-05-26 09:27:22','2025-05-26 09:27:22'),
(4,5,30.0000,'cash','credit','sell',13,'2025-05-26 09:29:35','2025-05-26 09:29:35'),
(5,5,120.0000,'cash','credit','sell',14,'2025-05-26 09:37:43','2025-05-26 09:37:43'),
(6,4,72.0000,'cash','credit','sell',18,'2025-05-26 12:02:43','2025-05-26 12:02:43'),
(7,4,90.0000,'cash','credit','sell',19,'2025-05-26 12:57:09','2025-05-26 12:57:09'),
(8,4,120.0000,'cash','credit','sell',22,'2025-05-26 14:19:40','2025-05-26 14:19:40'),
(9,5,75.0000,'cash','credit','sell',26,'2025-05-26 16:50:46','2025-05-26 16:50:46');
/*!40000 ALTER TABLE `cash_register_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `cash_registers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `cash_registers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `status` enum('close','open') NOT NULL DEFAULT 'open',
  `closed_at` datetime DEFAULT NULL,
  `closing_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_card_slips` int(11) NOT NULL DEFAULT 0,
  `total_cheques` int(11) NOT NULL DEFAULT 0,
  `denominations` text DEFAULT NULL,
  `closing_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_registers_business_id_foreign` (`business_id`),
  KEY `cash_registers_user_id_foreign` (`user_id`),
  KEY `cash_registers_location_id_index` (`location_id`),
  CONSTRAINT `cash_registers_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_registers_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `cash_registers` WRITE;
/*!40000 ALTER TABLE `cash_registers` DISABLE KEYS */;
INSERT INTO `cash_registers` VALUES
(1,1,1,6,'close','2025-05-24 18:20:51',0.0000,0,0,NULL,NULL,'2025-05-23 08:48:00','2025-05-24 18:20:51'),
(2,1,1,3,'close','2025-05-23 15:41:45',0.0000,0,0,NULL,NULL,'2025-05-23 15:35:00','2025-05-23 15:41:45'),
(3,1,NULL,3,'close','2025-05-25 23:02:02',0.0000,0,0,NULL,NULL,'2025-05-24 17:19:00','2025-05-25 23:02:02'),
(4,1,2,3,'open',NULL,0.0000,0,0,NULL,NULL,'2025-05-25 23:02:00','2025-05-25 23:02:24'),
(5,1,1,6,'open',NULL,0.0000,0,0,NULL,NULL,'2025-05-26 07:51:00','2025-05-26 07:51:07'),
(6,1,2,4,'open',NULL,0.0000,0,0,NULL,NULL,'2025-05-26 12:50:00','2025-05-26 12:50:11'),
(7,1,2,14,'open',NULL,0.0000,0,0,NULL,NULL,'2025-05-26 17:04:00','2025-05-26 17:04:48');
/*!40000 ALTER TABLE `cash_registers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `short_code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) NOT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `category_type` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_business_id_foreign` (`business_id`),
  KEY `categories_created_by_foreign` (`created_by`),
  KEY `categories_parent_id_index` (`parent_id`),
  CONSTRAINT `categories_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE,
  CONSTRAINT `categories_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES
(1,'General',1,'GEN',0,1,'product','Default Category',NULL,NULL,'2021-04-03 15:32:43','2021-04-03 15:32:43'),
(25,'Hardware',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-05-13 21:46:16','2025-05-13 21:46:16'),
(26,'INGCO',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-05-13 22:16:47','2025-05-13 22:16:47'),
(27,'TOOLS HUB',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-05-13 22:16:48','2025-05-13 22:16:48'),
(28,'WADFOW',1,NULL,0,1,'product',NULL,NULL,NULL,'2025-05-13 22:16:49','2025-05-13 22:16:49');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `categorizables`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `categorizables` (
  `category_id` int(11) NOT NULL,
  `categorizable_type` varchar(191) NOT NULL,
  `categorizable_id` bigint(20) unsigned NOT NULL,
  KEY `categorizables_categorizable_type_categorizable_id_index` (`categorizable_type`,`categorizable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `categorizables` WRITE;
/*!40000 ALTER TABLE `categorizables` DISABLE KEYS */;
/*!40000 ALTER TABLE `categorizables` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `type` varchar(191) NOT NULL,
  `contact_type` varchar(191) DEFAULT NULL,
  `land_mark` varchar(191) DEFAULT NULL,
  `street_name` varchar(191) DEFAULT NULL,
  `building_number` varchar(191) DEFAULT NULL,
  `additional_number` varchar(191) DEFAULT NULL,
  `supplier_business_name` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `prefix` varchar(191) DEFAULT NULL,
  `first_name` varchar(191) DEFAULT NULL,
  `middle_name` varchar(191) DEFAULT NULL,
  `last_name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `contact_id` varchar(191) DEFAULT NULL,
  `contact_status` varchar(191) NOT NULL DEFAULT 'active',
  `tax_number` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `address_line_1` text DEFAULT NULL,
  `address_line_2` text DEFAULT NULL,
  `zip_code` varchar(191) DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `mobile` varchar(191) NOT NULL,
  `landline` varchar(191) DEFAULT NULL,
  `alternate_number` varchar(191) DEFAULT NULL,
  `pay_term_number` int(11) DEFAULT NULL,
  `pay_term_type` enum('days','months') DEFAULT NULL,
  `credit_limit` decimal(22,4) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `balance` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `total_rp` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_used` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `total_rp_expired` int(11) NOT NULL DEFAULT 0 COMMENT 'rp is the short form of reward points',
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_address` text DEFAULT NULL,
  `shipping_custom_field_details` longtext DEFAULT NULL,
  `is_export` tinyint(1) NOT NULL DEFAULT 0,
  `export_custom_field_1` varchar(191) DEFAULT NULL,
  `export_custom_field_2` varchar(191) DEFAULT NULL,
  `export_custom_field_3` varchar(191) DEFAULT NULL,
  `export_custom_field_4` varchar(191) DEFAULT NULL,
  `export_custom_field_5` varchar(191) DEFAULT NULL,
  `export_custom_field_6` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `custom_field1` varchar(191) DEFAULT NULL,
  `custom_field2` varchar(191) DEFAULT NULL,
  `custom_field3` varchar(191) DEFAULT NULL,
  `custom_field4` varchar(191) DEFAULT NULL,
  `custom_field5` varchar(191) DEFAULT NULL,
  `custom_field6` varchar(191) DEFAULT NULL,
  `custom_field7` varchar(191) DEFAULT NULL,
  `custom_field8` varchar(191) DEFAULT NULL,
  `custom_field9` varchar(191) DEFAULT NULL,
  `custom_field10` varchar(191) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contacts_business_id_foreign` (`business_id`),
  KEY `contacts_created_by_foreign` (`created_by`),
  KEY `contacts_type_index` (`type`),
  KEY `contacts_contact_status_index` (`contact_status`)
) ENGINE=InnoDB AUTO_INCREMENT=294 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES
(1,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Walk-In Customer',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,0.0000,1,0.0000,0,0,0,1,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(11,1,'supplier',NULL,NULL,NULL,NULL,NULL,'INGCO GHANA (Ksi)','Mr MOHAMMED  ','Mr','MOHAMMED',NULL,NULL,NULL,'CO0009','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0552656974',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-03 10:10:44','2022-08-03 10:10:44'),
(12,1,'supplier',NULL,NULL,NULL,NULL,NULL,'BBC GHANA(PAINTS)','Mrs ELLEN BOATEMAA ASANTE','Mrs','ELLEN','BOATEMAA','ASANTE',NULL,'CO0010','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0543565978',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-07 18:40:18','2022-08-07 18:40:18'),
(13,1,'supplier',NULL,NULL,NULL,NULL,NULL,'MICK AKOSAH ENT','Mr MICHAEL AKOSAH ','Mr','MICHAEL','AKOSAH',NULL,NULL,'CO0011','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243844831',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-07 21:56:07','2022-08-07 21:56:07'),
(14,1,'supplier',NULL,NULL,NULL,NULL,NULL,'ELSHADDAI TRADING','Mr EKOW  ','Mr','EKOW',NULL,NULL,NULL,'CO0012','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0265492575',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-10 13:55:49','2022-08-10 13:55:49'),
(15,1,'supplier',NULL,NULL,NULL,NULL,NULL,'D.F JUSTICE ENTERPRISE','Mr D.F  JUSTICE','Mr','D.F',NULL,'JUSTICE',NULL,'CO0013','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246746533',NULL,'0548089577',NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-10 14:40:36','2022-08-10 14:40:36'),
(16,1,'supplier',NULL,NULL,NULL,NULL,NULL,'BOB ONE TRADING','Mr MATHIAS  ','Mr','MATHIAS',NULL,NULL,NULL,'CO0014','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241127569',NULL,'0249231824',NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-10 15:19:56','2022-08-10 15:19:56'),
(17,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SUSEC TANO HOUSE 2',NULL,'SUSEC','TANO','HOUSE 2',NULL,'CO0015','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0508157491',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-12 19:56:17','2022-08-12 19:56:17'),
(18,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ERIC OTOO ',NULL,'ERIC','OTOO',NULL,NULL,'CO0016','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246046310',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-12 19:58:52','2022-08-12 19:58:52'),
(19,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' painter  ',NULL,'painter',NULL,NULL,NULL,'CO0017','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'02',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-13 06:12:33','2022-08-13 06:12:33'),
(20,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr EFO MASTER ','Mr','EFO','MASTER',NULL,NULL,'CO0018','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246046310',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-13 09:50:59','2022-08-13 09:50:59'),
(21,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' sis joyce  ',NULL,'sis joyce',NULL,NULL,NULL,'CO0019','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0200887588',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-13 15:49:47','2022-08-13 15:49:47'),
(22,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Abdul  ',NULL,'Abdul',NULL,NULL,NULL,'CO0020','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241553094',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-15 10:08:07','2022-08-15 10:08:07'),
(23,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' cliff  ',NULL,'cliff',NULL,NULL,NULL,'CO0021','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542181580',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-15 13:05:33','2022-08-15 13:05:33'),
(24,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ALEX OPPONG ANTWI',NULL,'ALEX','OPPONG','ANTWI',NULL,'CO0022','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0544575156',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-15 13:34:33','2022-08-15 13:34:33'),
(25,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' AMPONSAH PRINCE ',NULL,'AMPONSAH','PRINCE',NULL,NULL,'CO0023','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0248784586',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-15 15:45:16','2022-08-15 15:45:16'),
(26,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr CITY BARBER ','Mr','CITY','BARBER',NULL,NULL,'CO0024','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542181580',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-15 16:17:56','2022-08-15 16:17:56'),
(27,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' CHARLES OPPONG ',NULL,'CHARLES','OPPONG',NULL,NULL,'CO0025','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542673757',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-16 06:45:46','2022-08-16 06:45:46'),
(28,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' DERRICK OFORI YEBOAH',NULL,'DERRICK','OFORI','YEBOAH',NULL,'CO0026','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0548539414',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-17 16:04:54','2022-08-17 16:04:54'),
(29,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ABESS TT HARDWARE','Mr','ABESS','TT','HARDWARE',NULL,'CO0027','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0245326233',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-18 11:37:18','2022-08-18 11:37:18'),
(30,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SUGAR  ',NULL,'SUGAR',NULL,NULL,NULL,'CO0028','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243903637',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-18 12:12:32','2022-08-18 12:12:32'),
(31,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SAMPSON  ',NULL,'SAMPSON',NULL,NULL,NULL,'CO0029','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0242984139',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-18 12:14:22','2022-08-18 12:14:22'),
(32,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ESTE  ',NULL,'ESTE',NULL,NULL,NULL,'CO0030','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249389981',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-18 14:01:24','2022-08-18 14:01:24'),
(33,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ISAAC KWADWO ',NULL,'ISAAC','KWADWO',NULL,NULL,'CO0031','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0592476146',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-19 08:12:33','2022-08-19 08:12:33'),
(34,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr mark  ','Mr','mark',NULL,NULL,NULL,'CO0032','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246046310',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-20 14:08:22','2022-08-20 14:08:22'),
(35,1,'supplier',NULL,NULL,NULL,NULL,NULL,'WHO IS FREE ENT','Mr EBENEZER  OTOO','Mr','EBENEZER',NULL,'OTOO',NULL,'CO0033','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249465999',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-21 19:49:32','2022-08-21 19:49:32'),
(36,1,'supplier',NULL,NULL,NULL,NULL,NULL,'ROPE COMPANY','Mrs ESTHER  APOH','Mrs','ESTHER',NULL,'APOH',NULL,'CO0034','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0244108292',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-21 19:52:08','2022-08-21 19:52:08'),
(37,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr AUGUSTINE  ','Mr','AUGUSTINE',NULL,NULL,NULL,'CO0035','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249376687',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-22 11:31:02','2022-08-22 11:31:02'),
(38,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr PROSPER  OTOO','Mr','PROSPER',NULL,'OTOO',NULL,'CO0036','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249917491',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-24 07:38:52','2022-08-24 07:38:52'),
(39,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs kate  ','Mrs','kate',NULL,NULL,NULL,'CO0037','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0208207901',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-25 08:04:51','2022-08-25 08:04:51'),
(40,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' sofomaame  ',NULL,'sofomaame',NULL,NULL,NULL,'CO0038','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'3',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-26 06:05:02','2022-08-26 06:05:02'),
(41,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr MOMBA  ENT','Mr','MOMBA',NULL,'ENT',NULL,'CO0039','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246405233',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-26 10:12:47','2022-08-26 10:12:47'),
(42,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr IDDRISU  MOHAMMED','Mr','IDDRISU',NULL,'MOHAMMED',NULL,'CO0040','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0551850981',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-26 14:44:37','2022-08-26 14:44:37'),
(43,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr evans tano ','Mr','evans','tano',NULL,NULL,'CO0041','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241251372',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-27 11:34:27','2022-08-27 11:34:27'),
(44,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SILAS  ',NULL,'SILAS',NULL,NULL,NULL,'CO0042','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'8',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-27 13:34:49','2022-08-27 13:34:49'),
(45,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SIS ATAA ',NULL,'SIS','ATAA',NULL,NULL,'CO0043','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'6',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-27 14:18:38','2022-08-27 14:18:38'),
(46,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'mr ABESS  ','mr','ABESS',NULL,NULL,NULL,'CO0044','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0245326233',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-29 11:30:19','2022-08-29 11:30:19'),
(47,1,'supplier',NULL,NULL,NULL,NULL,NULL,'ELSHADDAI TRADING','Mr EKOW  ','Mr','EKOW',NULL,NULL,NULL,'CO0045','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0265492575',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-08-30 19:33:13','2022-08-30 19:33:13'),
(48,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' sis Amina ',NULL,'sis','Amina',NULL,NULL,'CO0046','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243353412',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-01 06:49:23','2022-09-01 06:49:23'),
(51,1,'supplier',NULL,NULL,NULL,NULL,NULL,'JOENOCK COMPANY LTD',' JOE  ',NULL,'JOE',NULL,NULL,NULL,'CO0049','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0552866418',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-04 15:56:44','2022-09-04 15:56:44'),
(52,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr MICHAEL  ','Mr','MICHAEL',NULL,NULL,NULL,'CO0050','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0556583325',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-07 15:12:08','2022-09-07 15:12:08'),
(53,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr vincent  ','Mr','vincent',NULL,NULL,NULL,'CO0051','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0240601618',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-08 11:00:28','2022-09-08 11:00:28'),
(54,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' CHARLES  ',NULL,'CHARLES',NULL,NULL,NULL,'CO0052','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-10 09:59:27','2022-09-10 09:59:27'),
(56,1,'supplier',NULL,NULL,NULL,NULL,NULL,'adum side','Mr Thomas  ','Mr','Thomas',NULL,NULL,NULL,'CO0054','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0559155825',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-12 07:53:24','2022-09-12 07:53:24'),
(57,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs GRACE  ','Mrs','GRACE',NULL,NULL,NULL,'CO0055','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0545553348',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-13 08:13:15','2022-09-13 08:13:15'),
(58,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr FORJUI  ','Mr','FORJUI',NULL,NULL,NULL,'CO0056','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0208272389',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-13 09:29:07','2022-09-13 09:29:07'),
(59,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr J .A  AGYARKO MENSAH ','Mr','J .A  AGYARKO','MENSAH',NULL,NULL,'CO0057','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-13 10:09:19','2022-09-13 10:09:19'),
(60,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ABASS ADAMA ',NULL,'ABASS','ADAMA',NULL,NULL,'CO0058','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0244133272',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-13 12:13:07','2022-09-13 12:13:07'),
(61,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr Patrick  ','Mr','Patrick',NULL,NULL,NULL,'CO0059','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0509112198',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-14 11:10:03','2022-09-14 11:10:03'),
(62,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SOLDIER ASUFUFU ',NULL,'SOLDIER','ASUFUFU',NULL,NULL,'CO0060','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0244090784',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-14 15:10:00','2022-09-14 15:10:00'),
(63,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' bro baba ',NULL,'bro','baba',NULL,NULL,'CO0061','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 05:57:20','2022-09-15 05:57:20'),
(64,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' naasei  ',NULL,'naasei',NULL,NULL,NULL,'CO0062','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 06:52:31','2022-09-15 06:52:31'),
(65,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' sarkodie  ',NULL,'sarkodie',NULL,NULL,NULL,'CO0063','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 07:10:37','2022-09-15 07:10:37'),
(66,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' nuhu  ',NULL,'nuhu',NULL,NULL,NULL,'CO0064','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 07:30:40','2022-09-15 07:30:40'),
(67,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Achies  ',NULL,'Achies',NULL,NULL,NULL,'CO0065','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 07:33:17','2022-09-15 07:33:17'),
(68,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr Clement  ','Mr','Clement',NULL,NULL,NULL,'CO0066','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0543551820',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 08:01:48','2022-09-15 08:01:48'),
(69,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' A.D.B bank  ',NULL,'A.D.B bank',NULL,NULL,NULL,'CO0067','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 08:05:49','2022-09-15 08:05:49'),
(70,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' george  ',NULL,'george',NULL,NULL,NULL,'CO0068','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 08:07:29','2022-09-15 08:07:29'),
(71,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MASTER ANTWI ',NULL,'MASTER','ANTWI',NULL,NULL,'CO0069','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 09:23:51','2022-09-15 09:23:51'),
(72,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MENSAH MICHAEL ',NULL,'MENSAH','MICHAEL',NULL,NULL,'CO0070','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 09:29:10','2022-09-15 09:29:10'),
(73,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MAMA KATE ',NULL,'MAMA','KATE',NULL,NULL,'CO0071','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0208207901',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 09:35:35','2022-09-15 09:35:35'),
(74,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' KWAKU  ',NULL,'KWAKU',NULL,NULL,NULL,'CO0072','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 09:43:40','2022-09-15 09:43:40'),
(75,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ESTHER SOLDIER HILL',NULL,'ESTHER','SOLDIER','HILL',NULL,'CO0073','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0557291412',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 10:36:37','2022-09-15 10:36:37'),
(76,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'sis Agnes  ','sis','Agnes',NULL,NULL,NULL,'CO0074','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0547252235',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 10:47:46','2022-09-15 10:47:46'),
(77,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' amponsah  ',NULL,'amponsah',NULL,NULL,NULL,'CO0075','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 12:37:22','2022-09-15 12:37:22'),
(78,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' stephen dabie ',NULL,'stephen','dabie',NULL,NULL,'CO0076','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 12:45:21','2022-09-15 12:45:21'),
(79,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SIAKA  ',NULL,'SIAKA',NULL,NULL,NULL,'CO0077','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 12:53:35','2022-09-15 12:53:35'),
(80,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' E.K  ',NULL,'E.K',NULL,NULL,NULL,'CO0078','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 14:15:31','2022-09-15 14:15:31'),
(81,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ASANTE  ','Mr','ASANTE',NULL,NULL,NULL,'CO0079','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-15 15:44:24','2022-09-15 15:44:24'),
(82,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' OSEI  ',NULL,'OSEI',NULL,NULL,NULL,'CO0080','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-16 15:10:29','2022-09-16 15:10:29'),
(83,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Acquah  ',NULL,'Acquah',NULL,NULL,NULL,'CO0081','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 07:48:34','2022-09-17 07:48:34'),
(84,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Boakye FRND  ',NULL,'Boakye FRND',NULL,NULL,NULL,'CO0082','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 10:23:06','2022-09-17 10:23:06'),
(85,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' PAUL  ',NULL,'PAUL',NULL,NULL,NULL,'CO0083','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 10:32:58','2022-09-17 10:32:58'),
(86,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ERIC INGCO ',NULL,'ERIC','INGCO',NULL,NULL,'CO0084','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0595031217',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 10:45:11','2022-09-17 10:45:11'),
(87,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr KOBBY  ','Mr','KOBBY',NULL,NULL,NULL,'CO0085','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249157368',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 10:52:57','2022-09-17 10:52:57'),
(88,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' IVY  ',NULL,'IVY',NULL,NULL,NULL,'CO0086','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 12:06:37','2022-09-17 12:06:37'),
(89,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' rICHARD  ',NULL,'rICHARD',NULL,NULL,NULL,'CO0087','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 13:28:34','2022-09-17 13:28:34'),
(90,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ATAA  ',NULL,'ATAA',NULL,NULL,NULL,'CO0088','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 15:55:32','2022-09-17 15:55:32'),
(91,1,'supplier',NULL,NULL,NULL,NULL,NULL,'TOP COAT PAINT',' BLACK  ',NULL,'BLACK',NULL,NULL,NULL,'CO0089','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0558366892',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-17 19:38:21','2022-09-17 19:38:21'),
(92,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ayitey  ',NULL,'ayitey',NULL,NULL,NULL,'CO0090','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 06:11:16','2022-09-19 06:11:16'),
(93,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' George  ',NULL,'George',NULL,NULL,NULL,'CO0091','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 06:52:00','2022-09-19 06:52:00'),
(94,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' piesie stephen ',NULL,'piesie','stephen',NULL,NULL,'CO0092','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 06:54:54','2022-09-19 06:54:54'),
(96,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr CHARLES capee ','Mr','CHARLES','capee',NULL,NULL,'CO0094','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 07:16:00','2022-09-19 07:16:00'),
(97,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Rev opoku Afriyie ','Rev','opoku','Afriyie',NULL,NULL,'CO0095','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 08:23:38','2022-09-19 08:23:38'),
(98,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr PRINCE EMPIRE ','Mr','PRINCE','EMPIRE',NULL,NULL,'CO0096','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0244938065',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 08:50:34','2022-09-19 08:50:34'),
(99,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs ADWOA TAKYIWAA ','Mrs','ADWOA','TAKYIWAA',NULL,NULL,'CO0097','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 09:58:27','2022-09-19 09:58:27'),
(100,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' NANA YAW ',NULL,'NANA','YAW',NULL,NULL,'CO0098','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 10:04:39','2022-09-19 10:04:39'),
(101,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs GLORIA  ','Mrs','GLORIA',NULL,NULL,NULL,'CO0099','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 10:33:04','2022-09-19 10:33:04'),
(102,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr KENNEDY  ','Mr','KENNEDY',NULL,NULL,NULL,'CO0100','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542800075',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 11:27:39','2022-09-19 11:27:39'),
(103,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' BAAH YEBOAH ',NULL,'BAAH','YEBOAH',NULL,NULL,'CO0101','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 11:56:20','2022-09-19 11:56:20'),
(104,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' EBENEZER  ',NULL,'EBENEZER',NULL,NULL,NULL,'CO0102','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 13:08:41','2022-09-19 13:08:41'),
(105,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs MAMA mercy ','Mrs','MAMA','mercy',NULL,NULL,'CO0103','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0242083401',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 13:31:18','2022-09-19 13:31:18'),
(106,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' CYRIL  ',NULL,'CYRIL',NULL,NULL,NULL,'CO0104','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 14:20:14','2022-09-19 14:20:14'),
(107,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr OSEI WILLIAMS ','Mr','OSEI','WILLIAMS',NULL,NULL,'CO0105','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0248472583',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 15:09:54','2022-09-19 15:09:54'),
(108,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr IVY  ','Mr','IVY',NULL,NULL,NULL,'CO0106','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0206337989',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 15:18:00','2022-09-19 15:18:00'),
(109,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' NICK  ',NULL,'NICK',NULL,NULL,NULL,'CO0107','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 15:22:36','2022-09-19 15:22:36'),
(110,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs ADAMS  ','Mrs','ADAMS',NULL,NULL,NULL,'CO0108','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0247136575',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 15:28:33','2022-09-19 15:28:33'),
(111,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MICK  ',NULL,'MICK',NULL,NULL,NULL,'CO0109','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-19 15:42:33','2022-09-19 15:42:33'),
(112,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Ramzy  ',NULL,'Ramzy',NULL,NULL,NULL,'CO0110','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 07:39:31','2022-09-20 07:39:31'),
(113,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' AISHFADEEN ENT ',NULL,'AISHFADEEN','ENT',NULL,NULL,'CO0111','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243719219',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 08:53:00','2022-09-20 08:53:00'),
(114,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' GYIDOM  ',NULL,'GYIDOM',NULL,NULL,NULL,'CO0112','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0559744033',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 09:09:42','2022-09-20 09:09:42'),
(115,1,'supplier',NULL,NULL,NULL,NULL,NULL,'RIVERWAY COMPANY','Mr IBRAHIM  ','Mr','IBRAHIM',NULL,NULL,NULL,'CO0113','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0545434844',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 10:05:44','2022-09-20 10:05:44'),
(116,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SIMON  ',NULL,'SIMON',NULL,NULL,NULL,'CO0114','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0248088209',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 10:42:13','2022-09-20 10:42:13'),
(117,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr LEWIS  ','Mr','LEWIS',NULL,NULL,NULL,'CO0115','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246848687',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 12:02:38','2022-09-20 12:02:38'),
(119,1,'supplier',NULL,NULL,NULL,NULL,NULL,'ERICOSE ENT',' VERA ENT ',NULL,'VERA','ENT',NULL,NULL,'CO0117','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542181580',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-20 16:04:33','2022-09-20 16:04:33'),
(120,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' oscar  ',NULL,'oscar',NULL,NULL,NULL,'CO0118','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 07:14:49','2022-09-21 07:14:49'),
(121,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' marian  ',NULL,'marian',NULL,NULL,NULL,'CO0119','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0245952791',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 07:57:44','2022-09-21 07:57:44'),
(122,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs Paulina  ','Mrs','Paulina',NULL,NULL,NULL,'CO0120','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 09:18:50','2022-09-21 09:18:50'),
(123,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' alhaji  ',NULL,'alhaji',NULL,NULL,NULL,'CO0121','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 09:23:03','2022-09-21 09:23:03'),
(124,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs SARAH GYAN ','Mrs','SARAH','GYAN',NULL,NULL,'CO0122','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241280715',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 10:03:11','2022-09-21 10:03:11'),
(125,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' FIDAUS  ',NULL,'FIDAUS',NULL,NULL,NULL,'CO0123','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 10:54:26','2022-09-21 10:54:26'),
(126,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs PATRICIA  ','Mrs','PATRICIA',NULL,NULL,NULL,'CO0124','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 11:29:20','2022-09-21 11:29:20'),
(127,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr Darko  ','Mr','Darko',NULL,NULL,NULL,'CO0125','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 11:36:18','2022-09-21 11:36:18'),
(128,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MBOMBA  ',NULL,'MBOMBA',NULL,NULL,NULL,'CO0126','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246405283',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 13:12:47','2022-09-21 13:12:47'),
(129,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr EMMANUEL  ','Mr','EMMANUEL',NULL,NULL,NULL,'CO0127','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 15:18:14','2022-09-21 15:18:14'),
(130,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr IBRAHIM  ','Mr','IBRAHIM',NULL,NULL,NULL,'CO0128','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-21 15:43:14','2022-09-21 15:43:14'),
(131,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' christopher  ',NULL,'christopher',NULL,NULL,NULL,'CO0129','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 06:25:06','2022-09-22 06:25:06'),
(132,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' EFO  ',NULL,'EFO',NULL,NULL,NULL,'CO0130','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 06:45:25','2022-09-22 06:45:25'),
(133,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ACQUAH  ',NULL,'ACQUAH',NULL,NULL,NULL,'CO0131','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 06:56:43','2022-09-22 06:56:43'),
(134,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' I.K  ',NULL,'I.K',NULL,NULL,NULL,'CO0132','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 07:03:33','2022-09-22 07:03:33'),
(135,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ante maggie ',NULL,'ante','maggie',NULL,NULL,'CO0133','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 07:51:19','2022-09-22 07:51:19'),
(136,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr PRINCE  ','Mr','PRINCE',NULL,NULL,NULL,'CO0134','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 07:54:55','2022-09-22 07:54:55'),
(137,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr CYNTHIA  ','Mr','CYNTHIA',NULL,NULL,NULL,'CO0135','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 09:15:33','2022-09-22 09:15:33'),
(138,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MAMA JANET ',NULL,'MAMA','JANET',NULL,NULL,'CO0136','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542054536',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 09:59:29','2022-09-22 09:59:29'),
(139,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr THOMAS  ','Mr','THOMAS',NULL,NULL,NULL,'CO0137','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 10:03:28','2022-09-22 10:03:28'),
(140,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' RAZAK  ',NULL,'RAZAK',NULL,NULL,NULL,'CO0138','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 10:28:39','2022-09-22 10:28:39'),
(142,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' oduro  ',NULL,'oduro',NULL,NULL,NULL,'CO0140','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 11:26:24','2022-09-22 11:26:24'),
(143,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' EVACHAB  ',NULL,'EVACHAB',NULL,NULL,NULL,'CO0141','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 11:37:20','2022-09-22 11:37:20'),
(144,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' fAUSTINA  ',NULL,'fAUSTINA',NULL,NULL,NULL,'CO0142','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 12:23:54','2022-09-22 12:23:54'),
(145,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' helena  ',NULL,'helena',NULL,NULL,NULL,'CO0143','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 13:30:15','2022-09-22 13:30:15'),
(146,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' bayor cornelia ',NULL,'bayor','cornelia',NULL,NULL,'CO0144','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 13:44:38','2022-09-22 13:44:38'),
(147,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs justina kuupan ','Mrs','justina','kuupan',NULL,NULL,'CO0145','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0206489627',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 15:11:39','2022-09-22 15:11:39'),
(148,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' COLLINS  ',NULL,'COLLINS',NULL,NULL,NULL,'CO0146','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-22 16:16:06','2022-09-22 16:16:06'),
(149,1,'supplier',NULL,NULL,NULL,NULL,NULL,'TEAMLINK ENT',' SAM  ',NULL,'SAM',NULL,NULL,NULL,'CO0147','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0248841472',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-25 16:31:11','2022-09-25 16:31:11'),
(150,1,'supplier',NULL,NULL,NULL,NULL,NULL,'PRILINDAMENT','Mrs LINDA  ','Mrs','LINDA',NULL,NULL,NULL,'CO0148','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0558774526',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-25 16:36:16','2022-09-25 16:36:16'),
(152,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ERIC ADAMSU ','Mr','ERIC','ADAMSU',NULL,NULL,'CO0150','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0245347732',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 11:09:35','2022-09-26 11:09:35'),
(153,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ROBERT  ','Mr','ROBERT',NULL,NULL,NULL,'CO0151','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 11:46:01','2022-09-26 11:46:01'),
(154,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ADAMS  ','Mr','ADAMS',NULL,NULL,NULL,'CO0152','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 12:01:42','2022-09-26 12:01:42'),
(155,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SADIA MR ADAMS',NULL,'SADIA','MR','ADAMS',NULL,'CO0153','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 12:45:13','2022-09-26 12:45:13'),
(156,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr FOSU MOSES ','Mr','FOSU','MOSES',NULL,NULL,'CO0154','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 12:50:02','2022-09-26 12:50:02'),
(157,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr KUMI  ','Mr','KUMI',NULL,NULL,NULL,'CO0155','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 12:52:31','2022-09-26 12:52:31'),
(158,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr KENEF  ','Mr','KENEF',NULL,NULL,NULL,'CO0156','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0545373554',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 13:15:54','2022-09-26 13:15:54'),
(159,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' WOFA  ',NULL,'WOFA',NULL,NULL,NULL,'CO0157','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 13:38:31','2022-09-26 13:38:31'),
(160,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' GHANA RED CROSS',NULL,'GHANA','RED','CROSS',NULL,'CO0158','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 14:01:29','2022-09-26 14:01:29'),
(161,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ISAAC  ',NULL,'ISAAC',NULL,NULL,NULL,'CO0159','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 14:15:45','2022-09-26 14:15:45'),
(162,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' EMMANUEL  ',NULL,'EMMANUEL',NULL,NULL,NULL,'CO0160','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-26 14:20:42','2022-09-26 14:20:42'),
(164,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr KWAKU  ','Mr','KWAKU',NULL,NULL,NULL,'CO0162','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 07:06:26','2022-09-27 07:06:26'),
(165,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ELVIS GYABAAH ','Mr','ELVIS','GYABAAH',NULL,NULL,'CO0163','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 07:35:14','2022-09-27 07:35:14'),
(166,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' STEPHEN  ',NULL,'STEPHEN',NULL,NULL,NULL,'CO0164','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 08:03:48','2022-09-27 08:03:48'),
(167,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MADAM SERWAA ',NULL,'MADAM','SERWAA',NULL,NULL,'CO0165','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 08:15:53','2022-09-27 08:15:53'),
(168,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs JANET  ','Mrs','JANET',NULL,NULL,NULL,'CO0166','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 09:51:52','2022-09-27 09:51:52'),
(169,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr AZIZ  ','Mr','AZIZ',NULL,NULL,NULL,'CO0167','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 10:07:18','2022-09-27 10:07:18'),
(170,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ATTA  ',NULL,'ATTA',NULL,NULL,NULL,'CO0168','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 11:35:58','2022-09-27 11:35:58'),
(171,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ATTA BAAH ',NULL,'ATTA','BAAH',NULL,NULL,'CO0169','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 11:36:27','2022-09-27 11:36:27'),
(172,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'MAMA FELICIA  ','MAMA','FELICIA',NULL,NULL,NULL,'CO0170','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 11:49:06','2022-09-27 11:49:06'),
(173,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr FRANK  ','Mr','FRANK',NULL,NULL,NULL,'CO0171','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 12:21:36','2022-09-27 12:21:36'),
(174,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr YAW  ','Mr','YAW',NULL,NULL,NULL,'CO0172','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-27 16:00:08','2022-09-27 16:00:08'),
(175,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ODASANII EMMA ENT','Mr','ODASANII','EMMA','ENT',NULL,'CO0173','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0247411324',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-28 09:12:56','2022-09-28 09:12:56'),
(176,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' NANA OSEI BONSU',NULL,'NANA','OSEI','BONSU',NULL,'CO0174','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-28 12:13:26','2022-09-28 12:13:26'),
(177,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' DANIEL  ',NULL,'DANIEL',NULL,NULL,NULL,'CO0175','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-28 13:49:52','2022-09-28 13:49:52'),
(178,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs Christy  ','Mrs','Christy',NULL,NULL,NULL,'CO0176','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-28 14:39:14','2022-09-28 14:39:14'),
(179,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr JOSHUA  ','Mr','JOSHUA',NULL,NULL,NULL,'CO0177','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 07:38:49','2022-09-29 07:38:49'),
(180,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' NEWMONT  ',NULL,'NEWMONT',NULL,NULL,NULL,'CO0178','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 08:13:44','2022-09-29 08:13:44'),
(181,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr BOATENG  ','Mr','BOATENG',NULL,NULL,NULL,'CO0179','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 09:03:48','2022-09-29 09:03:48'),
(183,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr RODANIM ASANTE ','Mr','RODANIM','ASANTE',NULL,NULL,'CO0181','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 12:12:46','2022-09-29 12:12:46'),
(184,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MICHAEL  ',NULL,'MICHAEL',NULL,NULL,NULL,'CO0182','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 12:35:03','2022-09-29 12:35:03'),
(185,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr George  ','Mr','George',NULL,NULL,NULL,'CO0183','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 13:26:47','2022-09-29 13:26:47'),
(186,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Patrick AMOAKO ',NULL,'Patrick','AMOAKO',NULL,NULL,'CO0184','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 13:53:08','2022-09-29 13:53:08'),
(187,1,'supplier',NULL,NULL,NULL,NULL,NULL,'CHINA COMPANY','Mr JOHNSON  ','Mr','JOHNSON',NULL,NULL,NULL,'CO0185','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0206190597',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 14:27:15','2022-09-29 14:27:15'),
(188,1,'supplier',NULL,NULL,NULL,NULL,NULL,'turpentine','Mr JOE  ','Mr','JOE',NULL,NULL,NULL,'CO0186','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-29 19:55:34','2022-09-29 19:55:34'),
(189,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' NUSADI ENT  ',NULL,'NUSADI ENT',NULL,NULL,NULL,'CO0187','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 06:51:15','2022-09-30 06:51:15'),
(190,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' AFIA  ',NULL,'AFIA',NULL,NULL,NULL,'CO0188','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 07:23:31','2022-09-30 07:23:31'),
(191,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr SETH  ','Mr','SETH',NULL,NULL,NULL,'CO0189','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 08:39:14','2022-09-30 08:39:14'),
(192,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'SIS SANDRA  ','SIS','SANDRA',NULL,NULL,NULL,'CO0190','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 08:50:09','2022-09-30 08:50:09'),
(193,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs EVELYN  ','Mrs','EVELYN',NULL,NULL,NULL,'CO0191','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 09:18:24','2022-09-30 09:18:24'),
(194,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' SOFO  ',NULL,'SOFO',NULL,NULL,NULL,'CO0192','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 09:22:50','2022-09-30 09:22:50'),
(195,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Rev SAMUEL APPIAH ','Rev','SAMUEL','APPIAH',NULL,NULL,'CO0193','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 09:28:31','2022-09-30 09:28:31'),
(196,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ADOMA OBED ',NULL,'ADOMA','OBED',NULL,NULL,'CO0194','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 10:00:43','2022-09-30 10:00:43'),
(197,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' winfred  ',NULL,'winfred',NULL,NULL,NULL,'CO0195','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 10:19:00','2022-09-30 10:19:00'),
(198,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr PHILIP K ','Mr','PHILIP','K',NULL,NULL,'CO0196','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 10:57:02','2022-09-30 10:57:02'),
(199,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' DEPENDABLE GOD ACADEMY',NULL,'DEPENDABLE','GOD','ACADEMY',NULL,'CO0197','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 11:43:16','2022-09-30 11:43:16'),
(200,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' dock sandrock ',NULL,'dock','sandrock',NULL,NULL,'CO0198','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 12:26:34','2022-09-30 12:26:34'),
(201,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' AMPONSAH  ',NULL,'AMPONSAH',NULL,NULL,NULL,'CO0199','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 12:57:18','2022-09-30 12:57:18'),
(202,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr Stephen  ','Mr','Stephen',NULL,NULL,NULL,'CO0200','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 15:24:50','2022-09-30 15:24:50'),
(203,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr micheal  ','Mr','micheal',NULL,NULL,NULL,'CO0201','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0257622886',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-09-30 16:24:18','2022-09-30 16:24:18'),
(204,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Bingo mohammed ',NULL,'Bingo','mohammed',NULL,NULL,'CO0202','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 06:14:33','2022-10-01 06:14:33'),
(205,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr JOHN  ','Mr','JOHN',NULL,NULL,NULL,'CO0203','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 06:27:05','2022-10-01 06:27:05'),
(206,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr RICHARD  ','Mr','RICHARD',NULL,NULL,NULL,'CO0204','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 08:45:05','2022-10-01 08:45:05'),
(207,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ABDUL AZIZ ','Mr','ABDUL','AZIZ',NULL,NULL,'CO0205','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 09:22:00','2022-10-01 09:22:00'),
(208,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ASARE  ',NULL,'ASARE',NULL,NULL,NULL,'CO0206','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 09:37:56','2022-10-01 09:37:56'),
(209,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mrs OPHELIA  ','Mrs','OPHELIA',NULL,NULL,NULL,'CO0207','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 09:54:20','2022-10-01 09:54:20'),
(210,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ADOM NYAME ENT',NULL,'ADOM','NYAME','ENT',NULL,'CO0208','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249232043',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 10:55:07','2022-10-01 10:55:07'),
(211,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr vitus  ','Mr','vitus',NULL,NULL,NULL,'CO0209','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 11:28:14','2022-10-01 11:28:14'),
(212,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' IDDRISU mohammed ',NULL,'IDDRISU','mohammed',NULL,NULL,'CO0210','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-01 13:03:12','2022-10-01 13:03:12'),
(213,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ASANA  ',NULL,'ASANA',NULL,NULL,NULL,'CO0211','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-03 12:58:09','2022-10-03 12:58:09'),
(214,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' TAKYIWAA  ',NULL,'TAKYIWAA',NULL,NULL,NULL,'CO0212','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-03 13:04:46','2022-10-03 13:04:46'),
(215,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' NKETIA  ',NULL,'NKETIA',NULL,NULL,NULL,'CO0213','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-03 13:14:03','2022-10-03 13:14:03'),
(216,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' EMMA DUMASE ',NULL,'EMMA','DUMASE',NULL,NULL,'CO0214','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0257488967',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-03 16:07:19','2022-10-03 16:07:19'),
(217,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MAMA JOYCE NEWTOWN',NULL,'MAMA','JOYCE','NEWTOWN',NULL,'CO0215','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-04 05:59:54','2022-10-04 05:59:54'),
(218,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ESTHER  ',NULL,'ESTHER',NULL,NULL,NULL,'CO0216','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-05 07:49:33','2022-10-05 07:49:33'),
(219,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' emelia  ',NULL,'emelia',NULL,NULL,NULL,'CO0217','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-05 07:51:11','2022-10-05 07:51:11'),
(220,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' MAVIS  ',NULL,'MAVIS',NULL,NULL,NULL,'CO0218','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-05 09:48:58','2022-10-05 09:48:58'),
(221,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ALHAJI SULE ',NULL,'ALHAJI','SULE',NULL,NULL,'CO0219','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0244676475',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-07 12:05:22','2022-10-07 12:05:22'),
(222,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr Evans  ','Mr','Evans',NULL,NULL,NULL,'CO0220','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-07 15:10:10','2022-10-07 15:10:10'),
(223,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr SACKEY  ','Mr','SACKEY',NULL,NULL,NULL,'CO0221','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-08 16:15:26','2022-10-08 16:15:26'),
(224,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' KWAKU SAMMY ',NULL,'KWAKU','SAMMY',NULL,NULL,'CO0222','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-11 09:16:20','2022-10-11 09:16:20'),
(225,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' AGYA WUSU ',NULL,'AGYA','WUSU',NULL,NULL,'CO0223','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-11 13:39:33','2022-10-11 13:39:33'),
(226,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr DAVID  ','Mr','DAVID',NULL,NULL,NULL,'CO0224','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-15 08:08:42','2022-10-15 08:08:42'),
(227,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' ATTA  williams',NULL,'ATTA',NULL,'williams',NULL,'CO0225','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-10-19 11:11:39','2022-10-19 11:11:39'),
(228,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' JEFFERSON SULE ',NULL,'JEFFERSON','SULE',NULL,NULL,'CO0226','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-18 11:52:28','2022-11-18 11:52:28'),
(229,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' sarfo emma ',NULL,'sarfo','emma',NULL,NULL,'CO0227','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-22 13:38:14','2022-11-22 13:38:14'),
(230,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr AWUAH  ','Mr','AWUAH',NULL,NULL,NULL,'CO0228','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-29 07:02:45','2022-11-29 07:02:45'),
(231,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' kwaku takyi ',NULL,'kwaku','takyi',NULL,NULL,'CO0229','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-11-29 14:09:02','2022-11-29 14:09:02'),
(232,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr ALEX  ','Mr','ALEX',NULL,NULL,NULL,'CO0230','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2022-12-01 07:58:07','2022-12-01 07:58:07'),
(233,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr Francis  ','Mr','Francis',NULL,NULL,NULL,'CO0231','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-01-24 21:40:14','2023-01-24 21:40:14'),
(234,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'mr NANA KWAME ','mr','NANA','KWAME',NULL,NULL,'CO0232','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0531344909',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-07-27 12:25:13','2023-07-27 12:25:13'),
(235,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Bossman  ',NULL,'Bossman',NULL,NULL,NULL,'CO0233','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0556584336',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-07-28 10:02:01','2023-07-28 10:02:01'),
(236,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' welder francis ',NULL,'welder','francis',NULL,NULL,'CO0234','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-07-28 10:10:02','2023-07-28 10:10:02'),
(238,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'mrs Amalia  ','mrs','Amalia',NULL,NULL,NULL,'CO0236','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-08-07 13:40:58','2023-08-07 13:40:58'),
(239,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' bra solo carpee ',NULL,'bra solo','carpee',NULL,NULL,'CO0237','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542181580',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-09-04 15:40:20','2023-09-04 15:40:20'),
(240,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,' Generation innovative School ',NULL,'Generation innovative','School',NULL,NULL,'CO0238','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0553925749',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-09-05 16:18:12','2023-09-05 16:18:12'),
(241,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'sis Dufie  ','sis','Dufie',NULL,NULL,NULL,'CO0239','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2023-11-20 11:12:49','2023-11-20 11:12:49'),
(243,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'ERIC',NULL,'ERIC',NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-04-20 11:15:30','2024-04-20 11:15:30'),
(244,1,'customer','business',NULL,NULL,NULL,NULL,'PRIME CHASE ENTERPRISE','PRIME CHASE ENTERPRISE',NULL,'PRIME CHASE','ENTERPRISE',NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0244537554',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-05 11:53:10','2024-12-05 11:53:10'),
(245,1,'supplier','business',NULL,NULL,NULL,NULL,'DIMD GHANA LIMITED','',NULL,NULL,NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0552656974',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-06 11:35:58','2024-12-06 11:35:58'),
(246,1,'customer','business',NULL,NULL,NULL,NULL,'AMINA ENTERPRISE','',NULL,NULL,NULL,NULL,NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243353412',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-30 09:30:08','2024-12-30 09:30:08'),
(247,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'MR DESMOND','MR','DESMOND',NULL,NULL,NULL,'CO0004','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0592421047',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-30 13:17:04','2024-12-30 13:17:04'),
(248,1,'customer','business',NULL,NULL,NULL,NULL,'NYAME AKWAN ENTERPRISE','',NULL,NULL,NULL,NULL,NULL,'CO0005','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0207753343',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-12-30 15:44:39','2024-12-30 15:44:39'),
(249,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Nana Kwasi',NULL,'Nana','Kwasi',NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241045757',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-14 18:11:17','2025-05-14 18:11:17'),
(250,1,'customer','business',NULL,NULL,NULL,NULL,'CO MAN','',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0343378508',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-15 15:28:49','2025-05-15 15:28:49'),
(251,1,'customer','business',NULL,NULL,NULL,NULL,'Amalia','',NULL,NULL,NULL,NULL,NULL,'CO0002','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246159544',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-15 16:17:37','2025-05-15 16:17:37'),
(252,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Ike',NULL,'Ike',NULL,NULL,NULL,'CO0003','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0257605820',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-16 18:01:44','2025-05-16 18:01:44'),
(253,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Chief',NULL,'Chief',NULL,NULL,NULL,'CO0004','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0531525892',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-16 18:15:04','2025-05-16 18:15:04'),
(254,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Alexander Boamah',NULL,'Alexander','Boamah',NULL,NULL,'CO0005','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246208926',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 09:11:52','2025-05-19 09:11:52'),
(255,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Felix',NULL,'Felix',NULL,NULL,NULL,'CO0006','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0546464249',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 11:25:41','2025-05-19 11:25:41'),
(256,1,'customer','business',NULL,NULL,NULL,NULL,'Bethel Architectual and Construction Limited','',NULL,NULL,NULL,NULL,NULL,'CO0007','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0247133036',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 11:52:09','2025-05-19 11:52:09'),
(257,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Gyan Samuel',NULL,'Gyan','Samuel',NULL,NULL,'CO0008','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241323025',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 12:09:37','2025-05-19 12:09:37'),
(258,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Gregory',NULL,'Gregory',NULL,NULL,NULL,'CO0009','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0544178755',NULL,NULL,NULL,NULL,NULL,15,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 13:11:58','2025-05-19 13:11:58'),
(259,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Hanson Larnyor',NULL,'Hanson','Larnyor',NULL,NULL,'CO0010','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0206763512',NULL,NULL,NULL,NULL,NULL,15,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 15:01:01','2025-05-19 15:01:01'),
(260,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Simon Addae',NULL,'Simon','Addae',NULL,NULL,'CO0011','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0248734064',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 16:23:34','2025-05-19 16:23:34'),
(261,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Master Adams',NULL,'Master','Adams',NULL,NULL,'CO0012','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0242620718',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 16:27:28','2025-05-19 16:27:28'),
(262,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Alex',NULL,'Alex',NULL,NULL,NULL,'CO0013','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241567080',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 16:52:20','2025-05-19 16:52:20'),
(263,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Alex',NULL,'Alex',NULL,NULL,NULL,'CO0014','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0241567080',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 16:52:20','2025-05-19 16:52:20'),
(264,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Opoku Peter',NULL,'Opoku','Peter',NULL,NULL,'CO0015','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0539865011',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 16:56:15','2025-05-19 16:56:15'),
(265,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Kwasi Adu Osei',NULL,'Kwasi','Adu','Osei',NULL,'CO0016','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0200163332',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 16:58:11','2025-05-19 16:58:11'),
(266,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Atif VRA',NULL,'Atif','VRA',NULL,NULL,'CO0017','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0550739527',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 17:10:47','2025-05-19 17:10:47'),
(267,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Royal House of Priest Hood',NULL,'Royal','House of Priest','Hood',NULL,'CO0018','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0551500771',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 17:15:01','2025-05-19 17:15:01'),
(268,1,'customer','business',NULL,NULL,NULL,NULL,'FARMERS LINK','F',NULL,'F',NULL,NULL,NULL,'CO0019','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0530241918',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-19 17:29:45','2025-05-19 17:29:45'),
(269,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Nana Gyau',NULL,'Nana','Gyau',NULL,NULL,'CO0020','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0205021277',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 08:06:03','2025-05-20 08:06:03'),
(270,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Seth',NULL,'Seth',NULL,NULL,NULL,'CO0021','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0501512258',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 09:18:11','2025-05-20 09:18:11'),
(271,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Bright Dwumfour',NULL,'Bright','Dwumfour',NULL,NULL,'CO0023','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0545286219',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 10:27:24','2025-05-20 10:27:24'),
(272,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Appiah',NULL,'Appiah',NULL,NULL,NULL,'CO0024','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0542099257',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 11:25:40','2025-05-20 11:25:40'),
(273,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Liberty',NULL,'Liberty',NULL,NULL,NULL,'CO0025','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243387441',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 12:19:50','2025-05-20 12:19:50'),
(274,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Nana Yaw',NULL,'Nana','Yaw',NULL,NULL,'CO0026','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246906636',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 13:37:39','2025-05-20 13:37:39'),
(275,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Abdul Abubakar',NULL,'Abdul','Abubakar',NULL,NULL,'CO0027','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0244451581',NULL,NULL,NULL,NULL,NULL,14,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 14:41:57','2025-05-20 14:41:57'),
(276,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Francis Blay',NULL,'Francis','Blay',NULL,NULL,'CO0028','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0550289301',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-20 16:10:37','2025-05-20 16:10:37'),
(277,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Joshua KaKra',NULL,'Joshua','KaKra',NULL,NULL,'CO0029','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249178230',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 07:56:57','2025-05-21 07:56:57'),
(278,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Joshua KaKra',NULL,'Joshua','KaKra',NULL,NULL,'CO0030','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249178230',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 07:56:58','2025-05-21 07:56:58'),
(279,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Joshua KaKra',NULL,'Joshua','KaKra',NULL,NULL,'CO0030','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0249178230',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 07:56:58','2025-05-21 07:56:58'),
(280,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'sulimen',NULL,'sulimen',NULL,NULL,NULL,'CO0031','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0531729808',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 08:14:37','2025-05-21 08:14:37'),
(281,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Sulieman',NULL,'Sulieman',NULL,NULL,NULL,'CO0032','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0531729808',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 08:26:32','2025-05-21 08:26:32'),
(282,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Victor Seguro',NULL,'Victor','Seguro',NULL,NULL,'CO0033','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0592657428',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 09:43:53','2025-05-21 09:43:53'),
(283,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Emmanuel Osei Bonsu',NULL,'Emmanuel','Osei','Bonsu',NULL,'CO0034','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0247518283',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 10:37:11','2025-05-21 10:37:11'),
(284,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Kenneth Aidoo',NULL,'Kenneth','Aidoo',NULL,NULL,'CO0035','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0242075356',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 12:11:41','2025-05-21 12:11:41'),
(285,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Mr Kyeremeh Mohammed','Mr','Kyeremeh','Mohammed',NULL,NULL,'CO0036','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243378438',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 12:15:22','2025-05-21 12:15:22'),
(286,1,'customer','business',NULL,NULL,NULL,NULL,'DUFIE','',NULL,NULL,NULL,NULL,NULL,'CO0037','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0243060109',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-21 13:43:35','2025-05-21 13:43:35'),
(287,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Godwin Osei Boakye',NULL,'Godwin','Osei','Boakye',NULL,'CO0038','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0246322142',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-22 09:34:24','2025-05-22 09:34:24'),
(288,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Faiseal',NULL,'Faiseal',NULL,NULL,NULL,'CO0039','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0205595821',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-22 10:45:54','2025-05-22 10:45:54'),
(289,1,'customer',NULL,NULL,NULL,NULL,NULL,NULL,'Godwin Boyaga',NULL,'Godwin','Boyaga',NULL,NULL,'CO0040','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0531810164',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-22 11:22:57','2025-05-22 11:22:57'),
(290,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Andrews Kwaff',NULL,'Andrews','Kwaff',NULL,NULL,'CO0042','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0248229905',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-22 12:23:06','2025-05-22 12:23:06'),
(291,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Emmanuel Afriyie',NULL,'Emmanuel','Afriyie',NULL,NULL,'CO0043','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0546697997',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-22 12:45:06','2025-05-22 12:45:06'),
(292,1,'customer','individual',NULL,NULL,NULL,NULL,NULL,'Amankwaah Kenneth',NULL,'Amankwaah','Kenneth',NULL,NULL,'CO0044','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0598828055',NULL,NULL,NULL,NULL,NULL,4,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-22 13:47:52','2025-05-22 13:47:52'),
(293,1,'customer','business',NULL,NULL,NULL,NULL,'Y BOAKYE ENTERPRISE','',NULL,NULL,NULL,NULL,NULL,'CO0001','active',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'0551974116',NULL,NULL,NULL,NULL,NULL,3,0.0000,0,0,0,0,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2025-05-26 10:57:39','2025-05-26 10:57:39');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `country` varchar(100) NOT NULL,
  `currency` varchar(100) NOT NULL,
  `code` varchar(25) NOT NULL,
  `symbol` varchar(25) NOT NULL,
  `thousand_separator` varchar(10) NOT NULL,
  `decimal_separator` varchar(10) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES
(1,'Albania','Leke','ALL','Lek',',','.',NULL,NULL),
(2,'America','Dollars','USD','$',',','.',NULL,NULL),
(3,'Afghanistan','Afghanis','AF','؋',',','.',NULL,NULL),
(4,'Argentina','Pesos','ARS','$',',','.',NULL,NULL),
(5,'Aruba','Guilders','AWG','ƒ',',','.',NULL,NULL),
(6,'Australia','Dollars','AUD','$',',','.',NULL,NULL),
(7,'Azerbaijan','New Manats','AZ','ман',',','.',NULL,NULL),
(8,'Bahamas','Dollars','BSD','$',',','.',NULL,NULL),
(9,'Barbados','Dollars','BBD','$',',','.',NULL,NULL),
(10,'Belarus','Rubles','BYR','p.',',','.',NULL,NULL),
(11,'Belgium','Euro','EUR','€',',','.',NULL,NULL),
(12,'Beliz','Dollars','BZD','BZ$',',','.',NULL,NULL),
(13,'Bermuda','Dollars','BMD','$',',','.',NULL,NULL),
(14,'Bolivia','Bolivianos','BOB','$b',',','.',NULL,NULL),
(15,'Bosnia and Herzegovina','Convertible Marka','BAM','KM',',','.',NULL,NULL),
(16,'Botswana','Pula\'s','BWP','P',',','.',NULL,NULL),
(17,'Bulgaria','Leva','BG','лв',',','.',NULL,NULL),
(18,'Brazil','Reais','BRL','R$',',','.',NULL,NULL),
(19,'Britain [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),
(20,'Brunei Darussalam','Dollars','BND','$',',','.',NULL,NULL),
(21,'Cambodia','Riels','KHR','៛',',','.',NULL,NULL),
(22,'Canada','Dollars','CAD','$',',','.',NULL,NULL),
(23,'Cayman Islands','Dollars','KYD','$',',','.',NULL,NULL),
(24,'Chile','Pesos','CLP','$',',','.',NULL,NULL),
(25,'China','Yuan Renminbi','CNY','¥',',','.',NULL,NULL),
(26,'Colombia','Pesos','COP','$',',','.',NULL,NULL),
(27,'Costa Rica','Colón','CRC','₡',',','.',NULL,NULL),
(28,'Croatia','Kuna','HRK','kn',',','.',NULL,NULL),
(29,'Cuba','Pesos','CUP','₱',',','.',NULL,NULL),
(30,'Cyprus','Euro','EUR','€','.',',',NULL,NULL),
(31,'Czech Republic','Koruny','CZK','Kč',',','.',NULL,NULL),
(32,'Denmark','Kroner','DKK','kr',',','.',NULL,NULL),
(33,'Dominican Republic','Pesos','DOP ','RD$',',','.',NULL,NULL),
(34,'East Caribbean','Dollars','XCD','$',',','.',NULL,NULL),
(35,'Egypt','Pounds','EGP','£',',','.',NULL,NULL),
(36,'El Salvador','Colones','SVC','$',',','.',NULL,NULL),
(37,'England [United Kingdom]','Pounds','GBP','£',',','.',NULL,NULL),
(38,'Euro','Euro','EUR','€','.',',',NULL,NULL),
(39,'Falkland Islands','Pounds','FKP','£',',','.',NULL,NULL),
(40,'Fiji','Dollars','FJD','$',',','.',NULL,NULL),
(41,'France','Euro','EUR','€','.',',',NULL,NULL),
(42,'Ghana','Cedis','GHS','¢',',','.',NULL,NULL),
(43,'Gibraltar','Pounds','GIP','£',',','.',NULL,NULL),
(44,'Greece','Euro','EUR','€','.',',',NULL,NULL),
(45,'Guatemala','Quetzales','GTQ','Q',',','.',NULL,NULL),
(46,'Guernsey','Pounds','GGP','£',',','.',NULL,NULL),
(47,'Guyana','Dollars','GYD','$',',','.',NULL,NULL),
(48,'Holland [Netherlands]','Euro','EUR','€','.',',',NULL,NULL),
(49,'Honduras','Lempiras','HNL','L',',','.',NULL,NULL),
(50,'Hong Kong','Dollars','HKD','$',',','.',NULL,NULL),
(51,'Hungary','Forint','HUF','Ft',',','.',NULL,NULL),
(52,'Iceland','Kronur','ISK','kr',',','.',NULL,NULL),
(53,'India','Rupees','INR','₹',',','.',NULL,NULL),
(54,'Indonesia','Rupiahs','IDR','Rp',',','.',NULL,NULL),
(55,'Iran','Rials','IRR','﷼',',','.',NULL,NULL),
(56,'Ireland','Euro','EUR','€','.',',',NULL,NULL),
(57,'Isle of Man','Pounds','IMP','£',',','.',NULL,NULL),
(58,'Israel','New Shekels','ILS','₪',',','.',NULL,NULL),
(59,'Italy','Euro','EUR','€','.',',',NULL,NULL),
(60,'Jamaica','Dollars','JMD','J$',',','.',NULL,NULL),
(61,'Japan','Yen','JPY','¥',',','.',NULL,NULL),
(62,'Jersey','Pounds','JEP','£',',','.',NULL,NULL),
(63,'Kazakhstan','Tenge','KZT','лв',',','.',NULL,NULL),
(64,'Korea [North]','Won','KPW','₩',',','.',NULL,NULL),
(65,'Korea [South]','Won','KRW','₩',',','.',NULL,NULL),
(66,'Kyrgyzstan','Soms','KGS','лв',',','.',NULL,NULL),
(67,'Laos','Kips','LAK','₭',',','.',NULL,NULL),
(68,'Latvia','Lati','LVL','Ls',',','.',NULL,NULL),
(69,'Lebanon','Pounds','LBP','£',',','.',NULL,NULL),
(70,'Liberia','Dollars','LRD','$',',','.',NULL,NULL),
(71,'Liechtenstein','Switzerland Francs','CHF','CHF',',','.',NULL,NULL),
(72,'Lithuania','Litai','LTL','Lt',',','.',NULL,NULL),
(73,'Luxembourg','Euro','EUR','€','.',',',NULL,NULL),
(74,'Macedonia','Denars','MKD','ден',',','.',NULL,NULL),
(75,'Malaysia','Ringgits','MYR','RM',',','.',NULL,NULL),
(76,'Malta','Euro','EUR','€','.',',',NULL,NULL),
(77,'Mauritius','Rupees','MUR','₨',',','.',NULL,NULL),
(78,'Mexico','Pesos','MXN','$',',','.',NULL,NULL),
(79,'Mongolia','Tugriks','MNT','₮',',','.',NULL,NULL),
(80,'Mozambique','Meticais','MZ','MT',',','.',NULL,NULL),
(81,'Namibia','Dollars','NAD','$',',','.',NULL,NULL),
(82,'Nepal','Rupees','NPR','₨',',','.',NULL,NULL),
(83,'Netherlands Antilles','Guilders','ANG','ƒ',',','.',NULL,NULL),
(84,'Netherlands','Euro','EUR','€','.',',',NULL,NULL),
(85,'New Zealand','Dollars','NZD','$',',','.',NULL,NULL),
(86,'Nicaragua','Cordobas','NIO','C$',',','.',NULL,NULL),
(87,'Nigeria','Nairas','NGN','₦',',','.',NULL,NULL),
(88,'North Korea','Won','KPW','₩',',','.',NULL,NULL),
(89,'Norway','Krone','NOK','kr',',','.',NULL,NULL),
(90,'Oman','Rials','OMR','﷼',',','.',NULL,NULL),
(91,'Pakistan','Rupees','PKR','₨',',','.',NULL,NULL),
(92,'Panama','Balboa','PAB','B/.',',','.',NULL,NULL),
(93,'Paraguay','Guarani','PYG','Gs',',','.',NULL,NULL),
(94,'Peru','Nuevos Soles','PE','S/.',',','.',NULL,NULL),
(95,'Philippines','Pesos','PHP','Php',',','.',NULL,NULL),
(96,'Poland','Zlotych','PL','zł',',','.',NULL,NULL),
(97,'Qatar','Rials','QAR','﷼',',','.',NULL,NULL),
(98,'Romania','New Lei','RO','lei',',','.',NULL,NULL),
(99,'Russia','Rubles','RUB','руб',',','.',NULL,NULL),
(100,'Saint Helena','Pounds','SHP','£',',','.',NULL,NULL),
(101,'Saudi Arabia','Riyals','SAR','﷼',',','.',NULL,NULL),
(102,'Serbia','Dinars','RSD','Дин.',',','.',NULL,NULL),
(103,'Seychelles','Rupees','SCR','₨',',','.',NULL,NULL),
(104,'Singapore','Dollars','SGD','$',',','.',NULL,NULL),
(105,'Slovenia','Euro','EUR','€','.',',',NULL,NULL),
(106,'Solomon Islands','Dollars','SBD','$',',','.',NULL,NULL),
(107,'Somalia','Shillings','SOS','S',',','.',NULL,NULL),
(108,'South Africa','Rand','ZAR','R',',','.',NULL,NULL),
(109,'South Korea','Won','KRW','₩',',','.',NULL,NULL),
(110,'Spain','Euro','EUR','€','.',',',NULL,NULL),
(111,'Sri Lanka','Rupees','LKR','₨',',','.',NULL,NULL),
(112,'Sweden','Kronor','SEK','kr',',','.',NULL,NULL),
(113,'Switzerland','Francs','CHF','CHF',',','.',NULL,NULL),
(114,'Suriname','Dollars','SRD','$',',','.',NULL,NULL),
(115,'Syria','Pounds','SYP','£',',','.',NULL,NULL),
(116,'Taiwan','New Dollars','TWD','NT$',',','.',NULL,NULL),
(117,'Thailand','Baht','THB','฿',',','.',NULL,NULL),
(118,'Trinidad and Tobago','Dollars','TTD','TT$',',','.',NULL,NULL),
(119,'Turkey','Lira','TRY','TL',',','.',NULL,NULL),
(120,'Turkey','Liras','TRL','£',',','.',NULL,NULL),
(121,'Tuvalu','Dollars','TVD','$',',','.',NULL,NULL),
(122,'Ukraine','Hryvnia','UAH','₴',',','.',NULL,NULL),
(123,'United Kingdom','Pounds','GBP','£',',','.',NULL,NULL),
(124,'United States of America','Dollars','USD','$',',','.',NULL,NULL),
(125,'Uruguay','Pesos','UYU','$U',',','.',NULL,NULL),
(126,'Uzbekistan','Sums','UZS','лв',',','.',NULL,NULL),
(127,'Vatican City','Euro','EUR','€','.',',',NULL,NULL),
(128,'Venezuela','Bolivares Fuertes','VEF','Bs',',','.',NULL,NULL),
(129,'Vietnam','Dong','VND','₫',',','.',NULL,NULL),
(130,'Yemen','Rials','YER','﷼',',','.',NULL,NULL),
(131,'Zimbabwe','Zimbabwe Dollars','ZWD','Z$',',','.',NULL,NULL),
(132,'Iraq','Iraqi dinar','IQD','د.ع',',','.',NULL,NULL),
(133,'Kenya','Kenyan shilling','KES','KSh',',','.',NULL,NULL),
(134,'Bangladesh','Taka','BDT','৳',',','.',NULL,NULL),
(135,'Algerie','Algerian dinar','DZD','د.ج',' ','.',NULL,NULL),
(136,'United Arab Emirates','United Arab Emirates dirham','AED','د.إ',',','.',NULL,NULL),
(137,'Uganda','Uganda shillings','UGX','USh',',','.',NULL,NULL),
(138,'Tanzania','Tanzanian shilling','TZS','TSh',',','.',NULL,NULL),
(139,'Angola','Kwanza','AOA','Kz',',','.',NULL,NULL),
(140,'Kuwait','Kuwaiti dinar','KWD','KD',',','.',NULL,NULL),
(141,'Bahrain','Bahraini dinar','BHD','BD',',','.',NULL,NULL);
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `customer_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `amount` double(5,2) NOT NULL,
  `price_calculation_type` varchar(191) DEFAULT 'percentage',
  `selling_price_group_id` int(11) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `customer_groups_business_id_foreign` (`business_id`),
  KEY `customer_groups_created_by_index` (`created_by`),
  KEY `customer_groups_price_calculation_type_index` (`price_calculation_type`),
  KEY `customer_groups_selling_price_group_id_index` (`selling_price_group_id`),
  CONSTRAINT `customer_groups_business_id_foreign` FOREIGN KEY (`business_id`) REFERENCES `business` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `customer_groups` WRITE;
/*!40000 ALTER TABLE `customer_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `customer_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_configurations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `created_by` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `configuration` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_configurations_business_id_foreign` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_configurations` WRITE;
/*!40000 ALTER TABLE `dashboard_configurations` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_configurations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discount_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discount_variations` (
  `discount_id` int(11) NOT NULL,
  `variation_id` int(11) NOT NULL,
  KEY `discount_variations_discount_id_index` (`discount_id`),
  KEY `discount_variations_variation_id_index` (`variation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discount_variations` WRITE;
/*!40000 ALTER TABLE `discount_variations` DISABLE KEYS */;
/*!40000 ALTER TABLE `discount_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(11) NOT NULL,
  `brand_id` int(11) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `location_id` int(11) DEFAULT NULL,
  `priority` int(11) DEFAULT NULL,
  `discount_type` varchar(191) DEFAULT NULL,
  `discount_amount` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `starts_at` datetime DEFAULT NULL,
  `ends_at` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `spg` varchar(100) DEFAULT NULL COMMENT 'Applicable in specified selling price group only. Use of applicable_in_spg column is discontinued',
  `applicable_in_cg` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discounts_business_id_index` (`business_id`),
  KEY `discounts_brand_id_index` (`brand_id`),
  KEY `discounts_category_id_index` (`category_id`),
  KEY `discounts_location_id_index` (`location_id`),
  KEY `discounts_priority_index` (`priority`),
  KEY `discounts_spg_index` (`spg`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discounts` WRITE;
/*!40000 ALTER TABLE `discounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `discounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `document_and_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `document_and_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `notable_id` int(11) NOT NULL,
  `notable_type` varchar(191) NOT NULL,
  `heading` text DEFAULT NULL,
  `description` text DEFAULT NULL,
  `is_private` tinyint(1) NOT NULL DEFAULT 0,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_and_notes_business_id_index` (`business_id`),
  KEY `document_and_notes_notable_id_index` (`notable_id`),
  KEY `document_and_notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `document_and_notes` WRITE;
/*!40000 ALTER TABLE `document_and_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `document_and_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_allowances_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_allowances_and_deductions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `description` varchar(191) NOT NULL,
  `type` enum('allowance','deduction') NOT NULL,
  `amount` decimal(22,4) NOT NULL,
  `amount_type` enum('fixed','percent') NOT NULL,
  `applicable_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_allowances_and_deductions_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_allowances_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_allowances_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `business_id` int(11) NOT NULL,
  `clock_in_time` datetime DEFAULT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `essentials_shift_id` int(11) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `clock_in_note` text DEFAULT NULL,
  `clock_out_note` text DEFAULT NULL,
  `clock_in_location` text DEFAULT NULL,
  `clock_out_location` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_attendances_user_id_index` (`user_id`),
  KEY `essentials_attendances_business_id_index` (`business_id`),
  KEY `essentials_attendances_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_attendances` WRITE;
/*!40000 ALTER TABLE `essentials_attendances` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_document_shares`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_document_shares` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) NOT NULL,
  `value_type` enum('user','role') NOT NULL,
  `value` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_document_shares_document_id_index` (`document_id`),
  KEY `essentials_document_shares_value_type_index` (`value_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_document_shares` WRITE;
/*!40000 ALTER TABLE `essentials_document_shares` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_document_shares` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `type` varchar(191) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `description` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_documents` WRITE;
/*!40000 ALTER TABLE `essentials_documents` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_documents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `business_id` int(11) NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_holidays_business_id_index` (`business_id`),
  KEY `essentials_holidays_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_holidays` WRITE;
/*!40000 ALTER TABLE `essentials_holidays` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_kb` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` bigint(20) unsigned NOT NULL,
  `title` varchar(191) NOT NULL,
  `content` longtext DEFAULT NULL,
  `status` varchar(191) NOT NULL,
  `kb_type` varchar(191) NOT NULL,
  `parent_id` bigint(20) unsigned DEFAULT NULL COMMENT 'id from essentials_kb table',
  `share_with` varchar(191) DEFAULT NULL COMMENT 'public, private, only_with',
  `created_by` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_business_id_index` (`business_id`),
  KEY `essentials_kb_parent_id_index` (`parent_id`),
  KEY `essentials_kb_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb` WRITE;
/*!40000 ALTER TABLE `essentials_kb` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_kb_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_kb_users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `kb_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_kb_users_kb_id_index` (`kb_id`),
  KEY `essentials_kb_users_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_kb_users` WRITE;
/*!40000 ALTER TABLE `essentials_kb_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_kb_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_leave_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `leave_type` varchar(191) NOT NULL,
  `max_leave_count` int(11) DEFAULT NULL,
  `leave_count_interval` enum('month','year') DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leave_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leave_types` WRITE;
/*!40000 ALTER TABLE `essentials_leave_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_leaves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `essentials_leave_type_id` int(11) DEFAULT NULL,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `ref_no` varchar(191) DEFAULT NULL,
  `status` enum('pending','approved','cancelled') DEFAULT NULL,
  `reason` text DEFAULT NULL,
  `status_note` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_leaves_essentials_leave_type_id_index` (`essentials_leave_type_id`),
  KEY `essentials_leaves_business_id_index` (`business_id`),
  KEY `essentials_leaves_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_leaves` WRITE;
/*!40000 ALTER TABLE `essentials_leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_messages` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `message` text NOT NULL,
  `location_id` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_messages_business_id_index` (`business_id`),
  KEY `essentials_messages_user_id_index` (`user_id`),
  KEY `essentials_messages_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_messages` WRITE;
/*!40000 ALTER TABLE `essentials_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_messages` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_group_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_payroll_group_transactions` (
  `payroll_group_id` bigint(20) unsigned NOT NULL,
  `transaction_id` int(11) NOT NULL,
  KEY `essentials_payroll_group_transactions_payroll_group_id_foreign` (`payroll_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_group_transactions` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_group_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_payroll_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_payroll_groups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `status` varchar(191) NOT NULL,
  `payment_status` varchar(191) NOT NULL DEFAULT 'due',
  `gross_total` decimal(22,4) NOT NULL DEFAULT 0.0000,
  `created_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_payroll_groups` WRITE;
/*!40000 ALTER TABLE `essentials_payroll_groups` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_payroll_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_reminders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_reminders` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(191) NOT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `end_time` time DEFAULT NULL,
  `repeat` enum('one_time','every_day','every_week','every_month') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_reminders_business_id_index` (`business_id`),
  KEY `essentials_reminders_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_reminders` WRITE;
/*!40000 ALTER TABLE `essentials_reminders` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_reminders` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `type` enum('fixed_shift','flexible_shift') NOT NULL DEFAULT 'fixed_shift',
  `business_id` int(11) NOT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `is_allowed_auto_clockout` tinyint(1) NOT NULL DEFAULT 0,
  `auto_clockout_time` time DEFAULT NULL,
  `holidays` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_shifts_type_index` (`type`),
  KEY `essentials_shifts_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_to_dos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_to_dos` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `task` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `task_id` varchar(191) DEFAULT NULL,
  `description` text DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `estimated_hours` varchar(191) DEFAULT NULL,
  `priority` varchar(191) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_to_dos_status_index` (`status`),
  KEY `essentials_to_dos_priority_index` (`priority`),
  KEY `essentials_to_dos_created_by_index` (`created_by`),
  KEY `essentials_to_dos_business_id_index` (`business_id`),
  KEY `essentials_to_dos_task_id_index` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_to_dos` WRITE;
/*!40000 ALTER TABLE `essentials_to_dos` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_to_dos` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todo_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_todo_comments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `comment` text NOT NULL,
  `task_id` int(11) NOT NULL,
  `comment_by` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_todo_comments_task_id_index` (`task_id`),
  KEY `essentials_todo_comments_comment_by_index` (`comment_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todo_comments` WRITE;
/*!40000 ALTER TABLE `essentials_todo_comments` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todo_comments` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_todos_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_todos_users` (
  `todo_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_todos_users` WRITE;
/*!40000 ALTER TABLE `essentials_todos_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_todos_users` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_allowance_and_deductions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_allowance_and_deductions` (
  `user_id` int(11) NOT NULL,
  `allowance_deduction_id` int(11) NOT NULL,
  KEY `essentials_user_allowance_and_deductions_user_id_index` (`user_id`),
  KEY `allow_deduct_index` (`allowance_deduction_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_allowance_and_deductions` WRITE;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_allowance_and_deductions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `essentials_user_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `essentials_user_shifts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `essentials_shift_id` int(11) NOT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `essentials_user_shifts_user_id_index` (`user_id`),
  KEY `essentials_user_shifts_essentials_shift_id_index` (`essentials_shift_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `essentials_user_shifts` WRITE;
/*!40000 ALTER TABLE `essentials_user_shifts` DISABLE KEYS */;
/*!40000 ALTER TABLE `essentials_user_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expense_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `code` varchar(191) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_categories_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expense_categories` WRITE;
/*!40000 ALTER TABLE `expense_categories` DISABLE KEYS */;
INSERT INTO `expense_categories` VALUES
(1,'Salaries',1,'S30',NULL,NULL,'2021-04-10 10:37:15','2021-04-10 10:37:15'),
(2,'Bills',1,'B30',NULL,NULL,'2021-04-10 10:37:36','2021-04-10 10:37:36'),
(3,'Materials',1,'Mat',NULL,NULL,'2021-04-10 10:38:14','2021-04-10 10:38:14');
/*!40000 ALTER TABLE `expense_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `group_sub_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `group_sub_taxes` (
  `group_tax_id` int(10) unsigned NOT NULL,
  `tax_id` int(10) unsigned NOT NULL,
  KEY `group_sub_taxes_group_tax_id_foreign` (`group_tax_id`),
  KEY `group_sub_taxes_tax_id_foreign` (`tax_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `group_sub_taxes` WRITE;
/*!40000 ALTER TABLE `group_sub_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `group_sub_taxes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_layouts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_layouts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `header_text` text DEFAULT NULL,
  `invoice_no_prefix` varchar(191) DEFAULT NULL,
  `quotation_no_prefix` varchar(191) DEFAULT NULL,
  `invoice_heading` varchar(191) DEFAULT NULL,
  `sub_heading_line1` varchar(191) DEFAULT NULL,
  `sub_heading_line2` varchar(191) DEFAULT NULL,
  `sub_heading_line3` varchar(191) DEFAULT NULL,
  `sub_heading_line4` varchar(191) DEFAULT NULL,
  `sub_heading_line5` varchar(191) DEFAULT NULL,
  `invoice_heading_not_paid` varchar(191) DEFAULT NULL,
  `invoice_heading_paid` varchar(191) DEFAULT NULL,
  `quotation_heading` varchar(191) DEFAULT NULL,
  `sub_total_label` varchar(191) DEFAULT NULL,
  `discount_label` varchar(191) DEFAULT NULL,
  `tax_label` varchar(191) DEFAULT NULL,
  `total_label` varchar(191) DEFAULT NULL,
  `round_off_label` varchar(191) DEFAULT NULL,
  `total_due_label` varchar(191) DEFAULT NULL,
  `paid_label` varchar(191) DEFAULT NULL,
  `show_client_id` tinyint(1) NOT NULL DEFAULT 0,
  `client_id_label` varchar(191) DEFAULT NULL,
  `client_tax_label` varchar(191) DEFAULT NULL,
  `date_label` varchar(191) DEFAULT NULL,
  `date_time_format` varchar(191) DEFAULT NULL,
  `show_time` tinyint(1) NOT NULL DEFAULT 1,
  `show_brand` tinyint(1) NOT NULL DEFAULT 0,
  `show_sku` tinyint(1) NOT NULL DEFAULT 1,
  `show_cat_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `show_lot` tinyint(1) NOT NULL DEFAULT 0,
  `show_image` tinyint(1) NOT NULL DEFAULT 0,
  `show_sale_description` tinyint(1) NOT NULL DEFAULT 0,
  `sales_person_label` varchar(191) DEFAULT NULL,
  `show_sales_person` tinyint(1) NOT NULL DEFAULT 0,
  `table_product_label` varchar(191) DEFAULT NULL,
  `table_qty_label` varchar(191) DEFAULT NULL,
  `table_unit_price_label` varchar(191) DEFAULT NULL,
  `table_subtotal_label` varchar(191) DEFAULT NULL,
  `cat_code_label` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `show_logo` tinyint(1) NOT NULL DEFAULT 0,
  `show_business_name` tinyint(1) NOT NULL DEFAULT 0,
  `show_location_name` tinyint(1) NOT NULL DEFAULT 1,
  `show_landmark` tinyint(1) NOT NULL DEFAULT 1,
  `show_city` tinyint(1) NOT NULL DEFAULT 1,
  `show_state` tinyint(1) NOT NULL DEFAULT 1,
  `show_zip_code` tinyint(1) NOT NULL DEFAULT 1,
  `show_country` tinyint(1) NOT NULL DEFAULT 1,
  `show_mobile_number` tinyint(1) NOT NULL DEFAULT 1,
  `show_alternate_number` tinyint(1) NOT NULL DEFAULT 0,
  `show_email` tinyint(1) NOT NULL DEFAULT 0,
  `show_tax_1` tinyint(1) NOT NULL DEFAULT 1,
  `show_tax_2` tinyint(1) NOT NULL DEFAULT 0,
  `show_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `show_payments` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer` tinyint(1) NOT NULL DEFAULT 0,
  `customer_label` varchar(191) DEFAULT NULL,
  `commission_agent_label` varchar(191) DEFAULT NULL,
  `show_commission_agent` tinyint(1) NOT NULL DEFAULT 0,
  `show_reward_point` tinyint(1) NOT NULL DEFAULT 0,
  `highlight_color` varchar(10) DEFAULT NULL,
  `footer_text` text DEFAULT NULL,
  `module_info` text DEFAULT NULL,
  `common_settings` text DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `business_id` int(10) unsigned NOT NULL,
  `show_letter_head` tinyint(1) NOT NULL DEFAULT 0,
  `letter_head` varchar(191) DEFAULT NULL,
  `show_qr_code` tinyint(1) NOT NULL DEFAULT 0,
  `qr_code_fields` text DEFAULT NULL,
  `design` varchar(190) DEFAULT 'classic',
  `cn_heading` varchar(191) DEFAULT NULL COMMENT 'cn = credit note',
  `cn_no_label` varchar(191) DEFAULT NULL,
  `cn_amount_label` varchar(191) DEFAULT NULL,
  `table_tax_headings` text DEFAULT NULL,
  `show_previous_bal` tinyint(1) NOT NULL DEFAULT 0,
  `prev_bal_label` varchar(191) DEFAULT NULL,
  `change_return_label` varchar(191) DEFAULT NULL,
  `product_custom_fields` text DEFAULT NULL,
  `contact_custom_fields` text DEFAULT NULL,
  `location_custom_fields` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_layouts_business_id_foreign` (`business_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_layouts` WRITE;
/*!40000 ALTER TABLE `invoice_layouts` DISABLE KEYS */;
INSERT INTO `invoice_layouts` VALUES
(1,'Default',NULL,'Invoice No.',NULL,'Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Subtotal','Discount','Tax','Total',NULL,'Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,1,1,0,0,0,0,0,NULL,1,'Product','Quantity','Unit Price','Subtotal',NULL,NULL,1,0,1,1,1,1,1,1,1,1,1,1,0,0,1,1,'Customer',NULL,0,0,'#000000','<p>Thank you for your patronage</p>',NULL,'{\"due_date_label\":null,\"total_quantity_label\":null}',0,1,0,NULL,0,NULL,'elegant',NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,NULL,NULL,'2021-04-03 13:19:33','2022-09-15 20:24:20'),
(2,'Large',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal','Discount','Tax','Total','Round off','Total Due','Total Paid',0,NULL,NULL,'Date',NULL,1,0,1,0,0,0,0,0,NULL,1,'Product','Quantity','Unit Price','Subtotal','HSN',NULL,1,0,1,1,1,1,1,1,1,1,0,1,0,0,1,1,'Customer',NULL,0,0,'#000000',NULL,NULL,'{\"due_date_label\":\"Due Date\",\"total_quantity_label\":\"Total Quantity\"}',0,1,0,NULL,0,NULL,'classic','Credit Note','Ref. No.','Credit Amount',NULL,0,'All Balance Due','Change Return',NULL,NULL,NULL,'2021-04-11 08:42:09','2022-07-24 17:34:01'),
(3,'Receipt',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal',NULL,'Tax','Grand Total',NULL,NULL,'Total Paid',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,'User',1,'Description','Qty','Rate','Amount','HSN',NULL,0,0,1,1,1,1,0,0,1,1,0,0,0,0,1,1,'Customer',NULL,0,0,'#000000','<p>Thank you for your patronage</p>',NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":\"Due Date\",\"total_quantity_label\":\"Total Items\",\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":\"Total Tax\"}',1,1,0,NULL,0,NULL,'slim','Credit Note','Ref. No.','Credit Amount',NULL,0,'All Balance Due','Change Due',NULL,NULL,NULL,'2021-11-08 09:45:59','2025-01-02 14:12:25'),
(4,'Wholesale',NULL,'Invoice No.','Quotation No.','Invoice',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'Quotation','Subtotal',NULL,'Tax','Grand Total',NULL,NULL,'Total paid',0,NULL,NULL,'Date',NULL,1,0,0,0,0,0,0,0,'User',1,'Description','Qty','Rate','Amount','HSN',NULL,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,'Customer',NULL,0,0,'#000000','<p>Thanks for your patronage</p>',NULL,'{\"proforma_heading\":null,\"sales_order_heading\":null,\"due_date_label\":\"Due Date\",\"total_quantity_label\":\"Total Items\",\"item_discount_label\":null,\"discounted_unit_price_label\":null,\"total_items_label\":null,\"num_to_word_format\":\"international\",\"tax_summary_label\":null}',0,1,0,NULL,0,NULL,'slim','Credit Note','Ref. No','Credit Amount',NULL,0,'All Balance Due','Change Due',NULL,NULL,NULL,'2024-11-26 19:23:58','2024-11-26 19:23:58');
/*!40000 ALTER TABLE `invoice_layouts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_schemes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_schemes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `scheme_type` enum('blank','year') NOT NULL,
  `number_type` varchar(100) NOT NULL DEFAULT 'sequential',
  `prefix` varchar(191) DEFAULT NULL,
  `start_number` int(11) DEFAULT NULL,
  `invoice_count` int(11) NOT NULL DEFAULT 0,
  `total_digits` int(11) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_schemes_business_id_foreign` (`business_id`),
  KEY `invoice_schemes_scheme_type_index` (`scheme_type`),
  KEY `invoice_schemes_number_type_index` (`number_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_schemes` WRITE;
/*!40000 ALTER TABLE `invoice_schemes` DISABLE KEYS */;
INSERT INTO `invoice_schemes` VALUES
(1,1,'Default Scheme','year','sequential','INV-',1,10,4,1,'2021-04-03 13:19:33','2025-05-26 16:50:45');
/*!40000 ALTER TABLE `invoice_schemes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `media`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `media` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `file_name` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `uploaded_by` int(11) DEFAULT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_media_type` varchar(191) DEFAULT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_model_type_model_id_index` (`model_type`,`model_id`),
  KEY `media_business_id_index` (`business_id`),
  KEY `media_uploaded_by_index` (`uploaded_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `media` WRITE;
/*!40000 ALTER TABLE `media` DISABLE KEYS */;
/*!40000 ALTER TABLE `media` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=333 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES
(1,'2014_10_12_000000_create_users_table',1),
(2,'2014_10_12_100000_create_password_resets_table',1),
(3,'2016_06_01_000001_create_oauth_auth_codes_table',1),
(4,'2016_06_01_000002_create_oauth_access_tokens_table',1),
(5,'2016_06_01_000003_create_oauth_refresh_tokens_table',1),
(6,'2016_06_01_000004_create_oauth_clients_table',1),
(7,'2016_06_01_000005_create_oauth_personal_access_clients_table',1),
(8,'2017_07_05_071953_create_currencies_table',1),
(9,'2017_07_05_073658_create_business_table',1),
(10,'2017_07_22_075923_add_business_id_users_table',1),
(11,'2017_07_23_113209_create_brands_table',1),
(12,'2017_07_26_083429_create_permission_tables',1),
(13,'2017_07_26_110000_create_tax_rates_table',1),
(14,'2017_07_26_122313_create_units_table',1),
(15,'2017_07_27_075706_create_contacts_table',1),
(16,'2017_08_04_071038_create_categories_table',1),
(17,'2017_08_08_115903_create_products_table',1),
(18,'2017_08_09_061616_create_variation_templates_table',1),
(19,'2017_08_09_061638_create_variation_value_templates_table',1),
(20,'2017_08_10_061146_create_product_variations_table',1),
(21,'2017_08_10_061216_create_variations_table',1),
(22,'2017_08_19_054827_create_transactions_table',1),
(23,'2017_08_31_073533_create_purchase_lines_table',1),
(24,'2017_10_15_064638_create_transaction_payments_table',1),
(25,'2017_10_31_065621_add_default_sales_tax_to_business_table',1),
(26,'2017_11_20_051930_create_table_group_sub_taxes',1),
(27,'2017_11_20_063603_create_transaction_sell_lines',1),
(28,'2017_11_21_064540_create_barcodes_table',1),
(29,'2017_11_23_181237_create_invoice_schemes_table',1),
(30,'2017_12_25_122822_create_business_locations_table',1),
(31,'2017_12_25_160253_add_location_id_to_transactions_table',1),
(32,'2017_12_25_163227_create_variation_location_details_table',1),
(33,'2018_01_04_115627_create_sessions_table',1),
(34,'2018_01_05_112817_create_invoice_layouts_table',1),
(35,'2018_01_06_112303_add_invoice_scheme_id_and_invoice_layout_id_to_business_locations',1),
(36,'2018_01_08_104124_create_expense_categories_table',1),
(37,'2018_01_08_123327_modify_transactions_table_for_expenses',1),
(38,'2018_01_09_111005_modify_payment_status_in_transactions_table',1),
(39,'2018_01_09_111109_add_paid_on_column_to_transaction_payments_table',1),
(40,'2018_01_25_172439_add_printer_related_fields_to_business_locations_table',1),
(41,'2018_01_27_184322_create_printers_table',1),
(42,'2018_01_30_181442_create_cash_registers_table',1),
(43,'2018_01_31_125836_create_cash_register_transactions_table',1),
(44,'2018_02_07_173326_modify_business_table',1),
(45,'2018_02_08_105425_add_enable_product_expiry_column_to_business_table',1),
(46,'2018_02_08_111027_add_expiry_period_and_expiry_period_type_columns_to_products_table',1),
(47,'2018_02_08_131118_add_mfg_date_and_exp_date_purchase_lines_table',1),
(48,'2018_02_08_155348_add_exchange_rate_to_transactions_table',1),
(49,'2018_02_09_124945_modify_transaction_payments_table_for_contact_payments',1),
(50,'2018_02_12_113640_create_transaction_sell_lines_purchase_lines_table',1),
(51,'2018_02_12_114605_add_quantity_sold_in_purchase_lines_table',1),
(52,'2018_02_13_183323_alter_decimal_fields_size',1),
(53,'2018_02_14_161928_add_transaction_edit_days_to_business_table',1),
(54,'2018_02_15_161032_add_document_column_to_transactions_table',1),
(55,'2018_02_17_124709_add_more_options_to_invoice_layouts',1),
(56,'2018_02_19_111517_add_keyboard_shortcut_column_to_business_table',1),
(57,'2018_02_19_121537_stock_adjustment_move_to_transaction_table',1),
(58,'2018_02_20_165505_add_is_direct_sale_column_to_transactions_table',1),
(59,'2018_02_21_105329_create_system_table',1),
(60,'2018_02_23_100549_version_1_2',1),
(61,'2018_02_23_125648_add_enable_editing_sp_from_purchase_column_to_business_table',1),
(62,'2018_02_26_103612_add_sales_commission_agent_column_to_business_table',1),
(63,'2018_02_26_130519_modify_users_table_for_sales_cmmsn_agnt',1),
(64,'2018_02_26_134500_add_commission_agent_to_transactions_table',1),
(65,'2018_02_27_121422_add_item_addition_method_to_business_table',1),
(66,'2018_02_27_170232_modify_transactions_table_for_stock_transfer',1),
(67,'2018_03_05_153510_add_enable_inline_tax_column_to_business_table',1),
(68,'2018_03_06_210206_modify_product_barcode_types',1),
(69,'2018_03_13_181541_add_expiry_type_to_business_table',1),
(70,'2018_03_16_113446_product_expiry_setting_for_business',1),
(71,'2018_03_19_113601_add_business_settings_options',1),
(72,'2018_03_26_125334_add_pos_settings_to_business_table',1),
(73,'2018_03_26_165350_create_customer_groups_table',1),
(74,'2018_03_27_122720_customer_group_related_changes_in_tables',1),
(75,'2018_03_29_110138_change_tax_field_to_nullable_in_business_table',1),
(76,'2018_03_29_115502_add_changes_for_sr_number_in_products_and_sale_lines_table',1),
(77,'2018_03_29_134340_add_inline_discount_fields_in_purchase_lines',1),
(78,'2018_03_31_140921_update_transactions_table_exchange_rate',1),
(79,'2018_04_03_103037_add_contact_id_to_contacts_table',1),
(80,'2018_04_03_122709_add_changes_to_invoice_layouts_table',1),
(81,'2018_04_09_135320_change_exchage_rate_size_in_business_table',1),
(82,'2018_04_17_123122_add_lot_number_to_business',1),
(83,'2018_04_17_160845_add_product_racks_table',1),
(84,'2018_04_20_182015_create_res_tables_table',1),
(85,'2018_04_24_105246_restaurant_fields_in_transaction_table',1),
(86,'2018_04_24_114149_add_enabled_modules_business_table',1),
(87,'2018_04_24_133704_add_modules_fields_in_invoice_layout_table',1),
(88,'2018_04_27_132653_quotation_related_change',1),
(89,'2018_05_02_104439_add_date_format_and_time_format_to_business',1),
(90,'2018_05_02_111939_add_sell_return_to_transaction_payments',1),
(91,'2018_05_14_114027_add_rows_positions_for_products',1),
(92,'2018_05_14_125223_add_weight_to_products_table',1),
(93,'2018_05_14_164754_add_opening_stock_permission',1),
(94,'2018_05_15_134729_add_design_to_invoice_layouts',1),
(95,'2018_05_16_183307_add_tax_fields_invoice_layout',1),
(96,'2018_05_18_191956_add_sell_return_to_transaction_table',1),
(97,'2018_05_21_131349_add_custom_fileds_to_contacts_table',1),
(98,'2018_05_21_131607_invoice_layout_fields_for_sell_return',1),
(99,'2018_05_21_131949_add_custom_fileds_and_website_to_business_locations_table',1),
(100,'2018_05_22_123527_create_reference_counts_table',1),
(101,'2018_05_22_154540_add_ref_no_prefixes_column_to_business_table',1),
(102,'2018_05_24_132620_add_ref_no_column_to_transaction_payments_table',1),
(103,'2018_05_24_161026_add_location_id_column_to_business_location_table',1),
(104,'2018_05_25_180603_create_modifiers_related_table',1),
(105,'2018_05_29_121714_add_purchase_line_id_to_stock_adjustment_line_table',1),
(106,'2018_05_31_114645_add_res_order_status_column_to_transactions_table',1),
(107,'2018_06_05_103530_rename_purchase_line_id_in_stock_adjustment_lines_table',1),
(108,'2018_06_05_111905_modify_products_table_for_modifiers',1),
(109,'2018_06_06_110524_add_parent_sell_line_id_column_to_transaction_sell_lines_table',1),
(110,'2018_06_07_152443_add_is_service_staff_to_roles_table',1),
(111,'2018_06_07_182258_add_image_field_to_products_table',1),
(112,'2018_06_13_133705_create_bookings_table',1),
(113,'2018_06_15_173636_add_email_column_to_contacts_table',1),
(114,'2018_06_27_182835_add_superadmin_related_fields_business',1),
(115,'2018_07_10_101913_add_custom_fields_to_products_table',1),
(116,'2018_07_17_103434_add_sales_person_name_label_to_invoice_layouts_table',1),
(117,'2018_07_17_163920_add_theme_skin_color_column_to_business_table',1),
(118,'2018_07_24_160319_add_lot_no_line_id_to_transaction_sell_lines_table',1),
(119,'2018_07_25_110004_add_show_expiry_and_show_lot_colums_to_invoice_layouts_table',1),
(120,'2018_07_25_172004_add_discount_columns_to_transaction_sell_lines_table',1),
(121,'2018_07_26_124720_change_design_column_type_in_invoice_layouts_table',1),
(122,'2018_07_26_170424_add_unit_price_before_discount_column_to_transaction_sell_line_table',1),
(123,'2018_07_28_103614_add_credit_limit_column_to_contacts_table',1),
(124,'2018_08_08_110755_add_new_payment_methods_to_transaction_payments_table',1),
(125,'2018_08_08_122225_modify_cash_register_transactions_table_for_new_payment_methods',1),
(126,'2018_08_14_104036_add_opening_balance_type_to_transactions_table',1),
(127,'2018_09_04_155900_create_accounts_table',1),
(128,'2018_09_06_114438_create_selling_price_groups_table',1),
(129,'2018_09_06_154057_create_variation_group_prices_table',1),
(130,'2018_09_07_102413_add_permission_to_access_default_selling_price',1),
(131,'2018_09_07_134858_add_selling_price_group_id_to_transactions_table',1),
(132,'2018_09_10_112448_update_product_type_to_single_if_null_in_products_table',1),
(133,'2018_09_10_152703_create_account_transactions_table',1),
(134,'2018_09_10_173656_add_account_id_column_to_transaction_payments_table',1),
(135,'2018_09_19_123914_create_notification_templates_table',1),
(136,'2018_09_22_110504_add_sms_and_email_settings_columns_to_business_table',1),
(137,'2018_09_24_134942_add_lot_no_line_id_to_stock_adjustment_lines_table',1),
(138,'2018_09_26_105557_add_transaction_payments_for_existing_expenses',1),
(139,'2018_09_27_111609_modify_transactions_table_for_purchase_return',1),
(140,'2018_09_27_131154_add_quantity_returned_column_to_purchase_lines_table',1),
(141,'2018_10_02_131401_add_return_quantity_column_to_transaction_sell_lines_table',1),
(142,'2018_10_03_104918_add_qty_returned_column_to_transaction_sell_lines_purchase_lines_table',1),
(143,'2018_10_03_185947_add_default_notification_templates_to_database',1),
(144,'2018_10_09_153105_add_business_id_to_transaction_payments_table',1),
(145,'2018_10_16_135229_create_permission_for_sells_and_purchase',1),
(146,'2018_10_22_114441_add_columns_for_variable_product_modifications',1),
(147,'2018_10_22_134428_modify_variable_product_data',1),
(148,'2018_10_30_181558_add_table_tax_headings_to_invoice_layout',1),
(149,'2018_10_31_122619_add_pay_terms_field_transactions_table',1),
(150,'2018_10_31_161328_add_new_permissions_for_pos_screen',1),
(151,'2018_10_31_174752_add_access_selected_contacts_only_to_users_table',1),
(152,'2018_10_31_175627_add_user_contact_access',1),
(153,'2018_10_31_180559_add_auto_send_sms_column_to_notification_templates_table',1),
(154,'2018_11_02_171949_change_card_type_column_to_varchar_in_transaction_payments_table',1),
(155,'2018_11_08_105621_add_role_permissions',1),
(156,'2018_11_26_114135_add_is_suspend_column_to_transactions_table',1),
(157,'2018_11_28_104410_modify_units_table_for_multi_unit',1),
(158,'2018_11_28_170952_add_sub_unit_id_to_purchase_lines_and_sell_lines',1),
(159,'2018_11_29_115918_add_primary_key_in_system_table',1),
(160,'2018_12_03_185546_add_product_description_column_to_products_table',1),
(161,'2018_12_06_114937_modify_system_table_and_users_table',1),
(162,'2018_12_13_160007_add_custom_fields_display_options_to_invoice_layouts_table',1),
(163,'2018_12_14_103307_modify_system_table',1),
(164,'2018_12_18_133837_add_prev_balance_due_columns_to_invoice_layouts_table',1),
(165,'2018_12_18_170656_add_invoice_token_column_to_transaction_table',1),
(166,'2018_12_20_133639_add_date_time_format_column_to_invoice_layouts_table',1),
(167,'2018_12_21_120659_add_recurring_invoice_fields_to_transactions_table',1),
(168,'2018_12_24_154933_create_notifications_table',1),
(169,'2019_01_08_112015_add_document_column_to_transaction_payments_table',1),
(170,'2019_01_10_124645_add_account_permission',1),
(171,'2019_01_16_125825_add_subscription_no_column_to_transactions_table',1),
(172,'2019_01_28_111647_add_order_addresses_column_to_transactions_table',1),
(173,'2019_02_13_173821_add_is_inactive_column_to_products_table',1),
(174,'2019_02_19_103118_create_discounts_table',1),
(175,'2019_02_21_120324_add_discount_id_column_to_transaction_sell_lines_table',1),
(176,'2019_02_21_134324_add_permission_for_discount',1),
(177,'2019_03_04_170832_add_service_staff_columns_to_transaction_sell_lines_table',1),
(178,'2019_03_09_102425_add_sub_type_column_to_transactions_table',1),
(179,'2019_03_09_124457_add_indexing_transaction_sell_lines_purchase_lines_table',1),
(180,'2019_03_12_120336_create_activity_log_table',1),
(181,'2019_03_15_132925_create_media_table',1),
(182,'2019_05_08_130339_add_indexing_to_parent_id_in_transaction_payments_table',1),
(183,'2019_05_10_132311_add_missing_column_indexing',1),
(184,'2019_05_14_091812_add_show_image_column_to_invoice_layouts_table',1),
(185,'2019_05_25_104922_add_view_purchase_price_permission',1),
(186,'2019_06_17_103515_add_profile_informations_columns_to_users_table',1),
(187,'2019_06_18_135524_add_permission_to_view_own_sales_only',1),
(188,'2019_06_19_112058_add_database_changes_for_reward_points',1),
(189,'2019_06_28_133732_change_type_column_to_string_in_transactions_table',1),
(190,'2019_07_13_111420_add_is_created_from_api_column_to_transactions_table',1),
(191,'2019_07_15_165136_add_fields_for_combo_product',1),
(192,'2019_07_19_103446_add_mfg_quantity_used_column_to_purchase_lines_table',1),
(193,'2019_07_22_152649_add_not_for_selling_in_product_table',1),
(194,'2019_07_29_185351_add_show_reward_point_column_to_invoice_layouts_table',1),
(195,'2019_08_08_162302_add_sub_units_related_fields',1),
(196,'2019_08_26_133419_update_price_fields_decimal_point',1),
(197,'2019_09_02_160054_remove_location_permissions_from_roles',1),
(198,'2019_09_03_185259_add_permission_for_pos_screen',1),
(199,'2019_09_04_163141_add_location_id_to_cash_registers_table',1),
(200,'2019_09_04_184008_create_types_of_services_table',1),
(201,'2019_09_06_131445_add_types_of_service_fields_to_transactions_table',1),
(202,'2019_09_09_134810_add_default_selling_price_group_id_column_to_business_locations_table',1),
(203,'2019_09_12_105616_create_product_locations_table',1),
(204,'2019_09_17_122522_add_custom_labels_column_to_business_table',1),
(205,'2019_09_18_164319_add_shipping_fields_to_transactions_table',1),
(206,'2019_09_19_170927_close_all_active_registers',1),
(207,'2019_09_23_161906_add_media_description_cloumn_to_media_table',1),
(208,'2019_10_18_155633_create_account_types_table',1),
(209,'2019_10_22_163335_add_common_settings_column_to_business_table',1),
(210,'2019_10_29_132521_add_update_purchase_status_permission',1),
(211,'2019_11_09_110522_add_indexing_to_lot_number',1),
(212,'2019_11_19_170824_add_is_active_column_to_business_locations_table',1),
(213,'2019_11_21_162913_change_quantity_field_types_to_decimal',1),
(214,'2019_11_25_160340_modify_categories_table_for_polymerphic_relationship',1),
(215,'2019_12_02_105025_create_warranties_table',1),
(216,'2019_12_03_180342_add_common_settings_field_to_invoice_layouts_table',1),
(217,'2019_12_05_183955_add_more_fields_to_users_table',1),
(218,'2019_12_06_174904_add_change_return_label_column_to_invoice_layouts_table',1),
(219,'2019_12_11_121307_add_draft_and_quotation_list_permissions',1),
(220,'2019_12_12_180126_copy_expense_total_to_total_before_tax',1),
(221,'2019_12_19_181412_make_alert_quantity_field_nullable_on_products_table',1),
(222,'2019_12_25_173413_create_dashboard_configurations_table',1),
(223,'2020_01_08_133506_create_document_and_notes_table',1),
(224,'2020_01_09_113252_add_cc_bcc_column_to_notification_templates_table',1),
(225,'2020_01_16_174818_add_round_off_amount_field_to_transactions_table',1),
(226,'2020_01_28_162345_add_weighing_scale_settings_in_business_settings_table',1),
(227,'2020_02_18_172447_add_import_fields_to_transactions_table',1),
(228,'2020_03_13_135844_add_is_active_column_to_selling_price_groups_table',1),
(229,'2020_03_16_115449_add_contact_status_field_to_contacts_table',1),
(230,'2020_03_26_124736_add_allow_login_column_in_users_table',1),
(231,'2020_04_13_154150_add_feature_products_column_to_business_loactions',1),
(232,'2020_04_15_151802_add_user_type_to_users_table',1),
(233,'2020_04_22_153905_add_subscription_repeat_on_column_to_transactions_table',1),
(234,'2020_04_28_111436_add_shipping_address_to_contacts_table',1),
(235,'2020_06_01_094654_add_max_sale_discount_column_to_users_table',1),
(236,'2020_06_12_162245_modify_contacts_table',1),
(237,'2020_06_22_103104_change_recur_interval_default_to_one',1),
(238,'2020_07_09_174621_add_balance_field_to_contacts_table',1),
(239,'2020_07_23_104933_change_status_column_to_varchar_in_transaction_table',1),
(240,'2020_09_07_171059_change_completed_stock_transfer_status_to_final',1),
(241,'2020_09_21_123224_modify_booking_status_column_in_bookings_table',1),
(242,'2020_09_22_121639_create_discount_variations_table',1),
(243,'2020_10_05_121550_modify_business_location_table_for_invoice_layout',1),
(244,'2020_10_16_175726_set_status_as_received_for_opening_stock',1),
(245,'2018_10_01_151252_create_documents_table',2),
(246,'2018_10_02_151803_create_document_shares_table',2),
(247,'2018_10_09_134558_create_reminders_table',2),
(248,'2018_11_16_170756_create_to_dos_table',2),
(249,'2019_02_22_120329_essentials_messages',2),
(250,'2019_02_22_161513_add_message_permissions',2),
(251,'2019_03_29_164339_add_essentials_version_to_system_table',2),
(252,'2019_05_17_153306_create_essentials_leave_types_table',2),
(253,'2019_05_17_175921_create_essentials_leaves_table',2),
(254,'2019_05_21_154517_add_essentials_settings_columns_to_business_table',2),
(255,'2019_05_21_181653_create_table_essentials_attendance',2),
(256,'2019_05_30_110049_create_essentials_payrolls_table',2),
(257,'2019_06_04_105723_create_essentials_holidays_table',2),
(258,'2019_06_28_134217_add_payroll_columns_to_transactions_table',2),
(259,'2019_08_26_103520_add_approve_leave_permission',2),
(260,'2019_08_27_103724_create_essentials_allowance_and_deduction_table',2),
(261,'2019_08_27_105236_create_essentials_user_allowances_and_deductions',2),
(262,'2019_09_20_115906_add_more_columns_to_essentials_to_dos_table',2),
(263,'2019_09_23_120439_create_essentials_todo_comments_table',2),
(264,'2019_12_05_170724_add_hrm_columns_to_users_table',2),
(265,'2019_12_09_105809_add_allowance_and_deductions_permission',2),
(266,'2020_03_28_152838_create_essentials_shift_table',2),
(267,'2020_03_30_162029_create_user_shifts_table',2),
(268,'2020_03_31_134558_add_shift_id_to_attendance_table',2),
(269,'2020_11_05_105157_modify_todos_date_column_type',2),
(270,'2020_11_11_174852_add_end_time_column_to_essentials_reminders_table',2),
(271,'2020_11_26_170527_create_essentials_kb_table',2),
(272,'2020_11_30_112615_create_essentials_kb_users_table',2),
(273,'2021_02_12_185514_add_clock_in_location_to_essentials_attendances_table',2),
(274,'2021_02_16_190203_add_essentials_module_indexing',2),
(275,'2021_02_27_133448_add_columns_to_users_table',2),
(276,'2021_03_04_174857_create_payroll_groups_table',2),
(277,'2021_03_04_175025_create_payroll_group_transactions_table',2),
(278,'2021_03_09_123914_add_auto_clockout_to_essentials_shifts',2),
(279,'2020_10_23_170823_add_for_group_tax_column_to_tax_rates_table',3),
(280,'2020_11_04_130940_add_more_custom_fields_to_contacts_table',3),
(281,'2020_11_10_152841_add_cash_register_permissions',3),
(282,'2020_11_17_164041_modify_type_column_to_varchar_in_contacts_table',3),
(283,'2020_12_18_181447_add_shipping_custom_fields_to_transactions_table',3),
(284,'2020_12_22_164303_add_sub_status_column_to_transactions_table',3),
(285,'2020_12_24_153050_add_custom_fields_to_transactions_table',3),
(286,'2020_12_28_105403_add_whatsapp_text_column_to_notification_templates_table',3),
(287,'2020_12_29_165925_add_model_document_type_to_media_table',3),
(288,'2021_02_08_175632_add_contact_number_fields_to_users_table',3),
(289,'2021_02_11_172217_add_indexing_for_multiple_columns',3),
(290,'2021_02_23_122043_add_more_columns_to_customer_groups_table',3),
(291,'2021_02_24_175551_add_print_invoice_permission_to_all_roles',3),
(292,'2021_03_03_162021_add_purchase_order_columns_to_purchase_lines_and_transactions_table',3),
(293,'2021_03_11_120229_add_sales_order_columns',3),
(294,'2021_03_16_120705_add_business_id_to_activity_log_table',3),
(295,'2021_03_16_153427_add_code_columns_to_business_table',3),
(296,'2021_03_18_173308_add_account_details_column_to_accounts_table',3),
(297,'2021_03_18_183119_add_prefer_payment_account_columns_to_transactions_table',3),
(298,'2021_03_22_120810_add_more_types_of_service_custom_fields',3),
(299,'2021_03_24_183132_add_shipping_export_custom_field_details_to_contacts_table',3),
(300,'2021_03_25_170715_add_export_custom_fields_info_to_transactions_table',3),
(301,'2021_04_15_063449_add_denominations_column_to_cash_registers_table',3),
(302,'2021_05_22_083426_add_indexing_to_account_transactions_table',3),
(303,'2021_07_08_065808_add_additional_expense_columns_to_transaction_table',3),
(304,'2021_07_13_082918_add_qr_code_columns_to_invoice_layouts_table',3),
(305,'2021_07_21_061615_add_fields_to_show_commission_agent_in_invoice_layout',3),
(306,'2021_08_13_105549_add_crm_contact_id_to_users_table',3),
(307,'2021_08_25_114932_add_payment_link_fields_to_transaction_payments_table',3),
(308,'2021_09_01_063110_add_spg_column_to_discounts_table',3),
(309,'2021_09_03_061528_modify_cash_register_transactions_table',3),
(310,'2021_10_05_061658_add_source_column_to_transactions_table',3),
(311,'2021_12_16_121851_add_parent_id_column_to_expense_categories_table',3),
(312,'2022_04_14_075120_add_payment_type_column_to_transaction_payments_table',3),
(313,'2022_04_21_083327_create_cash_denominations_table',3),
(314,'2022_05_10_055307_add_delivery_date_column_to_transactions_table',3),
(315,'2022_06_13_123135_add_currency_precision_and_quantity_precision_fields_to_business_table',3),
(316,'2022_06_28_133342_add_secondary_unit_columns_to_products_sell_line_purchase_lines_tables',3),
(317,'2022_07_13_114307_create_purchase_requisition_related_columns',3),
(318,'2022_08_25_132707_add_service_staff_timer_fields_to_products_and_users_table',3),
(319,'2023_01_28_114255_add_letter_head_column_to_invoice_layouts_table',3),
(320,'2023_02_11_161510_add_event_column_to_activity_log_table',3),
(321,'2023_02_11_161511_add_batch_uuid_column_to_activity_log_table',3),
(322,'2023_03_02_170312_add_provider_to_oauth_clients_table',3),
(323,'2023_03_21_122731_add_sale_invoice_scheme_id_business_table',3),
(324,'2023_03_21_170446_add_number_type_to_invoice_scheme',3),
(325,'2023_04_17_155216_add_custom_fields_to_products',3),
(326,'2023_04_28_130247_add_price_type_to_group_price_table',3),
(327,'2023_06_21_033923_add_delivery_person_in_transactions',3),
(328,'2023_09_13_153555_add_service_staff_pin_columns_in_users',3),
(329,'2023_09_15_154404_add_is_kitchen_order_in_transactions',3),
(330,'2023_12_06_152840_add_contact_type_in_contacts',4),
(331,'2024_10_03_151459_modify_transaction_sell_lines_purchase_lines_table',5),
(332,'2025_03_07_114637_add_more_addresh_column_in_contact',6);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_permissions` (
  `permission_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_permissions` WRITE;
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
INSERT INTO `model_has_permissions` VALUES
(77,'App\\User',1),
(90,'App\\User',2),
(77,'App\\User',3),
(79,'App\\User',3),
(77,'App\\User',4),
(79,'App\\User',4),
(77,'App\\User',5),
(79,'App\\User',6),
(77,'App\\User',9),
(90,'App\\User',14),
(90,'App\\User',15);
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `model_has_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `model_has_roles` (
  `role_id` int(10) unsigned NOT NULL,
  `model_type` varchar(191) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_type_model_id_index` (`model_type`,`model_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `model_has_roles` WRITE;
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` VALUES
(1,'App\\User',1),
(3,'App\\User',2),
(1,'App\\User',3),
(1,'App\\User',4),
(3,'App\\User',4),
(2,'App\\User',5),
(2,'App\\User',6),
(2,'App\\User',9),
(2,'App\\User',14),
(2,'App\\User',15);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notification_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notification_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(11) NOT NULL,
  `template_for` varchar(191) NOT NULL,
  `email_body` text DEFAULT NULL,
  `sms_body` text DEFAULT NULL,
  `whatsapp_text` text DEFAULT NULL,
  `subject` varchar(191) DEFAULT NULL,
  `cc` varchar(191) DEFAULT NULL,
  `bcc` varchar(191) DEFAULT NULL,
  `auto_send` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_sms` tinyint(1) NOT NULL DEFAULT 0,
  `auto_send_wa_notif` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notification_templates` WRITE;
/*!40000 ALTER TABLE `notification_templates` DISABLE KEYS */;
INSERT INTO `notification_templates` VALUES
(1,1,'new_sale','<p>Dear {contact_name},</p>\n\n                    <p>Your invoice number is {invoice_number}<br />\n                    Total amount: {total_amount}<br />\n                    Paid amount: {received_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(2,1,'payment_received','<p>Dear {contact_name},</p>\n\n                <p>We have received a payment of {received_amount}</p>\n\n                <p>{business_logo}</p>','Dear {contact_name}, We have received a payment of {received_amount}. {business_name}',NULL,'Payment Received, from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(3,1,'payment_reminder','<p>Dear {contact_name},</p>\n\n                    <p>This is to remind you that you have pending payment of {due_amount}. Kindly pay it as soon as possible.</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, You have pending payment of {due_amount}. Kindly pay it as soon as possible. {business_name}',NULL,'Payment Reminder, from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(4,1,'new_booking','<p>Dear {contact_name},</p>\n\n                    <p>Your booking is confirmed</p>\n\n                    <p>Date: {start_time} to {end_time}</p>\n\n                    <p>Table: {table}</p>\n\n                    <p>Location: {location}</p>\n\n                    <p>{business_logo}</p>','Dear {contact_name}, Your booking is confirmed. Date: {start_time} to {end_time}, Table: {table}, Location: {location}',NULL,'Booking Confirmed - {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(5,1,'new_order','<p>Dear {contact_name},</p>\n\n                    <p>We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','Dear {contact_name}, We have a new order with reference number {order_ref_number}. Kindly process the products as soon as possible. {business_name}',NULL,'New Order, from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(6,1,'payment_paid','<p>Dear {contact_name},</p>\n\n                    <p>We have paid amount {paid_amount} again invoice number {order_ref_number}.<br />\n                    Kindly note it down.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have paid amount {paid_amount} again invoice number {order_ref_number}.\n                    Kindly note it down. {business_name}',NULL,'Payment Paid, from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(7,1,'items_received','<p>Dear {contact_name},</p>\n\n                    <p>We have received all items from invoice reference number {order_ref_number}. Thank you for processing it.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','We have received all items from invoice reference number {order_ref_number}. Thank you for processing it. {business_name}',NULL,'Items received, from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(8,1,'items_pending','<p>Dear {contact_name},<br />\n                    This is to remind you that we have not yet received some items from invoice reference number {order_ref_number}. Please process it as soon as possible.</p>\n\n                    <p>{business_name}<br />\n                    {business_logo}</p>','This is to remind you that we have not yet received some items from invoice reference number {order_ref_number} . Please process it as soon as possible.{business_name}',NULL,'Items Pending, from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33'),
(9,1,'new_quotation','<p>Dear {contact_name},</p>\n\n                    <p>Your quotation number is {invoice_number}<br />\n                    Total amount: {total_amount}</p>\n\n                    <p>Thank you for shopping with us.</p>\n\n                    <p>{business_logo}</p>\n\n                    <p>&nbsp;</p>','Dear {contact_name}, Thank you for shopping with us. {business_name}',NULL,'Thank you from {business_name}',NULL,NULL,0,0,0,'2021-04-03 13:19:33','2021-04-03 13:19:33');
/*!40000 ALTER TABLE `notification_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `notifications` (
  `id` char(36) NOT NULL,
  `type` varchar(191) NOT NULL,
  `notifiable_type` varchar(191) NOT NULL,
  `notifiable_id` bigint(20) unsigned NOT NULL,
  `data` text NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notifications_notifiable_type_notifiable_id_index` (`notifiable_type`,`notifiable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `notifications` WRITE;
/*!40000 ALTER TABLE `notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `notifications` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_access_tokens` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_access_tokens_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_access_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_auth_codes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_auth_codes` (
  `id` varchar(100) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `scopes` text DEFAULT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_auth_codes` WRITE;
/*!40000 ALTER TABLE `oauth_auth_codes` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_auth_codes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `secret` varchar(100) NOT NULL,
  `provider` varchar(191) DEFAULT NULL,
  `redirect` text NOT NULL,
  `personal_access_client` tinyint(1) NOT NULL,
  `password_client` tinyint(1) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_clients_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_clients` WRITE;
/*!40000 ALTER TABLE `oauth_clients` DISABLE KEYS */;
INSERT INTO `oauth_clients` VALUES
(1,NULL,'SalesPro POS Personal Access Client','vGYHlbQWhCzuiJwZ7F6EKyYYGiJmM57DSLFKfYOH',NULL,'http://localhost',1,0,0,'2023-12-30 17:53:32','2023-12-30 17:53:32'),
(2,NULL,'SalesPro POS Password Grant Client','bZa8j3kA1gzKtwoogePcvVulURo7szIc267sr1sf','users','http://localhost',0,1,0,'2023-12-30 17:53:32','2023-12-30 17:53:32'),
(3,NULL,'SALESPRO Personal Access Client','cJZrArzU53x0L0iWeemrLu8ldN4JniRg6bi745b6',NULL,'http://localhost',1,0,0,'2024-08-18 16:51:39','2024-08-18 16:51:39'),
(4,NULL,'SALESPRO Password Grant Client','eIedPrq1rUW0lkiWUs6ihHwfYUsyZYwJZNXa4jAC','users','http://localhost',0,1,0,'2024-08-18 16:51:39','2024-08-18 16:51:39'),
(5,NULL,'Ultimate POS Personal Access Client','i3g8d9fQLaMeaL6ldHA5IJavF7hBZdZYWAxu8d2a',NULL,'http://localhost',1,0,0,'2024-11-11 23:53:04','2024-11-11 23:53:04'),
(6,NULL,'Ultimate POS Password Grant Client','JJNRLlTuomNThMX4VO1TPNGoRI9m226msFZhmRUc','users','http://localhost',0,1,0,'2024-11-11 23:53:04','2024-11-11 23:53:04'),
(7,NULL,'SALESPRO Personal Access Client','f7QGUchY86r9qVcjKbs8InnzeQTKDogOxnblK3Oq',NULL,'http://localhost',1,0,0,'2025-05-13 17:28:12','2025-05-13 17:28:12'),
(8,NULL,'SALESPRO Password Grant Client','45FvYyMSTZ1WLSH0rqlhF7aYNXLI9t64zZyzJgh2','users','http://localhost',0,1,0,'2025-05-13 17:28:12','2025-05-13 17:28:12'),
(9,NULL,'SALESPRO Personal Access Client','oiaR1clLoRURbP3E5OIpy9VlMtmtFEUaXfmbAwtl',NULL,'http://localhost',1,0,0,'2025-05-15 08:25:30','2025-05-15 08:25:30'),
(10,NULL,'SALESPRO Password Grant Client','uxpMJsc7HYpvHKL2mjDq0dyjZ4XJNSspCILkFRFY','users','http://localhost',0,1,0,'2025-05-15 08:25:30','2025-05-15 08:25:30');
/*!40000 ALTER TABLE `oauth_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_personal_access_clients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_personal_access_clients` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `client_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_personal_access_clients_client_id_index` (`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_personal_access_clients` WRITE;
/*!40000 ALTER TABLE `oauth_personal_access_clients` DISABLE KEYS */;
INSERT INTO `oauth_personal_access_clients` VALUES
(1,1,'2023-12-30 17:53:32','2023-12-30 17:53:32'),
(2,3,'2024-08-18 16:51:39','2024-08-18 16:51:39'),
(3,5,'2024-11-11 23:53:04','2024-11-11 23:53:04'),
(4,7,'2025-05-13 17:28:12','2025-05-13 17:28:12'),
(5,9,'2025-05-15 08:25:30','2025-05-15 08:25:30');
/*!40000 ALTER TABLE `oauth_personal_access_clients` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `oauth_refresh_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `oauth_refresh_tokens` (
  `id` varchar(100) NOT NULL,
  `access_token_id` varchar(100) NOT NULL,
  `revoked` tinyint(1) NOT NULL,
  `expires_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `oauth_refresh_tokens_access_token_id_index` (`access_token_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `oauth_refresh_tokens` WRITE;
/*!40000 ALTER TABLE `oauth_refresh_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `oauth_refresh_tokens` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_resets` (
  `email` varchar(191) NOT NULL,
  `token` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `permissions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `guard_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=146 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `permissions` WRITE;
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` VALUES
(1,'profit_loss_report.view','web','2021-04-03 13:08:50',NULL),
(2,'direct_sell.access','web','2021-04-03 13:08:50',NULL),
(3,'product.opening_stock','web','2021-04-03 13:09:15','2021-04-03 13:09:15'),
(4,'crud_all_bookings','web','2021-04-03 13:09:26','2021-04-03 13:09:26'),
(5,'crud_own_bookings','web','2021-04-03 13:09:26','2021-04-03 13:09:26'),
(6,'access_default_selling_price','web','2021-04-03 13:09:41','2021-04-03 13:09:41'),
(7,'purchase.payments','web','2021-04-03 13:09:49','2021-04-03 13:09:49'),
(8,'sell.payments','web','2021-04-03 13:09:49','2021-04-03 13:09:49'),
(9,'edit_product_price_from_sale_screen','web','2021-04-03 13:09:51','2021-04-03 13:09:51'),
(10,'edit_product_discount_from_sale_screen','web','2021-04-03 13:09:51','2021-04-03 13:09:51'),
(11,'roles.view','web','2021-04-03 13:09:54','2021-04-03 13:09:54'),
(12,'roles.create','web','2021-04-03 13:09:54','2021-04-03 13:09:54'),
(13,'roles.update','web','2021-04-03 13:09:54','2021-04-03 13:09:54'),
(14,'roles.delete','web','2021-04-03 13:09:54','2021-04-03 13:09:54'),
(15,'account.access','web','2021-04-03 13:10:03','2021-04-03 13:10:03'),
(16,'discount.access','web','2021-04-03 13:10:06','2021-04-03 13:10:06'),
(17,'view_purchase_price','web','2021-04-03 13:10:15','2021-04-03 13:10:15'),
(18,'view_own_sell_only','web','2021-04-03 13:10:15','2021-04-03 13:10:15'),
(19,'edit_product_discount_from_pos_screen','web','2021-04-03 13:10:26','2021-04-03 13:10:26'),
(20,'edit_product_price_from_pos_screen','web','2021-04-03 13:10:26','2021-04-03 13:10:26'),
(21,'access_shipping','web','2021-04-03 13:10:31','2021-04-03 13:10:31'),
(22,'purchase.update_status','web','2021-04-03 13:10:33','2021-04-03 13:10:33'),
(23,'list_drafts','web','2021-04-03 13:10:41','2021-04-03 13:10:41'),
(24,'list_quotations','web','2021-04-03 13:10:41','2021-04-03 13:10:41'),
(25,'user.view','web','2021-04-03 13:13:03',NULL),
(26,'user.create','web','2021-04-03 13:13:03',NULL),
(27,'user.update','web','2021-04-03 13:13:03',NULL),
(28,'user.delete','web','2021-04-03 13:13:03',NULL),
(29,'supplier.view','web','2021-04-03 13:13:03',NULL),
(30,'supplier.create','web','2021-04-03 13:13:03',NULL),
(31,'supplier.update','web','2021-04-03 13:13:03',NULL),
(32,'supplier.delete','web','2021-04-03 13:13:03',NULL),
(33,'customer.view','web','2021-04-03 13:13:03',NULL),
(34,'customer.create','web','2021-04-03 13:13:03',NULL),
(35,'customer.update','web','2021-04-03 13:13:03',NULL),
(36,'customer.delete','web','2021-04-03 13:13:03',NULL),
(37,'product.view','web','2021-04-03 13:13:03',NULL),
(38,'product.create','web','2021-04-03 13:13:03',NULL),
(39,'product.update','web','2021-04-03 13:13:03',NULL),
(40,'product.delete','web','2021-04-03 13:13:03',NULL),
(41,'purchase.view','web','2021-04-03 13:13:03',NULL),
(42,'purchase.create','web','2021-04-03 13:13:03',NULL),
(43,'purchase.update','web','2021-04-03 13:13:03',NULL),
(44,'purchase.delete','web','2021-04-03 13:13:03',NULL),
(45,'sell.view','web','2021-04-03 13:13:03',NULL),
(46,'sell.create','web','2021-04-03 13:13:03',NULL),
(47,'sell.update','web','2021-04-03 13:13:03',NULL),
(48,'sell.delete','web','2021-04-03 13:13:03',NULL),
(49,'purchase_n_sell_report.view','web','2021-04-03 13:13:03',NULL),
(50,'contacts_report.view','web','2021-04-03 13:13:03',NULL),
(51,'stock_report.view','web','2021-04-03 13:13:03',NULL),
(52,'tax_report.view','web','2021-04-03 13:13:03',NULL),
(53,'trending_product_report.view','web','2021-04-03 13:13:03',NULL),
(54,'register_report.view','web','2021-04-03 13:13:03',NULL),
(55,'sales_representative.view','web','2021-04-03 13:13:03',NULL),
(56,'expense_report.view','web','2021-04-03 13:13:03',NULL),
(57,'business_settings.access','web','2021-04-03 13:13:03',NULL),
(58,'barcode_settings.access','web','2021-04-03 13:13:03',NULL),
(59,'invoice_settings.access','web','2021-04-03 13:13:03',NULL),
(60,'brand.view','web','2021-04-03 13:13:03',NULL),
(61,'brand.create','web','2021-04-03 13:13:03',NULL),
(62,'brand.update','web','2021-04-03 13:13:03',NULL),
(63,'brand.delete','web','2021-04-03 13:13:03',NULL),
(64,'tax_rate.view','web','2021-04-03 13:13:03',NULL),
(65,'tax_rate.create','web','2021-04-03 13:13:03',NULL),
(66,'tax_rate.update','web','2021-04-03 13:13:03',NULL),
(67,'tax_rate.delete','web','2021-04-03 13:13:03',NULL),
(68,'unit.view','web','2021-04-03 13:13:03',NULL),
(69,'unit.create','web','2021-04-03 13:13:03',NULL),
(70,'unit.update','web','2021-04-03 13:13:03',NULL),
(71,'unit.delete','web','2021-04-03 13:13:03',NULL),
(72,'category.view','web','2021-04-03 13:13:03',NULL),
(73,'category.create','web','2021-04-03 13:13:03',NULL),
(74,'category.update','web','2021-04-03 13:13:03',NULL),
(75,'category.delete','web','2021-04-03 13:13:03',NULL),
(76,'expense.access','web','2021-04-03 13:13:03',NULL),
(77,'access_all_locations','web','2021-04-03 13:13:03',NULL),
(78,'dashboard.data','web','2021-04-03 13:13:03',NULL),
(79,'location.1','web','2021-04-03 13:19:33','2021-04-03 13:19:33'),
(80,'selling_price_group.1','web','2021-04-03 15:33:22','2021-04-03 15:33:22'),
(81,'selling_price_group.2','web','2021-04-03 15:33:54','2021-04-03 15:33:54'),
(82,'view_product_stock_value','web','2021-04-11 09:02:47','2021-04-11 09:02:47'),
(83,'access_printers','web','2021-04-11 09:02:47','2021-04-11 09:02:47'),
(84,'essentials.create_message','web','2022-02-09 20:18:36','2022-02-09 20:18:36'),
(85,'essentials.view_message','web','2022-02-09 20:18:37','2022-02-09 20:18:37'),
(86,'essentials.approve_leave','web','2022-02-09 20:18:40','2022-02-09 20:18:40'),
(87,'essentials.assign_todos','web','2022-02-09 20:18:42','2022-02-09 20:18:42'),
(88,'essentials.add_allowance_and_deduction','web','2022-02-09 20:18:43','2022-02-09 20:18:43'),
(89,'selling_price_group.3','web','2022-07-31 21:48:48','2022-07-31 21:48:48'),
(90,'location.2','web','2023-03-12 22:06:35','2023-03-12 22:06:35'),
(91,'view_own_purchase','web','2023-03-30 22:26:15','2023-03-30 22:26:15'),
(92,'view_cash_register','web','2023-12-30 17:52:47','2023-12-30 17:52:47'),
(93,'close_cash_register','web','2023-12-30 17:52:47','2023-12-30 17:52:47'),
(94,'print_invoice','web','2023-12-30 17:53:04','2023-12-30 17:53:04'),
(95,'view_export_buttons','web','2023-12-31 07:15:17','2023-12-31 07:15:17'),
(96,'edit_purchase_payment','web','2023-12-31 07:15:17','2023-12-31 07:15:17'),
(97,'delete_purchase_payment','web','2023-12-31 07:15:17','2023-12-31 07:15:17'),
(98,'edit_pos_payment','web','2023-12-31 07:15:17','2023-12-31 07:15:17'),
(99,'disable_pay_checkout','web','2023-12-31 07:15:17','2023-12-31 07:15:17'),
(100,'disable_draft','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(101,'disable_express_checkout','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(102,'disable_discount','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(103,'disable_suspend_sale','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(104,'disable_credit_sale','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(105,'disable_quotation','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(106,'disable_card','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(107,'view_paid_sells_only','web','2023-12-31 07:15:18','2023-12-31 07:15:18'),
(108,'view_due_sells_only','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(109,'view_partial_sells_only','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(110,'view_overdue_sells_only','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(111,'direct_sell.update','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(112,'direct_sell.delete','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(113,'view_commission_agent_sell','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(114,'edit_sell_payment','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(115,'delete_sell_payment','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(116,'access_sell_return','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(117,'access_own_sell_return','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(118,'edit_invoice_number','web','2023-12-31 07:15:19','2023-12-31 07:15:19'),
(119,'draft.update','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(120,'draft.delete','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(121,'quotation.update','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(122,'quotation.delete','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(123,'access_pending_shipments_only','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(124,'access_commission_agent_shipping','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(125,'expense.add','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(126,'expense.edit','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(127,'expense.delete','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(128,'edit_account_transaction','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(129,'delete_account_transaction','web','2023-12-31 07:15:20','2023-12-31 07:15:20'),
(130,'customer_irrespective_of_sell','web','2023-12-31 07:15:21','2023-12-31 07:15:21'),
(131,'direct_sell.view','web','2023-12-31 07:15:21','2023-12-31 07:15:21'),
(132,'draft.view_all','web','2023-12-31 07:15:21','2023-12-31 07:15:21'),
(133,'quotation.view_all','web','2023-12-31 07:15:21','2023-12-31 07:15:21'),
(134,'all_expense.access','web','2023-12-31 07:15:21','2023-12-31 07:15:21'),
(135,'selling_price_group.4','web','2024-11-24 22:55:52','2024-11-24 22:55:52'),
(136,'purchase_order.create','web','2024-12-01 09:11:45','2024-12-01 09:11:45'),
(137,'purchase_order.update','web','2024-12-01 09:11:45','2024-12-01 09:11:45'),
(138,'so.create','web','2024-12-01 09:11:45','2024-12-01 09:11:45'),
(139,'so.update','web','2024-12-01 09:11:45','2024-12-01 09:11:45'),
(140,'purchase_order.view_all','web','2024-12-01 09:11:45','2024-12-01 09:11:45'),
(141,'so.view_all','web','2024-12-01 09:11:45','2024-12-01 09:11:45'),
(142,'selling_price_group.5','web','2024-12-27 22:25:57','2024-12-27 22:25:57'),
(143,'purchase_order.delete','web','2025-05-23 06:19:43','2025-05-23 06:19:43'),
(144,'so.delete','web','2025-05-23 06:19:43','2025-05-23 06:19:43'),
(145,'purchase_order.view_own','web','2025-05-23 06:19:43','2025-05-23 06:19:43');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `printers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `name` varchar(191) NOT NULL,
  `connection_type` enum('network','windows','linux') NOT NULL,
  `capability_profile` enum('default','simple','SP2000','TEP-200M','P822D') NOT NULL DEFAULT 'default',
  `char_per_line` varchar(191) DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `port` varchar(191) DEFAULT NULL,
  `path` varchar(191) DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `printers_business_id_foreign` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `printers` WRITE;
/*!40000 ALTER TABLE `printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `printers` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_locations` (
  `product_id` int(11) NOT NULL,
  `location_id` int(11) NOT NULL,
  KEY `product_locations_product_id_index` (`product_id`),
  KEY `product_locations_location_id_index` (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_locations` WRITE;
/*!40000 ALTER TABLE `product_locations` DISABLE KEYS */;
INSERT INTO `product_locations` VALUES
(1,1),
(1,2),
(2,1),
(2,2),
(3,1),
(3,2),
(4,1),
(4,2),
(5,1),
(5,2),
(6,1),
(6,2),
(7,1),
(7,2),
(8,1),
(8,2),
(9,1),
(9,2),
(10,1),
(10,2),
(11,1),
(11,2),
(12,1),
(12,2),
(13,1),
(13,2),
(14,1),
(14,2),
(15,1),
(15,2),
(16,1),
(16,2),
(17,1),
(17,2),
(18,1),
(18,2),
(19,1),
(19,2),
(20,1),
(20,2),
(21,1),
(21,2),
(22,1),
(22,2),
(23,1),
(23,2),
(24,1),
(24,2),
(25,1),
(25,2),
(26,1),
(26,2),
(27,1),
(27,2),
(28,1),
(28,2),
(29,1),
(29,2),
(30,1),
(30,2),
(31,1),
(31,2),
(32,1),
(32,2),
(33,1),
(33,2),
(34,1),
(34,2),
(35,1),
(35,2),
(36,1),
(36,2),
(37,1),
(37,2),
(38,1),
(38,2),
(39,1),
(39,2),
(40,1),
(40,2),
(41,1),
(41,2),
(42,1),
(42,2),
(43,1),
(43,2),
(44,1),
(44,2),
(45,1),
(45,2),
(46,1),
(46,2),
(47,1),
(47,2),
(48,1),
(48,2),
(49,1),
(49,2),
(50,1),
(50,2),
(51,1),
(51,2),
(52,1),
(52,2),
(53,1),
(53,2),
(54,1),
(54,2),
(55,1),
(55,2),
(56,1),
(56,2),
(57,1),
(57,2),
(58,1),
(58,2),
(59,1),
(59,2),
(60,1),
(60,2),
(61,1),
(61,2),
(62,1),
(62,2),
(63,1),
(63,2),
(64,1),
(64,2),
(65,1),
(65,2),
(66,1),
(66,2),
(67,1),
(67,2),
(68,1),
(68,2),
(69,1),
(69,2),
(70,1),
(70,2),
(71,1),
(71,2),
(72,1),
(72,2),
(73,1),
(73,2),
(74,1),
(74,2),
(75,1),
(75,2),
(76,1),
(76,2),
(77,1),
(77,2),
(78,1),
(78,2),
(79,1),
(79,2),
(80,1),
(80,2),
(81,1),
(81,2),
(82,1),
(82,2),
(83,1),
(83,2),
(84,1),
(84,2),
(85,1),
(85,2),
(86,1),
(86,2),
(87,1),
(87,2),
(88,1),
(88,2),
(89,1),
(89,2),
(90,1),
(90,2),
(91,1),
(91,2),
(92,1),
(92,2),
(93,1),
(93,2),
(94,1),
(94,2),
(95,1),
(95,2),
(96,1),
(96,2),
(97,1),
(97,2),
(98,1),
(98,2),
(99,1),
(99,2),
(100,1),
(100,2),
(101,1),
(101,2),
(102,1),
(102,2),
(103,1),
(103,2),
(104,1),
(104,2),
(105,1),
(105,2),
(106,1),
(106,2),
(107,1),
(107,2),
(108,1),
(108,2),
(109,1),
(109,2),
(110,1),
(110,2),
(111,1),
(111,2),
(112,1),
(112,2),
(113,1),
(113,2),
(114,1),
(114,2),
(115,1),
(115,2),
(116,1),
(116,2),
(117,1),
(117,2),
(118,1),
(118,2),
(119,1),
(119,2),
(120,1),
(120,2),
(121,1),
(121,2),
(122,1),
(122,2),
(123,1),
(123,2),
(124,1),
(124,2),
(125,1),
(125,2),
(126,1),
(126,2),
(127,1),
(127,2),
(128,1),
(128,2),
(129,1),
(129,2),
(130,1),
(130,2),
(131,1),
(131,2),
(132,1),
(132,2),
(133,1),
(133,2),
(134,1),
(134,2),
(135,1),
(135,2),
(136,1),
(136,2),
(137,1),
(137,2),
(138,1),
(138,2),
(139,1),
(139,2),
(140,1),
(140,2),
(141,1),
(141,2),
(142,1),
(142,2),
(143,1),
(143,2),
(144,1),
(144,2),
(145,1),
(145,2),
(146,1),
(146,2),
(147,1),
(147,2),
(148,1),
(148,2),
(149,1),
(149,2),
(150,1),
(150,2),
(151,1),
(151,2),
(152,1),
(152,2),
(153,1),
(153,2),
(154,1),
(154,2),
(155,1),
(155,2),
(156,1),
(156,2),
(157,1),
(157,2),
(158,1),
(158,2),
(159,1),
(159,2),
(160,1),
(160,2),
(161,1),
(161,2),
(162,1),
(162,2),
(163,1),
(163,2),
(164,1),
(164,2),
(165,1),
(165,2),
(166,1),
(166,2),
(167,1),
(167,2),
(168,1),
(168,2),
(169,1),
(169,2),
(170,1),
(170,2),
(171,1),
(171,2),
(172,1),
(172,2),
(173,1),
(173,2),
(174,1),
(174,2),
(175,1),
(175,2),
(176,1),
(176,2),
(177,1),
(177,2),
(178,1),
(178,2),
(179,1),
(179,2),
(180,1),
(180,2),
(181,1),
(181,2),
(182,1),
(182,2),
(183,1),
(183,2),
(184,1),
(184,2),
(185,1),
(185,2),
(186,1),
(186,2),
(187,1),
(187,2),
(188,1),
(188,2),
(189,1),
(189,2),
(190,1),
(190,2),
(191,1),
(191,2),
(192,1),
(192,2),
(193,1),
(193,2),
(194,1),
(194,2),
(195,1),
(195,2),
(196,1),
(196,2),
(197,1),
(197,2),
(198,1),
(198,2),
(199,1),
(199,2),
(200,1),
(200,2),
(201,1),
(201,2),
(202,1),
(202,2),
(203,1),
(203,2),
(204,1),
(204,2),
(205,1),
(205,2),
(206,1),
(206,2),
(207,1),
(207,2),
(208,1),
(208,2),
(209,1),
(209,2),
(210,1),
(210,2),
(211,1),
(211,2),
(212,1),
(212,2),
(213,1),
(213,2),
(214,1),
(214,2),
(215,1),
(215,2),
(216,1),
(216,2),
(217,1),
(217,2),
(218,1),
(218,2),
(219,1),
(219,2),
(220,1),
(220,2),
(221,1),
(221,2),
(222,1),
(222,2),
(223,1),
(223,2),
(224,1),
(224,2),
(225,1),
(225,2),
(226,1),
(226,2),
(227,1),
(227,2),
(228,1),
(228,2),
(229,1),
(229,2),
(230,1),
(230,2),
(231,1),
(231,2),
(232,1),
(232,2),
(233,1),
(233,2),
(234,1),
(234,2),
(235,1),
(235,2),
(236,1),
(236,2),
(237,1),
(237,2),
(238,1),
(238,2),
(239,1),
(239,2),
(240,1),
(240,2),
(241,1),
(241,2),
(242,1),
(242,2),
(243,1),
(243,2),
(244,1),
(244,2),
(245,1),
(245,2),
(246,1),
(246,2),
(247,1),
(247,2),
(248,1),
(248,2),
(249,1),
(249,2),
(250,1),
(250,2),
(251,1),
(251,2),
(252,1),
(252,2),
(253,1),
(253,2),
(254,1),
(254,2),
(255,1),
(255,2),
(256,1),
(256,2),
(257,1),
(257,2),
(258,1),
(258,2),
(259,1),
(259,2),
(260,1),
(260,2),
(261,1),
(261,2),
(262,1),
(262,2),
(263,1),
(263,2),
(264,1),
(264,2),
(265,1),
(265,2),
(266,1),
(266,2),
(267,1),
(267,2),
(268,1),
(268,2),
(269,1),
(269,2),
(270,1),
(270,2),
(271,1),
(271,2),
(272,1),
(272,2),
(273,1),
(273,2),
(274,1),
(274,2),
(275,1),
(275,2),
(276,1),
(276,2),
(277,1),
(277,2),
(278,1),
(278,2),
(279,1),
(279,2),
(280,1),
(280,2),
(281,1),
(281,2),
(282,1),
(282,2),
(283,1),
(283,2),
(284,1),
(284,2),
(285,1),
(285,2),
(286,1),
(286,2),
(287,1),
(287,2),
(288,1),
(288,2),
(289,1),
(289,2),
(290,1),
(290,2),
(291,1),
(291,2),
(292,1),
(292,2),
(293,1),
(293,2),
(294,1),
(294,2),
(295,1),
(295,2),
(296,1),
(296,2),
(297,1),
(297,2),
(298,1),
(298,2),
(299,1),
(299,2),
(300,1),
(300,2),
(301,1),
(301,2),
(302,1),
(302,2),
(303,1),
(303,2),
(304,1),
(304,2),
(305,1),
(305,2),
(306,1),
(306,2),
(307,1),
(307,2),
(308,1),
(308,2),
(309,1),
(309,2),
(310,1),
(310,2),
(311,1),
(311,2),
(312,1),
(312,2),
(313,1),
(313,2),
(314,1),
(314,2),
(315,1),
(315,2),
(316,1),
(316,2),
(317,1),
(317,2),
(318,1),
(318,2),
(319,1),
(319,2),
(320,1),
(320,2),
(321,1),
(321,2),
(322,1),
(322,2),
(323,1),
(323,2),
(324,1),
(324,2),
(325,1),
(325,2),
(326,1),
(326,2),
(327,1),
(327,2),
(328,1),
(328,2),
(329,1),
(329,2),
(330,1),
(330,2),
(331,1),
(331,2),
(332,1),
(332,2),
(333,1),
(333,2),
(334,1),
(334,2),
(335,1),
(335,2),
(336,1),
(336,2),
(337,1),
(337,2),
(338,1),
(338,2),
(339,1),
(339,2),
(340,1),
(340,2),
(341,1),
(341,2),
(342,1),
(342,2),
(343,1),
(343,2),
(344,1),
(344,2),
(345,1),
(345,2),
(346,1),
(346,2),
(347,1),
(347,2),
(348,1),
(348,2),
(349,1),
(349,2),
(350,1),
(350,2),
(351,1),
(351,2),
(352,1),
(352,2),
(353,1),
(353,2),
(354,1),
(354,2),
(355,1),
(355,2),
(356,1),
(356,2),
(357,1),
(357,2),
(358,1),
(358,2),
(359,1),
(359,2),
(360,1),
(360,2),
(361,1),
(361,2),
(362,1),
(362,2),
(363,1),
(363,2),
(364,1),
(364,2),
(365,1),
(365,2),
(366,1),
(366,2),
(367,1),
(367,2),
(368,1),
(368,2),
(369,1),
(369,2),
(370,1),
(370,2),
(371,1),
(371,2),
(372,1),
(372,2),
(373,1),
(373,2),
(374,1),
(374,2),
(375,1),
(375,2),
(376,1),
(376,2),
(377,1),
(377,2),
(378,1),
(378,2),
(379,1),
(379,2),
(380,1),
(380,2),
(381,1),
(381,2),
(382,1),
(382,2),
(383,1),
(383,2),
(384,1),
(384,2),
(385,1),
(385,2),
(386,1),
(386,2),
(387,1),
(387,2),
(388,1),
(388,2),
(389,1),
(389,2),
(390,1),
(390,2),
(391,1),
(391,2),
(392,1),
(392,2),
(393,1),
(393,2),
(394,1),
(394,2),
(395,1),
(395,2),
(396,1),
(396,2),
(397,1),
(397,2),
(398,1),
(398,2),
(399,1),
(399,2),
(400,1),
(400,2),
(401,1),
(401,2),
(402,1),
(402,2),
(403,1),
(403,2),
(404,1),
(404,2),
(405,1),
(405,2),
(406,1),
(406,2),
(407,1),
(407,2),
(408,1),
(408,2),
(409,1),
(409,2),
(410,1),
(410,2),
(411,1),
(411,2),
(412,1),
(412,2),
(413,1),
(413,2),
(414,1),
(414,2),
(415,1),
(415,2),
(416,1),
(416,2),
(417,1),
(417,2),
(418,1),
(418,2),
(419,1),
(419,2),
(420,1),
(420,2),
(421,1),
(421,2),
(422,1),
(422,2),
(423,1),
(423,2),
(424,1),
(424,2),
(425,1),
(425,2),
(426,1),
(426,2),
(427,1),
(427,2),
(428,1),
(428,2),
(429,1),
(429,2),
(430,1),
(430,2),
(431,1),
(431,2),
(432,1),
(432,2),
(433,1),
(433,2),
(434,1),
(434,2),
(435,1),
(435,2),
(436,1),
(436,2),
(437,1),
(437,2),
(438,1),
(438,2),
(439,1),
(439,2),
(440,1),
(440,2),
(441,1),
(441,2),
(442,1),
(442,2),
(443,1),
(443,2),
(444,1),
(444,2),
(445,1),
(445,2),
(446,1),
(446,2),
(447,1),
(447,2),
(448,1),
(448,2),
(449,1),
(449,2),
(450,1),
(450,2),
(451,1),
(451,2),
(452,1),
(452,2),
(453,1),
(453,2),
(454,1),
(454,2),
(455,1),
(455,2),
(456,1),
(456,2),
(457,1),
(457,2),
(458,1),
(458,2),
(459,1),
(459,2),
(460,1),
(460,2),
(461,1),
(461,2),
(462,1),
(462,2),
(463,1),
(463,2),
(464,1),
(464,2),
(465,1),
(465,2),
(466,1),
(466,2),
(467,1),
(467,2),
(468,1),
(468,2),
(469,1),
(469,2),
(470,1),
(470,2),
(471,1),
(471,2),
(472,1),
(472,2),
(473,1),
(473,2),
(474,1),
(474,2),
(475,1),
(475,2),
(476,1),
(476,2),
(477,1),
(477,2),
(478,1),
(478,2),
(479,1),
(479,2),
(480,1),
(480,2),
(481,1),
(481,2),
(482,1),
(482,2),
(483,1),
(483,2),
(484,1),
(484,2),
(485,1),
(485,2),
(486,1),
(486,2),
(487,1),
(487,2),
(488,1),
(488,2),
(489,1),
(489,2),
(490,1),
(490,2),
(491,1),
(491,2),
(492,1),
(492,2),
(493,1),
(493,2),
(494,1),
(494,2),
(495,1),
(495,2),
(496,1),
(496,2),
(497,1),
(497,2),
(498,1),
(498,2),
(499,1),
(499,2),
(500,1),
(500,2),
(501,1),
(501,2),
(502,1),
(502,2),
(503,1),
(503,2),
(504,1),
(504,2),
(505,1),
(505,2),
(506,1),
(506,2),
(507,1),
(507,2),
(508,1),
(508,2),
(509,1),
(509,2),
(510,1),
(510,2),
(511,1),
(511,2),
(512,1),
(512,2),
(513,1),
(513,2),
(514,1),
(514,2),
(515,1),
(515,2),
(516,1),
(516,2),
(517,1),
(517,2),
(518,1),
(518,2),
(519,1),
(519,2),
(520,1),
(520,2),
(521,1),
(521,2),
(522,1),
(522,2),
(523,1),
(523,2),
(524,1),
(524,2),
(525,1),
(525,2),
(526,1),
(526,2),
(527,1),
(527,2),
(528,1),
(528,2),
(529,1),
(529,2),
(530,1),
(530,2),
(531,1),
(531,2),
(532,1),
(532,2),
(533,1),
(533,2),
(534,1),
(534,2),
(535,1),
(535,2),
(536,1),
(536,2),
(537,1),
(537,2),
(538,1),
(538,2),
(539,1),
(539,2),
(540,1),
(540,2),
(541,1),
(541,2),
(542,1),
(542,2),
(543,1),
(543,2),
(544,1),
(544,2),
(545,1),
(545,2),
(546,1),
(546,2),
(547,1),
(547,2),
(548,1),
(548,2),
(549,1),
(549,2),
(550,1),
(550,2),
(551,1),
(551,2),
(552,1),
(552,2),
(553,1),
(553,2),
(554,1),
(554,2),
(555,1),
(555,2),
(556,1),
(556,2),
(557,1),
(557,2),
(558,1),
(558,2),
(559,1),
(559,2),
(560,1),
(560,2),
(561,1),
(561,2),
(562,1),
(562,2),
(563,1),
(563,2),
(564,1),
(564,2),
(565,1),
(565,2),
(566,1),
(566,2),
(567,1),
(567,2),
(568,1),
(568,2),
(569,1),
(569,2),
(570,1),
(570,2),
(571,1),
(571,2),
(572,1),
(572,2),
(573,1),
(573,2),
(574,1),
(574,2),
(575,1),
(575,2),
(576,1),
(576,2),
(577,1),
(577,2),
(578,1),
(578,2),
(579,1),
(579,2),
(580,1),
(580,2),
(581,1),
(581,2),
(582,1),
(582,2),
(583,1),
(583,2),
(584,1),
(584,2),
(585,1),
(585,2),
(586,1),
(586,2),
(587,1),
(587,2),
(588,1),
(588,2),
(589,1),
(589,2),
(590,1),
(590,2),
(591,1),
(591,2),
(592,1),
(592,2),
(593,1),
(593,2),
(594,1),
(594,2),
(595,1),
(595,2),
(596,1),
(596,2),
(597,1),
(597,2),
(598,1),
(598,2),
(599,1),
(599,2),
(600,1),
(600,2),
(601,1),
(601,2),
(602,1),
(602,2),
(603,1),
(603,2),
(604,1),
(604,2),
(605,1),
(605,2),
(606,1),
(606,2),
(607,1),
(607,2),
(608,1),
(608,2),
(609,1),
(609,2),
(610,1),
(610,2),
(611,1),
(611,2),
(612,1),
(612,2),
(613,1),
(613,2),
(614,1),
(614,2),
(615,1),
(615,2),
(616,1),
(616,2),
(617,1),
(617,2),
(618,1),
(618,2),
(619,1),
(619,2),
(620,1),
(620,2),
(621,1),
(621,2),
(622,1),
(622,2),
(623,1),
(623,2),
(624,1),
(624,2),
(625,1),
(625,2),
(626,1),
(626,2),
(627,1),
(627,2),
(628,1),
(628,2),
(629,1),
(629,2),
(630,1),
(630,2),
(631,1),
(631,2),
(632,1),
(632,2),
(633,1),
(633,2),
(634,1),
(634,2),
(635,1),
(635,2),
(636,1),
(636,2),
(637,1),
(637,2),
(638,1),
(638,2),
(639,1),
(639,2),
(640,1),
(640,2),
(641,1),
(641,2),
(642,1),
(642,2),
(643,1),
(643,2),
(644,1),
(644,2),
(645,1),
(645,2),
(646,1),
(646,2),
(647,1),
(647,2),
(648,1),
(648,2),
(649,1),
(649,2),
(650,1),
(650,2),
(651,1),
(651,2),
(652,1),
(652,2),
(653,1),
(653,2),
(654,1),
(654,2),
(655,1),
(655,2),
(656,1),
(656,2),
(657,1),
(657,2),
(658,1),
(658,2),
(659,1),
(659,2),
(660,1),
(660,2),
(661,1),
(661,2),
(662,1),
(662,2),
(663,1),
(663,2),
(664,1),
(664,2),
(665,1),
(665,2),
(666,1),
(666,2),
(667,1),
(667,2),
(668,1),
(668,2),
(669,1),
(669,2),
(670,1),
(670,2),
(671,1),
(671,2),
(672,1),
(672,2),
(673,1),
(673,2),
(674,1),
(674,2),
(675,1),
(675,2),
(676,1),
(676,2),
(677,1),
(677,2),
(678,1),
(678,2),
(679,1),
(679,2),
(680,1),
(680,2),
(681,1),
(681,2),
(682,1),
(682,2),
(683,1),
(683,2),
(684,1),
(684,2),
(685,1),
(685,2),
(686,1),
(686,2),
(687,1),
(687,2),
(688,1),
(688,2),
(689,1),
(689,2),
(690,1),
(690,2),
(691,1),
(691,2),
(692,1),
(692,2),
(693,1),
(693,2),
(694,1),
(694,2),
(695,1),
(695,2),
(696,1),
(696,2),
(697,1),
(697,2),
(698,1),
(698,2),
(699,1),
(699,2),
(700,1),
(700,2),
(701,1),
(701,2),
(702,1),
(702,2),
(703,1),
(703,2),
(704,1),
(704,2),
(705,1),
(705,2),
(706,1),
(706,2),
(707,1),
(707,2),
(708,1),
(708,2),
(709,1),
(709,2),
(710,1),
(710,2),
(711,1),
(711,2),
(712,1),
(712,2),
(713,1),
(713,2),
(714,1),
(714,2),
(715,1),
(715,2),
(716,1),
(716,2),
(717,1),
(717,2),
(718,1),
(718,2),
(719,1),
(719,2),
(720,1),
(720,2),
(721,1),
(721,2),
(722,1),
(722,2),
(723,1),
(723,2),
(724,1),
(724,2),
(725,1),
(725,2),
(726,1),
(726,2),
(727,1),
(727,2),
(728,1),
(728,2),
(729,1),
(729,2),
(730,1),
(730,2),
(731,1),
(731,2),
(732,1),
(732,2),
(733,1),
(733,2),
(734,1),
(734,2),
(735,1),
(735,2),
(736,1),
(736,2),
(737,1),
(737,2),
(738,1),
(738,2),
(739,1),
(739,2),
(740,1),
(740,2),
(741,1),
(741,2),
(742,1),
(742,2),
(743,1),
(743,2),
(744,1),
(744,2),
(745,1),
(745,2),
(746,1),
(746,2),
(747,1),
(747,2),
(748,1),
(748,2),
(749,1),
(749,2),
(750,1),
(750,2),
(751,1),
(751,2),
(752,1),
(752,2),
(753,1),
(753,2),
(754,1),
(754,2),
(755,1),
(755,2),
(756,1),
(756,2),
(757,1),
(757,2),
(758,1),
(758,2),
(759,1),
(759,2),
(760,1),
(760,2),
(761,1),
(761,2),
(762,1),
(762,2),
(763,1),
(763,2),
(764,1),
(764,2),
(765,1),
(765,2),
(766,1),
(766,2),
(767,1),
(767,2),
(768,1),
(768,2),
(769,1),
(769,2),
(770,1),
(770,2),
(771,1),
(771,2),
(772,1),
(772,2),
(773,1),
(773,2),
(774,1),
(774,2),
(775,1),
(775,2),
(776,1),
(776,2),
(777,1),
(777,2),
(778,1),
(778,2),
(779,1),
(779,2),
(780,1),
(780,2),
(781,1),
(781,2),
(782,1),
(782,2),
(783,1),
(783,2),
(784,1),
(784,2),
(785,1),
(785,2),
(786,1),
(786,2),
(787,1),
(787,2),
(788,1),
(788,2),
(789,1),
(789,2),
(790,1),
(790,2),
(791,1),
(791,2),
(792,1),
(792,2),
(793,1),
(793,2),
(794,1),
(794,2),
(795,1),
(795,2),
(796,1),
(796,2),
(797,1),
(797,2),
(798,1),
(798,2),
(799,1),
(799,2),
(800,1),
(800,2),
(801,1),
(801,2),
(802,1),
(802,2),
(803,1),
(803,2),
(804,1),
(804,2),
(805,1),
(805,2),
(806,1),
(806,2),
(807,1),
(807,2),
(808,1),
(808,2),
(809,1),
(809,2),
(810,1),
(810,2),
(811,1),
(811,2),
(812,1),
(812,2),
(813,1),
(813,2),
(814,1),
(814,2),
(815,1),
(815,2),
(816,1),
(816,2),
(817,1),
(817,2),
(818,1),
(818,2),
(819,1),
(819,2),
(820,1),
(820,2),
(821,1),
(821,2),
(822,1),
(822,2),
(823,1),
(823,2),
(824,1),
(824,2),
(825,1),
(825,2),
(826,1),
(826,2),
(827,1),
(827,2),
(828,1),
(828,2),
(829,1),
(829,2),
(830,1),
(830,2),
(831,1),
(831,2),
(832,1),
(832,2),
(833,1),
(833,2),
(834,1),
(834,2),
(835,1),
(835,2),
(836,1),
(836,2),
(837,1),
(837,2),
(838,1),
(838,2),
(839,1),
(839,2),
(840,1),
(840,2),
(841,1),
(841,2),
(842,1),
(842,2),
(843,1),
(843,2),
(844,1),
(844,2),
(845,1),
(845,2),
(846,1),
(846,2),
(847,1),
(847,2),
(848,1),
(848,2),
(849,1),
(849,2),
(850,1),
(850,2),
(851,1),
(851,2),
(852,1),
(852,2),
(853,1),
(853,2),
(854,1),
(854,2),
(855,1),
(855,2),
(856,1),
(856,2),
(857,1),
(857,2),
(858,1),
(858,2),
(859,1),
(859,2),
(860,1),
(860,2),
(861,1),
(861,2),
(862,1),
(862,2),
(863,1),
(863,2),
(864,1),
(864,2),
(865,1),
(865,2),
(866,1),
(866,2),
(867,1),
(867,2),
(868,1),
(868,2),
(869,1),
(869,2),
(870,1),
(870,2),
(871,1),
(871,2),
(872,1),
(872,2),
(873,1),
(873,2),
(874,1),
(874,2),
(875,1),
(875,2),
(876,1),
(876,2),
(877,1),
(877,2),
(878,1),
(878,2),
(879,1),
(879,2),
(880,1),
(880,2),
(881,1),
(881,2),
(882,1),
(882,2),
(883,1),
(883,2),
(884,1),
(884,2),
(885,1),
(885,2),
(886,1),
(886,2),
(887,1),
(887,2),
(888,1),
(888,2),
(889,1),
(889,2),
(890,1),
(890,2),
(891,1),
(891,2),
(892,1),
(892,2),
(893,1),
(893,2),
(894,1),
(894,2),
(895,1),
(895,2),
(896,1),
(896,2),
(897,1),
(897,2),
(898,1),
(898,2),
(899,1),
(899,2),
(900,1),
(900,2),
(901,1),
(901,2),
(902,1),
(902,2),
(903,1),
(903,2),
(904,1),
(904,2),
(905,1),
(905,2),
(906,1),
(906,2),
(907,1),
(907,2),
(908,1),
(908,2),
(909,1),
(909,2),
(910,1),
(910,2),
(911,1),
(911,2),
(912,1),
(912,2),
(913,1),
(913,2),
(914,1),
(914,2),
(915,1),
(915,2),
(916,1),
(916,2),
(917,1),
(917,2),
(918,1),
(918,2),
(919,1),
(919,2),
(920,1),
(920,2),
(921,1),
(921,2),
(922,1),
(922,2),
(923,1),
(923,2),
(924,1),
(924,2),
(925,1),
(925,2),
(926,1),
(926,2),
(927,1),
(927,2),
(928,1),
(928,2),
(929,1),
(929,2),
(930,1),
(930,2),
(931,1),
(931,2),
(932,1),
(932,2),
(933,1),
(933,2),
(934,1),
(934,2),
(935,1),
(935,2),
(936,1),
(936,2),
(937,1),
(937,2),
(938,1),
(938,2),
(939,1),
(939,2),
(940,1),
(940,2),
(941,1),
(941,2),
(942,1),
(942,2),
(943,1),
(943,2),
(944,1),
(944,2),
(945,1),
(945,2),
(946,1),
(946,2),
(947,1),
(947,2),
(948,1),
(948,2),
(949,1),
(949,2),
(950,1),
(950,2),
(951,1),
(951,2),
(952,1),
(952,2),
(953,1),
(953,2),
(954,1),
(954,2),
(955,1),
(955,2),
(956,1),
(956,2),
(957,1),
(957,2),
(958,1),
(958,2),
(959,1),
(959,2),
(960,1),
(960,2),
(961,1),
(961,2),
(962,1),
(962,2),
(963,1),
(963,2),
(964,1),
(964,2),
(965,1),
(965,2),
(966,1),
(966,2),
(967,1),
(967,2),
(968,1),
(968,2),
(969,1),
(969,2),
(970,1),
(970,2),
(971,1),
(971,2),
(972,1),
(972,2),
(973,1),
(973,2),
(974,1),
(974,2),
(975,1),
(975,2),
(976,1),
(976,2),
(977,1),
(977,2),
(978,1),
(978,2),
(979,1),
(979,2),
(980,1),
(980,2),
(981,1),
(981,2),
(982,1),
(982,2),
(983,1),
(983,2),
(984,1),
(984,2),
(985,1),
(985,2),
(986,1),
(986,2),
(987,1),
(987,2),
(988,1),
(988,2),
(989,1),
(989,2),
(990,1),
(990,2),
(991,1),
(991,2),
(992,1),
(992,2),
(993,1),
(993,2),
(994,1),
(994,2),
(995,1),
(995,2),
(996,1),
(996,2),
(997,1),
(997,2),
(998,1),
(998,2),
(999,1),
(999,2),
(1000,1),
(1000,2),
(1001,1),
(1001,2),
(1002,1),
(1002,2),
(1003,1),
(1003,2),
(1004,1),
(1004,2),
(1005,1),
(1005,2),
(1006,1),
(1006,2),
(1007,1),
(1007,2),
(1008,1),
(1008,2),
(1009,1),
(1009,2),
(1010,1),
(1010,2),
(1011,1),
(1011,2),
(1012,1),
(1012,2),
(1013,1),
(1013,2),
(1014,1),
(1014,2),
(1015,1),
(1015,2),
(1016,1),
(1016,2),
(1017,1),
(1017,2),
(1018,1),
(1018,2),
(1019,1),
(1019,2),
(1020,1),
(1020,2),
(1021,1),
(1021,2),
(1022,1),
(1022,2),
(1023,1),
(1023,2),
(1024,1),
(1024,2),
(1025,1),
(1025,2),
(1026,1),
(1026,2),
(1027,1),
(1027,2),
(1028,1),
(1028,2),
(1029,1),
(1029,2),
(1030,1),
(1030,2),
(1031,1),
(1031,2),
(1032,1),
(1032,2),
(1033,1),
(1033,2),
(1034,1),
(1034,2),
(1035,1),
(1035,2),
(1036,1),
(1036,2),
(1037,1),
(1037,2),
(1038,1),
(1038,2),
(1039,1),
(1039,2),
(1040,1),
(1040,2),
(1041,1),
(1041,2),
(1042,1),
(1042,2),
(1043,1),
(1043,2),
(1044,1),
(1044,2),
(1045,1),
(1045,2),
(1046,1),
(1046,2),
(1047,1),
(1047,2),
(1048,1),
(1048,2),
(1049,1),
(1049,2),
(1050,1),
(1050,2),
(1051,1),
(1051,2),
(1052,1),
(1052,2),
(1053,1),
(1053,2),
(1054,1),
(1054,2),
(1055,1),
(1055,2),
(1056,1),
(1056,2),
(1057,1),
(1057,2),
(1058,1),
(1058,2),
(1059,1),
(1059,2),
(1060,1),
(1060,2),
(1061,1),
(1061,2),
(1062,1),
(1062,2),
(1063,1),
(1063,2),
(1064,1),
(1064,2),
(1065,1),
(1065,2),
(1066,1),
(1066,2),
(1067,1),
(1067,2),
(1068,1),
(1068,2),
(1069,1),
(1069,2),
(1070,1),
(1070,2),
(1071,1),
(1071,2),
(1072,1),
(1072,2),
(1073,1),
(1073,2),
(1074,1),
(1074,2),
(1075,1),
(1075,2),
(1076,1),
(1076,2),
(1077,1),
(1077,2),
(1078,1),
(1078,2),
(1079,1),
(1079,2),
(1080,1),
(1080,2),
(1081,1),
(1081,2),
(1082,1),
(1082,2),
(1083,1),
(1083,2),
(1084,1),
(1084,2),
(1085,1),
(1085,2),
(1086,1),
(1086,2),
(1087,1),
(1087,2),
(1088,1),
(1088,2),
(1089,1),
(1089,2),
(1090,1),
(1090,2),
(1091,1),
(1091,2),
(1092,1),
(1092,2),
(1093,1),
(1093,2),
(1094,1),
(1094,2),
(1095,1),
(1095,2),
(1096,1),
(1096,2),
(1097,1),
(1097,2),
(1098,1),
(1098,2),
(1099,1),
(1099,2),
(1100,1),
(1100,2),
(1101,1),
(1101,2),
(1102,1),
(1102,2),
(1103,1),
(1103,2),
(1104,1),
(1104,2),
(1105,1),
(1105,2),
(1106,1),
(1106,2),
(1107,1),
(1107,2),
(1108,1),
(1108,2),
(1109,1),
(1109,2),
(1110,1),
(1110,2),
(1111,1),
(1111,2),
(1112,1),
(1112,2),
(1113,1),
(1113,2),
(1114,1),
(1114,2),
(1115,1),
(1115,2),
(1116,1),
(1116,2),
(1117,1),
(1117,2),
(1118,1),
(1118,2),
(1119,1),
(1119,2),
(1120,1),
(1120,2),
(1121,1),
(1121,2),
(1122,1),
(1122,2),
(1123,1),
(1123,2),
(1124,1),
(1124,2),
(1125,1),
(1125,2),
(1126,1),
(1126,2),
(1127,1),
(1127,2),
(1128,1),
(1128,2),
(1129,1),
(1129,2),
(1130,1),
(1130,2),
(1131,1),
(1131,2),
(1132,1),
(1132,2),
(1133,1),
(1133,2),
(1134,1),
(1134,2),
(1135,1),
(1135,2),
(1136,1),
(1136,2),
(1137,1),
(1137,2),
(1138,1),
(1138,2),
(1139,1),
(1139,2),
(1140,1),
(1140,2),
(1141,1),
(1141,2),
(1142,1),
(1142,2),
(1143,1),
(1143,2),
(1144,1),
(1144,2),
(1145,1),
(1145,2),
(1146,1),
(1146,2),
(1147,1),
(1147,2),
(1148,1),
(1148,2),
(1149,1),
(1149,2),
(1150,1),
(1150,2),
(1151,1),
(1151,2),
(1152,1),
(1152,2),
(1153,1),
(1153,2),
(1154,1),
(1154,2),
(1155,1),
(1155,2),
(1156,1),
(1156,2),
(1157,1),
(1157,2),
(1158,1),
(1158,2),
(1159,1),
(1159,2),
(1160,1),
(1160,2),
(1161,1),
(1161,2),
(1162,1),
(1162,2),
(1163,1),
(1163,2),
(1164,1),
(1164,2),
(1165,1),
(1165,2),
(1166,1),
(1166,2),
(1167,1),
(1167,2),
(1168,1),
(1168,2),
(1169,1),
(1169,2),
(1170,1),
(1170,2),
(1171,1),
(1171,2),
(1172,1),
(1172,2),
(1173,1),
(1173,2),
(1174,1),
(1174,2),
(1175,1),
(1175,2),
(1176,1),
(1176,2),
(1177,1),
(1177,2),
(1178,1),
(1178,2),
(1179,1),
(1179,2),
(1180,1),
(1180,2),
(1181,1),
(1181,2),
(1182,1),
(1182,2),
(1183,1),
(1183,2),
(1184,1),
(1184,2),
(1185,1),
(1185,2),
(1186,1),
(1186,2),
(1187,1),
(1187,2),
(1188,1),
(1188,2),
(1189,1),
(1189,2),
(1190,1),
(1190,2),
(1191,1),
(1191,2),
(1192,1),
(1192,2),
(1193,1),
(1193,2),
(1194,1),
(1194,2),
(1195,1),
(1195,2),
(1196,1),
(1196,2),
(1197,1),
(1197,2),
(1198,1),
(1198,2),
(1199,1),
(1199,2),
(1200,1),
(1200,2),
(1201,1),
(1201,2),
(1202,1),
(1202,2),
(1203,1),
(1203,2),
(1204,1),
(1204,2),
(1205,1),
(1205,2),
(1206,1),
(1206,2),
(1207,1),
(1207,2),
(1208,1),
(1208,2),
(1209,1),
(1209,2),
(1210,1),
(1210,2),
(1211,1),
(1211,2),
(1212,1),
(1212,2),
(1213,1),
(1213,2),
(1214,1),
(1214,2),
(1215,1),
(1215,2),
(1216,1),
(1216,2),
(1217,1),
(1217,2),
(1218,1),
(1218,2),
(1219,1),
(1219,2),
(1220,1),
(1220,2),
(1221,1),
(1221,2),
(1222,1),
(1222,2),
(1223,1),
(1223,2),
(1224,1),
(1224,2),
(1225,1),
(1225,2),
(1226,1),
(1226,2),
(1227,1),
(1227,2),
(1228,1),
(1228,2),
(1229,1),
(1229,2),
(1230,1),
(1230,2),
(1231,1),
(1231,2),
(1232,1),
(1232,2),
(1233,1),
(1233,2),
(1234,1),
(1234,2),
(1235,1),
(1235,2),
(1236,1),
(1236,2),
(1237,1),
(1237,2),
(1238,1),
(1238,2),
(1239,1),
(1239,2),
(1240,1),
(1240,2),
(1241,1),
(1241,2),
(1242,1),
(1242,2),
(1243,1),
(1243,2),
(1244,1),
(1244,2),
(1245,1),
(1245,2),
(1246,1),
(1246,2),
(1247,1),
(1247,2),
(1248,1),
(1248,2),
(1249,1),
(1249,2),
(1250,1),
(1250,2),
(1251,1),
(1251,2),
(1252,1),
(1252,2),
(1253,1),
(1253,2),
(1254,1),
(1254,2),
(1255,1),
(1255,2),
(1256,1),
(1256,2),
(1257,1),
(1257,2),
(1258,1),
(1258,2),
(1259,1),
(1259,2),
(1260,1),
(1260,2),
(1261,1),
(1261,2),
(1262,1),
(1262,2),
(1263,1),
(1263,2),
(1264,1),
(1264,2),
(1265,1),
(1265,2),
(1266,1),
(1266,2),
(1267,1),
(1267,2),
(1268,1),
(1268,2),
(1269,1),
(1269,2),
(1270,1),
(1270,2),
(1271,1),
(1271,2),
(1272,1),
(1272,2),
(1273,1),
(1273,2),
(1274,1),
(1274,2),
(1275,1),
(1275,2),
(1276,1),
(1276,2),
(1277,1),
(1277,2),
(1278,1),
(1278,2),
(1279,1),
(1279,2),
(1280,1),
(1280,2),
(1281,1),
(1281,2),
(1282,1),
(1282,2),
(1283,1),
(1283,2),
(1284,1),
(1284,2),
(1285,1),
(1285,2),
(1286,1),
(1286,2),
(1287,1),
(1287,2),
(1288,1),
(1288,2),
(1289,1),
(1289,2),
(1290,1),
(1290,2),
(1291,1),
(1291,2),
(1292,1),
(1292,2),
(1293,1),
(1293,2),
(1294,1),
(1294,2),
(1295,1),
(1295,2),
(1296,1),
(1296,2),
(1297,1),
(1297,2),
(1298,1),
(1298,2),
(1299,1),
(1299,2),
(1300,1),
(1300,2),
(1301,1),
(1301,2),
(1302,1),
(1302,2),
(1303,1),
(1303,2),
(1304,1),
(1304,2),
(1305,1),
(1305,2),
(1306,1),
(1306,2),
(1307,1),
(1307,2),
(1308,1),
(1308,2),
(1309,1),
(1309,2),
(1310,1),
(1310,2),
(1311,1),
(1311,2),
(1312,1),
(1312,2),
(1313,1),
(1313,2),
(1314,1),
(1314,2),
(1315,1),
(1315,2),
(1316,1),
(1316,2),
(1317,1),
(1317,2),
(1318,1),
(1318,2),
(1319,1),
(1319,2),
(1320,1),
(1320,2),
(1321,1),
(1321,2),
(1322,1),
(1322,2),
(1323,1),
(1323,2),
(1324,1),
(1324,2),
(1325,1),
(1325,2),
(1326,1),
(1326,2),
(1327,1),
(1327,2),
(1328,1),
(1328,2),
(1329,1),
(1329,2),
(1330,1),
(1330,2),
(1331,1),
(1331,2),
(1332,1),
(1332,2),
(1333,1),
(1333,2),
(1334,1),
(1334,2),
(1335,1),
(1335,2),
(1336,1),
(1336,2),
(1337,1),
(1337,2),
(1338,1),
(1338,2),
(1339,1),
(1339,2),
(1340,1),
(1340,2),
(1341,1),
(1341,2),
(1342,1),
(1342,2),
(1343,1),
(1343,2),
(1344,1),
(1344,2),
(1345,1),
(1345,2),
(1346,1),
(1346,2),
(1347,1),
(1347,2),
(1348,1),
(1348,2),
(1349,1),
(1349,2),
(1350,1),
(1350,2),
(1351,1),
(1351,2),
(1352,1),
(1352,2),
(1353,1),
(1353,2),
(1354,1),
(1354,2),
(1355,1),
(1355,2),
(1356,1),
(1356,2),
(1357,1),
(1357,2),
(1358,1),
(1358,2),
(1359,1),
(1359,2),
(1360,1),
(1360,2),
(1361,1),
(1361,2),
(1362,1),
(1362,2),
(1363,1),
(1363,2),
(1364,1),
(1364,2),
(1365,1),
(1365,2),
(1366,1),
(1366,2),
(1367,1),
(1367,2),
(1368,1),
(1368,2),
(1369,1),
(1369,2),
(1370,1),
(1370,2),
(1371,1),
(1371,2),
(1372,1),
(1372,2),
(1373,1),
(1373,2),
(1374,1),
(1374,2),
(1375,1),
(1375,2),
(1376,1),
(1376,2),
(1377,1),
(1377,2),
(1378,1),
(1378,2),
(1379,1),
(1379,2),
(1380,1),
(1380,2),
(1381,1),
(1381,2),
(1382,1),
(1382,2),
(1383,1),
(1383,2),
(1384,1),
(1384,2),
(1385,1),
(1385,2),
(1386,1),
(1386,2),
(1387,1),
(1387,2),
(1388,1),
(1388,2),
(1389,1),
(1389,2),
(1390,1),
(1390,2),
(1391,1),
(1391,2),
(1392,1),
(1392,2),
(1393,1),
(1393,2),
(1394,1),
(1394,2),
(1395,1),
(1395,2),
(1396,1),
(1396,2),
(1397,1),
(1397,2),
(1398,1),
(1398,2),
(1399,1),
(1399,2),
(1400,1),
(1400,2),
(1401,1),
(1401,2),
(1402,1),
(1402,2),
(1403,1),
(1403,2),
(1404,1),
(1404,2),
(1405,1),
(1405,2),
(1406,1),
(1406,2),
(1407,1),
(1407,2),
(1408,1),
(1408,2),
(1409,1),
(1409,2),
(1410,1),
(1410,2),
(1411,1),
(1411,2),
(1412,1),
(1412,2),
(1413,1),
(1413,2),
(1414,1),
(1414,2),
(1415,1),
(1415,2),
(1416,1),
(1416,2),
(1417,1),
(1417,2),
(1418,1),
(1418,2),
(1419,1),
(1419,2),
(1420,1),
(1420,2),
(1421,1),
(1421,2),
(1422,1),
(1422,2),
(1423,1),
(1423,2),
(1424,1),
(1424,2),
(1425,1),
(1425,2),
(1426,1),
(1426,2),
(1427,1),
(1427,2),
(1428,1),
(1428,2),
(1429,1),
(1429,2),
(1430,1),
(1430,2),
(1431,1),
(1431,2),
(1432,1),
(1432,2),
(1433,1),
(1433,2),
(1434,1),
(1434,2),
(1435,1),
(1435,2),
(1436,1),
(1436,2),
(1437,1),
(1437,2),
(1438,1),
(1438,2),
(1439,1),
(1439,2),
(1440,1),
(1440,2),
(1441,1),
(1441,2),
(1442,1),
(1442,2),
(1443,1),
(1443,2),
(1444,1),
(1444,2),
(1445,1),
(1445,2),
(1446,1),
(1446,2),
(1447,1),
(1447,2),
(1448,1),
(1448,2),
(1449,1),
(1449,2),
(1450,1),
(1450,2),
(1451,1),
(1451,2),
(1452,1),
(1452,2),
(1453,1),
(1453,2),
(1454,1),
(1454,2),
(1455,1),
(1455,2),
(1456,1),
(1456,2),
(1457,1),
(1457,2),
(1458,1),
(1458,2),
(1459,1),
(1459,2),
(1460,1),
(1460,2),
(1461,1),
(1461,2),
(1462,1),
(1462,2),
(1463,1),
(1463,2),
(1464,1),
(1464,2),
(1465,1),
(1465,2),
(1466,1),
(1466,2),
(1467,1),
(1467,2),
(1468,1),
(1468,2),
(1469,1),
(1469,2),
(1470,1),
(1470,2),
(1471,1),
(1471,2),
(1472,1),
(1472,2),
(1473,1),
(1473,2),
(1474,1),
(1474,2),
(1475,1),
(1475,2),
(1476,1),
(1476,2),
(1477,1),
(1477,2),
(1478,1),
(1478,2),
(1479,1),
(1479,2),
(1480,1),
(1480,2),
(1481,1),
(1481,2),
(1482,1),
(1482,2),
(1483,1),
(1483,2),
(1484,1),
(1484,2),
(1485,1),
(1485,2),
(1486,1),
(1486,2),
(1487,1),
(1487,2),
(1488,1),
(1488,2),
(1489,1),
(1489,2),
(1490,1),
(1490,2),
(1491,1),
(1491,2),
(1492,1),
(1492,2),
(1493,1),
(1493,2),
(1494,1),
(1494,2),
(1495,1),
(1495,2),
(1496,1),
(1496,2),
(1497,1),
(1497,2),
(1498,1),
(1498,2),
(1499,1),
(1499,2),
(1500,1),
(1500,2),
(1501,1),
(1501,2),
(1502,1),
(1502,2),
(1503,1),
(1503,2),
(1504,1),
(1504,2),
(1505,1),
(1505,2),
(1506,1),
(1506,2),
(1507,1),
(1507,2),
(1508,1),
(1508,2),
(1509,1),
(1509,2),
(1510,1),
(1510,2),
(1511,1),
(1511,2),
(1512,1),
(1512,2),
(1513,1),
(1513,2),
(1514,1),
(1514,2),
(1515,1),
(1515,2),
(1516,1),
(1516,2),
(1517,1),
(1517,2),
(1518,1),
(1518,2),
(1519,1),
(1519,2),
(1520,1),
(1520,2),
(1521,1),
(1521,2),
(1522,1),
(1522,2),
(1523,1),
(1523,2),
(1524,1),
(1524,2),
(1525,1),
(1525,2),
(1526,1),
(1526,2),
(1527,1),
(1527,2),
(1528,1),
(1528,2),
(1529,1),
(1529,2),
(1530,1),
(1530,2),
(1531,1),
(1531,2),
(1532,1),
(1532,2),
(1533,1),
(1533,2),
(1534,1),
(1534,2),
(1535,1),
(1535,2),
(1536,1),
(1536,2),
(1537,1),
(1537,2),
(1538,1),
(1538,2),
(1539,1),
(1539,2),
(1540,1),
(1540,2),
(1541,1),
(1541,2),
(1542,1),
(1542,2),
(1543,1),
(1543,2),
(1544,1),
(1544,2),
(1545,1),
(1545,2),
(1546,1),
(1546,2),
(1547,1),
(1547,2),
(1548,1),
(1548,2),
(1549,1),
(1549,2),
(1550,1),
(1550,2),
(1551,1),
(1551,2),
(1552,1),
(1552,2),
(1553,1),
(1553,2),
(1554,1),
(1554,2),
(1555,1),
(1555,2),
(1556,1),
(1556,2),
(1557,1),
(1557,2),
(1558,1),
(1558,2),
(1559,1),
(1559,2),
(1560,1),
(1560,2),
(1561,1),
(1561,2),
(1562,1),
(1562,2),
(1563,1),
(1563,2),
(1564,1),
(1564,2),
(1565,1),
(1565,2),
(1566,1),
(1566,2),
(1567,1),
(1567,2),
(1568,1),
(1568,2),
(1569,1),
(1569,2),
(1570,1),
(1570,2),
(1571,1),
(1571,2),
(1572,1),
(1572,2),
(1573,1),
(1573,2),
(1574,1),
(1574,2),
(1575,1),
(1575,2),
(1576,1),
(1576,2),
(1577,1),
(1577,2),
(1578,1),
(1578,2),
(1579,1),
(1579,2),
(1580,1),
(1580,2),
(1581,1),
(1581,2),
(1582,1),
(1582,2),
(1583,1),
(1583,2),
(1584,1),
(1584,2),
(1585,1),
(1585,2),
(1586,1),
(1586,2),
(1587,1),
(1587,2),
(1588,1),
(1588,2),
(1589,1),
(1589,2),
(1590,1),
(1590,2),
(1591,1),
(1591,2),
(1592,1),
(1592,2),
(1593,1),
(1593,2),
(1594,1),
(1594,2),
(1595,1),
(1595,2),
(1596,1),
(1596,2),
(1597,1),
(1597,2),
(1598,1),
(1598,2),
(1599,1),
(1599,2),
(1600,1),
(1600,2),
(1601,1),
(1601,2),
(1602,1),
(1602,2),
(1603,1),
(1603,2),
(1604,1),
(1604,2),
(1605,1),
(1605,2),
(1606,1),
(1606,2),
(1607,1),
(1607,2),
(1608,1),
(1608,2),
(1609,1),
(1609,2),
(1610,1),
(1610,2),
(1611,1),
(1611,2),
(1612,1),
(1612,2),
(1613,1),
(1613,2),
(1614,1),
(1614,2),
(1615,1),
(1615,2),
(1616,1),
(1616,2),
(1617,1),
(1617,2),
(1618,1),
(1618,2),
(1619,1),
(1619,2),
(1620,1),
(1620,2),
(1621,1),
(1621,2),
(1622,1),
(1622,2),
(1623,1),
(1623,2),
(1624,1),
(1624,2),
(1625,1),
(1625,2),
(1626,1),
(1626,2),
(1627,1),
(1627,2),
(1628,1),
(1628,2),
(1629,1),
(1629,2),
(1630,1),
(1630,2),
(1631,1),
(1631,2),
(1632,1),
(1632,2),
(1633,1),
(1633,2),
(1634,1),
(1634,2),
(1635,1),
(1635,2),
(1636,1),
(1636,2),
(1637,1),
(1637,2),
(1638,1),
(1638,2),
(1639,1),
(1639,2),
(1640,1),
(1640,2),
(1641,1),
(1641,2),
(1642,1),
(1642,2),
(1643,1),
(1643,2),
(1644,1),
(1644,2),
(1645,1),
(1645,2),
(1646,1),
(1646,2),
(1647,1),
(1647,2),
(1648,1),
(1648,2),
(1649,1),
(1649,2),
(1650,1),
(1650,2),
(1651,1),
(1651,2),
(1652,1),
(1652,2),
(1653,1),
(1653,2),
(1654,1),
(1654,2),
(1655,1),
(1655,2),
(1656,1),
(1656,2),
(1657,1),
(1657,2),
(1658,1),
(1658,2),
(1659,1),
(1659,2),
(1660,1),
(1660,2),
(1661,1),
(1661,2),
(1662,1),
(1662,2),
(1663,1),
(1663,2),
(1664,1),
(1664,2),
(1665,1),
(1665,2),
(1666,1),
(1666,2),
(1667,1),
(1667,2),
(1668,1),
(1668,2),
(1669,1),
(1669,2),
(1670,1),
(1670,2),
(1671,1),
(1671,2),
(1672,1),
(1672,2),
(1673,1),
(1673,2),
(1674,1),
(1674,2),
(1675,1),
(1675,2),
(1676,1),
(1676,2),
(1677,1),
(1677,2),
(1678,1),
(1678,2),
(1679,1),
(1679,2),
(1680,1),
(1680,2),
(1681,1),
(1681,2),
(1682,1),
(1682,2),
(1683,1),
(1683,2),
(1684,1),
(1684,2),
(1685,1),
(1685,2),
(1686,1),
(1686,2),
(1687,1),
(1687,2),
(1688,1),
(1688,2),
(1689,1),
(1689,2),
(1690,1),
(1690,2),
(1691,1),
(1691,2),
(1692,1),
(1692,2),
(1693,1),
(1693,2),
(1694,1),
(1694,2),
(1695,1),
(1695,2),
(1696,1),
(1696,2),
(1697,1),
(1697,2),
(1698,1),
(1698,2),
(1699,1),
(1699,2),
(1700,1),
(1700,2),
(1701,1),
(1701,2),
(1702,1),
(1702,2),
(1703,1),
(1703,2),
(1704,1),
(1704,2),
(1705,1),
(1705,2),
(1706,1),
(1706,2),
(1707,1),
(1707,2),
(1708,1),
(1708,2),
(1709,1),
(1709,2),
(1710,1),
(1710,2),
(1711,1),
(1711,2),
(1712,1),
(1712,2),
(1713,1),
(1713,2),
(1714,1),
(1714,2),
(1715,1),
(1715,2),
(1716,1),
(1716,2),
(1717,1),
(1717,2),
(1718,1),
(1718,2),
(1719,1),
(1719,2),
(1720,1),
(1720,2),
(1721,1),
(1721,2),
(1722,1),
(1722,2),
(1723,1),
(1723,2),
(1724,1),
(1724,2),
(1725,1),
(1725,2),
(1726,1),
(1726,2),
(1727,1),
(1727,2),
(1728,1),
(1728,2),
(1729,1),
(1729,2),
(1730,1),
(1730,2),
(1731,1),
(1731,2),
(1732,1),
(1732,2),
(1733,1),
(1733,2),
(1734,1),
(1734,2),
(1735,1),
(1735,2),
(1736,1),
(1736,2),
(1737,1),
(1737,2),
(1738,1),
(1738,2),
(1739,1),
(1739,2),
(1740,1),
(1740,2),
(1741,1),
(1741,2),
(1742,1),
(1742,2),
(1743,1),
(1743,2),
(1744,1),
(1744,2),
(1745,1),
(1745,2),
(1746,1),
(1746,2),
(1747,1),
(1747,2),
(1748,1),
(1748,2),
(1749,1),
(1749,2),
(1750,1),
(1750,2),
(1751,1),
(1751,2),
(1752,1),
(1752,2),
(1753,1),
(1753,2),
(1754,1),
(1754,2),
(1755,1),
(1755,2),
(1756,1),
(1756,2),
(1757,1),
(1757,2),
(1758,1),
(1758,2),
(1759,1),
(1759,2),
(1760,1),
(1760,2),
(1761,1),
(1761,2),
(1762,1),
(1762,2),
(1763,1),
(1763,2),
(1764,1),
(1764,2),
(1765,1),
(1765,2),
(1766,1),
(1766,2),
(1767,1),
(1767,2),
(1768,1),
(1768,2),
(1769,1),
(1769,2),
(1770,1),
(1770,2),
(1771,1),
(1771,2),
(1772,1),
(1772,2),
(1773,1),
(1773,2),
(1774,1),
(1774,2),
(1775,1),
(1775,2),
(1776,1),
(1776,2),
(1777,1),
(1777,2),
(1778,1),
(1778,2),
(1779,1),
(1779,2),
(1780,1),
(1780,2),
(1781,1),
(1781,2),
(1782,1),
(1782,2),
(1783,1),
(1783,2),
(1784,1),
(1784,2),
(1785,1),
(1785,2),
(1786,1),
(1786,2),
(1787,1),
(1787,2),
(1788,1),
(1788,2),
(1789,1),
(1789,2),
(1790,1),
(1790,2),
(1791,1),
(1791,2),
(1792,1),
(1792,2),
(1793,1),
(1793,2),
(1794,1),
(1794,2),
(1795,1),
(1795,2),
(1796,1),
(1796,2),
(1797,1),
(1797,2),
(1798,1),
(1798,2),
(1799,1),
(1799,2),
(1800,1),
(1800,2),
(1801,1),
(1801,2),
(1802,1),
(1802,2),
(1803,1),
(1803,2),
(1804,1),
(1804,2),
(1805,1),
(1805,2),
(1806,1),
(1806,2),
(1807,1),
(1807,2),
(1808,1),
(1808,2),
(1809,1),
(1809,2),
(1810,1),
(1810,2),
(1811,1),
(1811,2),
(1812,1),
(1812,2),
(1813,1),
(1813,2),
(1814,1),
(1814,2),
(1815,1),
(1815,2),
(1816,1),
(1816,2),
(1817,1),
(1817,2),
(1818,1),
(1818,2),
(1819,1),
(1819,2),
(1820,1),
(1820,2),
(1821,1),
(1821,2),
(1822,1),
(1822,2),
(1823,1),
(1823,2),
(1824,1),
(1824,2),
(1825,1),
(1825,2),
(1826,1),
(1826,2),
(1827,1),
(1827,2),
(1828,1),
(1828,2),
(1829,1),
(1829,2),
(1830,1),
(1830,2),
(1831,1),
(1831,2),
(1832,1),
(1832,2),
(1833,1),
(1833,2),
(1834,1),
(1834,2),
(1835,1),
(1835,2),
(1836,1),
(1836,2),
(1837,1),
(1837,2),
(1838,1),
(1838,2),
(1839,1),
(1839,2),
(1840,1),
(1840,2),
(1841,1),
(1841,2),
(1842,1),
(1842,2),
(1843,1),
(1843,2),
(1844,1),
(1844,2),
(1845,1),
(1845,2),
(1846,1),
(1846,2),
(1847,1),
(1847,2),
(1848,1),
(1848,2),
(1849,1),
(1849,2),
(1850,1),
(1850,2),
(1851,1),
(1851,2),
(1852,1),
(1852,2),
(1853,1),
(1853,2),
(1854,1),
(1854,2),
(1855,1),
(1855,2),
(1856,1),
(1856,2),
(1857,1),
(1857,2),
(1858,1),
(1858,2),
(1859,1),
(1859,2),
(1860,1),
(1860,2),
(1861,1),
(1861,2),
(1862,1),
(1862,2),
(1863,1),
(1863,2),
(1864,1),
(1864,2),
(1865,1),
(1865,2),
(1866,1),
(1866,2),
(1867,1),
(1867,2),
(1868,1),
(1868,2),
(1869,1),
(1869,2),
(1870,1),
(1870,2),
(1871,1),
(1871,2),
(1872,1),
(1872,2),
(1873,1),
(1873,2),
(1874,1),
(1874,2),
(1875,1),
(1875,2),
(1876,1),
(1876,2),
(1877,1),
(1877,2),
(1878,1),
(1878,2),
(1879,1),
(1879,2),
(1880,1),
(1880,2),
(1881,1),
(1881,2),
(1882,1),
(1882,2),
(1883,1),
(1883,2),
(1884,1),
(1884,2),
(1885,1),
(1885,2),
(1886,1),
(1886,2),
(1887,1),
(1887,2),
(1888,1),
(1888,2),
(1889,1),
(1889,2),
(1890,1),
(1890,2),
(1891,1),
(1891,2),
(1892,1),
(1892,2),
(1893,1),
(1893,2),
(1894,1),
(1894,2),
(1895,1),
(1895,2),
(1896,1),
(1896,2),
(1897,1),
(1897,2),
(1898,1),
(1898,2),
(1899,1),
(1899,2),
(1900,1),
(1900,2),
(1901,1),
(1901,2),
(1902,1),
(1902,2),
(1903,1),
(1903,2),
(1904,1),
(1904,2),
(1905,1),
(1905,2),
(1906,1),
(1906,2),
(1907,1),
(1907,2),
(1908,1),
(1908,2),
(1909,1),
(1909,2),
(1910,1),
(1910,2),
(1911,1),
(1911,2),
(1912,1),
(1912,2),
(1913,1),
(1913,2),
(1914,1),
(1914,2),
(1915,1),
(1915,2),
(1916,1),
(1916,2),
(1917,1),
(1917,2),
(1918,1),
(1918,2),
(1919,1),
(1919,2),
(1920,1),
(1920,2),
(1921,1),
(1921,2),
(1922,1),
(1922,2),
(1923,1),
(1923,2),
(1924,1),
(1924,2),
(1925,1),
(1925,2),
(1926,1),
(1926,2),
(1927,1),
(1927,2),
(1928,1),
(1928,2),
(1929,1),
(1929,2),
(1930,1),
(1930,2),
(1931,1),
(1931,2),
(1932,1),
(1932,2),
(1933,1),
(1933,2),
(1934,1),
(1934,2),
(1935,1),
(1935,2),
(1936,1),
(1936,2),
(1937,1),
(1937,2),
(1938,1),
(1938,2),
(1939,1),
(1939,2),
(1940,1),
(1940,2),
(1941,1),
(1941,2),
(1942,1),
(1942,2),
(1943,1),
(1943,2),
(1944,1),
(1944,2),
(1945,1),
(1945,2),
(1946,1),
(1946,2),
(1947,1),
(1947,2),
(1948,1),
(1948,2),
(1949,1),
(1949,2),
(1950,1),
(1950,2),
(1951,1),
(1951,2),
(1952,1),
(1952,2),
(1953,1),
(1953,2),
(1954,1),
(1954,2),
(1955,1),
(1955,2),
(1956,1),
(1956,2),
(1957,1),
(1957,2),
(1958,1),
(1958,2),
(1959,1),
(1959,2),
(1960,1),
(1960,2),
(1961,1),
(1961,2),
(1962,1),
(1962,2),
(1963,1),
(1963,2),
(1964,1),
(1964,2),
(1965,1),
(1965,2),
(1966,1),
(1966,2),
(1967,1),
(1967,2),
(1968,1),
(1968,2),
(1969,1),
(1969,2),
(1970,1),
(1970,2),
(1971,1),
(1971,2),
(1972,1),
(1972,2),
(1973,1),
(1973,2),
(1974,1),
(1974,2),
(1975,1),
(1975,2),
(1976,1),
(1976,2),
(1977,1),
(1977,2),
(1978,1),
(1978,2),
(1979,1),
(1979,2),
(1980,1),
(1980,2),
(1981,1),
(1981,2),
(1982,1),
(1982,2),
(1983,1),
(1983,2),
(1984,1),
(1984,2),
(1985,1),
(1985,2),
(1986,1),
(1986,2),
(1987,1),
(1987,2),
(1988,1),
(1988,2),
(1989,1),
(1989,2),
(1990,1),
(1990,2),
(1991,1),
(1991,2),
(1992,1),
(1992,2),
(1993,1),
(1993,2),
(1994,1),
(1994,2),
(1995,1),
(1995,2),
(1996,1),
(1996,2),
(1997,1),
(1997,2),
(1998,1),
(1998,2),
(1999,1),
(1999,2),
(2000,1),
(2000,2),
(2001,1),
(2001,2),
(2002,1),
(2002,2),
(2003,1),
(2003,2),
(2004,1),
(2004,2),
(2005,1),
(2005,2),
(2006,1),
(2006,2),
(2007,1),
(2007,2),
(2008,1),
(2008,2),
(2009,1),
(2009,2),
(2010,1),
(2010,2),
(2011,1),
(2011,2),
(2012,1),
(2012,2),
(2013,1),
(2013,2),
(2014,1),
(2014,2),
(2015,1),
(2015,2),
(2016,1),
(2016,2),
(2017,1),
(2017,2),
(2018,1),
(2018,2),
(2019,1),
(2019,2),
(2020,1),
(2020,2),
(2021,1),
(2021,2),
(2022,1),
(2022,2),
(2023,1),
(2023,2),
(2024,1),
(2024,2),
(2025,1),
(2025,2),
(2026,1),
(2026,2),
(2027,1),
(2027,2),
(2028,1),
(2028,2),
(2029,1),
(2029,2),
(2030,1),
(2030,2),
(2031,1),
(2031,2),
(2032,1),
(2032,2),
(2033,1),
(2033,2),
(2034,1),
(2034,2),
(2035,1),
(2035,2),
(2036,1),
(2036,2),
(2037,1),
(2037,2),
(2038,1),
(2038,2),
(2039,1),
(2039,2),
(2040,1),
(2040,2),
(2041,1),
(2041,2),
(2042,1),
(2042,2),
(2043,1),
(2043,2),
(2044,1),
(2044,2),
(2045,1),
(2045,2),
(2046,1),
(2046,2),
(2047,1),
(2047,2),
(2048,1),
(2048,2),
(2049,1),
(2049,2),
(2050,1),
(2050,2),
(2051,1),
(2051,2),
(2052,1),
(2052,2),
(2053,1),
(2053,2),
(2054,1),
(2054,2),
(2055,1),
(2055,2),
(2056,1),
(2056,2),
(2057,1),
(2057,2),
(2058,1),
(2058,2),
(2059,1),
(2059,2),
(2060,1),
(2060,2),
(2061,1),
(2061,2),
(2062,1),
(2062,2),
(2063,1),
(2063,2),
(2064,1),
(2064,2),
(2065,1),
(2065,2),
(2066,1),
(2066,2),
(2067,1),
(2067,2),
(2068,1),
(2068,2),
(2069,1),
(2069,2),
(2070,1),
(2070,2),
(2071,1),
(2071,2),
(2072,1),
(2072,2),
(2073,1),
(2073,2),
(2074,1),
(2074,2),
(2075,1),
(2075,2),
(2076,1),
(2076,2),
(2077,1),
(2077,2),
(2078,1),
(2078,2),
(2079,1),
(2079,2),
(2080,1),
(2080,2),
(2081,1),
(2081,2),
(2082,1),
(2082,2),
(2083,1),
(2083,2),
(2084,1),
(2084,2),
(2085,1),
(2085,2),
(2086,1),
(2086,2),
(2087,1),
(2087,2),
(2088,1),
(2088,2),
(2089,1),
(2089,2),
(2090,1),
(2090,2),
(2091,1),
(2091,2),
(2092,1),
(2092,2),
(2093,1),
(2093,2),
(2094,1),
(2094,2),
(2095,1),
(2095,2),
(2096,1),
(2096,2),
(2097,1),
(2097,2),
(2098,1),
(2098,2),
(2099,1),
(2099,2),
(2100,1),
(2100,2),
(2101,1),
(2101,2),
(2102,1),
(2102,2),
(2103,1),
(2103,2),
(2104,1),
(2104,2),
(2105,1),
(2105,2),
(2106,1),
(2106,2),
(2107,1),
(2107,2),
(2108,1),
(2108,2),
(2109,1),
(2109,2),
(2110,1),
(2110,2),
(2111,1),
(2111,2),
(2112,1),
(2112,2),
(2113,1),
(2113,2),
(2114,1),
(2114,2),
(2115,1),
(2115,2),
(2116,1),
(2116,2),
(2117,1),
(2117,2),
(2118,1),
(2118,2),
(2119,1),
(2119,2),
(2120,1),
(2120,2),
(2121,1),
(2121,2),
(2122,1),
(2122,2),
(2123,1),
(2123,2),
(2124,1),
(2124,2),
(2125,1),
(2125,2),
(2126,1),
(2126,2),
(2127,1),
(2127,2),
(2128,1),
(2128,2),
(2129,1),
(2129,2),
(2130,1),
(2130,2),
(2131,1),
(2131,2),
(2132,1),
(2132,2),
(2133,1),
(2133,2),
(2134,1),
(2134,2),
(2135,1),
(2135,2),
(2136,1),
(2136,2),
(2137,1),
(2137,2),
(2138,1),
(2138,2),
(2139,1),
(2139,2),
(2140,1),
(2140,2),
(2141,1),
(2141,2),
(2142,1),
(2142,2),
(2143,1),
(2143,2),
(2144,1),
(2144,2),
(2145,1),
(2145,2),
(2146,1),
(2146,2),
(2147,1),
(2147,2),
(2148,1),
(2148,2),
(2149,1),
(2149,2),
(2150,1),
(2150,2),
(2151,1),
(2151,2),
(2152,1),
(2152,2),
(2153,1),
(2153,2),
(2154,1),
(2154,2),
(2155,1),
(2155,2),
(2156,1),
(2156,2),
(2157,1),
(2157,2),
(2158,1),
(2158,2),
(2159,1),
(2159,2),
(2160,1),
(2160,2),
(2161,1),
(2161,2),
(2162,1),
(2162,2),
(2163,1),
(2163,2),
(2164,1),
(2164,2),
(2165,1),
(2165,2),
(2166,1),
(2166,2),
(2167,1),
(2167,2),
(2168,1),
(2168,2),
(2169,1),
(2169,2),
(2170,1),
(2170,2),
(2171,1),
(2171,2),
(2172,1),
(2172,2),
(2173,1),
(2173,2),
(2174,1),
(2174,2),
(2175,1),
(2175,2),
(2176,1),
(2176,2),
(2177,1),
(2177,2),
(2178,1),
(2178,2),
(2179,1),
(2179,2),
(2180,1),
(2180,2),
(2181,1),
(2181,2),
(2182,1),
(2182,2),
(2183,1),
(2183,2),
(2184,1),
(2184,2),
(2185,1),
(2185,2),
(2186,1),
(2186,2),
(2187,1),
(2187,2),
(2188,1),
(2188,2),
(2189,1),
(2189,2),
(2190,1),
(2190,2),
(2191,1),
(2191,2),
(2192,1),
(2192,2),
(2193,1),
(2193,2),
(2194,1),
(2194,2),
(2195,1),
(2195,2),
(2196,1),
(2196,2),
(2197,1),
(2197,2),
(2198,1),
(2198,2),
(2199,1),
(2199,2),
(2200,1),
(2200,2),
(2201,1),
(2201,2),
(2202,1),
(2202,2),
(2203,1),
(2203,2),
(2204,1),
(2204,2),
(2205,1),
(2205,2),
(2206,1),
(2206,2),
(2207,1),
(2207,2),
(2208,1),
(2208,2),
(2209,1),
(2209,2),
(2210,1),
(2210,2),
(2211,1),
(2211,2),
(2212,1),
(2212,2),
(2213,1),
(2213,2),
(2214,1),
(2214,2),
(2215,1),
(2215,2),
(2216,1),
(2216,2),
(2217,1),
(2217,2),
(2218,1),
(2218,2),
(2219,1),
(2219,2),
(2220,1),
(2220,2),
(2221,1),
(2221,2),
(2222,1),
(2222,2),
(2223,1),
(2223,2),
(2224,1),
(2224,2),
(2225,1),
(2225,2),
(2226,1),
(2226,2),
(2227,1),
(2227,2),
(2228,1),
(2228,2),
(2229,1),
(2229,2),
(2230,1),
(2230,2),
(2231,1),
(2231,2),
(2232,1),
(2232,2),
(2233,1),
(2233,2),
(2234,1),
(2234,2),
(2235,1),
(2235,2),
(2236,1),
(2236,2),
(2237,1),
(2237,2),
(2238,1),
(2238,2),
(2239,1),
(2239,2),
(2240,1),
(2240,2),
(2241,1),
(2241,2),
(2242,1),
(2242,2),
(2243,1),
(2243,2),
(2244,1),
(2244,2),
(2245,1),
(2245,2),
(2246,1),
(2246,2),
(2247,1),
(2247,2),
(2248,1),
(2248,2),
(2249,1),
(2249,2),
(2250,1),
(2250,2),
(2251,1),
(2251,2),
(2252,1),
(2252,2),
(2253,1),
(2253,2),
(2254,1),
(2254,2),
(2255,1),
(2255,2),
(2256,1),
(2256,2),
(2257,1),
(2257,2),
(2258,1),
(2258,2),
(2259,1),
(2259,2),
(2260,1),
(2260,2),
(2261,1),
(2261,2),
(2262,1),
(2262,2),
(2263,1),
(2263,2),
(2264,1),
(2264,2),
(2265,1),
(2265,2),
(2266,1),
(2266,2),
(2267,1),
(2267,2),
(2268,1),
(2268,2),
(2269,1),
(2269,2),
(2270,1),
(2270,2),
(2271,1),
(2271,2),
(2272,1),
(2272,2),
(2273,1),
(2273,2),
(2274,1),
(2274,2),
(2275,1),
(2275,2),
(2276,1),
(2276,2),
(2277,1),
(2277,2),
(2278,1),
(2278,2),
(2279,1),
(2279,2),
(2280,1),
(2280,2),
(2281,1),
(2281,2),
(2282,1),
(2282,2),
(2283,1),
(2283,2),
(2284,1),
(2284,2),
(2285,1),
(2285,2),
(2286,1),
(2286,2),
(2287,1),
(2287,2),
(2288,1),
(2288,2),
(2289,1),
(2289,2),
(2290,1),
(2290,2),
(2291,1),
(2291,2),
(2292,1),
(2292,2),
(2293,1),
(2293,2),
(2294,1),
(2294,2),
(2295,1),
(2295,2),
(2296,1),
(2296,2),
(2297,1),
(2297,2),
(2298,1),
(2298,2),
(2299,1),
(2299,2),
(2300,1),
(2300,2),
(2301,1),
(2301,2),
(2302,1),
(2302,2),
(2303,1),
(2303,2),
(2304,1),
(2304,2),
(2305,1),
(2305,2),
(2306,1),
(2306,2),
(2307,1),
(2307,2),
(2308,1),
(2308,2),
(2309,1),
(2309,2),
(2310,1),
(2310,2),
(2311,1),
(2311,2),
(2312,1),
(2312,2),
(2313,1),
(2313,2),
(2314,1),
(2314,2),
(2315,1),
(2315,2),
(2316,1),
(2316,2),
(2317,1),
(2317,2),
(2318,1),
(2318,2),
(2319,1),
(2319,2),
(2320,1),
(2320,2),
(2321,1),
(2321,2),
(2322,1),
(2322,2),
(2323,1),
(2323,2),
(2324,1),
(2324,2),
(2325,1),
(2325,2),
(2326,1),
(2326,2),
(2327,1),
(2327,2),
(2328,1),
(2328,2),
(2329,1),
(2329,2),
(2330,1),
(2330,2),
(2331,1),
(2331,2),
(2332,1),
(2332,2),
(2333,1),
(2333,2),
(2334,1),
(2334,2),
(2335,1),
(2335,2),
(2336,1),
(2336,2),
(2337,1),
(2337,2),
(2338,1),
(2338,2),
(2339,1),
(2339,2),
(2340,1),
(2340,2),
(2341,1),
(2341,2),
(2342,1),
(2342,2),
(2343,1),
(2343,2),
(2344,1),
(2344,2),
(2345,1),
(2345,2),
(2346,1),
(2346,2),
(2347,1),
(2347,2),
(2348,1),
(2348,2),
(2349,1),
(2349,2),
(2350,1),
(2350,2),
(2351,1),
(2351,2),
(2352,1),
(2352,2),
(2353,1),
(2353,2),
(2354,1),
(2354,2),
(2355,1),
(2355,2),
(2356,1),
(2356,2),
(2357,1),
(2357,2),
(2358,1),
(2358,2),
(2359,1),
(2359,2),
(2360,1),
(2360,2),
(2361,1),
(2361,2),
(2362,1),
(2362,2),
(2363,1),
(2363,2),
(2364,1),
(2364,2),
(2365,1),
(2365,2),
(2366,1),
(2366,2),
(2367,1),
(2367,2),
(2368,1),
(2368,2),
(2369,1),
(2369,2),
(2370,1),
(2370,2),
(2371,1),
(2371,2),
(2372,1),
(2372,2),
(2373,1),
(2373,2),
(2374,1),
(2374,2),
(2375,1),
(2375,2),
(2376,1),
(2376,2),
(2377,1),
(2377,2),
(2378,1),
(2378,2),
(2379,1),
(2379,2),
(2380,1),
(2380,2),
(2381,1),
(2381,2),
(2382,1),
(2382,2),
(2383,1),
(2383,2),
(2384,1),
(2384,2),
(2385,1),
(2385,2),
(2386,1),
(2386,2),
(2387,1),
(2387,2),
(2388,1),
(2388,2),
(2389,1),
(2389,2),
(2390,1),
(2390,2),
(2391,1),
(2391,2),
(2392,1),
(2392,2),
(2393,1),
(2393,2),
(2394,1),
(2394,2),
(2395,1),
(2395,2),
(2396,1),
(2396,2),
(2397,1),
(2397,2),
(2398,1),
(2398,2),
(2399,1),
(2399,2),
(2400,1),
(2400,2),
(2401,1),
(2401,2),
(2402,1),
(2402,2),
(2403,1),
(2403,2),
(2404,1),
(2404,2),
(2405,1),
(2405,2),
(2406,1),
(2406,2),
(2407,1),
(2407,2),
(2408,1),
(2408,2),
(2409,1),
(2409,2),
(2410,1),
(2410,2),
(2411,1),
(2411,2),
(2412,1),
(2412,2),
(2413,1),
(2413,2),
(2414,1),
(2414,2),
(2415,1),
(2415,2),
(2416,1),
(2416,2),
(2417,1),
(2417,2),
(2418,1),
(2418,2),
(2419,1),
(2419,2),
(2420,1),
(2420,2),
(2421,1),
(2421,2),
(2422,1),
(2422,2),
(2423,1),
(2423,2),
(2424,1),
(2424,2),
(2425,1),
(2425,2),
(2426,1),
(2426,2),
(2427,1),
(2427,2),
(2428,1),
(2428,2),
(2429,1),
(2429,2),
(2430,1),
(2430,2),
(2431,1),
(2431,2),
(2432,1),
(2432,2),
(2433,1),
(2433,2),
(2434,1),
(2434,2),
(2435,1),
(2435,2),
(2436,1),
(2436,2),
(2437,1),
(2437,2),
(2438,1),
(2438,2),
(2439,1),
(2439,2),
(2440,1),
(2440,2),
(2441,1),
(2441,2),
(2442,1),
(2442,2),
(2443,1),
(2443,2),
(2444,1),
(2444,2),
(2445,1),
(2445,2),
(2446,1),
(2446,2),
(2447,1),
(2447,2),
(2448,1),
(2448,2),
(2449,1),
(2449,2),
(2450,1),
(2450,2),
(2451,1),
(2451,2),
(2452,1),
(2452,2),
(2453,1),
(2453,2),
(2454,1),
(2454,2),
(2455,1),
(2455,2),
(2456,1),
(2456,2),
(2457,1),
(2457,2),
(2458,1),
(2458,2),
(2459,1),
(2459,2),
(2460,1),
(2460,2),
(2461,1),
(2461,2),
(2462,1),
(2462,2),
(2463,1),
(2463,2),
(2464,1),
(2464,2),
(2465,1),
(2465,2),
(2466,1),
(2466,2),
(2467,1),
(2467,2),
(2468,1),
(2468,2),
(2469,1),
(2469,2),
(2470,1),
(2470,2),
(2471,1),
(2471,2),
(2472,1),
(2472,2),
(2473,1),
(2473,2),
(2474,1),
(2474,2),
(2475,1),
(2475,2),
(2476,1),
(2476,2),
(2477,1),
(2477,2),
(2478,1),
(2478,2),
(2479,1),
(2479,2),
(2480,1),
(2480,2),
(2481,1),
(2481,2),
(2482,1),
(2482,2),
(2483,1),
(2483,2),
(2484,1),
(2484,2),
(2485,1),
(2485,2),
(2486,1),
(2486,2),
(2487,1),
(2487,2),
(2488,1),
(2488,2),
(2489,1),
(2489,2),
(2490,1),
(2490,2),
(2491,1),
(2491,2),
(2492,1),
(2492,2),
(2493,1),
(2493,2),
(2494,1),
(2494,2),
(2495,1),
(2495,2),
(2496,1),
(2496,2),
(2497,1),
(2497,2),
(2498,1),
(2498,2),
(2499,1),
(2499,2),
(2500,1),
(2500,2),
(2501,1),
(2501,2),
(2502,1),
(2502,2),
(2503,1),
(2503,2),
(2504,1),
(2504,2),
(2505,1),
(2505,2),
(2506,1),
(2506,2),
(2507,1),
(2507,2),
(2508,1),
(2508,2),
(2509,1),
(2509,2),
(2510,1),
(2510,2),
(2511,1),
(2511,2),
(2512,1),
(2512,2),
(2513,1),
(2513,2),
(2514,1),
(2514,2),
(2515,1),
(2515,2),
(2516,1),
(2516,2),
(2517,1),
(2517,2),
(2518,1),
(2518,2),
(2519,1),
(2519,2),
(2520,1),
(2520,2),
(2521,1),
(2521,2),
(2522,1),
(2522,2),
(2523,1),
(2523,2),
(2524,1),
(2524,2),
(2525,1),
(2525,2),
(2526,1),
(2526,2),
(2527,1),
(2527,2),
(2528,1),
(2528,2),
(2529,1),
(2529,2),
(2530,1),
(2530,2),
(2531,1),
(2531,2),
(2532,1),
(2532,2),
(2533,1),
(2533,2),
(2534,1),
(2534,2),
(2535,1),
(2535,2),
(2536,1),
(2536,2),
(2537,1),
(2537,2),
(2538,1),
(2538,2),
(2539,1),
(2539,2),
(2540,1),
(2540,2),
(2541,1),
(2541,2),
(2542,1),
(2542,2),
(2543,1),
(2543,2),
(2544,1),
(2544,2),
(2545,1),
(2545,2),
(2546,1),
(2546,2),
(2547,1),
(2547,2),
(2548,1),
(2548,2),
(2549,1),
(2549,2),
(2550,1),
(2550,2),
(2551,1),
(2551,2),
(2552,1),
(2552,2),
(2553,1),
(2553,2),
(2554,1),
(2554,2),
(2555,1),
(2555,2),
(2556,1),
(2556,2),
(2557,1),
(2557,2),
(2558,1),
(2558,2),
(2559,1),
(2559,2),
(2560,1),
(2560,2),
(2561,1),
(2561,2),
(2562,1),
(2562,2),
(2563,1),
(2563,2),
(2564,1),
(2564,2),
(2565,1),
(2565,2),
(2566,1),
(2566,2),
(2567,1),
(2567,2),
(2568,1),
(2568,2),
(2569,1),
(2569,2),
(2570,1),
(2570,2),
(2571,1),
(2571,2),
(2572,1),
(2572,2),
(2573,1),
(2573,2),
(2574,1),
(2574,2),
(2575,1),
(2575,2),
(2576,1),
(2576,2),
(2577,1),
(2577,2),
(2578,1),
(2578,2),
(2579,1),
(2579,2),
(2580,1),
(2580,2),
(2581,1),
(2581,2),
(2582,1),
(2582,2),
(2583,1),
(2583,2),
(2584,1),
(2584,2),
(2585,1),
(2585,2),
(2586,1),
(2586,2),
(2587,1),
(2587,2),
(2588,1),
(2588,2),
(2589,1),
(2589,2),
(2590,1),
(2590,2),
(2591,1),
(2591,2),
(2592,1),
(2592,2),
(2593,1),
(2593,2),
(2594,1),
(2594,2),
(2595,1),
(2595,2),
(2596,1),
(2596,2),
(2597,1),
(2597,2),
(2598,1),
(2598,2),
(2599,1),
(2599,2),
(2600,1),
(2600,2),
(2601,1),
(2601,2),
(2602,1),
(2602,2),
(2603,1),
(2603,2),
(2604,1),
(2604,2),
(2605,1),
(2605,2),
(2606,1),
(2606,2),
(2607,1),
(2607,2),
(2608,1),
(2608,2),
(2609,1),
(2609,2),
(2610,1),
(2610,2),
(2611,1),
(2611,2),
(2612,1),
(2612,2),
(2613,1),
(2613,2),
(2614,1),
(2614,2),
(2615,1),
(2615,2),
(2616,1),
(2616,2),
(2617,1),
(2617,2),
(2618,1),
(2618,2),
(2619,1),
(2619,2),
(2620,1),
(2620,2),
(2621,1),
(2621,2),
(2622,1),
(2622,2),
(2623,1),
(2623,2),
(2624,1),
(2624,2),
(2625,1),
(2625,2),
(2626,1),
(2626,2),
(2627,1),
(2627,2),
(2628,1),
(2628,2),
(2629,1),
(2629,2),
(2630,1),
(2630,2),
(2631,1),
(2631,2),
(2632,1),
(2632,2),
(2633,1),
(2633,2),
(2634,1),
(2634,2),
(2635,1),
(2635,2),
(2636,1),
(2636,2),
(2637,1),
(2637,2),
(2638,1),
(2638,2),
(2639,1),
(2639,2),
(2640,1),
(2640,2),
(2641,1),
(2641,2),
(2642,1),
(2642,2),
(2643,1),
(2643,2),
(2644,1),
(2644,2),
(2645,1),
(2645,2),
(2646,1),
(2646,2),
(2647,1),
(2647,2),
(2648,1),
(2648,2),
(2649,1),
(2649,2),
(2650,1),
(2650,2),
(2651,1),
(2651,2),
(2652,1),
(2652,2),
(2653,1),
(2653,2),
(2654,1),
(2654,2),
(2655,1),
(2655,2),
(2656,1),
(2656,2),
(2657,1),
(2657,2),
(2658,1),
(2658,2),
(2659,1),
(2659,2),
(2660,1),
(2660,2),
(2661,1),
(2661,2),
(2662,1),
(2662,2),
(2663,1),
(2663,2),
(2664,1),
(2664,2),
(2665,1),
(2665,2),
(2666,1),
(2666,2),
(2667,1),
(2667,2),
(2668,1),
(2668,2),
(2669,1),
(2669,2),
(2670,1),
(2670,2),
(2671,1),
(2671,2),
(2672,1),
(2672,2),
(2673,1),
(2673,2),
(2674,1),
(2674,2),
(2675,1),
(2675,2),
(2676,1),
(2676,2),
(2677,1),
(2677,2),
(2678,1),
(2678,2),
(2679,1),
(2679,2),
(2680,1),
(2680,2),
(2681,1),
(2681,2),
(2682,1),
(2682,2),
(2683,1),
(2683,2),
(2684,1),
(2684,2),
(2685,1),
(2685,2),
(2686,1),
(2686,2),
(2687,1),
(2687,2),
(2688,1),
(2688,2),
(2689,1),
(2689,2),
(2690,1),
(2690,2),
(2691,1),
(2691,2),
(2692,1),
(2692,2),
(2693,1),
(2693,2),
(2694,1),
(2694,2),
(2695,1),
(2695,2),
(2696,1),
(2696,2),
(2697,1),
(2697,2),
(2698,1),
(2698,2),
(2699,1),
(2699,2),
(2700,1),
(2700,2),
(2701,1),
(2701,2),
(2702,1),
(2702,2),
(2703,1),
(2703,2),
(2704,1),
(2704,2),
(2705,1),
(2705,2),
(2706,1),
(2706,2),
(2707,1),
(2707,2),
(2708,1),
(2708,2),
(2709,1),
(2709,2),
(2710,1),
(2710,2),
(2711,1),
(2711,2),
(2712,1),
(2712,2),
(2713,1),
(2713,2),
(2714,1),
(2714,2),
(2715,1),
(2715,2),
(2716,1),
(2716,2),
(2717,1),
(2717,2),
(2718,1),
(2718,2),
(2719,1),
(2719,2),
(2720,1),
(2720,2),
(2721,1),
(2721,2),
(2722,1),
(2722,2),
(2723,1),
(2723,2),
(2724,1),
(2724,2),
(2725,1),
(2725,2),
(2726,1),
(2726,2),
(2727,1),
(2727,2),
(2728,1),
(2728,2),
(2729,1),
(2729,2),
(2730,1),
(2730,2),
(2731,1),
(2731,2),
(2732,1),
(2732,2),
(2733,1),
(2733,2),
(2734,1),
(2734,2),
(2735,1),
(2735,2),
(2736,1),
(2736,2),
(2737,1),
(2737,2),
(2738,1),
(2738,2),
(2739,1),
(2739,2),
(2740,1),
(2740,2),
(2741,1),
(2741,2),
(2742,1),
(2742,2),
(2743,1),
(2743,2),
(2744,1),
(2744,2),
(2745,1),
(2745,2),
(2746,1),
(2746,2),
(2747,1),
(2747,2),
(2748,1),
(2748,2),
(2749,1),
(2749,2),
(2750,1),
(2750,2),
(2751,1),
(2751,2),
(2752,1),
(2752,2),
(2753,1),
(2753,2),
(2754,1),
(2754,2),
(2755,1),
(2755,2),
(2756,1),
(2756,2),
(2757,1),
(2757,2),
(2758,1),
(2758,2),
(2759,1),
(2759,2),
(2760,1),
(2760,2),
(2761,1),
(2761,2),
(2762,1),
(2762,2),
(2763,1),
(2763,2),
(2764,1),
(2764,2),
(2765,1),
(2765,2),
(2766,1),
(2766,2),
(2767,1),
(2767,2),
(2768,1),
(2768,2),
(2769,1),
(2769,2),
(2770,1),
(2770,2),
(2771,1),
(2771,2),
(2772,1),
(2772,2),
(2773,1),
(2773,2),
(2774,1),
(2774,2),
(2775,1),
(2775,2),
(2776,1),
(2776,2),
(2777,1),
(2777,2),
(2778,1),
(2778,2),
(2779,1),
(2779,2),
(2780,1),
(2780,2),
(2781,1),
(2781,2),
(2782,1),
(2782,2),
(2783,1),
(2783,2),
(2784,1),
(2784,2),
(2785,1),
(2785,2),
(2786,1),
(2786,2),
(2787,1),
(2787,2),
(2788,1),
(2788,2),
(2789,1),
(2789,2),
(2790,1),
(2790,2),
(2791,1),
(2791,2),
(2792,1),
(2792,2),
(2793,1),
(2793,2),
(2794,1),
(2794,2),
(2795,1),
(2795,2),
(2796,1),
(2796,2),
(2797,1),
(2797,2),
(2798,1),
(2798,2),
(2799,1),
(2799,2),
(2800,1),
(2800,2),
(2801,1),
(2801,2),
(2802,1),
(2802,2),
(2803,1),
(2803,2),
(2804,1),
(2804,2),
(2805,1),
(2805,2),
(2806,1),
(2806,2),
(2807,1),
(2807,2),
(2808,1),
(2808,2),
(2809,1),
(2809,2),
(2810,1),
(2810,2),
(2811,1),
(2811,2),
(2812,1),
(2812,2),
(2813,1),
(2813,2),
(2814,1),
(2814,2),
(2815,1),
(2815,2),
(2816,1),
(2816,2),
(2817,1),
(2817,2),
(2818,1),
(2818,2),
(2819,1),
(2819,2),
(2820,1),
(2820,2),
(2821,1),
(2821,2),
(2822,1),
(2822,2),
(2823,1),
(2823,2),
(2824,1),
(2824,2),
(2825,1),
(2825,2),
(2826,1),
(2826,2),
(2827,1),
(2827,2),
(2828,1),
(2828,2),
(2829,1),
(2829,2),
(2830,1),
(2830,2),
(2831,1),
(2831,2),
(2832,1),
(2832,2),
(2833,1),
(2833,2),
(2834,1),
(2834,2),
(2835,1),
(2835,2),
(2836,1),
(2836,2),
(2837,1),
(2837,2),
(2838,1),
(2838,2),
(2839,1),
(2839,2),
(2840,1),
(2840,2),
(2841,1),
(2841,2),
(2842,1),
(2842,2),
(2843,1),
(2843,2),
(2844,1),
(2844,2),
(2845,1),
(2845,2),
(2846,1),
(2846,2),
(2847,1),
(2847,2),
(2848,1),
(2848,2),
(2849,1),
(2849,2),
(2850,1),
(2850,2),
(2851,1),
(2851,2),
(2852,1),
(2852,2),
(2853,1),
(2853,2),
(2854,1),
(2854,2),
(2855,1),
(2855,2),
(2856,1),
(2856,2),
(2857,1),
(2857,2),
(2858,1),
(2858,2),
(2859,1),
(2859,2),
(2860,1),
(2860,2),
(2861,1),
(2861,2),
(2862,1),
(2862,2),
(2863,1),
(2863,2),
(2864,1),
(2864,2),
(2865,1),
(2865,2),
(2866,1),
(2866,2),
(2867,1),
(2867,2),
(2868,1),
(2868,2),
(2869,1),
(2869,2),
(2870,1),
(2870,2),
(2871,1),
(2871,2),
(2872,1),
(2872,2),
(2873,1),
(2873,2),
(2874,1),
(2874,2),
(2875,1),
(2875,2),
(2876,1),
(2876,2),
(2877,1),
(2877,2),
(2878,1),
(2878,2),
(2879,1),
(2879,2),
(2880,1),
(2880,2),
(2881,1),
(2881,2),
(2882,1),
(2882,2),
(2883,1),
(2883,2),
(2884,1),
(2884,2),
(2885,1),
(2885,2),
(2886,1),
(2886,2),
(2887,1),
(2887,2),
(2888,1),
(2888,2),
(2889,1),
(2889,2),
(2890,1),
(2890,2),
(2891,1),
(2891,2),
(2892,1),
(2892,2),
(2893,1),
(2893,2),
(2894,1),
(2894,2),
(2895,1),
(2895,2),
(2896,1),
(2896,2),
(2897,1),
(2897,2),
(2898,1),
(2898,2),
(2899,1),
(2899,2),
(2900,1),
(2900,2),
(2901,1),
(2901,2),
(2902,1),
(2902,2),
(2903,1),
(2903,2),
(2904,1),
(2904,2),
(2905,1),
(2905,2),
(2906,1),
(2906,2),
(2907,1),
(2907,2),
(2908,1),
(2908,2),
(2909,1),
(2909,2),
(2910,1),
(2910,2),
(2911,1),
(2911,2),
(2912,1),
(2912,2),
(2913,1),
(2913,2),
(2914,1),
(2914,2),
(2915,1),
(2915,2),
(2916,1),
(2916,2),
(2917,1),
(2917,2),
(2918,1),
(2918,2),
(2919,1),
(2919,2),
(2920,1),
(2920,2),
(2921,1),
(2921,2),
(2922,1),
(2922,2),
(2923,1),
(2923,2),
(2924,1),
(2924,2),
(2925,1),
(2925,2),
(2926,1),
(2926,2),
(2927,1),
(2927,2),
(2928,1),
(2928,2),
(2929,1),
(2929,2),
(2930,1),
(2930,2),
(2931,1),
(2931,2),
(2932,1),
(2932,2),
(2933,1),
(2933,2),
(2934,1),
(2934,2),
(2935,1),
(2935,2),
(2936,1),
(2936,2),
(2937,1),
(2937,2),
(2938,1),
(2938,2),
(2939,1),
(2939,2),
(2940,1),
(2940,2),
(2941,1),
(2941,2),
(2942,1),
(2942,2),
(2943,1),
(2943,2),
(2944,1),
(2944,2),
(2945,1),
(2945,2),
(2946,1),
(2946,2),
(2947,1),
(2947,2),
(2948,1),
(2948,2),
(2949,1),
(2949,2),
(2950,1),
(2950,2),
(2951,1),
(2951,2),
(2952,1),
(2952,2),
(2953,1),
(2953,2),
(2954,1),
(2954,2),
(2955,1),
(2955,2),
(2956,1),
(2956,2),
(2957,1),
(2957,2),
(2958,1),
(2958,2),
(2959,1),
(2959,2),
(2960,1),
(2960,2),
(2961,1),
(2961,2),
(2962,1),
(2962,2),
(2963,1),
(2963,2),
(2964,1),
(2964,2),
(2965,1),
(2965,2),
(2966,1),
(2966,2),
(2967,1),
(2967,2),
(2968,1),
(2968,2),
(2969,1),
(2969,2),
(2970,1),
(2970,2),
(2971,1),
(2971,2),
(2972,1),
(2972,2),
(2973,1),
(2973,2),
(2974,1),
(2974,2),
(2975,1),
(2975,2),
(2976,1),
(2976,2),
(2977,1),
(2977,2),
(2978,1),
(2978,2),
(2979,1),
(2979,2),
(2980,1),
(2980,2),
(2981,1),
(2981,2),
(2982,1),
(2982,2),
(2983,1),
(2983,2),
(2984,1),
(2984,2),
(2985,1),
(2985,2),
(2986,1),
(2986,2),
(2987,1),
(2987,2),
(2988,1),
(2988,2),
(2989,1),
(2989,2),
(2990,1),
(2990,2),
(2991,1),
(2991,2),
(2992,1),
(2992,2),
(2993,1),
(2993,2),
(2994,1),
(2994,2),
(2995,1),
(2995,2),
(2996,1),
(2996,2),
(2997,1),
(2997,2),
(2998,1),
(2998,2),
(2999,1),
(2999,2),
(3000,1),
(3000,2),
(3001,1),
(3001,2),
(3002,1),
(3002,2),
(3003,1),
(3003,2),
(3004,1),
(3004,2),
(3005,1),
(3005,2),
(3006,1),
(3006,2),
(3007,1),
(3007,2),
(3008,1),
(3008,2),
(3009,1),
(3009,2),
(3010,1),
(3010,2),
(3011,1),
(3011,2),
(3012,1),
(3012,2),
(3013,1),
(3013,2),
(3014,1),
(3014,2),
(3015,1),
(3015,2),
(3016,1),
(3016,2),
(3017,1),
(3017,2),
(3018,1),
(3018,2),
(3019,1),
(3019,2),
(3020,1),
(3020,2),
(3021,1),
(3021,2),
(3022,1),
(3022,2),
(3023,1),
(3023,2),
(3024,1),
(3024,2),
(3025,1),
(3025,2),
(3026,1),
(3026,2),
(3027,1),
(3027,2),
(3028,1),
(3028,2),
(3029,1),
(3029,2),
(3030,1),
(3030,2),
(3031,1),
(3031,2),
(3032,1),
(3032,2),
(3033,1),
(3033,2),
(3034,1),
(3034,2),
(3035,1),
(3035,2),
(3036,1),
(3036,2),
(3037,1),
(3037,2),
(3038,1),
(3038,2),
(3039,1),
(3039,2),
(3040,1),
(3040,2),
(3041,1),
(3041,2),
(3042,1),
(3042,2),
(3043,1),
(3043,2),
(3044,1),
(3044,2),
(3045,1),
(3045,2),
(3046,1),
(3046,2),
(3047,1),
(3047,2),
(3048,1),
(3048,2),
(3049,1),
(3049,2),
(3050,1),
(3050,2),
(3051,1),
(3051,2),
(3052,1),
(3052,2),
(3053,1),
(3053,2),
(3054,1),
(3054,2),
(3055,1),
(3055,2),
(3056,1),
(3056,2),
(3057,1),
(3057,2),
(3058,1),
(3058,2),
(3059,1),
(3059,2),
(3060,1),
(3060,2),
(3061,1),
(3061,2),
(3062,1),
(3062,2),
(3063,1),
(3063,2),
(3064,1),
(3064,2),
(3065,1),
(3065,2),
(3066,1),
(3066,2),
(3067,1),
(3067,2),
(3068,1),
(3068,2),
(3069,1),
(3069,2),
(3070,1),
(3070,2),
(3071,1),
(3071,2),
(3072,1),
(3072,2),
(3073,1),
(3073,2),
(3074,1),
(3074,2),
(3075,1),
(3075,2),
(3076,1),
(3076,2),
(3077,1),
(3077,2),
(3078,1),
(3078,2),
(3079,1),
(3079,2),
(3080,1),
(3080,2),
(3081,1),
(3081,2),
(3082,1),
(3082,2),
(3083,1),
(3083,2),
(3084,1),
(3084,2),
(3085,1),
(3085,2),
(3086,1),
(3086,2),
(3087,1),
(3087,2),
(3088,1),
(3088,2),
(3089,1),
(3089,2),
(3090,1),
(3090,2),
(3091,1),
(3091,2),
(3092,1),
(3092,2),
(3093,1),
(3093,2),
(3094,1),
(3094,2),
(3095,1),
(3095,2),
(3096,1),
(3096,2),
(3097,1),
(3097,2),
(3098,1),
(3098,2),
(3099,1),
(3099,2),
(3100,1),
(3100,2),
(3101,1),
(3101,2),
(3102,1),
(3102,2),
(3103,1),
(3103,2),
(3104,1),
(3104,2),
(3105,1),
(3105,2),
(3106,1),
(3106,2),
(3107,1),
(3107,2),
(3108,1),
(3108,2),
(3109,1),
(3109,2),
(3110,1),
(3110,2),
(3111,1),
(3111,2),
(3112,1),
(3112,2),
(3113,1),
(3113,2),
(3114,1),
(3114,2),
(3115,1),
(3115,2),
(3116,1),
(3116,2),
(3117,1),
(3117,2),
(3118,1),
(3118,2),
(3119,1),
(3119,2),
(3120,1),
(3120,2),
(3121,1),
(3121,2),
(3122,1),
(3122,2),
(3123,1),
(3123,2),
(3124,1),
(3124,2),
(3125,1),
(3125,2),
(3126,1),
(3126,2),
(3127,1),
(3127,2),
(3128,1),
(3128,2),
(3129,1),
(3129,2),
(3130,1),
(3130,2),
(3131,1),
(3131,2),
(3132,1),
(3132,2),
(3133,1),
(3133,2),
(3134,1),
(3134,2),
(3135,1),
(3135,2),
(3136,1),
(3136,2),
(3137,1),
(3137,2),
(3138,1),
(3138,2),
(3139,1),
(3139,2),
(3140,1),
(3140,2),
(3141,1),
(3141,2),
(3142,1),
(3142,2),
(3143,1),
(3143,2),
(3144,1),
(3144,2),
(3145,1),
(3145,2),
(3146,1),
(3146,2),
(3147,1),
(3147,2),
(3148,1),
(3148,2),
(3149,1),
(3149,2),
(3150,1),
(3150,2),
(3151,1),
(3151,2),
(3152,1),
(3152,2),
(3153,1),
(3153,2),
(3154,1),
(3154,2),
(3155,1),
(3155,2),
(3156,1),
(3156,2),
(3157,1),
(3157,2),
(3158,1),
(3158,2),
(3159,1),
(3159,2),
(3160,1),
(3160,2),
(3161,1),
(3161,2),
(3162,1),
(3162,2),
(3163,1),
(3163,2),
(3164,1),
(3164,2),
(3165,1),
(3165,2),
(3166,1),
(3166,2),
(3167,1),
(3167,2),
(3168,1),
(3168,2),
(3169,1),
(3169,2),
(3170,1),
(3170,2),
(3171,1),
(3171,2),
(3172,1),
(3172,2),
(3173,1),
(3173,2),
(3174,1),
(3174,2),
(3175,1),
(3175,2),
(3176,1),
(3176,2),
(3177,1),
(3177,2),
(3178,1),
(3178,2),
(3179,1),
(3179,2),
(3180,1),
(3180,2),
(3181,1),
(3181,2),
(3182,1),
(3182,2),
(3183,1),
(3183,2),
(3184,1),
(3184,2),
(3185,1),
(3185,2),
(3186,1),
(3186,2),
(3187,1),
(3187,2),
(3188,1),
(3188,2),
(3189,1),
(3189,2),
(3190,1),
(3190,2),
(3191,1),
(3191,2),
(3192,1),
(3192,2),
(3193,1),
(3193,2),
(3194,1),
(3194,2),
(3195,1),
(3195,2),
(3196,1),
(3196,2),
(3197,1),
(3197,2),
(3198,1),
(3198,2),
(3199,1),
(3199,2),
(3200,1),
(3200,2),
(3201,1),
(3201,2),
(3202,1),
(3202,2),
(3203,1),
(3203,2),
(3204,1),
(3204,2),
(3205,1),
(3205,2),
(3206,1),
(3206,2),
(3207,1),
(3207,2),
(3208,1),
(3208,2),
(3209,1),
(3209,2),
(3210,1),
(3210,2),
(3211,1),
(3211,2),
(3212,1),
(3212,2),
(3213,1),
(3213,2),
(3214,1),
(3214,2),
(3215,1),
(3215,2),
(3216,1),
(3216,2),
(3217,1),
(3217,2),
(3218,1),
(3218,2),
(3219,1),
(3219,2),
(3220,1),
(3220,2),
(3221,1),
(3221,2),
(3222,1),
(3222,2),
(3223,1),
(3223,2),
(3224,1),
(3224,2),
(3225,1),
(3225,2),
(3226,1),
(3226,2),
(3227,1),
(3227,2),
(3228,1),
(3228,2),
(3229,1),
(3229,2),
(3230,1),
(3230,2),
(3231,1),
(3231,2),
(3232,1),
(3232,2),
(3233,1),
(3233,2),
(3234,1),
(3234,2),
(3235,1),
(3235,2),
(3236,1),
(3236,2),
(3237,1),
(3237,2),
(3238,1),
(3238,2),
(3239,1),
(3239,2),
(3240,1),
(3240,2),
(3241,1),
(3241,2),
(3242,1),
(3242,2),
(3243,1),
(3243,2),
(3244,1),
(3244,2),
(3245,1),
(3245,2),
(3246,1),
(3246,2),
(3247,1),
(3247,2),
(3248,1),
(3248,2),
(3249,1),
(3249,2),
(3250,1),
(3250,2),
(3251,1),
(3251,2),
(3252,1),
(3252,2),
(3253,1),
(3253,2),
(3254,1),
(3254,2),
(3255,1),
(3255,2),
(3256,1),
(3256,2),
(3257,1),
(3257,2),
(3258,1),
(3258,2),
(3259,1),
(3259,2),
(3260,1),
(3260,2),
(3261,1),
(3261,2),
(3262,1),
(3262,2),
(3263,1),
(3263,2),
(3264,1),
(3264,2),
(3265,1),
(3265,2),
(3266,1),
(3266,2),
(3267,1),
(3267,2),
(3268,1),
(3268,2),
(3269,1),
(3269,2),
(3270,1),
(3270,2),
(3271,1),
(3271,2),
(3272,1),
(3272,2),
(3273,1),
(3273,2),
(3274,1),
(3274,2),
(3275,1),
(3275,2),
(3276,1),
(3276,2),
(3277,1),
(3277,2),
(3278,1),
(3278,2),
(3279,1),
(3279,2),
(3280,1),
(3280,2),
(3281,1),
(3281,2),
(3282,1),
(3282,2),
(3283,1),
(3283,2),
(3284,1),
(3284,2),
(3285,1),
(3285,2),
(3286,1),
(3286,2),
(3287,1),
(3287,2),
(3288,1),
(3288,2),
(3289,1),
(3289,2),
(3290,1),
(3290,2),
(3291,1),
(3291,2),
(3292,1),
(3292,2),
(3293,1),
(3293,2),
(3294,1),
(3294,2),
(3295,1),
(3295,2),
(3296,1),
(3296,2),
(3297,1),
(3297,2),
(3298,1),
(3298,2),
(3299,1),
(3299,2),
(3300,1),
(3300,2),
(3301,1),
(3301,2),
(3302,1),
(3302,2),
(3303,1),
(3303,2),
(3304,1),
(3304,2),
(3305,1),
(3305,2),
(3306,1),
(3306,2),
(3307,1),
(3307,2),
(3308,1),
(3308,2),
(3309,1),
(3309,2),
(3310,1),
(3310,2),
(3311,1),
(3311,2),
(3312,1),
(3312,2),
(3313,1),
(3313,2),
(3314,1),
(3314,2),
(3315,1),
(3315,2),
(3316,1),
(3316,2),
(3317,1),
(3317,2),
(3318,1),
(3318,2),
(3319,1),
(3319,2),
(3320,1),
(3320,2),
(3321,1),
(3321,2),
(3322,1),
(3322,2),
(3323,1),
(3323,2),
(3324,1),
(3324,2),
(3325,1),
(3325,2),
(3326,1),
(3326,2),
(3327,1),
(3327,2),
(3328,1),
(3328,2),
(3329,1),
(3329,2),
(3330,1),
(3330,2),
(3331,1),
(3331,2),
(3332,1),
(3332,2),
(3333,1),
(3333,2),
(3334,1),
(3334,2),
(3335,1),
(3335,2),
(3336,1),
(3336,2),
(3337,1),
(3337,2),
(3338,1),
(3338,2),
(3339,1),
(3339,2),
(3340,1),
(3340,2),
(3341,1),
(3341,2),
(3342,1),
(3342,2),
(3343,1),
(3343,2),
(3344,1),
(3344,2),
(3345,1),
(3345,2),
(3346,1),
(3346,2),
(3347,1),
(3347,2),
(3348,1),
(3348,2),
(3349,1),
(3349,2),
(3350,1),
(3350,2),
(3351,1),
(3351,2),
(3352,1),
(3352,2),
(3353,1),
(3353,2),
(3354,1),
(3354,2),
(3355,1),
(3355,2),
(3356,1),
(3356,2),
(3357,1),
(3357,2),
(3358,1),
(3358,2),
(3359,1),
(3359,2),
(3360,1),
(3360,2),
(3361,1),
(3361,2),
(3362,1),
(3362,2),
(3363,1),
(3363,2),
(3364,1),
(3364,2),
(3365,1),
(3365,2),
(3366,1),
(3366,2),
(3367,1),
(3367,2),
(3368,1),
(3368,2),
(3369,1),
(3369,2),
(3370,1),
(3370,2),
(3371,1),
(3371,2),
(3372,1),
(3372,2),
(3373,1),
(3373,2),
(3374,1),
(3374,2),
(3375,1),
(3375,2),
(3376,1),
(3376,2),
(3377,1),
(3377,2),
(3378,1),
(3378,2),
(3379,1),
(3379,2),
(3380,1),
(3380,2),
(3381,1),
(3381,2),
(3382,1),
(3382,2),
(3383,1),
(3383,2),
(3384,1),
(3384,2),
(3385,1),
(3385,2),
(3386,1),
(3386,2),
(3387,1),
(3387,2),
(3388,1),
(3388,2),
(3389,1),
(3389,2),
(3390,1),
(3390,2);
/*!40000 ALTER TABLE `product_locations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_racks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_racks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int(10) unsigned NOT NULL,
  `location_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `rack` varchar(191) DEFAULT NULL,
  `row` varchar(191) DEFAULT NULL,
  `position` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_racks_business_id_index` (`business_id`),
  KEY `product_racks_location_id_index` (`location_id`),
  KEY `product_racks_product_id_index` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_racks` WRITE;
/*!40000 ALTER TABLE `product_racks` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_racks` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `product_variations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `product_variations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `variation_template_id` int(11) DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `is_dummy` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `product_variations_name_index` (`name`),
  KEY `product_variations_product_id_index` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3391 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `product_variations` WRITE;
/*!40000 ALTER TABLE `product_variations` DISABLE KEYS */;
INSERT INTO `product_variations` VALUES
(1,NULL,'DUMMY',1,1,'2025-05-23 06:00:39','2025-05-23 06:00:39'),
(2,NULL,'DUMMY',2,1,'2025-05-23 06:00:39','2025-05-23 06:00:39'),
(3,NULL,'DUMMY',3,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(4,NULL,'DUMMY',4,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(5,NULL,'DUMMY',5,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(6,NULL,'DUMMY',6,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(7,NULL,'DUMMY',7,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(8,NULL,'DUMMY',8,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(9,NULL,'DUMMY',9,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(10,NULL,'DUMMY',10,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(11,NULL,'DUMMY',11,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(12,NULL,'DUMMY',12,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(13,NULL,'DUMMY',13,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(14,NULL,'DUMMY',14,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(15,NULL,'DUMMY',15,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(16,NULL,'DUMMY',16,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(17,NULL,'DUMMY',17,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(18,NULL,'DUMMY',18,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(19,NULL,'DUMMY',19,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(20,NULL,'DUMMY',20,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(21,NULL,'DUMMY',21,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(22,NULL,'DUMMY',22,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(23,NULL,'DUMMY',23,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(24,NULL,'DUMMY',24,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(25,NULL,'DUMMY',25,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(26,NULL,'DUMMY',26,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(27,NULL,'DUMMY',27,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(28,NULL,'DUMMY',28,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(29,NULL,'DUMMY',29,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(30,NULL,'DUMMY',30,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(31,NULL,'DUMMY',31,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(32,NULL,'DUMMY',32,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(33,NULL,'DUMMY',33,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(34,NULL,'DUMMY',34,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(35,NULL,'DUMMY',35,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(36,NULL,'DUMMY',36,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(37,NULL,'DUMMY',37,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(38,NULL,'DUMMY',38,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(39,NULL,'DUMMY',39,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(40,NULL,'DUMMY',40,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(41,NULL,'DUMMY',41,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(42,NULL,'DUMMY',42,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(43,NULL,'DUMMY',43,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(44,NULL,'DUMMY',44,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(45,NULL,'DUMMY',45,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(46,NULL,'DUMMY',46,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(47,NULL,'DUMMY',47,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(48,NULL,'DUMMY',48,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(49,NULL,'DUMMY',49,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(50,NULL,'DUMMY',50,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(51,NULL,'DUMMY',51,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(52,NULL,'DUMMY',52,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(53,NULL,'DUMMY',53,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(54,NULL,'DUMMY',54,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(55,NULL,'DUMMY',55,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(56,NULL,'DUMMY',56,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(57,NULL,'DUMMY',57,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(58,NULL,'DUMMY',58,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(59,NULL,'DUMMY',59,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(60,NULL,'DUMMY',60,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(61,NULL,'DUMMY',61,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(62,NULL,'DUMMY',62,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(63,NULL,'DUMMY',63,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(64,NULL,'DUMMY',64,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(65,NULL,'DUMMY',65,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(66,NULL,'DUMMY',66,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(67,NULL,'DUMMY',67,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(68,NULL,'DUMMY',68,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(69,NULL,'DUMMY',69,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(70,NULL,'DUMMY',70,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(71,NULL,'DUMMY',71,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(72,NULL,'DUMMY',72,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(73,NULL,'DUMMY',73,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(74,NULL,'DUMMY',74,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(75,NULL,'DUMMY',75,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(76,NULL,'DUMMY',76,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(77,NULL,'DUMMY',77,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(78,NULL,'DUMMY',78,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(79,NULL,'DUMMY',79,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(80,NULL,'DUMMY',80,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(81,NULL,'DUMMY',81,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(82,NULL,'DUMMY',82,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(83,NULL,'DUMMY',83,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(84,NULL,'DUMMY',84,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(85,NULL,'DUMMY',85,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(86,NULL,'DUMMY',86,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(87,NULL,'DUMMY',87,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(88,NULL,'DUMMY',88,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(89,NULL,'DUMMY',89,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(90,NULL,'DUMMY',90,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(91,NULL,'DUMMY',91,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(92,NULL,'DUMMY',92,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(93,NULL,'DUMMY',93,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(94,NULL,'DUMMY',94,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(95,NULL,'DUMMY',95,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(96,NULL,'DUMMY',96,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(97,NULL,'DUMMY',97,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(98,NULL,'DUMMY',98,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(99,NULL,'DUMMY',99,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(100,NULL,'DUMMY',100,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(101,NULL,'DUMMY',101,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(102,NULL,'DUMMY',102,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(103,NULL,'DUMMY',103,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(104,NULL,'DUMMY',104,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(105,NULL,'DUMMY',105,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(106,NULL,'DUMMY',106,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(107,NULL,'DUMMY',107,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(108,NULL,'DUMMY',108,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(109,NULL,'DUMMY',109,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(110,NULL,'DUMMY',110,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(111,NULL,'DUMMY',111,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(112,NULL,'DUMMY',112,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(113,NULL,'DUMMY',113,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(114,NULL,'DUMMY',114,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(115,NULL,'DUMMY',115,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(116,NULL,'DUMMY',116,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(117,NULL,'DUMMY',117,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(118,NULL,'DUMMY',118,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(119,NULL,'DUMMY',119,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(120,NULL,'DUMMY',120,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(121,NULL,'DUMMY',121,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(122,NULL,'DUMMY',122,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(123,NULL,'DUMMY',123,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(124,NULL,'DUMMY',124,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(125,NULL,'DUMMY',125,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(126,NULL,'DUMMY',126,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(127,NULL,'DUMMY',127,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(128,NULL,'DUMMY',128,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(129,NULL,'DUMMY',129,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(130,NULL,'DUMMY',130,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(131,NULL,'DUMMY',131,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(132,NULL,'DUMMY',132,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(133,NULL,'DUMMY',133,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(134,NULL,'DUMMY',134,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(135,NULL,'DUMMY',135,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(136,NULL,'DUMMY',136,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(137,NULL,'DUMMY',137,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(138,NULL,'DUMMY',138,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(139,NULL,'DUMMY',139,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(140,NULL,'DUMMY',140,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(141,NULL,'DUMMY',141,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(142,NULL,'DUMMY',142,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(143,NULL,'DUMMY',143,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(144,NULL,'DUMMY',144,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(145,NULL,'DUMMY',145,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(146,NULL,'DUMMY',146,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(147,NULL,'DUMMY',147,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(148,NULL,'DUMMY',148,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(149,NULL,'DUMMY',149,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(150,NULL,'DUMMY',150,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(151,NULL,'DUMMY',151,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(152,NULL,'DUMMY',152,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(153,NULL,'DUMMY',153,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(154,NULL,'DUMMY',154,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(155,NULL,'DUMMY',155,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(156,NULL,'DUMMY',156,1,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(157,NULL,'DUMMY',157,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(158,NULL,'DUMMY',158,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(159,NULL,'DUMMY',159,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(160,NULL,'DUMMY',160,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(161,NULL,'DUMMY',161,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(162,NULL,'DUMMY',162,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(163,NULL,'DUMMY',163,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(164,NULL,'DUMMY',164,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(165,NULL,'DUMMY',165,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(166,NULL,'DUMMY',166,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(167,NULL,'DUMMY',167,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(168,NULL,'DUMMY',168,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(169,NULL,'DUMMY',169,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(170,NULL,'DUMMY',170,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(171,NULL,'DUMMY',171,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(172,NULL,'DUMMY',172,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(173,NULL,'DUMMY',173,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(174,NULL,'DUMMY',174,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(175,NULL,'DUMMY',175,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(176,NULL,'DUMMY',176,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(177,NULL,'DUMMY',177,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(178,NULL,'DUMMY',178,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(179,NULL,'DUMMY',179,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(180,NULL,'DUMMY',180,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(181,NULL,'DUMMY',181,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(182,NULL,'DUMMY',182,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(183,NULL,'DUMMY',183,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(184,NULL,'DUMMY',184,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(185,NULL,'DUMMY',185,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(186,NULL,'DUMMY',186,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(187,NULL,'DUMMY',187,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(188,NULL,'DUMMY',188,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(189,NULL,'DUMMY',189,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(190,NULL,'DUMMY',190,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(191,NULL,'DUMMY',191,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(192,NULL,'DUMMY',192,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(193,NULL,'DUMMY',193,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(194,NULL,'DUMMY',194,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(195,NULL,'DUMMY',195,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(196,NULL,'DUMMY',196,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(197,NULL,'DUMMY',197,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(198,NULL,'DUMMY',198,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(199,NULL,'DUMMY',199,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(200,NULL,'DUMMY',200,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(201,NULL,'DUMMY',201,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(202,NULL,'DUMMY',202,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(203,NULL,'DUMMY',203,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(204,NULL,'DUMMY',204,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(205,NULL,'DUMMY',205,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(206,NULL,'DUMMY',206,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(207,NULL,'DUMMY',207,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(208,NULL,'DUMMY',208,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(209,NULL,'DUMMY',209,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(210,NULL,'DUMMY',210,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(211,NULL,'DUMMY',211,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(212,NULL,'DUMMY',212,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(213,NULL,'DUMMY',213,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(214,NULL,'DUMMY',214,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(215,NULL,'DUMMY',215,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(216,NULL,'DUMMY',216,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(217,NULL,'DUMMY',217,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(218,NULL,'DUMMY',218,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(219,NULL,'DUMMY',219,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(220,NULL,'DUMMY',220,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(221,NULL,'DUMMY',221,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(222,NULL,'DUMMY',222,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(223,NULL,'DUMMY',223,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(224,NULL,'DUMMY',224,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(225,NULL,'DUMMY',225,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(226,NULL,'DUMMY',226,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(227,NULL,'DUMMY',227,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(228,NULL,'DUMMY',228,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(229,NULL,'DUMMY',229,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(230,NULL,'DUMMY',230,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(231,NULL,'DUMMY',231,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(232,NULL,'DUMMY',232,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(233,NULL,'DUMMY',233,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(234,NULL,'DUMMY',234,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(235,NULL,'DUMMY',235,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(236,NULL,'DUMMY',236,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(237,NULL,'DUMMY',237,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(238,NULL,'DUMMY',238,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(239,NULL,'DUMMY',239,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(240,NULL,'DUMMY',240,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(241,NULL,'DUMMY',241,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(242,NULL,'DUMMY',242,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(243,NULL,'DUMMY',243,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(244,NULL,'DUMMY',244,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(245,NULL,'DUMMY',245,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(246,NULL,'DUMMY',246,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(247,NULL,'DUMMY',247,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(248,NULL,'DUMMY',248,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(249,NULL,'DUMMY',249,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(250,NULL,'DUMMY',250,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(251,NULL,'DUMMY',251,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(252,NULL,'DUMMY',252,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(253,NULL,'DUMMY',253,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(254,NULL,'DUMMY',254,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(255,NULL,'DUMMY',255,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(256,NULL,'DUMMY',256,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(257,NULL,'DUMMY',257,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(258,NULL,'DUMMY',258,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(259,NULL,'DUMMY',259,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(260,NULL,'DUMMY',260,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(261,NULL,'DUMMY',261,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(262,NULL,'DUMMY',262,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(263,NULL,'DUMMY',263,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(264,NULL,'DUMMY',264,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(265,NULL,'DUMMY',265,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(266,NULL,'DUMMY',266,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(267,NULL,'DUMMY',267,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(268,NULL,'DUMMY',268,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(269,NULL,'DUMMY',269,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(270,NULL,'DUMMY',270,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(271,NULL,'DUMMY',271,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(272,NULL,'DUMMY',272,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(273,NULL,'DUMMY',273,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(274,NULL,'DUMMY',274,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(275,NULL,'DUMMY',275,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(276,NULL,'DUMMY',276,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(277,NULL,'DUMMY',277,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(278,NULL,'DUMMY',278,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(279,NULL,'DUMMY',279,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(280,NULL,'DUMMY',280,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(281,NULL,'DUMMY',281,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(282,NULL,'DUMMY',282,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(283,NULL,'DUMMY',283,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(284,NULL,'DUMMY',284,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(285,NULL,'DUMMY',285,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(286,NULL,'DUMMY',286,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(287,NULL,'DUMMY',287,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(288,NULL,'DUMMY',288,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(289,NULL,'DUMMY',289,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(290,NULL,'DUMMY',290,1,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(291,NULL,'DUMMY',291,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(292,NULL,'DUMMY',292,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(293,NULL,'DUMMY',293,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(294,NULL,'DUMMY',294,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(295,NULL,'DUMMY',295,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(296,NULL,'DUMMY',296,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(297,NULL,'DUMMY',297,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(298,NULL,'DUMMY',298,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(299,NULL,'DUMMY',299,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(300,NULL,'DUMMY',300,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(301,NULL,'DUMMY',301,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(302,NULL,'DUMMY',302,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(303,NULL,'DUMMY',303,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(304,NULL,'DUMMY',304,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(305,NULL,'DUMMY',305,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(306,NULL,'DUMMY',306,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(307,NULL,'DUMMY',307,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(308,NULL,'DUMMY',308,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(309,NULL,'DUMMY',309,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(310,NULL,'DUMMY',310,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(311,NULL,'DUMMY',311,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(312,NULL,'DUMMY',312,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(313,NULL,'DUMMY',313,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(314,NULL,'DUMMY',314,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(315,NULL,'DUMMY',315,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(316,NULL,'DUMMY',316,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(317,NULL,'DUMMY',317,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(318,NULL,'DUMMY',318,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(319,NULL,'DUMMY',319,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(320,NULL,'DUMMY',320,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(321,NULL,'DUMMY',321,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(322,NULL,'DUMMY',322,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(323,NULL,'DUMMY',323,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(324,NULL,'DUMMY',324,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(325,NULL,'DUMMY',325,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(326,NULL,'DUMMY',326,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(327,NULL,'DUMMY',327,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(328,NULL,'DUMMY',328,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(329,NULL,'DUMMY',329,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(330,NULL,'DUMMY',330,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(331,NULL,'DUMMY',331,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(332,NULL,'DUMMY',332,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(333,NULL,'DUMMY',333,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(334,NULL,'DUMMY',334,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(335,NULL,'DUMMY',335,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(336,NULL,'DUMMY',336,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(337,NULL,'DUMMY',337,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(338,NULL,'DUMMY',338,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(339,NULL,'DUMMY',339,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(340,NULL,'DUMMY',340,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(341,NULL,'DUMMY',341,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(342,NULL,'DUMMY',342,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(343,NULL,'DUMMY',343,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(344,NULL,'DUMMY',344,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(345,NULL,'DUMMY',345,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(346,NULL,'DUMMY',346,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(347,NULL,'DUMMY',347,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(348,NULL,'DUMMY',348,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(349,NULL,'DUMMY',349,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(350,NULL,'DUMMY',350,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(351,NULL,'DUMMY',351,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(352,NULL,'DUMMY',352,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(353,NULL,'DUMMY',353,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(354,NULL,'DUMMY',354,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(355,NULL,'DUMMY',355,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(356,NULL,'DUMMY',356,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(357,NULL,'DUMMY',357,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(358,NULL,'DUMMY',358,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(359,NULL,'DUMMY',359,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(360,NULL,'DUMMY',360,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(361,NULL,'DUMMY',361,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(362,NULL,'DUMMY',362,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(363,NULL,'DUMMY',363,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(364,NULL,'DUMMY',364,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(365,NULL,'DUMMY',365,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(366,NULL,'DUMMY',366,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(367,NULL,'DUMMY',367,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(368,NULL,'DUMMY',368,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(369,NULL,'DUMMY',369,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(370,NULL,'DUMMY',370,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(371,NULL,'DUMMY',371,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(372,NULL,'DUMMY',372,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(373,NULL,'DUMMY',373,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(374,NULL,'DUMMY',374,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(375,NULL,'DUMMY',375,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(376,NULL,'DUMMY',376,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(377,NULL,'DUMMY',377,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(378,NULL,'DUMMY',378,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(379,NULL,'DUMMY',379,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(380,NULL,'DUMMY',380,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(381,NULL,'DUMMY',381,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(382,NULL,'DUMMY',382,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(383,NULL,'DUMMY',383,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(384,NULL,'DUMMY',384,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(385,NULL,'DUMMY',385,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(386,NULL,'DUMMY',386,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(387,NULL,'DUMMY',387,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(388,NULL,'DUMMY',388,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(389,NULL,'DUMMY',389,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(390,NULL,'DUMMY',390,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(391,NULL,'DUMMY',391,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(392,NULL,'DUMMY',392,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(393,NULL,'DUMMY',393,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(394,NULL,'DUMMY',394,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(395,NULL,'DUMMY',395,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(396,NULL,'DUMMY',396,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(397,NULL,'DUMMY',397,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(398,NULL,'DUMMY',398,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(399,NULL,'DUMMY',399,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(400,NULL,'DUMMY',400,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(401,NULL,'DUMMY',401,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(402,NULL,'DUMMY',402,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(403,NULL,'DUMMY',403,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(404,NULL,'DUMMY',404,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(405,NULL,'DUMMY',405,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(406,NULL,'DUMMY',406,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(407,NULL,'DUMMY',407,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(408,NULL,'DUMMY',408,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(409,NULL,'DUMMY',409,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(410,NULL,'DUMMY',410,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(411,NULL,'DUMMY',411,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(412,NULL,'DUMMY',412,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(413,NULL,'DUMMY',413,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(414,NULL,'DUMMY',414,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(415,NULL,'DUMMY',415,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(416,NULL,'DUMMY',416,1,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(417,NULL,'DUMMY',417,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(418,NULL,'DUMMY',418,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(419,NULL,'DUMMY',419,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(420,NULL,'DUMMY',420,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(421,NULL,'DUMMY',421,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(422,NULL,'DUMMY',422,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(423,NULL,'DUMMY',423,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(424,NULL,'DUMMY',424,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(425,NULL,'DUMMY',425,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(426,NULL,'DUMMY',426,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(427,NULL,'DUMMY',427,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(428,NULL,'DUMMY',428,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(429,NULL,'DUMMY',429,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(430,NULL,'DUMMY',430,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(431,NULL,'DUMMY',431,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(432,NULL,'DUMMY',432,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(433,NULL,'DUMMY',433,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(434,NULL,'DUMMY',434,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(435,NULL,'DUMMY',435,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(436,NULL,'DUMMY',436,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(437,NULL,'DUMMY',437,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(438,NULL,'DUMMY',438,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(439,NULL,'DUMMY',439,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(440,NULL,'DUMMY',440,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(441,NULL,'DUMMY',441,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(442,NULL,'DUMMY',442,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(443,NULL,'DUMMY',443,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(444,NULL,'DUMMY',444,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(445,NULL,'DUMMY',445,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(446,NULL,'DUMMY',446,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(447,NULL,'DUMMY',447,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(448,NULL,'DUMMY',448,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(449,NULL,'DUMMY',449,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(450,NULL,'DUMMY',450,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(451,NULL,'DUMMY',451,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(452,NULL,'DUMMY',452,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(453,NULL,'DUMMY',453,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(454,NULL,'DUMMY',454,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(455,NULL,'DUMMY',455,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(456,NULL,'DUMMY',456,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(457,NULL,'DUMMY',457,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(458,NULL,'DUMMY',458,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(459,NULL,'DUMMY',459,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(460,NULL,'DUMMY',460,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(461,NULL,'DUMMY',461,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(462,NULL,'DUMMY',462,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(463,NULL,'DUMMY',463,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(464,NULL,'DUMMY',464,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(465,NULL,'DUMMY',465,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(466,NULL,'DUMMY',466,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(467,NULL,'DUMMY',467,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(468,NULL,'DUMMY',468,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(469,NULL,'DUMMY',469,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(470,NULL,'DUMMY',470,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(471,NULL,'DUMMY',471,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(472,NULL,'DUMMY',472,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(473,NULL,'DUMMY',473,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(474,NULL,'DUMMY',474,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(475,NULL,'DUMMY',475,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(476,NULL,'DUMMY',476,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(477,NULL,'DUMMY',477,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(478,NULL,'DUMMY',478,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(479,NULL,'DUMMY',479,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(480,NULL,'DUMMY',480,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(481,NULL,'DUMMY',481,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(482,NULL,'DUMMY',482,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(483,NULL,'DUMMY',483,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(484,NULL,'DUMMY',484,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(485,NULL,'DUMMY',485,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(486,NULL,'DUMMY',486,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(487,NULL,'DUMMY',487,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(488,NULL,'DUMMY',488,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(489,NULL,'DUMMY',489,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(490,NULL,'DUMMY',490,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(491,NULL,'DUMMY',491,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(492,NULL,'DUMMY',492,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(493,NULL,'DUMMY',493,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(494,NULL,'DUMMY',494,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(495,NULL,'DUMMY',495,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(496,NULL,'DUMMY',496,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(497,NULL,'DUMMY',497,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(498,NULL,'DUMMY',498,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(499,NULL,'DUMMY',499,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(500,NULL,'DUMMY',500,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(501,NULL,'DUMMY',501,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(502,NULL,'DUMMY',502,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(503,NULL,'DUMMY',503,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(504,NULL,'DUMMY',504,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(505,NULL,'DUMMY',505,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(506,NULL,'DUMMY',506,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(507,NULL,'DUMMY',507,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(508,NULL,'DUMMY',508,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(509,NULL,'DUMMY',509,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(510,NULL,'DUMMY',510,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(511,NULL,'DUMMY',511,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(512,NULL,'DUMMY',512,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(513,NULL,'DUMMY',513,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(514,NULL,'DUMMY',514,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(515,NULL,'DUMMY',515,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(516,NULL,'DUMMY',516,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(517,NULL,'DUMMY',517,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(518,NULL,'DUMMY',518,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(519,NULL,'DUMMY',519,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(520,NULL,'DUMMY',520,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(521,NULL,'DUMMY',521,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(522,NULL,'DUMMY',522,1,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(523,NULL,'DUMMY',523,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(524,NULL,'DUMMY',524,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(525,NULL,'DUMMY',525,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(526,NULL,'DUMMY',526,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(527,NULL,'DUMMY',527,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(528,NULL,'DUMMY',528,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(529,NULL,'DUMMY',529,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(530,NULL,'DUMMY',530,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(531,NULL,'DUMMY',531,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(532,NULL,'DUMMY',532,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(533,NULL,'DUMMY',533,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(534,NULL,'DUMMY',534,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(535,NULL,'DUMMY',535,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(536,NULL,'DUMMY',536,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(537,NULL,'DUMMY',537,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(538,NULL,'DUMMY',538,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(539,NULL,'DUMMY',539,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(540,NULL,'DUMMY',540,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(541,NULL,'DUMMY',541,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(542,NULL,'DUMMY',542,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(543,NULL,'DUMMY',543,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(544,NULL,'DUMMY',544,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(545,NULL,'DUMMY',545,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(546,NULL,'DUMMY',546,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(547,NULL,'DUMMY',547,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(548,NULL,'DUMMY',548,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(549,NULL,'DUMMY',549,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(550,NULL,'DUMMY',550,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(551,NULL,'DUMMY',551,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(552,NULL,'DUMMY',552,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(553,NULL,'DUMMY',553,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(554,NULL,'DUMMY',554,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(555,NULL,'DUMMY',555,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(556,NULL,'DUMMY',556,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(557,NULL,'DUMMY',557,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(558,NULL,'DUMMY',558,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(559,NULL,'DUMMY',559,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(560,NULL,'DUMMY',560,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(561,NULL,'DUMMY',561,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(562,NULL,'DUMMY',562,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(563,NULL,'DUMMY',563,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(564,NULL,'DUMMY',564,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(565,NULL,'DUMMY',565,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(566,NULL,'DUMMY',566,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(567,NULL,'DUMMY',567,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(568,NULL,'DUMMY',568,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(569,NULL,'DUMMY',569,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(570,NULL,'DUMMY',570,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(571,NULL,'DUMMY',571,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(572,NULL,'DUMMY',572,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(573,NULL,'DUMMY',573,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(574,NULL,'DUMMY',574,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(575,NULL,'DUMMY',575,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(576,NULL,'DUMMY',576,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(577,NULL,'DUMMY',577,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(578,NULL,'DUMMY',578,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(579,NULL,'DUMMY',579,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(580,NULL,'DUMMY',580,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(581,NULL,'DUMMY',581,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(582,NULL,'DUMMY',582,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(583,NULL,'DUMMY',583,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(584,NULL,'DUMMY',584,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(585,NULL,'DUMMY',585,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(586,NULL,'DUMMY',586,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(587,NULL,'DUMMY',587,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(588,NULL,'DUMMY',588,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(589,NULL,'DUMMY',589,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(590,NULL,'DUMMY',590,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(591,NULL,'DUMMY',591,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(592,NULL,'DUMMY',592,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(593,NULL,'DUMMY',593,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(594,NULL,'DUMMY',594,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(595,NULL,'DUMMY',595,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(596,NULL,'DUMMY',596,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(597,NULL,'DUMMY',597,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(598,NULL,'DUMMY',598,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(599,NULL,'DUMMY',599,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(600,NULL,'DUMMY',600,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(601,NULL,'DUMMY',601,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(602,NULL,'DUMMY',602,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(603,NULL,'DUMMY',603,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(604,NULL,'DUMMY',604,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(605,NULL,'DUMMY',605,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(606,NULL,'DUMMY',606,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(607,NULL,'DUMMY',607,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(608,NULL,'DUMMY',608,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(609,NULL,'DUMMY',609,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(610,NULL,'DUMMY',610,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(611,NULL,'DUMMY',611,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(612,NULL,'DUMMY',612,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(613,NULL,'DUMMY',613,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(614,NULL,'DUMMY',614,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(615,NULL,'DUMMY',615,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(616,NULL,'DUMMY',616,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(617,NULL,'DUMMY',617,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(618,NULL,'DUMMY',618,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(619,NULL,'DUMMY',619,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(620,NULL,'DUMMY',620,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(621,NULL,'DUMMY',621,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(622,NULL,'DUMMY',622,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(623,NULL,'DUMMY',623,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(624,NULL,'DUMMY',624,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(625,NULL,'DUMMY',625,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(626,NULL,'DUMMY',626,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(627,NULL,'DUMMY',627,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(628,NULL,'DUMMY',628,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(629,NULL,'DUMMY',629,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(630,NULL,'DUMMY',630,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(631,NULL,'DUMMY',631,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(632,NULL,'DUMMY',632,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(633,NULL,'DUMMY',633,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(634,NULL,'DUMMY',634,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(635,NULL,'DUMMY',635,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(636,NULL,'DUMMY',636,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(637,NULL,'DUMMY',637,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(638,NULL,'DUMMY',638,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(639,NULL,'DUMMY',639,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(640,NULL,'DUMMY',640,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(641,NULL,'DUMMY',641,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(642,NULL,'DUMMY',642,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(643,NULL,'DUMMY',643,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(644,NULL,'DUMMY',644,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(645,NULL,'DUMMY',645,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(646,NULL,'DUMMY',646,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(647,NULL,'DUMMY',647,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(648,NULL,'DUMMY',648,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(649,NULL,'DUMMY',649,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(650,NULL,'DUMMY',650,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(651,NULL,'DUMMY',651,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(652,NULL,'DUMMY',652,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(653,NULL,'DUMMY',653,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(654,NULL,'DUMMY',654,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(655,NULL,'DUMMY',655,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(656,NULL,'DUMMY',656,1,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(657,NULL,'DUMMY',657,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(658,NULL,'DUMMY',658,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(659,NULL,'DUMMY',659,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(660,NULL,'DUMMY',660,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(661,NULL,'DUMMY',661,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(662,NULL,'DUMMY',662,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(663,NULL,'DUMMY',663,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(664,NULL,'DUMMY',664,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(665,NULL,'DUMMY',665,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(666,NULL,'DUMMY',666,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(667,NULL,'DUMMY',667,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(668,NULL,'DUMMY',668,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(669,NULL,'DUMMY',669,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(670,NULL,'DUMMY',670,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(671,NULL,'DUMMY',671,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(672,NULL,'DUMMY',672,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(673,NULL,'DUMMY',673,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(674,NULL,'DUMMY',674,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(675,NULL,'DUMMY',675,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(676,NULL,'DUMMY',676,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(677,NULL,'DUMMY',677,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(678,NULL,'DUMMY',678,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(679,NULL,'DUMMY',679,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(680,NULL,'DUMMY',680,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(681,NULL,'DUMMY',681,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(682,NULL,'DUMMY',682,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(683,NULL,'DUMMY',683,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(684,NULL,'DUMMY',684,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(685,NULL,'DUMMY',685,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(686,NULL,'DUMMY',686,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(687,NULL,'DUMMY',687,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(688,NULL,'DUMMY',688,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(689,NULL,'DUMMY',689,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(690,NULL,'DUMMY',690,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(691,NULL,'DUMMY',691,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(692,NULL,'DUMMY',692,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(693,NULL,'DUMMY',693,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(694,NULL,'DUMMY',694,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(695,NULL,'DUMMY',695,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(696,NULL,'DUMMY',696,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(697,NULL,'DUMMY',697,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(698,NULL,'DUMMY',698,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(699,NULL,'DUMMY',699,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(700,NULL,'DUMMY',700,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(701,NULL,'DUMMY',701,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(702,NULL,'DUMMY',702,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(703,NULL,'DUMMY',703,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(704,NULL,'DUMMY',704,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(705,NULL,'DUMMY',705,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(706,NULL,'DUMMY',706,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(707,NULL,'DUMMY',707,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(708,NULL,'DUMMY',708,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(709,NULL,'DUMMY',709,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(710,NULL,'DUMMY',710,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(711,NULL,'DUMMY',711,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(712,NULL,'DUMMY',712,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(713,NULL,'DUMMY',713,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(714,NULL,'DUMMY',714,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(715,NULL,'DUMMY',715,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(716,NULL,'DUMMY',716,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(717,NULL,'DUMMY',717,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(718,NULL,'DUMMY',718,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(719,NULL,'DUMMY',719,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(720,NULL,'DUMMY',720,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(721,NULL,'DUMMY',721,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(722,NULL,'DUMMY',722,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(723,NULL,'DUMMY',723,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(724,NULL,'DUMMY',724,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(725,NULL,'DUMMY',725,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(726,NULL,'DUMMY',726,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(727,NULL,'DUMMY',727,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(728,NULL,'DUMMY',728,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(729,NULL,'DUMMY',729,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(730,NULL,'DUMMY',730,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(731,NULL,'DUMMY',731,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(732,NULL,'DUMMY',732,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(733,NULL,'DUMMY',733,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(734,NULL,'DUMMY',734,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(735,NULL,'DUMMY',735,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(736,NULL,'DUMMY',736,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(737,NULL,'DUMMY',737,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(738,NULL,'DUMMY',738,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(739,NULL,'DUMMY',739,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(740,NULL,'DUMMY',740,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(741,NULL,'DUMMY',741,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(742,NULL,'DUMMY',742,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(743,NULL,'DUMMY',743,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(744,NULL,'DUMMY',744,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(745,NULL,'DUMMY',745,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(746,NULL,'DUMMY',746,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(747,NULL,'DUMMY',747,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(748,NULL,'DUMMY',748,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(749,NULL,'DUMMY',749,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(750,NULL,'DUMMY',750,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(751,NULL,'DUMMY',751,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(752,NULL,'DUMMY',752,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(753,NULL,'DUMMY',753,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(754,NULL,'DUMMY',754,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(755,NULL,'DUMMY',755,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(756,NULL,'DUMMY',756,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(757,NULL,'DUMMY',757,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(758,NULL,'DUMMY',758,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(759,NULL,'DUMMY',759,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(760,NULL,'DUMMY',760,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(761,NULL,'DUMMY',761,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(762,NULL,'DUMMY',762,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(763,NULL,'DUMMY',763,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(764,NULL,'DUMMY',764,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(765,NULL,'DUMMY',765,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(766,NULL,'DUMMY',766,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(767,NULL,'DUMMY',767,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(768,NULL,'DUMMY',768,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(769,NULL,'DUMMY',769,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(770,NULL,'DUMMY',770,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(771,NULL,'DUMMY',771,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(772,NULL,'DUMMY',772,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(773,NULL,'DUMMY',773,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(774,NULL,'DUMMY',774,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(775,NULL,'DUMMY',775,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(776,NULL,'DUMMY',776,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(777,NULL,'DUMMY',777,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(778,NULL,'DUMMY',778,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(779,NULL,'DUMMY',779,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(780,NULL,'DUMMY',780,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(781,NULL,'DUMMY',781,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(782,NULL,'DUMMY',782,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(783,NULL,'DUMMY',783,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(784,NULL,'DUMMY',784,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(785,NULL,'DUMMY',785,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(786,NULL,'DUMMY',786,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(787,NULL,'DUMMY',787,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(788,NULL,'DUMMY',788,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(789,NULL,'DUMMY',789,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(790,NULL,'DUMMY',790,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(791,NULL,'DUMMY',791,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(792,NULL,'DUMMY',792,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(793,NULL,'DUMMY',793,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(794,NULL,'DUMMY',794,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(795,NULL,'DUMMY',795,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(796,NULL,'DUMMY',796,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(797,NULL,'DUMMY',797,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(798,NULL,'DUMMY',798,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(799,NULL,'DUMMY',799,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(800,NULL,'DUMMY',800,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(801,NULL,'DUMMY',801,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(802,NULL,'DUMMY',802,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(803,NULL,'DUMMY',803,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(804,NULL,'DUMMY',804,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(805,NULL,'DUMMY',805,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(806,NULL,'DUMMY',806,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(807,NULL,'DUMMY',807,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(808,NULL,'DUMMY',808,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(809,NULL,'DUMMY',809,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(810,NULL,'DUMMY',810,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(811,NULL,'DUMMY',811,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(812,NULL,'DUMMY',812,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(813,NULL,'DUMMY',813,1,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(814,NULL,'DUMMY',814,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(815,NULL,'DUMMY',815,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(816,NULL,'DUMMY',816,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(817,NULL,'DUMMY',817,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(818,NULL,'DUMMY',818,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(819,NULL,'DUMMY',819,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(820,NULL,'DUMMY',820,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(821,NULL,'DUMMY',821,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(822,NULL,'DUMMY',822,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(823,NULL,'DUMMY',823,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(824,NULL,'DUMMY',824,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(825,NULL,'DUMMY',825,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(826,NULL,'DUMMY',826,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(827,NULL,'DUMMY',827,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(828,NULL,'DUMMY',828,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(829,NULL,'DUMMY',829,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(830,NULL,'DUMMY',830,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(831,NULL,'DUMMY',831,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(832,NULL,'DUMMY',832,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(833,NULL,'DUMMY',833,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(834,NULL,'DUMMY',834,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(835,NULL,'DUMMY',835,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(836,NULL,'DUMMY',836,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(837,NULL,'DUMMY',837,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(838,NULL,'DUMMY',838,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(839,NULL,'DUMMY',839,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(840,NULL,'DUMMY',840,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(841,NULL,'DUMMY',841,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(842,NULL,'DUMMY',842,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(843,NULL,'DUMMY',843,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(844,NULL,'DUMMY',844,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(845,NULL,'DUMMY',845,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(846,NULL,'DUMMY',846,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(847,NULL,'DUMMY',847,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(848,NULL,'DUMMY',848,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(849,NULL,'DUMMY',849,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(850,NULL,'DUMMY',850,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(851,NULL,'DUMMY',851,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(852,NULL,'DUMMY',852,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(853,NULL,'DUMMY',853,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(854,NULL,'DUMMY',854,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(855,NULL,'DUMMY',855,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(856,NULL,'DUMMY',856,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(857,NULL,'DUMMY',857,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(858,NULL,'DUMMY',858,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(859,NULL,'DUMMY',859,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(860,NULL,'DUMMY',860,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(861,NULL,'DUMMY',861,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(862,NULL,'DUMMY',862,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(863,NULL,'DUMMY',863,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(864,NULL,'DUMMY',864,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(865,NULL,'DUMMY',865,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(866,NULL,'DUMMY',866,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(867,NULL,'DUMMY',867,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(868,NULL,'DUMMY',868,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(869,NULL,'DUMMY',869,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(870,NULL,'DUMMY',870,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(871,NULL,'DUMMY',871,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(872,NULL,'DUMMY',872,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(873,NULL,'DUMMY',873,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(874,NULL,'DUMMY',874,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(875,NULL,'DUMMY',875,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(876,NULL,'DUMMY',876,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(877,NULL,'DUMMY',877,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(878,NULL,'DUMMY',878,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(879,NULL,'DUMMY',879,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(880,NULL,'DUMMY',880,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(881,NULL,'DUMMY',881,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(882,NULL,'DUMMY',882,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(883,NULL,'DUMMY',883,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(884,NULL,'DUMMY',884,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(885,NULL,'DUMMY',885,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(886,NULL,'DUMMY',886,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(887,NULL,'DUMMY',887,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(888,NULL,'DUMMY',888,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(889,NULL,'DUMMY',889,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(890,NULL,'DUMMY',890,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(891,NULL,'DUMMY',891,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(892,NULL,'DUMMY',892,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(893,NULL,'DUMMY',893,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(894,NULL,'DUMMY',894,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(895,NULL,'DUMMY',895,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(896,NULL,'DUMMY',896,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(897,NULL,'DUMMY',897,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(898,NULL,'DUMMY',898,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(899,NULL,'DUMMY',899,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(900,NULL,'DUMMY',900,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(901,NULL,'DUMMY',901,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(902,NULL,'DUMMY',902,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(903,NULL,'DUMMY',903,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(904,NULL,'DUMMY',904,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(905,NULL,'DUMMY',905,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(906,NULL,'DUMMY',906,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(907,NULL,'DUMMY',907,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(908,NULL,'DUMMY',908,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(909,NULL,'DUMMY',909,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(910,NULL,'DUMMY',910,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(911,NULL,'DUMMY',911,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(912,NULL,'DUMMY',912,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(913,NULL,'DUMMY',913,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(914,NULL,'DUMMY',914,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(915,NULL,'DUMMY',915,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(916,NULL,'DUMMY',916,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(917,NULL,'DUMMY',917,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(918,NULL,'DUMMY',918,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(919,NULL,'DUMMY',919,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(920,NULL,'DUMMY',920,1,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(921,NULL,'DUMMY',921,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(922,NULL,'DUMMY',922,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(923,NULL,'DUMMY',923,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(924,NULL,'DUMMY',924,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(925,NULL,'DUMMY',925,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(926,NULL,'DUMMY',926,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(927,NULL,'DUMMY',927,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(928,NULL,'DUMMY',928,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(929,NULL,'DUMMY',929,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(930,NULL,'DUMMY',930,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(931,NULL,'DUMMY',931,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(932,NULL,'DUMMY',932,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(933,NULL,'DUMMY',933,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(934,NULL,'DUMMY',934,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(935,NULL,'DUMMY',935,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(936,NULL,'DUMMY',936,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(937,NULL,'DUMMY',937,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(938,NULL,'DUMMY',938,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(939,NULL,'DUMMY',939,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(940,NULL,'DUMMY',940,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(941,NULL,'DUMMY',941,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(942,NULL,'DUMMY',942,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(943,NULL,'DUMMY',943,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(944,NULL,'DUMMY',944,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(945,NULL,'DUMMY',945,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(946,NULL,'DUMMY',946,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(947,NULL,'DUMMY',947,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(948,NULL,'DUMMY',948,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(949,NULL,'DUMMY',949,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(950,NULL,'DUMMY',950,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(951,NULL,'DUMMY',951,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(952,NULL,'DUMMY',952,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(953,NULL,'DUMMY',953,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(954,NULL,'DUMMY',954,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(955,NULL,'DUMMY',955,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(956,NULL,'DUMMY',956,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(957,NULL,'DUMMY',957,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(958,NULL,'DUMMY',958,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(959,NULL,'DUMMY',959,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(960,NULL,'DUMMY',960,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(961,NULL,'DUMMY',961,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(962,NULL,'DUMMY',962,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(963,NULL,'DUMMY',963,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(964,NULL,'DUMMY',964,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(965,NULL,'DUMMY',965,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(966,NULL,'DUMMY',966,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(967,NULL,'DUMMY',967,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(968,NULL,'DUMMY',968,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(969,NULL,'DUMMY',969,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(970,NULL,'DUMMY',970,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(971,NULL,'DUMMY',971,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(972,NULL,'DUMMY',972,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(973,NULL,'DUMMY',973,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(974,NULL,'DUMMY',974,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(975,NULL,'DUMMY',975,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(976,NULL,'DUMMY',976,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(977,NULL,'DUMMY',977,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(978,NULL,'DUMMY',978,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(979,NULL,'DUMMY',979,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(980,NULL,'DUMMY',980,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(981,NULL,'DUMMY',981,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(982,NULL,'DUMMY',982,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(983,NULL,'DUMMY',983,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(984,NULL,'DUMMY',984,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(985,NULL,'DUMMY',985,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(986,NULL,'DUMMY',986,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(987,NULL,'DUMMY',987,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(988,NULL,'DUMMY',988,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(989,NULL,'DUMMY',989,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(990,NULL,'DUMMY',990,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(991,NULL,'DUMMY',991,1,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(992,NULL,'DUMMY',992,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(993,NULL,'DUMMY',993,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(994,NULL,'DUMMY',994,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(995,NULL,'DUMMY',995,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(996,NULL,'DUMMY',996,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(997,NULL,'DUMMY',997,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(998,NULL,'DUMMY',998,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(999,NULL,'DUMMY',999,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1000,NULL,'DUMMY',1000,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1001,NULL,'DUMMY',1001,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1002,NULL,'DUMMY',1002,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1003,NULL,'DUMMY',1003,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1004,NULL,'DUMMY',1004,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1005,NULL,'DUMMY',1005,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1006,NULL,'DUMMY',1006,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1007,NULL,'DUMMY',1007,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1008,NULL,'DUMMY',1008,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1009,NULL,'DUMMY',1009,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1010,NULL,'DUMMY',1010,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1011,NULL,'DUMMY',1011,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1012,NULL,'DUMMY',1012,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1013,NULL,'DUMMY',1013,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1014,NULL,'DUMMY',1014,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1015,NULL,'DUMMY',1015,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1016,NULL,'DUMMY',1016,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1017,NULL,'DUMMY',1017,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1018,NULL,'DUMMY',1018,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1019,NULL,'DUMMY',1019,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1020,NULL,'DUMMY',1020,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1021,NULL,'DUMMY',1021,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1022,NULL,'DUMMY',1022,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1023,NULL,'DUMMY',1023,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1024,NULL,'DUMMY',1024,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1025,NULL,'DUMMY',1025,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1026,NULL,'DUMMY',1026,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1027,NULL,'DUMMY',1027,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1028,NULL,'DUMMY',1028,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1029,NULL,'DUMMY',1029,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1030,NULL,'DUMMY',1030,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1031,NULL,'DUMMY',1031,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1032,NULL,'DUMMY',1032,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1033,NULL,'DUMMY',1033,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1034,NULL,'DUMMY',1034,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1035,NULL,'DUMMY',1035,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1036,NULL,'DUMMY',1036,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1037,NULL,'DUMMY',1037,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1038,NULL,'DUMMY',1038,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1039,NULL,'DUMMY',1039,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1040,NULL,'DUMMY',1040,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1041,NULL,'DUMMY',1041,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1042,NULL,'DUMMY',1042,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1043,NULL,'DUMMY',1043,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1044,NULL,'DUMMY',1044,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1045,NULL,'DUMMY',1045,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1046,NULL,'DUMMY',1046,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1047,NULL,'DUMMY',1047,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1048,NULL,'DUMMY',1048,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1049,NULL,'DUMMY',1049,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1050,NULL,'DUMMY',1050,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1051,NULL,'DUMMY',1051,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1052,NULL,'DUMMY',1052,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1053,NULL,'DUMMY',1053,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1054,NULL,'DUMMY',1054,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1055,NULL,'DUMMY',1055,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1056,NULL,'DUMMY',1056,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1057,NULL,'DUMMY',1057,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1058,NULL,'DUMMY',1058,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1059,NULL,'DUMMY',1059,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1060,NULL,'DUMMY',1060,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1061,NULL,'DUMMY',1061,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1062,NULL,'DUMMY',1062,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1063,NULL,'DUMMY',1063,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1064,NULL,'DUMMY',1064,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1065,NULL,'DUMMY',1065,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1066,NULL,'DUMMY',1066,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1067,NULL,'DUMMY',1067,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1068,NULL,'DUMMY',1068,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1069,NULL,'DUMMY',1069,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1070,NULL,'DUMMY',1070,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1071,NULL,'DUMMY',1071,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1072,NULL,'DUMMY',1072,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1073,NULL,'DUMMY',1073,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1074,NULL,'DUMMY',1074,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1075,NULL,'DUMMY',1075,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1076,NULL,'DUMMY',1076,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1077,NULL,'DUMMY',1077,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1078,NULL,'DUMMY',1078,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1079,NULL,'DUMMY',1079,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1080,NULL,'DUMMY',1080,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1081,NULL,'DUMMY',1081,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1082,NULL,'DUMMY',1082,1,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1083,NULL,'DUMMY',1083,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1084,NULL,'DUMMY',1084,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1085,NULL,'DUMMY',1085,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1086,NULL,'DUMMY',1086,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1087,NULL,'DUMMY',1087,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1088,NULL,'DUMMY',1088,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1089,NULL,'DUMMY',1089,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1090,NULL,'DUMMY',1090,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1091,NULL,'DUMMY',1091,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1092,NULL,'DUMMY',1092,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1093,NULL,'DUMMY',1093,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1094,NULL,'DUMMY',1094,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1095,NULL,'DUMMY',1095,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1096,NULL,'DUMMY',1096,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1097,NULL,'DUMMY',1097,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1098,NULL,'DUMMY',1098,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1099,NULL,'DUMMY',1099,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1100,NULL,'DUMMY',1100,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1101,NULL,'DUMMY',1101,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1102,NULL,'DUMMY',1102,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1103,NULL,'DUMMY',1103,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1104,NULL,'DUMMY',1104,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1105,NULL,'DUMMY',1105,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1106,NULL,'DUMMY',1106,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1107,NULL,'DUMMY',1107,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1108,NULL,'DUMMY',1108,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1109,NULL,'DUMMY',1109,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1110,NULL,'DUMMY',1110,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1111,NULL,'DUMMY',1111,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1112,NULL,'DUMMY',1112,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1113,NULL,'DUMMY',1113,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1114,NULL,'DUMMY',1114,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1115,NULL,'DUMMY',1115,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1116,NULL,'DUMMY',1116,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1117,NULL,'DUMMY',1117,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1118,NULL,'DUMMY',1118,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1119,NULL,'DUMMY',1119,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1120,NULL,'DUMMY',1120,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1121,NULL,'DUMMY',1121,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1122,NULL,'DUMMY',1122,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1123,NULL,'DUMMY',1123,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1124,NULL,'DUMMY',1124,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1125,NULL,'DUMMY',1125,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1126,NULL,'DUMMY',1126,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1127,NULL,'DUMMY',1127,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1128,NULL,'DUMMY',1128,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1129,NULL,'DUMMY',1129,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1130,NULL,'DUMMY',1130,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1131,NULL,'DUMMY',1131,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1132,NULL,'DUMMY',1132,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1133,NULL,'DUMMY',1133,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1134,NULL,'DUMMY',1134,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1135,NULL,'DUMMY',1135,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1136,NULL,'DUMMY',1136,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1137,NULL,'DUMMY',1137,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1138,NULL,'DUMMY',1138,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1139,NULL,'DUMMY',1139,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1140,NULL,'DUMMY',1140,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1141,NULL,'DUMMY',1141,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1142,NULL,'DUMMY',1142,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1143,NULL,'DUMMY',1143,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1144,NULL,'DUMMY',1144,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1145,NULL,'DUMMY',1145,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1146,NULL,'DUMMY',1146,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1147,NULL,'DUMMY',1147,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1148,NULL,'DUMMY',1148,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1149,NULL,'DUMMY',1149,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1150,NULL,'DUMMY',1150,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1151,NULL,'DUMMY',1151,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1152,NULL,'DUMMY',1152,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1153,NULL,'DUMMY',1153,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1154,NULL,'DUMMY',1154,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1155,NULL,'DUMMY',1155,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1156,NULL,'DUMMY',1156,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1157,NULL,'DUMMY',1157,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1158,NULL,'DUMMY',1158,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1159,NULL,'DUMMY',1159,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1160,NULL,'DUMMY',1160,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1161,NULL,'DUMMY',1161,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1162,NULL,'DUMMY',1162,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1163,NULL,'DUMMY',1163,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1164,NULL,'DUMMY',1164,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1165,NULL,'DUMMY',1165,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1166,NULL,'DUMMY',1166,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1167,NULL,'DUMMY',1167,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1168,NULL,'DUMMY',1168,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1169,NULL,'DUMMY',1169,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1170,NULL,'DUMMY',1170,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1171,NULL,'DUMMY',1171,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1172,NULL,'DUMMY',1172,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1173,NULL,'DUMMY',1173,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1174,NULL,'DUMMY',1174,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1175,NULL,'DUMMY',1175,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1176,NULL,'DUMMY',1176,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1177,NULL,'DUMMY',1177,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1178,NULL,'DUMMY',1178,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1179,NULL,'DUMMY',1179,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1180,NULL,'DUMMY',1180,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1181,NULL,'DUMMY',1181,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1182,NULL,'DUMMY',1182,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1183,NULL,'DUMMY',1183,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1184,NULL,'DUMMY',1184,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1185,NULL,'DUMMY',1185,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1186,NULL,'DUMMY',1186,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1187,NULL,'DUMMY',1187,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1188,NULL,'DUMMY',1188,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1189,NULL,'DUMMY',1189,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1190,NULL,'DUMMY',1190,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1191,NULL,'DUMMY',1191,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1192,NULL,'DUMMY',1192,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1193,NULL,'DUMMY',1193,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1194,NULL,'DUMMY',1194,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1195,NULL,'DUMMY',1195,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1196,NULL,'DUMMY',1196,1,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1197,NULL,'DUMMY',1197,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1198,NULL,'DUMMY',1198,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1199,NULL,'DUMMY',1199,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1200,NULL,'DUMMY',1200,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1201,NULL,'DUMMY',1201,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1202,NULL,'DUMMY',1202,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1203,NULL,'DUMMY',1203,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1204,NULL,'DUMMY',1204,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1205,NULL,'DUMMY',1205,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1206,NULL,'DUMMY',1206,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1207,NULL,'DUMMY',1207,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1208,NULL,'DUMMY',1208,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1209,NULL,'DUMMY',1209,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1210,NULL,'DUMMY',1210,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1211,NULL,'DUMMY',1211,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1212,NULL,'DUMMY',1212,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1213,NULL,'DUMMY',1213,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1214,NULL,'DUMMY',1214,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1215,NULL,'DUMMY',1215,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1216,NULL,'DUMMY',1216,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1217,NULL,'DUMMY',1217,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1218,NULL,'DUMMY',1218,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1219,NULL,'DUMMY',1219,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1220,NULL,'DUMMY',1220,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1221,NULL,'DUMMY',1221,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1222,NULL,'DUMMY',1222,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1223,NULL,'DUMMY',1223,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1224,NULL,'DUMMY',1224,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1225,NULL,'DUMMY',1225,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1226,NULL,'DUMMY',1226,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1227,NULL,'DUMMY',1227,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1228,NULL,'DUMMY',1228,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1229,NULL,'DUMMY',1229,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1230,NULL,'DUMMY',1230,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1231,NULL,'DUMMY',1231,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1232,NULL,'DUMMY',1232,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1233,NULL,'DUMMY',1233,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1234,NULL,'DUMMY',1234,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1235,NULL,'DUMMY',1235,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1236,NULL,'DUMMY',1236,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1237,NULL,'DUMMY',1237,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1238,NULL,'DUMMY',1238,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1239,NULL,'DUMMY',1239,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1240,NULL,'DUMMY',1240,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1241,NULL,'DUMMY',1241,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1242,NULL,'DUMMY',1242,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1243,NULL,'DUMMY',1243,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1244,NULL,'DUMMY',1244,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1245,NULL,'DUMMY',1245,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1246,NULL,'DUMMY',1246,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1247,NULL,'DUMMY',1247,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1248,NULL,'DUMMY',1248,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1249,NULL,'DUMMY',1249,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1250,NULL,'DUMMY',1250,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1251,NULL,'DUMMY',1251,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1252,NULL,'DUMMY',1252,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1253,NULL,'DUMMY',1253,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1254,NULL,'DUMMY',1254,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1255,NULL,'DUMMY',1255,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1256,NULL,'DUMMY',1256,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1257,NULL,'DUMMY',1257,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1258,NULL,'DUMMY',1258,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1259,NULL,'DUMMY',1259,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1260,NULL,'DUMMY',1260,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1261,NULL,'DUMMY',1261,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1262,NULL,'DUMMY',1262,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1263,NULL,'DUMMY',1263,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1264,NULL,'DUMMY',1264,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1265,NULL,'DUMMY',1265,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1266,NULL,'DUMMY',1266,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1267,NULL,'DUMMY',1267,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1268,NULL,'DUMMY',1268,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1269,NULL,'DUMMY',1269,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1270,NULL,'DUMMY',1270,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1271,NULL,'DUMMY',1271,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1272,NULL,'DUMMY',1272,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1273,NULL,'DUMMY',1273,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1274,NULL,'DUMMY',1274,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1275,NULL,'DUMMY',1275,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1276,NULL,'DUMMY',1276,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1277,NULL,'DUMMY',1277,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1278,NULL,'DUMMY',1278,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1279,NULL,'DUMMY',1279,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1280,NULL,'DUMMY',1280,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1281,NULL,'DUMMY',1281,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1282,NULL,'DUMMY',1282,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1283,NULL,'DUMMY',1283,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1284,NULL,'DUMMY',1284,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1285,NULL,'DUMMY',1285,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1286,NULL,'DUMMY',1286,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1287,NULL,'DUMMY',1287,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1288,NULL,'DUMMY',1288,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1289,NULL,'DUMMY',1289,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1290,NULL,'DUMMY',1290,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1291,NULL,'DUMMY',1291,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1292,NULL,'DUMMY',1292,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1293,NULL,'DUMMY',1293,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1294,NULL,'DUMMY',1294,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1295,NULL,'DUMMY',1295,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1296,NULL,'DUMMY',1296,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1297,NULL,'DUMMY',1297,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1298,NULL,'DUMMY',1298,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1299,NULL,'DUMMY',1299,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1300,NULL,'DUMMY',1300,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1301,NULL,'DUMMY',1301,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1302,NULL,'DUMMY',1302,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1303,NULL,'DUMMY',1303,1,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1304,NULL,'DUMMY',1304,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1305,NULL,'DUMMY',1305,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1306,NULL,'DUMMY',1306,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1307,NULL,'DUMMY',1307,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1308,NULL,'DUMMY',1308,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1309,NULL,'DUMMY',1309,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1310,NULL,'DUMMY',1310,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1311,NULL,'DUMMY',1311,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1312,NULL,'DUMMY',1312,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1313,NULL,'DUMMY',1313,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1314,NULL,'DUMMY',1314,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1315,NULL,'DUMMY',1315,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1316,NULL,'DUMMY',1316,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1317,NULL,'DUMMY',1317,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1318,NULL,'DUMMY',1318,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1319,NULL,'DUMMY',1319,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1320,NULL,'DUMMY',1320,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1321,NULL,'DUMMY',1321,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1322,NULL,'DUMMY',1322,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1323,NULL,'DUMMY',1323,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1324,NULL,'DUMMY',1324,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1325,NULL,'DUMMY',1325,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1326,NULL,'DUMMY',1326,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1327,NULL,'DUMMY',1327,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1328,NULL,'DUMMY',1328,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1329,NULL,'DUMMY',1329,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1330,NULL,'DUMMY',1330,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1331,NULL,'DUMMY',1331,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1332,NULL,'DUMMY',1332,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1333,NULL,'DUMMY',1333,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1334,NULL,'DUMMY',1334,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1335,NULL,'DUMMY',1335,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1336,NULL,'DUMMY',1336,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1337,NULL,'DUMMY',1337,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1338,NULL,'DUMMY',1338,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1339,NULL,'DUMMY',1339,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1340,NULL,'DUMMY',1340,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1341,NULL,'DUMMY',1341,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1342,NULL,'DUMMY',1342,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1343,NULL,'DUMMY',1343,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1344,NULL,'DUMMY',1344,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1345,NULL,'DUMMY',1345,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1346,NULL,'DUMMY',1346,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1347,NULL,'DUMMY',1347,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1348,NULL,'DUMMY',1348,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1349,NULL,'DUMMY',1349,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1350,NULL,'DUMMY',1350,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1351,NULL,'DUMMY',1351,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1352,NULL,'DUMMY',1352,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1353,NULL,'DUMMY',1353,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1354,NULL,'DUMMY',1354,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1355,NULL,'DUMMY',1355,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1356,NULL,'DUMMY',1356,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1357,NULL,'DUMMY',1357,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1358,NULL,'DUMMY',1358,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1359,NULL,'DUMMY',1359,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1360,NULL,'DUMMY',1360,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1361,NULL,'DUMMY',1361,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1362,NULL,'DUMMY',1362,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1363,NULL,'DUMMY',1363,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1364,NULL,'DUMMY',1364,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1365,NULL,'DUMMY',1365,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1366,NULL,'DUMMY',1366,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1367,NULL,'DUMMY',1367,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1368,NULL,'DUMMY',1368,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1369,NULL,'DUMMY',1369,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1370,NULL,'DUMMY',1370,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1371,NULL,'DUMMY',1371,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1372,NULL,'DUMMY',1372,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1373,NULL,'DUMMY',1373,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1374,NULL,'DUMMY',1374,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1375,NULL,'DUMMY',1375,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1376,NULL,'DUMMY',1376,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1377,NULL,'DUMMY',1377,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1378,NULL,'DUMMY',1378,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1379,NULL,'DUMMY',1379,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1380,NULL,'DUMMY',1380,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1381,NULL,'DUMMY',1381,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1382,NULL,'DUMMY',1382,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1383,NULL,'DUMMY',1383,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1384,NULL,'DUMMY',1384,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1385,NULL,'DUMMY',1385,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1386,NULL,'DUMMY',1386,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1387,NULL,'DUMMY',1387,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1388,NULL,'DUMMY',1388,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1389,NULL,'DUMMY',1389,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1390,NULL,'DUMMY',1390,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1391,NULL,'DUMMY',1391,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1392,NULL,'DUMMY',1392,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1393,NULL,'DUMMY',1393,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1394,NULL,'DUMMY',1394,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1395,NULL,'DUMMY',1395,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1396,NULL,'DUMMY',1396,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1397,NULL,'DUMMY',1397,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1398,NULL,'DUMMY',1398,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1399,NULL,'DUMMY',1399,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1400,NULL,'DUMMY',1400,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1401,NULL,'DUMMY',1401,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1402,NULL,'DUMMY',1402,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1403,NULL,'DUMMY',1403,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1404,NULL,'DUMMY',1404,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1405,NULL,'DUMMY',1405,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1406,NULL,'DUMMY',1406,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1407,NULL,'DUMMY',1407,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1408,NULL,'DUMMY',1408,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1409,NULL,'DUMMY',1409,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1410,NULL,'DUMMY',1410,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1411,NULL,'DUMMY',1411,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1412,NULL,'DUMMY',1412,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1413,NULL,'DUMMY',1413,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1414,NULL,'DUMMY',1414,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1415,NULL,'DUMMY',1415,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1416,NULL,'DUMMY',1416,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1417,NULL,'DUMMY',1417,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1418,NULL,'DUMMY',1418,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1419,NULL,'DUMMY',1419,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1420,NULL,'DUMMY',1420,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1421,NULL,'DUMMY',1421,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1422,NULL,'DUMMY',1422,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1423,NULL,'DUMMY',1423,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1424,NULL,'DUMMY',1424,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1425,NULL,'DUMMY',1425,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1426,NULL,'DUMMY',1426,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1427,NULL,'DUMMY',1427,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1428,NULL,'DUMMY',1428,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1429,NULL,'DUMMY',1429,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1430,NULL,'DUMMY',1430,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1431,NULL,'DUMMY',1431,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1432,NULL,'DUMMY',1432,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1433,NULL,'DUMMY',1433,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1434,NULL,'DUMMY',1434,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1435,NULL,'DUMMY',1435,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1436,NULL,'DUMMY',1436,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1437,NULL,'DUMMY',1437,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1438,NULL,'DUMMY',1438,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1439,NULL,'DUMMY',1439,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1440,NULL,'DUMMY',1440,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1441,NULL,'DUMMY',1441,1,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1442,NULL,'DUMMY',1442,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1443,NULL,'DUMMY',1443,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1444,NULL,'DUMMY',1444,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1445,NULL,'DUMMY',1445,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1446,NULL,'DUMMY',1446,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1447,NULL,'DUMMY',1447,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1448,NULL,'DUMMY',1448,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1449,NULL,'DUMMY',1449,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1450,NULL,'DUMMY',1450,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1451,NULL,'DUMMY',1451,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1452,NULL,'DUMMY',1452,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1453,NULL,'DUMMY',1453,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1454,NULL,'DUMMY',1454,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1455,NULL,'DUMMY',1455,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1456,NULL,'DUMMY',1456,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1457,NULL,'DUMMY',1457,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1458,NULL,'DUMMY',1458,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1459,NULL,'DUMMY',1459,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1460,NULL,'DUMMY',1460,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1461,NULL,'DUMMY',1461,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1462,NULL,'DUMMY',1462,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1463,NULL,'DUMMY',1463,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1464,NULL,'DUMMY',1464,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1465,NULL,'DUMMY',1465,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1466,NULL,'DUMMY',1466,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1467,NULL,'DUMMY',1467,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1468,NULL,'DUMMY',1468,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1469,NULL,'DUMMY',1469,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1470,NULL,'DUMMY',1470,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1471,NULL,'DUMMY',1471,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1472,NULL,'DUMMY',1472,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1473,NULL,'DUMMY',1473,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1474,NULL,'DUMMY',1474,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1475,NULL,'DUMMY',1475,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1476,NULL,'DUMMY',1476,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1477,NULL,'DUMMY',1477,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1478,NULL,'DUMMY',1478,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1479,NULL,'DUMMY',1479,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1480,NULL,'DUMMY',1480,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1481,NULL,'DUMMY',1481,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1482,NULL,'DUMMY',1482,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1483,NULL,'DUMMY',1483,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1484,NULL,'DUMMY',1484,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1485,NULL,'DUMMY',1485,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1486,NULL,'DUMMY',1486,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1487,NULL,'DUMMY',1487,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1488,NULL,'DUMMY',1488,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1489,NULL,'DUMMY',1489,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1490,NULL,'DUMMY',1490,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1491,NULL,'DUMMY',1491,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1492,NULL,'DUMMY',1492,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1493,NULL,'DUMMY',1493,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1494,NULL,'DUMMY',1494,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1495,NULL,'DUMMY',1495,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1496,NULL,'DUMMY',1496,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1497,NULL,'DUMMY',1497,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1498,NULL,'DUMMY',1498,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1499,NULL,'DUMMY',1499,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1500,NULL,'DUMMY',1500,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1501,NULL,'DUMMY',1501,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1502,NULL,'DUMMY',1502,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1503,NULL,'DUMMY',1503,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1504,NULL,'DUMMY',1504,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1505,NULL,'DUMMY',1505,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1506,NULL,'DUMMY',1506,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1507,NULL,'DUMMY',1507,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1508,NULL,'DUMMY',1508,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1509,NULL,'DUMMY',1509,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1510,NULL,'DUMMY',1510,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1511,NULL,'DUMMY',1511,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1512,NULL,'DUMMY',1512,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1513,NULL,'DUMMY',1513,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1514,NULL,'DUMMY',1514,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1515,NULL,'DUMMY',1515,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1516,NULL,'DUMMY',1516,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1517,NULL,'DUMMY',1517,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1518,NULL,'DUMMY',1518,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1519,NULL,'DUMMY',1519,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1520,NULL,'DUMMY',1520,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1521,NULL,'DUMMY',1521,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1522,NULL,'DUMMY',1522,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1523,NULL,'DUMMY',1523,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1524,NULL,'DUMMY',1524,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1525,NULL,'DUMMY',1525,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1526,NULL,'DUMMY',1526,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1527,NULL,'DUMMY',1527,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1528,NULL,'DUMMY',1528,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1529,NULL,'DUMMY',1529,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1530,NULL,'DUMMY',1530,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1531,NULL,'DUMMY',1531,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1532,NULL,'DUMMY',1532,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1533,NULL,'DUMMY',1533,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1534,NULL,'DUMMY',1534,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1535,NULL,'DUMMY',1535,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1536,NULL,'DUMMY',1536,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1537,NULL,'DUMMY',1537,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1538,NULL,'DUMMY',1538,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1539,NULL,'DUMMY',1539,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1540,NULL,'DUMMY',1540,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1541,NULL,'DUMMY',1541,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1542,NULL,'DUMMY',1542,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1543,NULL,'DUMMY',1543,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1544,NULL,'DUMMY',1544,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1545,NULL,'DUMMY',1545,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1546,NULL,'DUMMY',1546,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1547,NULL,'DUMMY',1547,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1548,NULL,'DUMMY',1548,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1549,NULL,'DUMMY',1549,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1550,NULL,'DUMMY',1550,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1551,NULL,'DUMMY',1551,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1552,NULL,'DUMMY',1552,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1553,NULL,'DUMMY',1553,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1554,NULL,'DUMMY',1554,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1555,NULL,'DUMMY',1555,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1556,NULL,'DUMMY',1556,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1557,NULL,'DUMMY',1557,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1558,NULL,'DUMMY',1558,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1559,NULL,'DUMMY',1559,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1560,NULL,'DUMMY',1560,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1561,NULL,'DUMMY',1561,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1562,NULL,'DUMMY',1562,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1563,NULL,'DUMMY',1563,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1564,NULL,'DUMMY',1564,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1565,NULL,'DUMMY',1565,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1566,NULL,'DUMMY',1566,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1567,NULL,'DUMMY',1567,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1568,NULL,'DUMMY',1568,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1569,NULL,'DUMMY',1569,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1570,NULL,'DUMMY',1570,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1571,NULL,'DUMMY',1571,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1572,NULL,'DUMMY',1572,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1573,NULL,'DUMMY',1573,1,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1574,NULL,'DUMMY',1574,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1575,NULL,'DUMMY',1575,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1576,NULL,'DUMMY',1576,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1577,NULL,'DUMMY',1577,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1578,NULL,'DUMMY',1578,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1579,NULL,'DUMMY',1579,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1580,NULL,'DUMMY',1580,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1581,NULL,'DUMMY',1581,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1582,NULL,'DUMMY',1582,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1583,NULL,'DUMMY',1583,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1584,NULL,'DUMMY',1584,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1585,NULL,'DUMMY',1585,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1586,NULL,'DUMMY',1586,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1587,NULL,'DUMMY',1587,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1588,NULL,'DUMMY',1588,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1589,NULL,'DUMMY',1589,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1590,NULL,'DUMMY',1590,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1591,NULL,'DUMMY',1591,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1592,NULL,'DUMMY',1592,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1593,NULL,'DUMMY',1593,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1594,NULL,'DUMMY',1594,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1595,NULL,'DUMMY',1595,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1596,NULL,'DUMMY',1596,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1597,NULL,'DUMMY',1597,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1598,NULL,'DUMMY',1598,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1599,NULL,'DUMMY',1599,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1600,NULL,'DUMMY',1600,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1601,NULL,'DUMMY',1601,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1602,NULL,'DUMMY',1602,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1603,NULL,'DUMMY',1603,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1604,NULL,'DUMMY',1604,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1605,NULL,'DUMMY',1605,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1606,NULL,'DUMMY',1606,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1607,NULL,'DUMMY',1607,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1608,NULL,'DUMMY',1608,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1609,NULL,'DUMMY',1609,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1610,NULL,'DUMMY',1610,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1611,NULL,'DUMMY',1611,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1612,NULL,'DUMMY',1612,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1613,NULL,'DUMMY',1613,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1614,NULL,'DUMMY',1614,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1615,NULL,'DUMMY',1615,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1616,NULL,'DUMMY',1616,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1617,NULL,'DUMMY',1617,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1618,NULL,'DUMMY',1618,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1619,NULL,'DUMMY',1619,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1620,NULL,'DUMMY',1620,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1621,NULL,'DUMMY',1621,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1622,NULL,'DUMMY',1622,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1623,NULL,'DUMMY',1623,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1624,NULL,'DUMMY',1624,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1625,NULL,'DUMMY',1625,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1626,NULL,'DUMMY',1626,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1627,NULL,'DUMMY',1627,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1628,NULL,'DUMMY',1628,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1629,NULL,'DUMMY',1629,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1630,NULL,'DUMMY',1630,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1631,NULL,'DUMMY',1631,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1632,NULL,'DUMMY',1632,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1633,NULL,'DUMMY',1633,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1634,NULL,'DUMMY',1634,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1635,NULL,'DUMMY',1635,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1636,NULL,'DUMMY',1636,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1637,NULL,'DUMMY',1637,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1638,NULL,'DUMMY',1638,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1639,NULL,'DUMMY',1639,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1640,NULL,'DUMMY',1640,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1641,NULL,'DUMMY',1641,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1642,NULL,'DUMMY',1642,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1643,NULL,'DUMMY',1643,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1644,NULL,'DUMMY',1644,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1645,NULL,'DUMMY',1645,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1646,NULL,'DUMMY',1646,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1647,NULL,'DUMMY',1647,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1648,NULL,'DUMMY',1648,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1649,NULL,'DUMMY',1649,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1650,NULL,'DUMMY',1650,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1651,NULL,'DUMMY',1651,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1652,NULL,'DUMMY',1652,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1653,NULL,'DUMMY',1653,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1654,NULL,'DUMMY',1654,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1655,NULL,'DUMMY',1655,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1656,NULL,'DUMMY',1656,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1657,NULL,'DUMMY',1657,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1658,NULL,'DUMMY',1658,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1659,NULL,'DUMMY',1659,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1660,NULL,'DUMMY',1660,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1661,NULL,'DUMMY',1661,1,'2025-05-23 06:00:53','2025-05-23 06:00:53'),
(1662,NULL,'DUMMY',1662,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1663,NULL,'DUMMY',1663,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1664,NULL,'DUMMY',1664,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1665,NULL,'DUMMY',1665,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1666,NULL,'DUMMY',1666,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1667,NULL,'DUMMY',1667,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1668,NULL,'DUMMY',1668,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1669,NULL,'DUMMY',1669,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1670,NULL,'DUMMY',1670,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1671,NULL,'DUMMY',1671,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1672,NULL,'DUMMY',1672,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1673,NULL,'DUMMY',1673,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1674,NULL,'DUMMY',1674,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1675,NULL,'DUMMY',1675,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1676,NULL,'DUMMY',1676,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1677,NULL,'DUMMY',1677,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1678,NULL,'DUMMY',1678,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1679,NULL,'DUMMY',1679,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1680,NULL,'DUMMY',1680,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1681,NULL,'DUMMY',1681,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1682,NULL,'DUMMY',1682,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1683,NULL,'DUMMY',1683,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1684,NULL,'DUMMY',1684,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1685,NULL,'DUMMY',1685,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1686,NULL,'DUMMY',1686,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1687,NULL,'DUMMY',1687,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1688,NULL,'DUMMY',1688,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1689,NULL,'DUMMY',1689,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1690,NULL,'DUMMY',1690,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1691,NULL,'DUMMY',1691,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1692,NULL,'DUMMY',1692,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1693,NULL,'DUMMY',1693,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1694,NULL,'DUMMY',1694,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1695,NULL,'DUMMY',1695,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1696,NULL,'DUMMY',1696,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1697,NULL,'DUMMY',1697,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1698,NULL,'DUMMY',1698,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1699,NULL,'DUMMY',1699,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1700,NULL,'DUMMY',1700,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1701,NULL,'DUMMY',1701,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1702,NULL,'DUMMY',1702,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1703,NULL,'DUMMY',1703,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1704,NULL,'DUMMY',1704,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1705,NULL,'DUMMY',1705,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1706,NULL,'DUMMY',1706,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1707,NULL,'DUMMY',1707,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1708,NULL,'DUMMY',1708,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1709,NULL,'DUMMY',1709,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1710,NULL,'DUMMY',1710,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1711,NULL,'DUMMY',1711,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1712,NULL,'DUMMY',1712,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1713,NULL,'DUMMY',1713,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1714,NULL,'DUMMY',1714,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1715,NULL,'DUMMY',1715,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1716,NULL,'DUMMY',1716,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1717,NULL,'DUMMY',1717,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1718,NULL,'DUMMY',1718,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1719,NULL,'DUMMY',1719,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1720,NULL,'DUMMY',1720,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1721,NULL,'DUMMY',1721,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1722,NULL,'DUMMY',1722,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1723,NULL,'DUMMY',1723,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1724,NULL,'DUMMY',1724,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1725,NULL,'DUMMY',1725,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1726,NULL,'DUMMY',1726,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1727,NULL,'DUMMY',1727,1,'2025-05-23 06:00:54','2025-05-23 06:00:54'),
(1728,NULL,'DUMMY',1728,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1729,NULL,'DUMMY',1729,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1730,NULL,'DUMMY',1730,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1731,NULL,'DUMMY',1731,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1732,NULL,'DUMMY',1732,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1733,NULL,'DUMMY',1733,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1734,NULL,'DUMMY',1734,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1735,NULL,'DUMMY',1735,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1736,NULL,'DUMMY',1736,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1737,NULL,'DUMMY',1737,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1738,NULL,'DUMMY',1738,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1739,NULL,'DUMMY',1739,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1740,NULL,'DUMMY',1740,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1741,NULL,'DUMMY',1741,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1742,NULL,'DUMMY',1742,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1743,NULL,'DUMMY',1743,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1744,NULL,'DUMMY',1744,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1745,NULL,'DUMMY',1745,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1746,NULL,'DUMMY',1746,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1747,NULL,'DUMMY',1747,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1748,NULL,'DUMMY',1748,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1749,NULL,'DUMMY',1749,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1750,NULL,'DUMMY',1750,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1751,NULL,'DUMMY',1751,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1752,NULL,'DUMMY',1752,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1753,NULL,'DUMMY',1753,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1754,NULL,'DUMMY',1754,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1755,NULL,'DUMMY',1755,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1756,NULL,'DUMMY',1756,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1757,NULL,'DUMMY',1757,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1758,NULL,'DUMMY',1758,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1759,NULL,'DUMMY',1759,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1760,NULL,'DUMMY',1760,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1761,NULL,'DUMMY',1761,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1762,NULL,'DUMMY',1762,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1763,NULL,'DUMMY',1763,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1764,NULL,'DUMMY',1764,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1765,NULL,'DUMMY',1765,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1766,NULL,'DUMMY',1766,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1767,NULL,'DUMMY',1767,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1768,NULL,'DUMMY',1768,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1769,NULL,'DUMMY',1769,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1770,NULL,'DUMMY',1770,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1771,NULL,'DUMMY',1771,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1772,NULL,'DUMMY',1772,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1773,NULL,'DUMMY',1773,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1774,NULL,'DUMMY',1774,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1775,NULL,'DUMMY',1775,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1776,NULL,'DUMMY',1776,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1777,NULL,'DUMMY',1777,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1778,NULL,'DUMMY',1778,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1779,NULL,'DUMMY',1779,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1780,NULL,'DUMMY',1780,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1781,NULL,'DUMMY',1781,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1782,NULL,'DUMMY',1782,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1783,NULL,'DUMMY',1783,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1784,NULL,'DUMMY',1784,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1785,NULL,'DUMMY',1785,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1786,NULL,'DUMMY',1786,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1787,NULL,'DUMMY',1787,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1788,NULL,'DUMMY',1788,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1789,NULL,'DUMMY',1789,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1790,NULL,'DUMMY',1790,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1791,NULL,'DUMMY',1791,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1792,NULL,'DUMMY',1792,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1793,NULL,'DUMMY',1793,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1794,NULL,'DUMMY',1794,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1795,NULL,'DUMMY',1795,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1796,NULL,'DUMMY',1796,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1797,NULL,'DUMMY',1797,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1798,NULL,'DUMMY',1798,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1799,NULL,'DUMMY',1799,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1800,NULL,'DUMMY',1800,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1801,NULL,'DUMMY',1801,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1802,NULL,'DUMMY',1802,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1803,NULL,'DUMMY',1803,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1804,NULL,'DUMMY',1804,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1805,NULL,'DUMMY',1805,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1806,NULL,'DUMMY',1806,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1807,NULL,'DUMMY',1807,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1808,NULL,'DUMMY',1808,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1809,NULL,'DUMMY',1809,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1810,NULL,'DUMMY',1810,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1811,NULL,'DUMMY',1811,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1812,NULL,'DUMMY',1812,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1813,NULL,'DUMMY',1813,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1814,NULL,'DUMMY',1814,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1815,NULL,'DUMMY',1815,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1816,NULL,'DUMMY',1816,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1817,NULL,'DUMMY',1817,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1818,NULL,'DUMMY',1818,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1819,NULL,'DUMMY',1819,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1820,NULL,'DUMMY',1820,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1821,NULL,'DUMMY',1821,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1822,NULL,'DUMMY',1822,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1823,NULL,'DUMMY',1823,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1824,NULL,'DUMMY',1824,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1825,NULL,'DUMMY',1825,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1826,NULL,'DUMMY',1826,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1827,NULL,'DUMMY',1827,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1828,NULL,'DUMMY',1828,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1829,NULL,'DUMMY',1829,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1830,NULL,'DUMMY',1830,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1831,NULL,'DUMMY',1831,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1832,NULL,'DUMMY',1832,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1833,NULL,'DUMMY',1833,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1834,NULL,'DUMMY',1834,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1835,NULL,'DUMMY',1835,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1836,NULL,'DUMMY',1836,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1837,NULL,'DUMMY',1837,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1838,NULL,'DUMMY',1838,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1839,NULL,'DUMMY',1839,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1840,NULL,'DUMMY',1840,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1841,NULL,'DUMMY',1841,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1842,NULL,'DUMMY',1842,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1843,NULL,'DUMMY',1843,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1844,NULL,'DUMMY',1844,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1845,NULL,'DUMMY',1845,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1846,NULL,'DUMMY',1846,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1847,NULL,'DUMMY',1847,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1848,NULL,'DUMMY',1848,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1849,NULL,'DUMMY',1849,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1850,NULL,'DUMMY',1850,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1851,NULL,'DUMMY',1851,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1852,NULL,'DUMMY',1852,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1853,NULL,'DUMMY',1853,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1854,NULL,'DUMMY',1854,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1855,NULL,'DUMMY',1855,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1856,NULL,'DUMMY',1856,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1857,NULL,'DUMMY',1857,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1858,NULL,'DUMMY',1858,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1859,NULL,'DUMMY',1859,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1860,NULL,'DUMMY',1860,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1861,NULL,'DUMMY',1861,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1862,NULL,'DUMMY',1862,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1863,NULL,'DUMMY',1863,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1864,NULL,'DUMMY',1864,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1865,NULL,'DUMMY',1865,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1866,NULL,'DUMMY',1866,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1867,NULL,'DUMMY',1867,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1868,NULL,'DUMMY',1868,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1869,NULL,'DUMMY',1869,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1870,NULL,'DUMMY',1870,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1871,NULL,'DUMMY',1871,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1872,NULL,'DUMMY',1872,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1873,NULL,'DUMMY',1873,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1874,NULL,'DUMMY',1874,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1875,NULL,'DUMMY',1875,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1876,NULL,'DUMMY',1876,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1877,NULL,'DUMMY',1877,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1878,NULL,'DUMMY',1878,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1879,NULL,'DUMMY',1879,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1880,NULL,'DUMMY',1880,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1881,NULL,'DUMMY',1881,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1882,NULL,'DUMMY',1882,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1883,NULL,'DUMMY',1883,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1884,NULL,'DUMMY',1884,1,'2025-05-23 06:00:55','2025-05-23 06:00:55'),
(1885,NULL,'DUMMY',1885,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1886,NULL,'DUMMY',1886,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1887,NULL,'DUMMY',1887,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1888,NULL,'DUMMY',1888,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1889,NULL,'DUMMY',1889,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1890,NULL,'DUMMY',1890,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1891,NULL,'DUMMY',1891,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1892,NULL,'DUMMY',1892,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1893,NULL,'DUMMY',1893,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1894,NULL,'DUMMY',1894,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1895,NULL,'DUMMY',1895,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1896,NULL,'DUMMY',1896,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1897,NULL,'DUMMY',1897,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1898,NULL,'DUMMY',1898,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1899,NULL,'DUMMY',1899,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1900,NULL,'DUMMY',1900,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1901,NULL,'DUMMY',1901,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1902,NULL,'DUMMY',1902,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1903,NULL,'DUMMY',1903,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1904,NULL,'DUMMY',1904,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1905,NULL,'DUMMY',1905,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1906,NULL,'DUMMY',1906,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1907,NULL,'DUMMY',1907,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1908,NULL,'DUMMY',1908,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1909,NULL,'DUMMY',1909,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1910,NULL,'DUMMY',1910,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1911,NULL,'DUMMY',1911,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1912,NULL,'DUMMY',1912,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1913,NULL,'DUMMY',1913,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1914,NULL,'DUMMY',1914,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1915,NULL,'DUMMY',1915,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1916,NULL,'DUMMY',1916,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1917,NULL,'DUMMY',1917,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1918,NULL,'DUMMY',1918,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1919,NULL,'DUMMY',1919,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1920,NULL,'DUMMY',1920,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1921,NULL,'DUMMY',1921,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1922,NULL,'DUMMY',1922,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1923,NULL,'DUMMY',1923,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1924,NULL,'DUMMY',1924,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1925,NULL,'DUMMY',1925,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1926,NULL,'DUMMY',1926,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1927,NULL,'DUMMY',1927,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1928,NULL,'DUMMY',1928,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1929,NULL,'DUMMY',1929,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1930,NULL,'DUMMY',1930,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1931,NULL,'DUMMY',1931,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1932,NULL,'DUMMY',1932,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1933,NULL,'DUMMY',1933,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1934,NULL,'DUMMY',1934,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1935,NULL,'DUMMY',1935,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1936,NULL,'DUMMY',1936,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1937,NULL,'DUMMY',1937,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1938,NULL,'DUMMY',1938,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1939,NULL,'DUMMY',1939,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1940,NULL,'DUMMY',1940,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1941,NULL,'DUMMY',1941,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1942,NULL,'DUMMY',1942,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1943,NULL,'DUMMY',1943,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1944,NULL,'DUMMY',1944,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1945,NULL,'DUMMY',1945,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1946,NULL,'DUMMY',1946,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1947,NULL,'DUMMY',1947,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1948,NULL,'DUMMY',1948,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1949,NULL,'DUMMY',1949,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1950,NULL,'DUMMY',1950,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1951,NULL,'DUMMY',1951,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1952,NULL,'DUMMY',1952,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1953,NULL,'DUMMY',1953,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1954,NULL,'DUMMY',1954,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1955,NULL,'DUMMY',1955,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1956,NULL,'DUMMY',1956,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1957,NULL,'DUMMY',1957,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1958,NULL,'DUMMY',1958,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1959,NULL,'DUMMY',1959,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1960,NULL,'DUMMY',1960,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1961,NULL,'DUMMY',1961,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1962,NULL,'DUMMY',1962,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1963,NULL,'DUMMY',1963,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1964,NULL,'DUMMY',1964,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1965,NULL,'DUMMY',1965,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1966,NULL,'DUMMY',1966,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1967,NULL,'DUMMY',1967,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1968,NULL,'DUMMY',1968,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1969,NULL,'DUMMY',1969,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1970,NULL,'DUMMY',1970,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1971,NULL,'DUMMY',1971,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1972,NULL,'DUMMY',1972,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1973,NULL,'DUMMY',1973,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1974,NULL,'DUMMY',1974,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1975,NULL,'DUMMY',1975,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1976,NULL,'DUMMY',1976,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1977,NULL,'DUMMY',1977,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1978,NULL,'DUMMY',1978,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1979,NULL,'DUMMY',1979,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1980,NULL,'DUMMY',1980,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1981,NULL,'DUMMY',1981,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1982,NULL,'DUMMY',1982,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1983,NULL,'DUMMY',1983,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1984,NULL,'DUMMY',1984,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1985,NULL,'DUMMY',1985,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1986,NULL,'DUMMY',1986,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1987,NULL,'DUMMY',1987,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1988,NULL,'DUMMY',1988,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1989,NULL,'DUMMY',1989,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1990,NULL,'DUMMY',1990,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1991,NULL,'DUMMY',1991,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1992,NULL,'DUMMY',1992,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1993,NULL,'DUMMY',1993,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1994,NULL,'DUMMY',1994,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1995,NULL,'DUMMY',1995,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1996,NULL,'DUMMY',1996,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1997,NULL,'DUMMY',1997,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1998,NULL,'DUMMY',1998,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(1999,NULL,'DUMMY',1999,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2000,NULL,'DUMMY',2000,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2001,NULL,'DUMMY',2001,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2002,NULL,'DUMMY',2002,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2003,NULL,'DUMMY',2003,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2004,NULL,'DUMMY',2004,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2005,NULL,'DUMMY',2005,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2006,NULL,'DUMMY',2006,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2007,NULL,'DUMMY',2007,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2008,NULL,'DUMMY',2008,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2009,NULL,'DUMMY',2009,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2010,NULL,'DUMMY',2010,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2011,NULL,'DUMMY',2011,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2012,NULL,'DUMMY',2012,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2013,NULL,'DUMMY',2013,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2014,NULL,'DUMMY',2014,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2015,NULL,'DUMMY',2015,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2016,NULL,'DUMMY',2016,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2017,NULL,'DUMMY',2017,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2018,NULL,'DUMMY',2018,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2019,NULL,'DUMMY',2019,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2020,NULL,'DUMMY',2020,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2021,NULL,'DUMMY',2021,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2022,NULL,'DUMMY',2022,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2023,NULL,'DUMMY',2023,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2024,NULL,'DUMMY',2024,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2025,NULL,'DUMMY',2025,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2026,NULL,'DUMMY',2026,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2027,NULL,'DUMMY',2027,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2028,NULL,'DUMMY',2028,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2029,NULL,'DUMMY',2029,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2030,NULL,'DUMMY',2030,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2031,NULL,'DUMMY',2031,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2032,NULL,'DUMMY',2032,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2033,NULL,'DUMMY',2033,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2034,NULL,'DUMMY',2034,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2035,NULL,'DUMMY',2035,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2036,NULL,'DUMMY',2036,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2037,NULL,'DUMMY',2037,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2038,NULL,'DUMMY',2038,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2039,NULL,'DUMMY',2039,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2040,NULL,'DUMMY',2040,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2041,NULL,'DUMMY',2041,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2042,NULL,'DUMMY',2042,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2043,NULL,'DUMMY',2043,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2044,NULL,'DUMMY',2044,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2045,NULL,'DUMMY',2045,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2046,NULL,'DUMMY',2046,1,'2025-05-23 06:00:56','2025-05-23 06:00:56'),
(2047,NULL,'DUMMY',2047,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2048,NULL,'DUMMY',2048,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2049,NULL,'DUMMY',2049,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2050,NULL,'DUMMY',2050,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2051,NULL,'DUMMY',2051,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2052,NULL,'DUMMY',2052,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2053,NULL,'DUMMY',2053,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2054,NULL,'DUMMY',2054,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2055,NULL,'DUMMY',2055,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2056,NULL,'DUMMY',2056,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2057,NULL,'DUMMY',2057,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2058,NULL,'DUMMY',2058,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2059,NULL,'DUMMY',2059,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2060,NULL,'DUMMY',2060,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2061,NULL,'DUMMY',2061,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2062,NULL,'DUMMY',2062,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2063,NULL,'DUMMY',2063,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2064,NULL,'DUMMY',2064,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2065,NULL,'DUMMY',2065,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2066,NULL,'DUMMY',2066,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2067,NULL,'DUMMY',2067,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2068,NULL,'DUMMY',2068,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2069,NULL,'DUMMY',2069,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2070,NULL,'DUMMY',2070,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2071,NULL,'DUMMY',2071,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2072,NULL,'DUMMY',2072,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2073,NULL,'DUMMY',2073,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2074,NULL,'DUMMY',2074,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2075,NULL,'DUMMY',2075,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2076,NULL,'DUMMY',2076,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2077,NULL,'DUMMY',2077,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2078,NULL,'DUMMY',2078,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2079,NULL,'DUMMY',2079,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2080,NULL,'DUMMY',2080,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2081,NULL,'DUMMY',2081,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2082,NULL,'DUMMY',2082,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2083,NULL,'DUMMY',2083,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2084,NULL,'DUMMY',2084,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2085,NULL,'DUMMY',2085,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2086,NULL,'DUMMY',2086,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2087,NULL,'DUMMY',2087,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2088,NULL,'DUMMY',2088,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2089,NULL,'DUMMY',2089,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2090,NULL,'DUMMY',2090,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2091,NULL,'DUMMY',2091,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2092,NULL,'DUMMY',2092,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2093,NULL,'DUMMY',2093,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2094,NULL,'DUMMY',2094,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2095,NULL,'DUMMY',2095,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2096,NULL,'DUMMY',2096,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2097,NULL,'DUMMY',2097,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2098,NULL,'DUMMY',2098,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2099,NULL,'DUMMY',2099,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2100,NULL,'DUMMY',2100,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2101,NULL,'DUMMY',2101,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2102,NULL,'DUMMY',2102,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2103,NULL,'DUMMY',2103,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2104,NULL,'DUMMY',2104,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2105,NULL,'DUMMY',2105,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2106,NULL,'DUMMY',2106,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2107,NULL,'DUMMY',2107,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2108,NULL,'DUMMY',2108,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2109,NULL,'DUMMY',2109,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2110,NULL,'DUMMY',2110,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2111,NULL,'DUMMY',2111,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2112,NULL,'DUMMY',2112,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2113,NULL,'DUMMY',2113,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2114,NULL,'DUMMY',2114,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2115,NULL,'DUMMY',2115,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2116,NULL,'DUMMY',2116,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2117,NULL,'DUMMY',2117,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2118,NULL,'DUMMY',2118,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2119,NULL,'DUMMY',2119,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2120,NULL,'DUMMY',2120,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2121,NULL,'DUMMY',2121,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2122,NULL,'DUMMY',2122,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2123,NULL,'DUMMY',2123,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2124,NULL,'DUMMY',2124,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2125,NULL,'DUMMY',2125,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2126,NULL,'DUMMY',2126,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2127,NULL,'DUMMY',2127,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2128,NULL,'DUMMY',2128,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2129,NULL,'DUMMY',2129,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2130,NULL,'DUMMY',2130,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2131,NULL,'DUMMY',2131,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2132,NULL,'DUMMY',2132,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2133,NULL,'DUMMY',2133,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2134,NULL,'DUMMY',2134,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2135,NULL,'DUMMY',2135,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2136,NULL,'DUMMY',2136,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2137,NULL,'DUMMY',2137,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2138,NULL,'DUMMY',2138,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2139,NULL,'DUMMY',2139,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2140,NULL,'DUMMY',2140,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2141,NULL,'DUMMY',2141,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2142,NULL,'DUMMY',2142,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2143,NULL,'DUMMY',2143,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2144,NULL,'DUMMY',2144,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2145,NULL,'DUMMY',2145,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2146,NULL,'DUMMY',2146,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2147,NULL,'DUMMY',2147,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2148,NULL,'DUMMY',2148,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2149,NULL,'DUMMY',2149,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2150,NULL,'DUMMY',2150,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2151,NULL,'DUMMY',2151,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2152,NULL,'DUMMY',2152,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2153,NULL,'DUMMY',2153,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2154,NULL,'DUMMY',2154,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2155,NULL,'DUMMY',2155,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2156,NULL,'DUMMY',2156,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2157,NULL,'DUMMY',2157,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2158,NULL,'DUMMY',2158,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2159,NULL,'DUMMY',2159,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2160,NULL,'DUMMY',2160,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2161,NULL,'DUMMY',2161,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2162,NULL,'DUMMY',2162,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2163,NULL,'DUMMY',2163,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2164,NULL,'DUMMY',2164,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2165,NULL,'DUMMY',2165,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2166,NULL,'DUMMY',2166,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2167,NULL,'DUMMY',2167,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2168,NULL,'DUMMY',2168,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2169,NULL,'DUMMY',2169,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2170,NULL,'DUMMY',2170,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2171,NULL,'DUMMY',2171,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2172,NULL,'DUMMY',2172,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2173,NULL,'DUMMY',2173,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2174,NULL,'DUMMY',2174,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2175,NULL,'DUMMY',2175,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2176,NULL,'DUMMY',2176,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2177,NULL,'DUMMY',2177,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2178,NULL,'DUMMY',2178,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2179,NULL,'DUMMY',2179,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2180,NULL,'DUMMY',2180,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2181,NULL,'DUMMY',2181,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2182,NULL,'DUMMY',2182,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2183,NULL,'DUMMY',2183,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2184,NULL,'DUMMY',2184,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2185,NULL,'DUMMY',2185,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2186,NULL,'DUMMY',2186,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2187,NULL,'DUMMY',2187,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2188,NULL,'DUMMY',2188,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2189,NULL,'DUMMY',2189,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2190,NULL,'DUMMY',2190,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2191,NULL,'DUMMY',2191,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2192,NULL,'DUMMY',2192,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2193,NULL,'DUMMY',2193,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2194,NULL,'DUMMY',2194,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2195,NULL,'DUMMY',2195,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2196,NULL,'DUMMY',2196,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2197,NULL,'DUMMY',2197,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2198,NULL,'DUMMY',2198,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2199,NULL,'DUMMY',2199,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2200,NULL,'DUMMY',2200,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2201,NULL,'DUMMY',2201,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2202,NULL,'DUMMY',2202,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2203,NULL,'DUMMY',2203,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2204,NULL,'DUMMY',2204,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2205,NULL,'DUMMY',2205,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2206,NULL,'DUMMY',2206,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2207,NULL,'DUMMY',2207,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2208,NULL,'DUMMY',2208,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2209,NULL,'DUMMY',2209,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2210,NULL,'DUMMY',2210,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2211,NULL,'DUMMY',2211,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2212,NULL,'DUMMY',2212,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2213,NULL,'DUMMY',2213,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2214,NULL,'DUMMY',2214,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2215,NULL,'DUMMY',2215,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2216,NULL,'DUMMY',2216,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2217,NULL,'DUMMY',2217,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2218,NULL,'DUMMY',2218,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2219,NULL,'DUMMY',2219,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2220,NULL,'DUMMY',2220,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2221,NULL,'DUMMY',2221,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2222,NULL,'DUMMY',2222,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2223,NULL,'DUMMY',2223,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2224,NULL,'DUMMY',2224,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2225,NULL,'DUMMY',2225,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2226,NULL,'DUMMY',2226,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2227,NULL,'DUMMY',2227,1,'2025-05-23 06:00:57','2025-05-23 06:00:57'),
(2228,NULL,'DUMMY',2228,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2229,NULL,'DUMMY',2229,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2230,NULL,'DUMMY',2230,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2231,NULL,'DUMMY',2231,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2232,NULL,'DUMMY',2232,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2233,NULL,'DUMMY',2233,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2234,NULL,'DUMMY',2234,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2235,NULL,'DUMMY',2235,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2236,NULL,'DUMMY',2236,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2237,NULL,'DUMMY',2237,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2238,NULL,'DUMMY',2238,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2239,NULL,'DUMMY',2239,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2240,NULL,'DUMMY',2240,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2241,NULL,'DUMMY',2241,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2242,NULL,'DUMMY',2242,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2243,NULL,'DUMMY',2243,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2244,NULL,'DUMMY',2244,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2245,NULL,'DUMMY',2245,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2246,NULL,'DUMMY',2246,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2247,NULL,'DUMMY',2247,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2248,NULL,'DUMMY',2248,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2249,NULL,'DUMMY',2249,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2250,NULL,'DUMMY',2250,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2251,NULL,'DUMMY',2251,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2252,NULL,'DUMMY',2252,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2253,NULL,'DUMMY',2253,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2254,NULL,'DUMMY',2254,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2255,NULL,'DUMMY',2255,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2256,NULL,'DUMMY',2256,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2257,NULL,'DUMMY',2257,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2258,NULL,'DUMMY',2258,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2259,NULL,'DUMMY',2259,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2260,NULL,'DUMMY',2260,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2261,NULL,'DUMMY',2261,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2262,NULL,'DUMMY',2262,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2263,NULL,'DUMMY',2263,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2264,NULL,'DUMMY',2264,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2265,NULL,'DUMMY',2265,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2266,NULL,'DUMMY',2266,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2267,NULL,'DUMMY',2267,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2268,NULL,'DUMMY',2268,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2269,NULL,'DUMMY',2269,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2270,NULL,'DUMMY',2270,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2271,NULL,'DUMMY',2271,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2272,NULL,'DUMMY',2272,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2273,NULL,'DUMMY',2273,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2274,NULL,'DUMMY',2274,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2275,NULL,'DUMMY',2275,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2276,NULL,'DUMMY',2276,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2277,NULL,'DUMMY',2277,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2278,NULL,'DUMMY',2278,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2279,NULL,'DUMMY',2279,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2280,NULL,'DUMMY',2280,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2281,NULL,'DUMMY',2281,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2282,NULL,'DUMMY',2282,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2283,NULL,'DUMMY',2283,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2284,NULL,'DUMMY',2284,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2285,NULL,'DUMMY',2285,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2286,NULL,'DUMMY',2286,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2287,NULL,'DUMMY',2287,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2288,NULL,'DUMMY',2288,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2289,NULL,'DUMMY',2289,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2290,NULL,'DUMMY',2290,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2291,NULL,'DUMMY',2291,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2292,NULL,'DUMMY',2292,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2293,NULL,'DUMMY',2293,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2294,NULL,'DUMMY',2294,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2295,NULL,'DUMMY',2295,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2296,NULL,'DUMMY',2296,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2297,NULL,'DUMMY',2297,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2298,NULL,'DUMMY',2298,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2299,NULL,'DUMMY',2299,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2300,NULL,'DUMMY',2300,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2301,NULL,'DUMMY',2301,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2302,NULL,'DUMMY',2302,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2303,NULL,'DUMMY',2303,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2304,NULL,'DUMMY',2304,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2305,NULL,'DUMMY',2305,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2306,NULL,'DUMMY',2306,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2307,NULL,'DUMMY',2307,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2308,NULL,'DUMMY',2308,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2309,NULL,'DUMMY',2309,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2310,NULL,'DUMMY',2310,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2311,NULL,'DUMMY',2311,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2312,NULL,'DUMMY',2312,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2313,NULL,'DUMMY',2313,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2314,NULL,'DUMMY',2314,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2315,NULL,'DUMMY',2315,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2316,NULL,'DUMMY',2316,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2317,NULL,'DUMMY',2317,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2318,NULL,'DUMMY',2318,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2319,NULL,'DUMMY',2319,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2320,NULL,'DUMMY',2320,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2321,NULL,'DUMMY',2321,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2322,NULL,'DUMMY',2322,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2323,NULL,'DUMMY',2323,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2324,NULL,'DUMMY',2324,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2325,NULL,'DUMMY',2325,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2326,NULL,'DUMMY',2326,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2327,NULL,'DUMMY',2327,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2328,NULL,'DUMMY',2328,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2329,NULL,'DUMMY',2329,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2330,NULL,'DUMMY',2330,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2331,NULL,'DUMMY',2331,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2332,NULL,'DUMMY',2332,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2333,NULL,'DUMMY',2333,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2334,NULL,'DUMMY',2334,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2335,NULL,'DUMMY',2335,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2336,NULL,'DUMMY',2336,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2337,NULL,'DUMMY',2337,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2338,NULL,'DUMMY',2338,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2339,NULL,'DUMMY',2339,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2340,NULL,'DUMMY',2340,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2341,NULL,'DUMMY',2341,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2342,NULL,'DUMMY',2342,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2343,NULL,'DUMMY',2343,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2344,NULL,'DUMMY',2344,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2345,NULL,'DUMMY',2345,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2346,NULL,'DUMMY',2346,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2347,NULL,'DUMMY',2347,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2348,NULL,'DUMMY',2348,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2349,NULL,'DUMMY',2349,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2350,NULL,'DUMMY',2350,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2351,NULL,'DUMMY',2351,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2352,NULL,'DUMMY',2352,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2353,NULL,'DUMMY',2353,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2354,NULL,'DUMMY',2354,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2355,NULL,'DUMMY',2355,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2356,NULL,'DUMMY',2356,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2357,NULL,'DUMMY',2357,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2358,NULL,'DUMMY',2358,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2359,NULL,'DUMMY',2359,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2360,NULL,'DUMMY',2360,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2361,NULL,'DUMMY',2361,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2362,NULL,'DUMMY',2362,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2363,NULL,'DUMMY',2363,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2364,NULL,'DUMMY',2364,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2365,NULL,'DUMMY',2365,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2366,NULL,'DUMMY',2366,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2367,NULL,'DUMMY',2367,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2368,NULL,'DUMMY',2368,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2369,NULL,'DUMMY',2369,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2370,NULL,'DUMMY',2370,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2371,NULL,'DUMMY',2371,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2372,NULL,'DUMMY',2372,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2373,NULL,'DUMMY',2373,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2374,NULL,'DUMMY',2374,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2375,NULL,'DUMMY',2375,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2376,NULL,'DUMMY',2376,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2377,NULL,'DUMMY',2377,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2378,NULL,'DUMMY',2378,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2379,NULL,'DUMMY',2379,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2380,NULL,'DUMMY',2380,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2381,NULL,'DUMMY',2381,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2382,NULL,'DUMMY',2382,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2383,NULL,'DUMMY',2383,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2384,NULL,'DUMMY',2384,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2385,NULL,'DUMMY',2385,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2386,NULL,'DUMMY',2386,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2387,NULL,'DUMMY',2387,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2388,NULL,'DUMMY',2388,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2389,NULL,'DUMMY',2389,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2390,NULL,'DUMMY',2390,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2391,NULL,'DUMMY',2391,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2392,NULL,'DUMMY',2392,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2393,NULL,'DUMMY',2393,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2394,NULL,'DUMMY',2394,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2395,NULL,'DUMMY',2395,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2396,NULL,'DUMMY',2396,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2397,NULL,'DUMMY',2397,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2398,NULL,'DUMMY',2398,1,'2025-05-23 06:00:58','2025-05-23 06:00:58'),
(2399,NULL,'DUMMY',2399,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2400,NULL,'DUMMY',2400,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2401,NULL,'DUMMY',2401,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2402,NULL,'DUMMY',2402,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2403,NULL,'DUMMY',2403,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2404,NULL,'DUMMY',2404,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2405,NULL,'DUMMY',2405,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2406,NULL,'DUMMY',2406,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2407,NULL,'DUMMY',2407,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2408,NULL,'DUMMY',2408,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2409,NULL,'DUMMY',2409,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2410,NULL,'DUMMY',2410,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2411,NULL,'DUMMY',2411,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2412,NULL,'DUMMY',2412,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2413,NULL,'DUMMY',2413,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2414,NULL,'DUMMY',2414,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2415,NULL,'DUMMY',2415,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2416,NULL,'DUMMY',2416,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2417,NULL,'DUMMY',2417,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2418,NULL,'DUMMY',2418,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2419,NULL,'DUMMY',2419,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2420,NULL,'DUMMY',2420,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2421,NULL,'DUMMY',2421,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2422,NULL,'DUMMY',2422,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2423,NULL,'DUMMY',2423,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2424,NULL,'DUMMY',2424,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2425,NULL,'DUMMY',2425,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2426,NULL,'DUMMY',2426,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2427,NULL,'DUMMY',2427,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2428,NULL,'DUMMY',2428,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2429,NULL,'DUMMY',2429,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2430,NULL,'DUMMY',2430,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2431,NULL,'DUMMY',2431,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2432,NULL,'DUMMY',2432,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2433,NULL,'DUMMY',2433,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2434,NULL,'DUMMY',2434,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2435,NULL,'DUMMY',2435,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2436,NULL,'DUMMY',2436,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2437,NULL,'DUMMY',2437,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2438,NULL,'DUMMY',2438,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2439,NULL,'DUMMY',2439,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2440,NULL,'DUMMY',2440,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2441,NULL,'DUMMY',2441,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2442,NULL,'DUMMY',2442,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2443,NULL,'DUMMY',2443,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2444,NULL,'DUMMY',2444,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2445,NULL,'DUMMY',2445,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2446,NULL,'DUMMY',2446,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2447,NULL,'DUMMY',2447,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2448,NULL,'DUMMY',2448,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2449,NULL,'DUMMY',2449,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2450,NULL,'DUMMY',2450,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2451,NULL,'DUMMY',2451,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2452,NULL,'DUMMY',2452,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2453,NULL,'DUMMY',2453,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2454,NULL,'DUMMY',2454,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2455,NULL,'DUMMY',2455,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2456,NULL,'DUMMY',2456,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2457,NULL,'DUMMY',2457,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2458,NULL,'DUMMY',2458,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2459,NULL,'DUMMY',2459,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2460,NULL,'DUMMY',2460,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2461,NULL,'DUMMY',2461,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2462,NULL,'DUMMY',2462,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2463,NULL,'DUMMY',2463,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2464,NULL,'DUMMY',2464,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2465,NULL,'DUMMY',2465,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2466,NULL,'DUMMY',2466,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2467,NULL,'DUMMY',2467,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2468,NULL,'DUMMY',2468,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2469,NULL,'DUMMY',2469,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2470,NULL,'DUMMY',2470,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2471,NULL,'DUMMY',2471,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2472,NULL,'DUMMY',2472,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2473,NULL,'DUMMY',2473,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2474,NULL,'DUMMY',2474,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2475,NULL,'DUMMY',2475,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2476,NULL,'DUMMY',2476,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2477,NULL,'DUMMY',2477,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2478,NULL,'DUMMY',2478,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2479,NULL,'DUMMY',2479,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2480,NULL,'DUMMY',2480,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2481,NULL,'DUMMY',2481,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2482,NULL,'DUMMY',2482,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2483,NULL,'DUMMY',2483,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2484,NULL,'DUMMY',2484,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2485,NULL,'DUMMY',2485,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2486,NULL,'DUMMY',2486,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2487,NULL,'DUMMY',2487,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2488,NULL,'DUMMY',2488,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2489,NULL,'DUMMY',2489,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2490,NULL,'DUMMY',2490,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2491,NULL,'DUMMY',2491,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2492,NULL,'DUMMY',2492,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2493,NULL,'DUMMY',2493,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2494,NULL,'DUMMY',2494,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2495,NULL,'DUMMY',2495,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2496,NULL,'DUMMY',2496,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2497,NULL,'DUMMY',2497,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2498,NULL,'DUMMY',2498,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2499,NULL,'DUMMY',2499,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2500,NULL,'DUMMY',2500,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2501,NULL,'DUMMY',2501,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2502,NULL,'DUMMY',2502,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2503,NULL,'DUMMY',2503,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2504,NULL,'DUMMY',2504,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2505,NULL,'DUMMY',2505,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2506,NULL,'DUMMY',2506,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2507,NULL,'DUMMY',2507,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2508,NULL,'DUMMY',2508,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2509,NULL,'DUMMY',2509,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2510,NULL,'DUMMY',2510,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2511,NULL,'DUMMY',2511,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2512,NULL,'DUMMY',2512,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2513,NULL,'DUMMY',2513,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2514,NULL,'DUMMY',2514,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2515,NULL,'DUMMY',2515,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2516,NULL,'DUMMY',2516,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2517,NULL,'DUMMY',2517,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2518,NULL,'DUMMY',2518,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2519,NULL,'DUMMY',2519,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2520,NULL,'DUMMY',2520,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2521,NULL,'DUMMY',2521,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2522,NULL,'DUMMY',2522,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2523,NULL,'DUMMY',2523,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2524,NULL,'DUMMY',2524,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2525,NULL,'DUMMY',2525,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2526,NULL,'DUMMY',2526,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2527,NULL,'DUMMY',2527,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2528,NULL,'DUMMY',2528,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2529,NULL,'DUMMY',2529,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2530,NULL,'DUMMY',2530,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2531,NULL,'DUMMY',2531,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2532,NULL,'DUMMY',2532,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2533,NULL,'DUMMY',2533,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2534,NULL,'DUMMY',2534,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2535,NULL,'DUMMY',2535,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2536,NULL,'DUMMY',2536,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2537,NULL,'DUMMY',2537,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2538,NULL,'DUMMY',2538,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2539,NULL,'DUMMY',2539,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2540,NULL,'DUMMY',2540,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2541,NULL,'DUMMY',2541,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2542,NULL,'DUMMY',2542,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2543,NULL,'DUMMY',2543,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2544,NULL,'DUMMY',2544,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2545,NULL,'DUMMY',2545,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2546,NULL,'DUMMY',2546,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2547,NULL,'DUMMY',2547,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2548,NULL,'DUMMY',2548,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2549,NULL,'DUMMY',2549,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2550,NULL,'DUMMY',2550,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2551,NULL,'DUMMY',2551,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2552,NULL,'DUMMY',2552,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2553,NULL,'DUMMY',2553,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2554,NULL,'DUMMY',2554,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2555,NULL,'DUMMY',2555,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2556,NULL,'DUMMY',2556,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2557,NULL,'DUMMY',2557,1,'2025-05-23 06:00:59','2025-05-23 06:00:59'),
(2558,NULL,'DUMMY',2558,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2559,NULL,'DUMMY',2559,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2560,NULL,'DUMMY',2560,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2561,NULL,'DUMMY',2561,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2562,NULL,'DUMMY',2562,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2563,NULL,'DUMMY',2563,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2564,NULL,'DUMMY',2564,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2565,NULL,'DUMMY',2565,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2566,NULL,'DUMMY',2566,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2567,NULL,'DUMMY',2567,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2568,NULL,'DUMMY',2568,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2569,NULL,'DUMMY',2569,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2570,NULL,'DUMMY',2570,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2571,NULL,'DUMMY',2571,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2572,NULL,'DUMMY',2572,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2573,NULL,'DUMMY',2573,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2574,NULL,'DUMMY',2574,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2575,NULL,'DUMMY',2575,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2576,NULL,'DUMMY',2576,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2577,NULL,'DUMMY',2577,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2578,NULL,'DUMMY',2578,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2579,NULL,'DUMMY',2579,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2580,NULL,'DUMMY',2580,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2581,NULL,'DUMMY',2581,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2582,NULL,'DUMMY',2582,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2583,NULL,'DUMMY',2583,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2584,NULL,'DUMMY',2584,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2585,NULL,'DUMMY',2585,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2586,NULL,'DUMMY',2586,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2587,NULL,'DUMMY',2587,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2588,NULL,'DUMMY',2588,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2589,NULL,'DUMMY',2589,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2590,NULL,'DUMMY',2590,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2591,NULL,'DUMMY',2591,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2592,NULL,'DUMMY',2592,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2593,NULL,'DUMMY',2593,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2594,NULL,'DUMMY',2594,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2595,NULL,'DUMMY',2595,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2596,NULL,'DUMMY',2596,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2597,NULL,'DUMMY',2597,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2598,NULL,'DUMMY',2598,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2599,NULL,'DUMMY',2599,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2600,NULL,'DUMMY',2600,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2601,NULL,'DUMMY',2601,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2602,NULL,'DUMMY',2602,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2603,NULL,'DUMMY',2603,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2604,NULL,'DUMMY',2604,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2605,NULL,'DUMMY',2605,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2606,NULL,'DUMMY',2606,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2607,NULL,'DUMMY',2607,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2608,NULL,'DUMMY',2608,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2609,NULL,'DUMMY',2609,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2610,NULL,'DUMMY',2610,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2611,NULL,'DUMMY',2611,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2612,NULL,'DUMMY',2612,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2613,NULL,'DUMMY',2613,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2614,NULL,'DUMMY',2614,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2615,NULL,'DUMMY',2615,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2616,NULL,'DUMMY',2616,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2617,NULL,'DUMMY',2617,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2618,NULL,'DUMMY',2618,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2619,NULL,'DUMMY',2619,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2620,NULL,'DUMMY',2620,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2621,NULL,'DUMMY',2621,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2622,NULL,'DUMMY',2622,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2623,NULL,'DUMMY',2623,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2624,NULL,'DUMMY',2624,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2625,NULL,'DUMMY',2625,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2626,NULL,'DUMMY',2626,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2627,NULL,'DUMMY',2627,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2628,NULL,'DUMMY',2628,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2629,NULL,'DUMMY',2629,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2630,NULL,'DUMMY',2630,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2631,NULL,'DUMMY',2631,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2632,NULL,'DUMMY',2632,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2633,NULL,'DUMMY',2633,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2634,NULL,'DUMMY',2634,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2635,NULL,'DUMMY',2635,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2636,NULL,'DUMMY',2636,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2637,NULL,'DUMMY',2637,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2638,NULL,'DUMMY',2638,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2639,NULL,'DUMMY',2639,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2640,NULL,'DUMMY',2640,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2641,NULL,'DUMMY',2641,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2642,NULL,'DUMMY',2642,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2643,NULL,'DUMMY',2643,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2644,NULL,'DUMMY',2644,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2645,NULL,'DUMMY',2645,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2646,NULL,'DUMMY',2646,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2647,NULL,'DUMMY',2647,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2648,NULL,'DUMMY',2648,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2649,NULL,'DUMMY',2649,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2650,NULL,'DUMMY',2650,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2651,NULL,'DUMMY',2651,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2652,NULL,'DUMMY',2652,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2653,NULL,'DUMMY',2653,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2654,NULL,'DUMMY',2654,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2655,NULL,'DUMMY',2655,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2656,NULL,'DUMMY',2656,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2657,NULL,'DUMMY',2657,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2658,NULL,'DUMMY',2658,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2659,NULL,'DUMMY',2659,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2660,NULL,'DUMMY',2660,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2661,NULL,'DUMMY',2661,1,'2025-05-23 06:01:00','2025-05-23 06:01:00'),
(2662,NULL,'DUMMY',2662,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2663,NULL,'DUMMY',2663,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2664,NULL,'DUMMY',2664,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2665,NULL,'DUMMY',2665,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2666,NULL,'DUMMY',2666,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2667,NULL,'DUMMY',2667,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2668,NULL,'DUMMY',2668,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2669,NULL,'DUMMY',2669,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2670,NULL,'DUMMY',2670,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2671,NULL,'DUMMY',2671,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2672,NULL,'DUMMY',2672,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2673,NULL,'DUMMY',2673,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2674,NULL,'DUMMY',2674,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2675,NULL,'DUMMY',2675,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2676,NULL,'DUMMY',2676,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2677,NULL,'DUMMY',2677,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2678,NULL,'DUMMY',2678,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2679,NULL,'DUMMY',2679,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2680,NULL,'DUMMY',2680,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2681,NULL,'DUMMY',2681,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2682,NULL,'DUMMY',2682,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2683,NULL,'DUMMY',2683,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2684,NULL,'DUMMY',2684,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2685,NULL,'DUMMY',2685,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2686,NULL,'DUMMY',2686,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2687,NULL,'DUMMY',2687,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2688,NULL,'DUMMY',2688,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2689,NULL,'DUMMY',2689,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2690,NULL,'DUMMY',2690,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2691,NULL,'DUMMY',2691,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2692,NULL,'DUMMY',2692,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2693,NULL,'DUMMY',2693,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2694,NULL,'DUMMY',2694,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2695,NULL,'DUMMY',2695,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2696,NULL,'DUMMY',2696,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2697,NULL,'DUMMY',2697,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2698,NULL,'DUMMY',2698,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2699,NULL,'DUMMY',2699,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2700,NULL,'DUMMY',2700,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2701,NULL,'DUMMY',2701,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2702,NULL,'DUMMY',2702,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2703,NULL,'DUMMY',2703,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2704,NULL,'DUMMY',2704,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2705,NULL,'DUMMY',2705,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2706,NULL,'DUMMY',2706,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2707,NULL,'DUMMY',2707,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2708,NULL,'DUMMY',2708,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2709,NULL,'DUMMY',2709,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2710,NULL,'DUMMY',2710,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2711,NULL,'DUMMY',2711,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2712,NULL,'DUMMY',2712,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2713,NULL,'DUMMY',2713,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2714,NULL,'DUMMY',2714,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2715,NULL,'DUMMY',2715,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2716,NULL,'DUMMY',2716,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2717,NULL,'DUMMY',2717,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2718,NULL,'DUMMY',2718,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2719,NULL,'DUMMY',2719,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2720,NULL,'DUMMY',2720,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2721,NULL,'DUMMY',2721,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2722,NULL,'DUMMY',2722,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2723,NULL,'DUMMY',2723,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2724,NULL,'DUMMY',2724,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2725,NULL,'DUMMY',2725,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2726,NULL,'DUMMY',2726,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2727,NULL,'DUMMY',2727,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2728,NULL,'DUMMY',2728,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2729,NULL,'DUMMY',2729,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2730,NULL,'DUMMY',2730,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2731,NULL,'DUMMY',2731,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2732,NULL,'DUMMY',2732,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2733,NULL,'DUMMY',2733,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2734,NULL,'DUMMY',2734,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2735,NULL,'DUMMY',2735,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2736,NULL,'DUMMY',2736,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2737,NULL,'DUMMY',2737,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2738,NULL,'DUMMY',2738,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2739,NULL,'DUMMY',2739,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2740,NULL,'DUMMY',2740,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2741,NULL,'DUMMY',2741,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2742,NULL,'DUMMY',2742,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2743,NULL,'DUMMY',2743,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2744,NULL,'DUMMY',2744,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2745,NULL,'DUMMY',2745,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2746,NULL,'DUMMY',2746,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2747,NULL,'DUMMY',2747,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2748,NULL,'DUMMY',2748,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2749,NULL,'DUMMY',2749,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2750,NULL,'DUMMY',2750,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2751,NULL,'DUMMY',2751,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2752,NULL,'DUMMY',2752,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2753,NULL,'DUMMY',2753,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2754,NULL,'DUMMY',2754,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2755,NULL,'DUMMY',2755,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2756,NULL,'DUMMY',2756,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2757,NULL,'DUMMY',2757,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2758,NULL,'DUMMY',2758,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2759,NULL,'DUMMY',2759,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2760,NULL,'DUMMY',2760,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2761,NULL,'DUMMY',2761,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2762,NULL,'DUMMY',2762,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2763,NULL,'DUMMY',2763,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2764,NULL,'DUMMY',2764,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2765,NULL,'DUMMY',2765,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2766,NULL,'DUMMY',2766,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2767,NULL,'DUMMY',2767,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2768,NULL,'DUMMY',2768,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2769,NULL,'DUMMY',2769,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2770,NULL,'DUMMY',2770,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2771,NULL,'DUMMY',2771,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2772,NULL,'DUMMY',2772,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2773,NULL,'DUMMY',2773,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2774,NULL,'DUMMY',2774,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2775,NULL,'DUMMY',2775,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2776,NULL,'DUMMY',2776,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2777,NULL,'DUMMY',2777,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2778,NULL,'DUMMY',2778,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2779,NULL,'DUMMY',2779,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2780,NULL,'DUMMY',2780,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2781,NULL,'DUMMY',2781,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2782,NULL,'DUMMY',2782,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2783,NULL,'DUMMY',2783,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2784,NULL,'DUMMY',2784,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2785,NULL,'DUMMY',2785,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2786,NULL,'DUMMY',2786,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2787,NULL,'DUMMY',2787,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2788,NULL,'DUMMY',2788,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2789,NULL,'DUMMY',2789,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2790,NULL,'DUMMY',2790,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2791,NULL,'DUMMY',2791,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2792,NULL,'DUMMY',2792,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2793,NULL,'DUMMY',2793,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2794,NULL,'DUMMY',2794,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2795,NULL,'DUMMY',2795,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2796,NULL,'DUMMY',2796,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2797,NULL,'DUMMY',2797,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2798,NULL,'DUMMY',2798,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2799,NULL,'DUMMY',2799,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2800,NULL,'DUMMY',2800,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2801,NULL,'DUMMY',2801,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2802,NULL,'DUMMY',2802,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2803,NULL,'DUMMY',2803,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2804,NULL,'DUMMY',2804,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2805,NULL,'DUMMY',2805,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2806,NULL,'DUMMY',2806,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2807,NULL,'DUMMY',2807,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2808,NULL,'DUMMY',2808,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2809,NULL,'DUMMY',2809,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2810,NULL,'DUMMY',2810,1,'2025-05-23 06:01:01','2025-05-23 06:01:01'),
(2811,NULL,'DUMMY',2811,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2812,NULL,'DUMMY',2812,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2813,NULL,'DUMMY',2813,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2814,NULL,'DUMMY',2814,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2815,NULL,'DUMMY',2815,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2816,NULL,'DUMMY',2816,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2817,NULL,'DUMMY',2817,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2818,NULL,'DUMMY',2818,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2819,NULL,'DUMMY',2819,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2820,NULL,'DUMMY',2820,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2821,NULL,'DUMMY',2821,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2822,NULL,'DUMMY',2822,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2823,NULL,'DUMMY',2823,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2824,NULL,'DUMMY',2824,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2825,NULL,'DUMMY',2825,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2826,NULL,'DUMMY',2826,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2827,NULL,'DUMMY',2827,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2828,NULL,'DUMMY',2828,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2829,NULL,'DUMMY',2829,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2830,NULL,'DUMMY',2830,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2831,NULL,'DUMMY',2831,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2832,NULL,'DUMMY',2832,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2833,NULL,'DUMMY',2833,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2834,NULL,'DUMMY',2834,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2835,NULL,'DUMMY',2835,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2836,NULL,'DUMMY',2836,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2837,NULL,'DUMMY',2837,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2838,NULL,'DUMMY',2838,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2839,NULL,'DUMMY',2839,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2840,NULL,'DUMMY',2840,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2841,NULL,'DUMMY',2841,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2842,NULL,'DUMMY',2842,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2843,NULL,'DUMMY',2843,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2844,NULL,'DUMMY',2844,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2845,NULL,'DUMMY',2845,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2846,NULL,'DUMMY',2846,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2847,NULL,'DUMMY',2847,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2848,NULL,'DUMMY',2848,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2849,NULL,'DUMMY',2849,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2850,NULL,'DUMMY',2850,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2851,NULL,'DUMMY',2851,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2852,NULL,'DUMMY',2852,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2853,NULL,'DUMMY',2853,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2854,NULL,'DUMMY',2854,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2855,NULL,'DUMMY',2855,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2856,NULL,'DUMMY',2856,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2857,NULL,'DUMMY',2857,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2858,NULL,'DUMMY',2858,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2859,NULL,'DUMMY',2859,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2860,NULL,'DUMMY',2860,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2861,NULL,'DUMMY',2861,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2862,NULL,'DUMMY',2862,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2863,NULL,'DUMMY',2863,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2864,NULL,'DUMMY',2864,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2865,NULL,'DUMMY',2865,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2866,NULL,'DUMMY',2866,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2867,NULL,'DUMMY',2867,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2868,NULL,'DUMMY',2868,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2869,NULL,'DUMMY',2869,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2870,NULL,'DUMMY',2870,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2871,NULL,'DUMMY',2871,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2872,NULL,'DUMMY',2872,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2873,NULL,'DUMMY',2873,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2874,NULL,'DUMMY',2874,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2875,NULL,'DUMMY',2875,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2876,NULL,'DUMMY',2876,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2877,NULL,'DUMMY',2877,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2878,NULL,'DUMMY',2878,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2879,NULL,'DUMMY',2879,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2880,NULL,'DUMMY',2880,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2881,NULL,'DUMMY',2881,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2882,NULL,'DUMMY',2882,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2883,NULL,'DUMMY',2883,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2884,NULL,'DUMMY',2884,1,'2025-05-23 06:01:02','2025-05-23 06:01:02'),
(2885,NULL,'DUMMY',2885,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2886,NULL,'DUMMY',2886,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2887,NULL,'DUMMY',2887,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2888,NULL,'DUMMY',2888,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2889,NULL,'DUMMY',2889,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2890,NULL,'DUMMY',2890,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2891,NULL,'DUMMY',2891,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2892,NULL,'DUMMY',2892,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2893,NULL,'DUMMY',2893,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2894,NULL,'DUMMY',2894,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2895,NULL,'DUMMY',2895,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2896,NULL,'DUMMY',2896,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2897,NULL,'DUMMY',2897,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2898,NULL,'DUMMY',2898,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2899,NULL,'DUMMY',2899,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2900,NULL,'DUMMY',2900,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2901,NULL,'DUMMY',2901,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2902,NULL,'DUMMY',2902,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2903,NULL,'DUMMY',2903,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2904,NULL,'DUMMY',2904,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2905,NULL,'DUMMY',2905,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2906,NULL,'DUMMY',2906,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2907,NULL,'DUMMY',2907,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2908,NULL,'DUMMY',2908,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2909,NULL,'DUMMY',2909,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2910,NULL,'DUMMY',2910,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2911,NULL,'DUMMY',2911,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2912,NULL,'DUMMY',2912,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2913,NULL,'DUMMY',2913,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2914,NULL,'DUMMY',2914,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2915,NULL,'DUMMY',2915,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2916,NULL,'DUMMY',2916,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2917,NULL,'DUMMY',2917,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2918,NULL,'DUMMY',2918,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2919,NULL,'DUMMY',2919,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2920,NULL,'DUMMY',2920,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2921,NULL,'DUMMY',2921,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2922,NULL,'DUMMY',2922,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2923,NULL,'DUMMY',2923,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2924,NULL,'DUMMY',2924,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2925,NULL,'DUMMY',2925,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2926,NULL,'DUMMY',2926,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2927,NULL,'DUMMY',2927,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2928,NULL,'DUMMY',2928,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2929,NULL,'DUMMY',2929,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2930,NULL,'DUMMY',2930,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2931,NULL,'DUMMY',2931,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2932,NULL,'DUMMY',2932,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2933,NULL,'DUMMY',2933,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2934,NULL,'DUMMY',2934,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2935,NULL,'DUMMY',2935,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2936,NULL,'DUMMY',2936,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2937,NULL,'DUMMY',2937,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2938,NULL,'DUMMY',2938,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2939,NULL,'DUMMY',2939,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2940,NULL,'DUMMY',2940,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2941,NULL,'DUMMY',2941,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2942,NULL,'DUMMY',2942,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2943,NULL,'DUMMY',2943,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2944,NULL,'DUMMY',2944,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2945,NULL,'DUMMY',2945,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2946,NULL,'DUMMY',2946,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2947,NULL,'DUMMY',2947,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2948,NULL,'DUMMY',2948,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2949,NULL,'DUMMY',2949,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2950,NULL,'DUMMY',2950,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2951,NULL,'DUMMY',2951,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2952,NULL,'DUMMY',2952,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2953,NULL,'DUMMY',2953,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2954,NULL,'DUMMY',2954,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2955,NULL,'DUMMY',2955,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2956,NULL,'DUMMY',2956,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2957,NULL,'DUMMY',2957,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2958,NULL,'DUMMY',2958,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2959,NULL,'DUMMY',2959,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2960,NULL,'DUMMY',2960,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2961,NULL,'DUMMY',2961,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2962,NULL,'DUMMY',2962,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2963,NULL,'DUMMY',2963,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2964,NULL,'DUMMY',2964,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2965,NULL,'DUMMY',2965,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2966,NULL,'DUMMY',2966,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2967,NULL,'DUMMY',2967,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2968,NULL,'DUMMY',2968,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2969,NULL,'DUMMY',2969,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2970,NULL,'DUMMY',2970,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2971,NULL,'DUMMY',2971,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2972,NULL,'DUMMY',2972,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2973,NULL,'DUMMY',2973,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2974,NULL,'DUMMY',2974,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2975,NULL,'DUMMY',2975,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2976,NULL,'DUMMY',2976,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2977,NULL,'DUMMY',2977,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2978,NULL,'DUMMY',2978,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2979,NULL,'DUMMY',2979,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2980,NULL,'DUMMY',2980,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2981,NULL,'DUMMY',2981,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2982,NULL,'DUMMY',2982,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2983,NULL,'DUMMY',2983,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2984,NULL,'DUMMY',2984,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2985,NULL,'DUMMY',2985,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2986,NULL,'DUMMY',2986,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2987,NULL,'DUMMY',2987,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2988,NULL,'DUMMY',2988,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2989,NULL,'DUMMY',2989,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2990,NULL,'DUMMY',2990,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2991,NULL,'DUMMY',2991,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2992,NULL,'DUMMY',2992,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2993,NULL,'DUMMY',2993,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2994,NULL,'DUMMY',2994,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2995,NULL,'DUMMY',2995,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2996,NULL,'DUMMY',2996,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2997,NULL,'DUMMY',2997,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2998,NULL,'DUMMY',2998,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(2999,NULL,'DUMMY',2999,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3000,NULL,'DUMMY',3000,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3001,NULL,'DUMMY',3001,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3002,NULL,'DUMMY',3002,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3003,NULL,'DUMMY',3003,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3004,NULL,'DUMMY',3004,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3005,NULL,'DUMMY',3005,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3006,NULL,'DUMMY',3006,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3007,NULL,'DUMMY',3007,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3008,NULL,'DUMMY',3008,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3009,NULL,'DUMMY',3009,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3010,NULL,'DUMMY',3010,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3011,NULL,'DUMMY',3011,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3012,NULL,'DUMMY',3012,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3013,NULL,'DUMMY',3013,1,'2025-05-23 06:01:03','2025-05-23 06:01:03'),
(3014,NULL,'DUMMY',3014,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3015,NULL,'DUMMY',3015,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3016,NULL,'DUMMY',3016,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3017,NULL,'DUMMY',3017,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3018,NULL,'DUMMY',3018,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3019,NULL,'DUMMY',3019,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3020,NULL,'DUMMY',3020,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3021,NULL,'DUMMY',3021,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3022,NULL,'DUMMY',3022,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3023,NULL,'DUMMY',3023,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3024,NULL,'DUMMY',3024,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3025,NULL,'DUMMY',3025,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3026,NULL,'DUMMY',3026,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3027,NULL,'DUMMY',3027,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3028,NULL,'DUMMY',3028,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3029,NULL,'DUMMY',3029,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3030,NULL,'DUMMY',3030,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3031,NULL,'DUMMY',3031,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3032,NULL,'DUMMY',3032,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3033,NULL,'DUMMY',3033,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3034,NULL,'DUMMY',3034,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3035,NULL,'DUMMY',3035,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3036,NULL,'DUMMY',3036,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3037,NULL,'DUMMY',3037,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3038,NULL,'DUMMY',3038,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3039,NULL,'DUMMY',3039,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3040,NULL,'DUMMY',3040,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3041,NULL,'DUMMY',3041,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3042,NULL,'DUMMY',3042,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3043,NULL,'DUMMY',3043,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3044,NULL,'DUMMY',3044,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3045,NULL,'DUMMY',3045,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3046,NULL,'DUMMY',3046,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3047,NULL,'DUMMY',3047,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3048,NULL,'DUMMY',3048,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3049,NULL,'DUMMY',3049,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3050,NULL,'DUMMY',3050,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3051,NULL,'DUMMY',3051,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3052,NULL,'DUMMY',3052,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3053,NULL,'DUMMY',3053,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3054,NULL,'DUMMY',3054,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3055,NULL,'DUMMY',3055,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3056,NULL,'DUMMY',3056,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3057,NULL,'DUMMY',3057,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3058,NULL,'DUMMY',3058,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3059,NULL,'DUMMY',3059,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3060,NULL,'DUMMY',3060,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3061,NULL,'DUMMY',3061,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3062,NULL,'DUMMY',3062,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3063,NULL,'DUMMY',3063,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3064,NULL,'DUMMY',3064,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3065,NULL,'DUMMY',3065,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3066,NULL,'DUMMY',3066,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3067,NULL,'DUMMY',3067,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3068,NULL,'DUMMY',3068,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3069,NULL,'DUMMY',3069,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3070,NULL,'DUMMY',3070,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3071,NULL,'DUMMY',3071,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3072,NULL,'DUMMY',3072,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3073,NULL,'DUMMY',3073,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3074,NULL,'DUMMY',3074,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3075,NULL,'DUMMY',3075,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3076,NULL,'DUMMY',3076,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3077,NULL,'DUMMY',3077,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3078,NULL,'DUMMY',3078,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3079,NULL,'DUMMY',3079,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3080,NULL,'DUMMY',3080,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3081,NULL,'DUMMY',3081,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3082,NULL,'DUMMY',3082,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3083,NULL,'DUMMY',3083,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3084,NULL,'DUMMY',3084,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3085,NULL,'DUMMY',3085,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3086,NULL,'DUMMY',3086,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3087,NULL,'DUMMY',3087,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3088,NULL,'DUMMY',3088,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3089,NULL,'DUMMY',3089,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3090,NULL,'DUMMY',3090,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3091,NULL,'DUMMY',3091,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3092,NULL,'DUMMY',3092,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3093,NULL,'DUMMY',3093,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3094,NULL,'DUMMY',3094,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3095,NULL,'DUMMY',3095,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3096,NULL,'DUMMY',3096,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3097,NULL,'DUMMY',3097,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3098,NULL,'DUMMY',3098,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3099,NULL,'DUMMY',3099,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3100,NULL,'DUMMY',3100,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3101,NULL,'DUMMY',3101,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3102,NULL,'DUMMY',3102,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3103,NULL,'DUMMY',3103,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3104,NULL,'DUMMY',3104,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3105,NULL,'DUMMY',3105,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3106,NULL,'DUMMY',3106,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3107,NULL,'DUMMY',3107,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3108,NULL,'DUMMY',3108,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3109,NULL,'DUMMY',3109,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3110,NULL,'DUMMY',3110,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3111,NULL,'DUMMY',3111,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3112,NULL,'DUMMY',3112,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3113,NULL,'DUMMY',3113,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3114,NULL,'DUMMY',3114,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3115,NULL,'DUMMY',3115,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3116,NULL,'DUMMY',3116,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3117,NULL,'DUMMY',3117,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3118,NULL,'DUMMY',3118,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3119,NULL,'DUMMY',3119,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3120,NULL,'DUMMY',3120,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3121,NULL,'DUMMY',3121,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3122,NULL,'DUMMY',3122,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3123,NULL,'DUMMY',3123,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3124,NULL,'DUMMY',3124,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3125,NULL,'DUMMY',3125,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3126,NULL,'DUMMY',3126,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3127,NULL,'DUMMY',3127,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3128,NULL,'DUMMY',3128,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3129,NULL,'DUMMY',3129,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3130,NULL,'DUMMY',3130,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3131,NULL,'DUMMY',3131,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3132,NULL,'DUMMY',3132,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3133,NULL,'DUMMY',3133,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3134,NULL,'DUMMY',3134,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3135,NULL,'DUMMY',3135,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3136,NULL,'DUMMY',3136,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3137,NULL,'DUMMY',3137,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3138,NULL,'DUMMY',3138,1,'2025-05-23 06:01:04','2025-05-23 06:01:04'),
(3139,NULL,'DUMMY',3139,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3140,NULL,'DUMMY',3140,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3141,NULL,'DUMMY',3141,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3142,NULL,'DUMMY',3142,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3143,NULL,'DUMMY',3143,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3144,NULL,'DUMMY',3144,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3145,NULL,'DUMMY',3145,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3146,NULL,'DUMMY',3146,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3147,NULL,'DUMMY',3147,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3148,NULL,'DUMMY',3148,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3149,NULL,'DUMMY',3149,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3150,NULL,'DUMMY',3150,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3151,NULL,'DUMMY',3151,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3152,NULL,'DUMMY',3152,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3153,NULL,'DUMMY',3153,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3154,NULL,'DUMMY',3154,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3155,NULL,'DUMMY',3155,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3156,NULL,'DUMMY',3156,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3157,NULL,'DUMMY',3157,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3158,NULL,'DUMMY',3158,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3159,NULL,'DUMMY',3159,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3160,NULL,'DUMMY',3160,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3161,NULL,'DUMMY',3161,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3162,NULL,'DUMMY',3162,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3163,NULL,'DUMMY',3163,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3164,NULL,'DUMMY',3164,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3165,NULL,'DUMMY',3165,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3166,NULL,'DUMMY',3166,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3167,NULL,'DUMMY',3167,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3168,NULL,'DUMMY',3168,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3169,NULL,'DUMMY',3169,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3170,NULL,'DUMMY',3170,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3171,NULL,'DUMMY',3171,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3172,NULL,'DUMMY',3172,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3173,NULL,'DUMMY',3173,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3174,NULL,'DUMMY',3174,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3175,NULL,'DUMMY',3175,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3176,NULL,'DUMMY',3176,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3177,NULL,'DUMMY',3177,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3178,NULL,'DUMMY',3178,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3179,NULL,'DUMMY',3179,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3180,NULL,'DUMMY',3180,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3181,NULL,'DUMMY',3181,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3182,NULL,'DUMMY',3182,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3183,NULL,'DUMMY',3183,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3184,NULL,'DUMMY',3184,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3185,NULL,'DUMMY',3185,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3186,NULL,'DUMMY',3186,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3187,NULL,'DUMMY',3187,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3188,NULL,'DUMMY',3188,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3189,NULL,'DUMMY',3189,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3190,NULL,'DUMMY',3190,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3191,NULL,'DUMMY',3191,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3192,NULL,'DUMMY',3192,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3193,NULL,'DUMMY',3193,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3194,NULL,'DUMMY',3194,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3195,NULL,'DUMMY',3195,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3196,NULL,'DUMMY',3196,1,'2025-05-23 06:01:05','2025-05-23 06:01:05'),
(3197,NULL,'DUMMY',3197,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3198,NULL,'DUMMY',3198,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3199,NULL,'DUMMY',3199,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3200,NULL,'DUMMY',3200,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3201,NULL,'DUMMY',3201,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3202,NULL,'DUMMY',3202,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3203,NULL,'DUMMY',3203,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3204,NULL,'DUMMY',3204,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3205,NULL,'DUMMY',3205,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3206,NULL,'DUMMY',3206,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3207,NULL,'DUMMY',3207,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3208,NULL,'DUMMY',3208,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3209,NULL,'DUMMY',3209,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3210,NULL,'DUMMY',3210,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3211,NULL,'DUMMY',3211,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3212,NULL,'DUMMY',3212,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3213,NULL,'DUMMY',3213,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3214,NULL,'DUMMY',3214,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3215,NULL,'DUMMY',3215,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3216,NULL,'DUMMY',3216,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3217,NULL,'DUMMY',3217,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3218,NULL,'DUMMY',3218,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3219,NULL,'DUMMY',3219,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3220,NULL,'DUMMY',3220,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3221,NULL,'DUMMY',3221,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3222,NULL,'DUMMY',3222,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3223,NULL,'DUMMY',3223,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3224,NULL,'DUMMY',3224,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3225,NULL,'DUMMY',3225,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3226,NULL,'DUMMY',3226,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3227,NULL,'DUMMY',3227,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3228,NULL,'DUMMY',3228,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3229,NULL,'DUMMY',3229,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3230,NULL,'DUMMY',3230,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3231,NULL,'DUMMY',3231,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3232,NULL,'DUMMY',3232,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3233,NULL,'DUMMY',3233,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3234,NULL,'DUMMY',3234,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3235,NULL,'DUMMY',3235,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3236,NULL,'DUMMY',3236,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3237,NULL,'DUMMY',3237,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3238,NULL,'DUMMY',3238,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3239,NULL,'DUMMY',3239,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3240,NULL,'DUMMY',3240,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3241,NULL,'DUMMY',3241,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3242,NULL,'DUMMY',3242,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3243,NULL,'DUMMY',3243,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3244,NULL,'DUMMY',3244,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3245,NULL,'DUMMY',3245,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3246,NULL,'DUMMY',3246,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3247,NULL,'DUMMY',3247,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3248,NULL,'DUMMY',3248,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3249,NULL,'DUMMY',3249,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3250,NULL,'DUMMY',3250,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3251,NULL,'DUMMY',3251,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3252,NULL,'DUMMY',3252,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3253,NULL,'DUMMY',3253,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3254,NULL,'DUMMY',3254,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3255,NULL,'DUMMY',3255,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3256,NULL,'DUMMY',3256,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3257,NULL,'DUMMY',3257,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3258,NULL,'DUMMY',3258,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3259,NULL,'DUMMY',3259,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3260,NULL,'DUMMY',3260,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3261,NULL,'DUMMY',3261,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3262,NULL,'DUMMY',3262,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3263,NULL,'DUMMY',3263,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3264,NULL,'DUMMY',3264,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3265,NULL,'DUMMY',3265,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3266,NULL,'DUMMY',3266,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3267,NULL,'DUMMY',3267,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3268,NULL,'DUMMY',3268,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3269,NULL,'DUMMY',3269,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3270,NULL,'DUMMY',3270,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3271,NULL,'DUMMY',3271,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3272,NULL,'DUMMY',3272,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3273,NULL,'DUMMY',3273,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3274,NULL,'DUMMY',3274,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3275,NULL,'DUMMY',3275,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3276,NULL,'DUMMY',3276,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3277,NULL,'DUMMY',3277,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3278,NULL,'DUMMY',3278,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3279,NULL,'DUMMY',3279,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3280,NULL,'DUMMY',3280,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3281,NULL,'DUMMY',3281,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3282,NULL,'DUMMY',3282,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3283,NULL,'DUMMY',3283,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3284,NULL,'DUMMY',3284,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3285,NULL,'DUMMY',3285,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3286,NULL,'DUMMY',3286,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3287,NULL,'DUMMY',3287,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3288,NULL,'DUMMY',3288,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3289,NULL,'DUMMY',3289,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3290,NULL,'DUMMY',3290,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3291,NULL,'DUMMY',3291,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3292,NULL,'DUMMY',3292,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3293,NULL,'DUMMY',3293,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3294,NULL,'DUMMY',3294,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3295,NULL,'DUMMY',3295,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3296,NULL,'DUMMY',3296,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3297,NULL,'DUMMY',3297,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3298,NULL,'DUMMY',3298,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3299,NULL,'DUMMY',3299,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3300,NULL,'DUMMY',3300,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3301,NULL,'DUMMY',3301,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3302,NULL,'DUMMY',3302,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3303,NULL,'DUMMY',3303,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3304,NULL,'DUMMY',3304,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3305,NULL,'DUMMY',3305,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3306,NULL,'DUMMY',3306,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3307,NULL,'DUMMY',3307,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3308,NULL,'DUMMY',3308,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3309,NULL,'DUMMY',3309,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3310,NULL,'DUMMY',3310,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3311,NULL,'DUMMY',3311,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3312,NULL,'DUMMY',3312,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3313,NULL,'DUMMY',3313,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3314,NULL,'DUMMY',3314,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3315,NULL,'DUMMY',3315,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3316,NULL,'DUMMY',3316,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3317,NULL,'DUMMY',3317,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3318,NULL,'DUMMY',3318,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3319,NULL,'DUMMY',3319,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3320,NULL,'DUMMY',3320,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3321,NULL,'DUMMY',3321,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3322,NULL,'DUMMY',3322,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3323,NULL,'DUMMY',3323,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3324,NULL,'DUMMY',3324,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3325,NULL,'DUMMY',3325,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3326,NULL,'DUMMY',3326,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3327,NULL,'DUMMY',3327,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3328,NULL,'DUMMY',3328,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3329,NULL,'DUMMY',3329,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3330,NULL,'DUMMY',3330,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3331,NULL,'DUMMY',3331,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3332,NULL,'DUMMY',3332,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3333,NULL,'DUMMY',3333,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3334,NULL,'DUMMY',3334,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3335,NULL,'DUMMY',3335,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3336,NULL,'DUMMY',3336,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3337,NULL,'DUMMY',3337,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3338,NULL,'DUMMY',3338,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3339,NULL,'DUMMY',3339,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3340,NULL,'DUMMY',3340,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3341,NULL,'DUMMY',3341,1,'2025-05-23 06:01:06','2025-05-23 06:01:06'),
(3342,NULL,'DUMMY',3342,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3343,NULL,'DUMMY',3343,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3344,NULL,'DUMMY',3344,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3345,NULL,'DUMMY',3345,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3346,NULL,'DUMMY',3346,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3347,NULL,'DUMMY',3347,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3348,NULL,'DUMMY',3348,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3349,NULL,'DUMMY',3349,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3350,NULL,'DUMMY',3350,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3351,NULL,'DUMMY',3351,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3352,NULL,'DUMMY',3352,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3353,NULL,'DUMMY',3353,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3354,NULL,'DUMMY',3354,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3355,NULL,'DUMMY',3355,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3356,NULL,'DUMMY',3356,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3357,NULL,'DUMMY',3357,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3358,NULL,'DUMMY',3358,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3359,NULL,'DUMMY',3359,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3360,NULL,'DUMMY',3360,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3361,NULL,'DUMMY',3361,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3362,NULL,'DUMMY',3362,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3363,NULL,'DUMMY',3363,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3364,NULL,'DUMMY',3364,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3365,NULL,'DUMMY',3365,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3366,NULL,'DUMMY',3366,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3367,NULL,'DUMMY',3367,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3368,NULL,'DUMMY',3368,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3369,NULL,'DUMMY',3369,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3370,NULL,'DUMMY',3370,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3371,NULL,'DUMMY',3371,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3372,NULL,'DUMMY',3372,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3373,NULL,'DUMMY',3373,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3374,NULL,'DUMMY',3374,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3375,NULL,'DUMMY',3375,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3376,NULL,'DUMMY',3376,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3377,NULL,'DUMMY',3377,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3378,NULL,'DUMMY',3378,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3379,NULL,'DUMMY',3379,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3380,NULL,'DUMMY',3380,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3381,NULL,'DUMMY',3381,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3382,NULL,'DUMMY',3382,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3383,NULL,'DUMMY',3383,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3384,NULL,'DUMMY',3384,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3385,NULL,'DUMMY',3385,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3386,NULL,'DUMMY',3386,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3387,NULL,'DUMMY',3387,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3388,NULL,'DUMMY',3388,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3389,NULL,'DUMMY',3389,1,'2025-05-23 06:01:07','2025-05-23 06:01:07'),
(3390,NULL,'DUMMY',3390,1,'2025-05-23 06:01:07','2025-05-23 06:01:07');
/*!40000 ALTER TABLE `product_variations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `products` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `business_id` int(10) unsigned NOT NULL,
  `type` enum('single','variable','modifier','combo') DEFAULT NULL,
  `unit_id` int(10) unsigned DEFAULT NULL,
  `secondary_unit_id` int(11) DEFAULT NULL,
  `sub_unit_ids` text DEFAULT NULL,
  `brand_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `sub_category_id` int(10) unsigned DEFAULT NULL,
  `tax` int(10) unsigned DEFAULT NULL,
  `tax_type` enum('inclusive','exclusive') NOT NULL,
  `enable_stock` tinyint(1) NOT NULL DEFAULT 0,
  `alert_quantity` decimal(22,4) DEFAULT NULL,
  `sku` varchar(191) NOT NULL,
  `barcode_type` enum('C39','C128','EAN13','EAN8','UPCA','UPCE') DEFAULT 'C128',
  `expiry_period` decimal(4,2) DEFAULT NULL,
  `expiry_period_type` enum('days','months') DEFAULT NULL,
  `enable_sr_no` tinyint(1) NOT NULL DEFAULT 0,
  `weight` varchar(191) DEFAULT NULL,
  `product_custom_field1` varchar(191) DEFAULT NULL,
  `product_custom_field2` varchar(191) DEFAULT NULL,
  `product_custom_field3` varchar(191) DEFAULT NULL,
  `product_custom_field4` varchar(191) DEFAULT NULL,
  `product_custom_field5` varchar(191) DEFAULT NULL,
  `product_custom_field6` varchar(191) DEFAULT NULL,
  `product_custom_field7` varchar(191) DEFAULT NULL,
  `product_custom_field8` varchar(191) DEFAULT NULL,
  `product_custom_field9` varchar(191) DEFAULT NULL,
  `product_custom_field10` varchar(191) DEFAULT NULL,
  `product_custom_field11` varchar(191) DEFAULT NULL,
  `product_custom_field12` varchar(191) DEFAULT NULL,
  `product_custom_field13` varchar(191) DEFAULT NULL,
  `product_custom_field14` varchar(191) DEFAULT NULL,
  `product_custom_field15` varchar(191) DEFAULT NULL,
  `product_custom_field16` varchar(191) DEFAULT NULL,
  `product_custom_field17` varchar(191) DEFAULT NULL,
  `product_custom_field18` varchar(191) DEFAULT NULL,
  `product_custom_field19` varchar(191) DEFAULT NULL,
  `product_custom_field20` varchar(191) DEFAULT NULL,
  `image` varchar(191) DEFAULT NULL,
  `product_description` text DEFAULT NULL,
  `created_by` int(10) unsigned NOT NULL,
  `preparation_time_in_minutes` int(11) DEFAULT NULL,
  `warranty_id` int(11) DEFAULT NULL,
  `is_inactive` tinyint(1) NOT NULL DEFAULT 0,
  `not_for_selling` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `products_brand_id_foreign` (`brand_id`),
  KEY `products_category_id_foreign` (`category_id`),
  KEY `products_sub_category_id_foreign` (`sub_category_id`),
  KEY `products_tax_foreign` (`tax`),
  KEY `products_name_index` (`name`),
  KEY `products_business_id_index` (`business_id`),
  KEY `products_unit_id_index` (`unit_id`),
  KEY `products_created_by_index` (`created_by`),
  KEY `products_warranty_id_index` (`warranty_id`),
  KEY `products_type_index` (`type`),
  KEY `products_tax_type_index` (`tax_type`),
  KEY `products_barcode_type_index` (`barcode_type`),
  KEY `products_secondary_unit_id_index` (`secondary_unit_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3391 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `products` WRITE;
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` VALUES
(1,'AAC1408 Auto air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AAC1408','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:39','2025-05-23 06:00:39'),
(2,'AAC1601 Auto air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AAC1601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:39','2025-05-23 06:00:39'),
(3,'AAC2508 Auto air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AAC2508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:39','2025-05-23 06:00:39'),
(4,'AB4018 Aspirator blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AB4018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(5,'AB4038 Aspirator blower 400W new model',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AB4038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(6,'AB6008 Air Blower 600w - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AB6008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(7,'AB6038 Aspirator blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AB6038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(8,'AB8008 Aspirator blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AB8008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(9,'AB8038 Aspirator Blower 800W',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AB8038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(10,'ABCB05 Brush cutter blade',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ABCB05','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(11,'ABG031 Air blow gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ABG031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(12,'ABH10601 Screwdriver bit holder - P25C100',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ABH10601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(13,'ABH20601 Screwdriver bit holder with release',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ABH20601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(14,'ABH60501 Square to Hex Adapter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ABH60501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(15,'AC1200508 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC1200508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(16,'AC1301008 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC1301008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(17,'AC202411 Air compressors 24L',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC202411','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(18,'AC20248 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC20248','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(19,'AC255011 Air Compressor 50L',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC255011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(20,'AC25508 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC25508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(21,'AC300508 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC300508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(22,'AC301008 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC301008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(23,'AC402001 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC402001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(24,'AC553001 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC553001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(25,'AC755001 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AC755001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(26,'ACN18641 Air concrete nailer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACN18641','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(27,'ACN50401 2 In 1 combo brad nailer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACN50401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(28,'ACS111152 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACS111152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(29,'ACS111242 Air compressor 24L 1.5hp oil free',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACS111242','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(30,'ACS112501 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACS112501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(31,'ACS175406 Silent and oil free air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACS175406','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(32,'ACS215506 Silent and oil free air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACS215506','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(33,'ACS2241001 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACS2241001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(34,'ACS4481501 Air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ACS4481501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(35,'AG10108 Angle Grinder 1010w New Model - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG10108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(36,'AG10108-5 Angle grinder 1010w - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG10108-5','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(37,'AG110018 Angle grinder 1100w - P1C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG110018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(38,'AG110028 Angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG110028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(39,'AG110038 Angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG110038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(40,'AG1100385 Angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG1100385','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(41,'AG130018 Angle grinder 1300w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG130018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(42,'AG150018 Angle grinder 1500w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG150018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(43,'AG200018 Angle grinder 2000w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG200018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(44,'AG220018 Angle grinder 2200w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG220018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(45,'AG24008 Angle grinder 2400w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG24008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(46,'AG24008-1 Angle Grinder 2400w with BMC - C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG24008-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(47,'AG26008 Angle grinder 2600w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG26008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(48,'AG30008 Angle grinder 3000w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG30008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(49,'AG71038 Angle grinder 710w - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG71038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(50,'AG75028 Angle grinder 750w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG75028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(51,'AG85038 Angle grinder 850w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG85038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(52,'AG8508-1 Angle Grinder 950w with BMC - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG8508-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(53,'AG90028 Angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG90028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(54,'AG900285 Angle grinder 900w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG900285','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(55,'AG9608 Angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AG9608','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(56,'AGL02301 Air grease lubricator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGL02301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(57,'AGL02451 Air grease lubricator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGL02451','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(58,'AGSB1805 Chain Saw Bar 18\" - Old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB1805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(59,'AGSB2241 Chain saw bar 24\" - old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB2241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(60,'AGSB50501 Chain saw bar',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB50501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(61,'AGSB50801 Chain saw bar',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB50801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(62,'AGSB51001 Chain saw bar',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB51001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(63,'AGSB51201 Chain saw bar',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB51201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(64,'AGSB51603 Chain saw bar',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB51603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(65,'AGSB51801 Chain saw bar',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB51801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(66,'AGSB52401 Chain saw bar',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSB52401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(67,'AGSC1805 Saw Chain 18\" - Old - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC1805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(68,'AGSC2241 Saw chain 24\" - Old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC2241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(69,'AGSC50501 Saw chain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC50501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(70,'AGSC50801 Saw chain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC50801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(71,'AGSC51001 Saw chain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC51001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(72,'AGSC51201 Saw chain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC51201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(73,'AGSC51603 Saw chain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC51603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(74,'AGSC51801 Saw chain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC51801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(75,'AGSC52401 Saw chain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGSC52401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(76,'AGW150361 Grinding Wheel 6\" 36 Grit - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGW150361','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(77,'AGW1506023 Bench grinding wheel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGW1506023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(78,'AGW150801 Grinding Wheel 6\" 80 Grit - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGW150801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(79,'AGW200361 Grinding Wheel 8\" 36 Grit - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGW200361','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(80,'AGW200801 Grinding Wheel 8\" 80 Grit - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGW200801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(81,'AGW2008016 Bench grinding wheel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGW2008016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(82,'AGW2008017 Bench grinding wheel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AGW2008017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(83,'AH1051 Air hose',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AH1051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(84,'AH1101 Air Hose 10m',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AH1101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(85,'AH1151 Air Hose 15m',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AH1151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(86,'AHM006 Auto-darkening welding helmet',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AHM006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(87,'AHM008 Auto-darkening welding helmet',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AHM008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(88,'AHM009 Auto-darkening welding helmet',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AHM009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(89,'AHM112 Auto-darkening welding goggle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AHM112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(90,'AHPH5028 High pressure hose(Quick connector)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AHPH5028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(91,'AHPH7511 Pipe cleaning hose',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AHPH7511','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(92,'AIW11222 Air impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AIW11222','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(93,'AIW11223 Air impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AIW11223','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(94,'AIW12562 Air impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AIW12562','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(95,'AIW341302 Air impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AIW341302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(96,'AKB0501 Accessories for die grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKB0501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(97,'AKB0502 Accessories for die grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKB0502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(98,'AKB1012 Accessories for  mini grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKB1012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(99,'AKD2052 5 Pcs SDS plus hammer drill bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKD2052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(100,'AKD2101 10 Pcs hammer drill bits and chisels set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKD2101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(101,'AKD2688 Drill bits display box',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKD2688','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(102,'AKD41301 13 Pcs flat wood drill bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKD41301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(103,'AKD5075 7 Pcs SDS max hammer drill bit and chisel set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKD5075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(104,'AKD7058 5 Pcs glass drill bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKD7058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(105,'AKD8088 8 Pcs jig saw blades set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKD8088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(106,'AKDB0801 8 Pcs HSS twist drill bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDB0801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(107,'AKDB1065 6PCS HSS twist drill bits set - P40C80',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDB1065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(108,'AKDB1125 12 Pcs HSS twist drill bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDB1125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(109,'AKDB3055 5 Pcs masonry drill bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDB3055','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(110,'AKDB5055 5 Pcs wood drill bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDB5055','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(111,'AKDB9190 19Pcs HSS twist drill bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDB9190','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(112,'AKDL1201 12 Pcs flat wood drill bits set 152mm - P6C12',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDL1201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(113,'AKDL12201 22 Pcs drill bits and screwdriver bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDL12201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(114,'AKDL31101 11PCS Masonry and hammer drill bits set - P6C12',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDL31101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(115,'AKDL51501 15pcs HSS drill bits set - P6C12',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKDL51501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(116,'AKFS140102 Sanding sheet set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKFS140102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(117,'AKFS145115 Sanding sheet set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKFS145115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(118,'AKFS240101-1 Sanding sheet set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKFS240101-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(119,'AKFS2401012 Sanding sheet set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKFS2401012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(120,'AKFS2641151 Sanding sheet set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKFS2641151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(121,'AKH0071 Bi-metal hole saw set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKH0071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(122,'AKH0121 Bi-metal Hole saw 12 pcs SET - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKH0121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(123,'AKH0132 Bi-metal hole saw set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKH0132','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(124,'AKHS04065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS04065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(125,'AKHS06065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS06065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(126,'AKHS08065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS08065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(127,'AKHS10065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS10065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(128,'AKHS12065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS12065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(129,'AKHS15065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS15065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(130,'AKHS18065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS18065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(131,'AKHS24065 sandpaper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS24065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(132,'AKHS702 Hole saw set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKHS702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(133,'AKISD0201 2 In 1 screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKISD0201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(134,'AKISD0901 9 Pcs interchangeable screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKISD0901','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(135,'AKISD1208 13 In 1 ratchet screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKISD1208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(136,'AKMG2501 250 Pcs Accessories for Mini Drill - P5C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKMG2501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(137,'AKMG4208 Accessories of mini drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKMG4208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(138,'AKMG7072 General use set for mini drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKMG7072','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(139,'AKRS125101 Purple sanding disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRS125101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(140,'AKRS150051 Sanding sheet for random orbital sander',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRS150051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(141,'AKRS150103 Purple sanding disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRS150103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(142,'AKRT1201 12 Pcs router bits set(6mm)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRT1201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(143,'AKRT1211 12 Pcs router bits set(8mm)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRT1211','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(144,'AKRT1221 12 Pcs router bits set(12mm)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRT1221','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(145,'AKRT24061 24 Pcs Router bits set 6mm - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRT24061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(146,'AKRT24081 24 Pcs Router bits set 8mm - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKRT24081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(147,'AKSD0071 9 Pcs screwdriver bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKSD0071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(148,'AKSD08301 30 Pcs screwdriver bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKSD08301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(149,'AKSDB1901 19 Pcs drill bits & screwdriver bits set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKSDB1901','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(150,'AKSDB9165 16PCS drill bits & screwdriver bits set - P20C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKSDB9165','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(151,'AKSDFL1208 12 Pcs flexible shaft screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKSDFL1208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(152,'AKSDS0301 3 Pcs step drill bit set - C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKSDS0301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(153,'AKSDS2061 Step drill bit set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKSDS2061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(154,'AKT0053 5 Pcs air tools  set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKT0053','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(155,'AKTGS2061 Glue gun stick',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKTGS2061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(156,'AKTGS3011 Glue gun stick',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKTGS3011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:40','2025-05-23 06:00:40'),
(157,'AKTMT1502 Multi tool blade set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKTMT1502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(158,'AKTMT2301 Multi tool blade 23pcs set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AKTMT2301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(159,'ALS1601 Line spool for Grass trimmer - C50',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ALS1601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(160,'ALS1602 Line spool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ALS1602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(161,'ALS2001 Trimmer line',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ALS2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(162,'ALS25405 Line spool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ALS25405','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(163,'AMAN4501 45º Angle nozzle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMAN4501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(164,'AMFP4002 Foam producer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMFP4002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(165,'AMGF0501 Clean maintenance kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMGF0501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(166,'AMGF0702 Painting tools accesories',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMGF0702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(167,'AMHB2791 Horizontal brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMHB2791','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(168,'AMN65061 6 Pcs impact magnetic nut set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMN65061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(169,'AMSG028 Spray gun(Quick connector)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMSG028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(170,'AMWB1781 Wheel brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMWB1781','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(171,'AMWH6001 6 Pcs magnetic welding holder set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AMWH6001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(172,'ANA01181 Concrete nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA01181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(173,'ANA01251 Concrete nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA01251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(174,'ANA01381 Concrete nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA01381','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(175,'ANA01641 Concrete nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA01641','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(176,'ANA06825 Headless pins',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA06825','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(177,'ANA12018 Concrete nail 18mm for  CSTLI3805',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA12018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(178,'ANA18201 Brad nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA18201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(179,'ANA18301 Brad nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA18301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(180,'ANA18356 Brad nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA18356','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(181,'ANA18401 Brad nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA18401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(182,'ANA18506 Brad nail',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ANA18506','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(183,'AP140016 Polisher',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AP140016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(184,'AP140028 Polisher',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AP140028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(185,'AP14008 Angle polisher 1400w - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AP14008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(186,'APB0111801 Wool polishing bonnet',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'APB0111801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(187,'APB30160 Pool brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'APB30160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(188,'APLI2001 Cordless Polisher 20v - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'APLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(189,'APLI20151 Cordless polisher 20V 6\" + Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'APLI20151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(190,'APLI20181 Cordless polisher 7\" 20V + Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'APLI20181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(191,'APP0111801 Polishing pad with flange',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'APP0111801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(192,'APS1501 Air Sander - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'APS1501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(193,'ASE106 6 Pcs screw extractor set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASE106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(194,'ASG1061 Air spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASG1061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(195,'ASG1065 Air spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASG1065','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(196,'ASG2101 HVLP air spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASG2101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(197,'ASG3101 Air spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASG3101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(198,'ASG3102 Air spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASG3102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(199,'ASG4041 Air spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASG4041','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(200,'ASG4042 Air spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ASG4042','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(201,'AST18351 Crown staple',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AST18351','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(202,'ATG0601 Air tire inflating gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ATG0601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(203,'AWG1001 Air washing gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'AWG1001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(204,'BAS3502 Band saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BAS3502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(205,'BG61502 Bench grinder 150w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BG61502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(206,'BG83502 Bench grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BG83502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(207,'BJ9508 Biscuit Jointer 950w P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BJ9508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(208,'BM2S180017 Mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BM2S180017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(209,'BM2S18004 Mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BM2S18004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(210,'BM2S24001 Mitre saw 2400w - old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BM2S24001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(211,'BM2S24007 Mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BM2S24007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(212,'BMIS16002 Mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BMIS16002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(213,'BMS14002 Mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BMS14002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(214,'BMS14007 Mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BMS14007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(215,'BMS18001 Mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BMS18001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(216,'BMS18007 Mitre saw 1800w- 10\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BMS18007','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(217,'BSP020801 Sanding sheet 2pcs set for PBS12001',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'BSP020801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(218,'CABLI2001 L-I aspirator blower 20v - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(219,'CABLI20018 Cordless blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI20018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(220,'CABLI200181 Cordless blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI200181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(221,'CABLI2002 L-I Blower 20v - P1C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(222,'CABLI20028 Cordless blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI20028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(223,'CABLI200281 Cordless blower 20V 1 Speed + Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI200281','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(224,'CABLI200282 Cordless blower 20V 1 Speed + 2 Battery - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI200282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(225,'CABLI20323 Cordless blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI20323','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(226,'CABLI203235 Cordless blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI203235','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(227,'CABLI20428 Cordless blower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CABLI20428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(228,'CACLI2001 L-I auto air compressor 20v - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CACLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(229,'CACLI2002 Cordless auto air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CACLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(230,'CACLI2003 Cordless air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CACLI2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(231,'CACLI2018 Cordless auto air compressor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CACLI2018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(232,'CAGLI1151 L-I angle grinder 20v - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI1151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(233,'CAGLI1152 L-I Angle Grinder 20v Brushless -C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI1152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(234,'CAGLI201158 Cordless angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI201158','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(235,'CAGLI201258 Cordless angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI201258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(236,'CAGLI20157 Lithium-ion angle grinder 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI20157','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(237,'CAGLI211156 Cordless angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI211156','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(238,'CAGLI2111561 Cordless angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI2111561','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(239,'CAGLI21154 Cordless angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI21154','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(240,'CAGLI211541 Cordless angle grinder with variable speed controller',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI211541','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(241,'CAGLI211542 Cordless angle grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI211542','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(242,'CAGLI271532 Cordless angle grinder 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI271532','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(243,'CAGLI76012 Cordless mini cut-off tool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CAGLI76012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(244,'CBNLI2002 Cordless Brad Nailer Kit 20v - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CBNLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(245,'CBNLI2008 Cordless brad nailer 20V 35mm + Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CBNLI2008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(246,'CBNLI3505 Cordless brad nailer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CBNLI3505','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(247,'CBNLI3508 Cordless brad nailer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CBNLI3508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(248,'CBNLI3606 Cordless pin nailer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CBNLI3606','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(249,'CBNLI5008 Cordless brad nailer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CBNLI5008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(250,'CBSLI20127 Cordless band saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CBSLI20127','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(251,'CCVLI2023011 Cordless concrete vibrator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CCVLI2023011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(252,'CCVLI2023013 Cordless Concrete Vibrator 20v - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CCVLI2023013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(253,'CDLI12202 Cordless drill 12v Type-C + 2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI12202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(254,'CDLI1232 L-I cordless drill 12v with BMC - P1C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI1232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(255,'CDLI12325 Cordless Drill 12V - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI12325','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(256,'CDLI1241 L-I cordless drill 12v - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI1241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(257,'CDLI12428 Cordless drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI12428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(258,'CDLI16682 Compact brushless cordless drill 16v 60Nm+ 2 Batteries',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI16682','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(259,'CDLI20012 Cordless Drill 20v with 1.5Ah Batteries - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(260,'CDLI2002 Cordless drill 20v ind with bag - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(261,'CDLI20021 L-I cordless drill 20v - ind - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(262,'CDLI200215 Cordless Drill 20v - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI200215','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(263,'CDLI20024 L-I cordless drill 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20024','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(264,'CDLI20025 L-I cordless drill 20v with bag - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(265,'CDLI20028 Lithium-ion cordless drill 20v - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(266,'CDLI2003 L-I cordless drill 20v with BMC - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(267,'CDLI200515 Cordless drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI200515','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(268,'CDLI200518 Lithium-Ion Cordless drill 20V 45Nm +Battery in Carton Box',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI200518','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(269,'CDLI200528 Lithium-Ion cordless drill 20V 45Nm + 2 Battery - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI200528','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(270,'CDLI20453 Brushless cordless drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20453','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(271,'CDLI204531 Brushless cordless drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI204531','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(272,'CDLI205582 Cordless Drill 20V 55Nm +Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI205582','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(273,'CDLI20602 Compact Brushless Cordless Drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(274,'CDLI206021 Compact Brushless Cordless Drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI206021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(275,'CDLI20668 Cordless Drill 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CDLI20668','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(276,'CES1301 Lithium-Ion scale 12V 30Kg - C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CES1301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(277,'CES1302 Lithium-Ion scale USB-C 12V 100Kg',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CES1302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(278,'CES1303 Cordless scale',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CES1303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(279,'CFALI2001 Cordless fan',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CFALI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(280,'CFALI2002 Cordless fan',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CFALI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(281,'CFP027K Cordless food processor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CFP027K','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(282,'CGGLI2001 Cordless glue gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGGLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(283,'CGSLI2001 L-I chain saw 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGSLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(284,'CGSLI20128 Cordless chain saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGSLI20128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(285,'CGSLI2058 Cordless pruner saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGSLI2058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(286,'CGSLI20682 Cordless Mini Chainsaw 20v - 6\" - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGSLI20682','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(287,'CGSLI20851 Cordless chain saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGSLI20851','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(288,'CGSLI40168 Cordless chain saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGSLI40168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(289,'CGSLI401682 Cordless chain saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGSLI401682','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(290,'CGTLI2001 L-I grass trimmer 20v - C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGTLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:41','2025-05-23 06:00:41'),
(291,'CGTLI20018 Cordless grass trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGTLI20018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(292,'CGTLI20328 Cordless grass trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGTLI20328','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(293,'CGTLI203285 Cordless grass trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGTLI203285','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(294,'CGW011151 Diamond cup wheels',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGW011151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(295,'CGW011251 Diamond cup wheels 5\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGW011251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(296,'CGW011501 Diamond cup wheels',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGW011501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(297,'CGW021151 Diamond cup wheels',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGW021151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(298,'CGW021251 Diamond cup wheels',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGW021251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(299,'CGW021501 Diamond cup wheels',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CGW021501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(300,'CHB048K Cordless hand blender',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHB048K','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(301,'CHPTB0101 Paint brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB0101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(302,'CHPTB0102 Paint brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB0102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(303,'CHPTB0103 Paint brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB0103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(304,'CHPTB0114091 9 Pcs paint brush set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB0114091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(305,'CHPTB68704 Paint brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB68704','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(306,'CHPTB78601 Paint brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB78601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(307,'CHPTB78601201 12 Pcs paint brush set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB78601201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(308,'CHPTB78602 Paint brush 2\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB78602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(309,'CHPTB78603 Paint brush 3\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB78603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(310,'CHPTB7860301 3 Pcs paint brush set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB7860301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(311,'CHPTB78604 Paint brush 4\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB78604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(312,'CHPTB7860801 8 Pcs paint brush set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB7860801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(313,'CHPTB78615 Paint brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB78615','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(314,'CHPTB78625 Paint brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHPTB78625','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(315,'CHTLI2001 Cordless Hedge Trimmer 20v - Old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHTLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(316,'CHTLI20018 Cordless hedge trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHTLI20018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(317,'CHTLI40028 Cordless hedge trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHTLI40028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(318,'CHTLI400282 Cordless hedge trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CHTLI400282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(319,'CIDLI12201 Lithium-ion impact drill 12V - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI12201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(320,'CIDLI12202 Cordless impact drill 12v USB-C + 2 Battery & Charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI12202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(321,'CIDLI1228 Cordless impact drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI1228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(322,'CIDLI1232 Cordless Impact Drill 12v - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI1232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(323,'CIDLI12328 Lithium-Ion impact drill 12V with BMC - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI12328','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(324,'CIDLI2002 Cordless impact drill 20v ind with bag - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(325,'CIDLI200215 Cordless impact drill 20v - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI200215','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(326,'CIDLI20025 L-I Impact Drill 20v with Bag - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(327,'CIDLI2003 L-I impact drill 20v with BMC - P1C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(328,'CIDLI20031 Cordless Drill 20v with BMC - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(329,'CIDLI201452 Cordless impact drill 20V 2 Batteries',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI201452','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(330,'CIDLI201455 Cordless impact drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI201455','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(331,'CIDLI20508 Lithium-Ion Brushless cordless impact drill 20V 2 Batteries',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(332,'CIDLI20558 Cordless Impact Drill 20V 55Nm + 2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20558','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(333,'CIDLI20602 Lithium-Ion compact brushless impact drill 20V + 2 Battery & Charger - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(334,'CIDLI206021 Compact Brushless Cordless Impact Drill 20V 60Nm - P1C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI206021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(335,'CIDLI20605 Lithium-Ion brushless impact drill 20V 70Nm - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20605','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(336,'CIDLI20608 Brushless Impact Drill 20v - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20608','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(337,'CIDLI20668 Cordless Impact Drill 20V 66Nm + 2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20668','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(338,'CIDLI20968 Cordless Impact Drill 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIDLI20968','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(339,'CIRLI12015 Cordless impact driver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIRLI12015','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(340,'CIRLI16178 Cordless impact driver 16V 170Nm + 2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIRLI16178','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(341,'CIRLI2002 Cordless impact driver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIRLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(342,'CIRLI20020 Cordless impact driver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIRLI20020','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(343,'CIRLI2017 Lithium-ion impact driver - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIRLI2017','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(344,'CIRLI2028 Cordless impact driver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIRLI2028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(345,'CIWLI2001 Cordless impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(346,'CIWLI20208 Cordless impact driver&wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI20208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(347,'CIWLI2038 Cordless impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI2038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(348,'CIWLI2040 Cordless impact wrench 20V + 2 Batteries',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI2040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(349,'CIWLI2050 Cordless impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI2050','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(350,'CIWLI20501 Cordless impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI20501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(351,'CIWLI2085 Cordless impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI2085','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(352,'CIWLI20851 Cordless impact wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CIWLI20851','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(353,'CJB052K Cordless stand blender',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CJB052K','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(354,'CJRLI2001 Cordless Radio - C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CJRLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(355,'CJSLI1008 Cordless jig saw 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CJSLI1008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(356,'CJSLI65081 Lithium-ion jig saw 20V + Battery - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CJSLI65081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(357,'CJSLI8501 Cordless jig saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CJSLI8501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(358,'CKLI1628 Cordless 2 pcs combo kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI1628','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(359,'CKLI2006 Cordless Combo Kit Drill & Impact Driver - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI2006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(360,'CKLI2008 Cordless Drill & Rotary Hammer Set - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI2008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(361,'CKLI2009 Cordless Drill and Angle Grinder Set - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI2009','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(362,'CKLI2010 Cordless 4 Pcs Combo Kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI2010','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(363,'CKLI2019 5 Pcs Cordless industrial combo kit 20V + 2 Battery - P1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI2019','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(364,'CKLI20271 Cordless 2 pcs combo kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI20271','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(365,'CKLI20272 Cordless 2 pcs combo kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI20272','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(366,'CKLI20273 Cordless 2 pcs combo kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI20273','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(367,'CKLI20275 Cordless 20V Impact Drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI20275','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(368,'CKLI2058 5 Pcs Cordless industrial combo kit 20V + 2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI2058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(369,'CKLI2098 9 Pcs cordless industrial combo kit 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CKLI2098','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(370,'CMGLI12011 Cordless Mini Grinder 12v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CMGLI12011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(371,'CMGLI20011 Cordless grinder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CMGLI20011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(372,'CMLI2001 Cordless Multi-Tool 20v - C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CMLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(373,'CMLI20228 Cordless multi-tool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CMLI20228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(374,'CMS2001 Cordless mitre saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CMS2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(375,'COPLI2001 Cordless polisher',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COPLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(376,'COS223558 Cut off saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS223558','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(377,'COS223589 Cut off saw 2200w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS223589','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(378,'COS23090 5 Pcs Tools bag set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS23090','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(379,'COS23093 Hand saw 3pcs set 16\" 18\" 20\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS23093','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(380,'COS23095 8 Pcs welding machine 160A @ 30% tools set - P1C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS23095','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(381,'COS243558 Cut off saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS243558','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(382,'COS35538 Cut off saw 2350w - C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS35538','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(383,'COS4051 Cut off saw 3000w - C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COS4051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(384,'COSLI23048 Cordless Impact Wrench 20V 400Nm + 2 Battery + Socket Set + Work Lamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI23048','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(385,'COSLI230521 3pcs cordless set Rotary Hammer & Angle Grinder & Impact Driver 20V - C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI230521','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(386,'COSLI230701 P20S Lithium-Ion battery and charger kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI230701','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(387,'COSLI230703 Cordless 2 Pcs combo kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI230703','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(388,'COSLI23114 Cordless impact drill 12V + 2 Battery + Accessories - P1C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI23114','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(389,'COSLI240201 Heat gun combo kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(390,'COSLI240202 Cordless Rotary Hammer + Impact drill + angle grinder 20v + 2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(391,'COSLI240203 Cordless Blower + Grass Trimmer 20V + 2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(392,'COSLI240208 Cordless rotary hammer 20V 22mm + Battery + FREE Hand Blender 11V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(393,'COSLI240311 3 pcs Battery 20V 2Ah',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240311','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(394,'COSLI240312 2 x battery kit 20V 4Ah',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240312','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(395,'COSLI240315 Cordless drill 20V + 2 battery + FREE coffee grinder 4V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240315','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(396,'COSLI240464 P20S Lithium-Ion battery kit 2x5Ah - P5C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240464','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(397,'COSLI240786 Cordless drill 16V 60Nm + 2 Battery + 11 pcs Cleaning brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240786','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(398,'COSLI240866 Cordless 20v circular saw 7.25\" + brad nailer 35mm +2 Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'COSLI240866','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(399,'CPHT2016012 Cordless pole hedge trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPHT2016012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(400,'CPM15008 Water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPM15008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(401,'CPM3708 Water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPM3708','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(402,'CPM7508 Water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPM7508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(403,'CPSLI2014 Cordless palm sander',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPSLI2014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(404,'CPTS201681 Cordless pole saw with pole hedge trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPTS201681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(405,'CPWLI2008 Cordless pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPWLI2008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(406,'CPWLI20082 Cordless pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPWLI20082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(407,'CPWLI20362 Cordless pressure washer 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPWLI20362','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(408,'CPWLI4006 Cordless pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CPWLI4006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(409,'CRCLI2002 Cordless hydraulic cable cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRCLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(410,'CRHLI1601 Cordless Rotary hammer 20V - 16mm - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI1601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(411,'CRHLI20168 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI20168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(412,'CRHLI201681 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI201681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(413,'CRHLI20208 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI20208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(414,'CRHLI202081 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI202081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(415,'CRHLI20228 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI20228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(416,'CRHLI202287 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI202287','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:42','2025-05-23 06:00:42'),
(417,'CRHLI202289 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI202289','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(418,'CRHLI20288 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI20288','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(419,'CRHLI202882 Cordless rotary hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI202882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(420,'CRHLI2201 Cordless Rotary Hammer 20V - 22mm - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI2201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(421,'CRHLI22012 Cordless Rotary Hammer Set 20v - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRHLI22012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(422,'CRSLI6508 Cordless reciprocating saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CRSLI6508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(423,'CS18528 Circular saw 1400w - P1C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CS18528','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(424,'CS18538 Circular saw 7\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CS18538','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(425,'CS18568 Circular saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CS18568','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(426,'CS23522 Circular saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CS23522','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(427,'CS2358 Circular saw 2200w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CS2358','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(428,'CSDLI0401 L-I cordless screwdriver 4v - P10C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI0401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(429,'CSDLI0402 Cordless Screwdriver 4V P10C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI0402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(430,'CSDLI0403 Lithium-Ion cordless screwdriver - P10C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI0403','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(431,'CSDLI0406 Lithium-Ion cordless screwdriver 4V USB-C - C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI0406','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(432,'CSDLI04062 Cordless screwdriver 4V 5Nm USB-C',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI04062','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(433,'CSDLI0442 Cordless screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI0442','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(434,'CSDLI04425 Cordless screwdriver 4V 4Nm Type-C',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI04425','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(435,'CSDLI0801 L-I cordless screwdriver 8v - P1C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI0801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(436,'CSDLI0802 Cordless screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI0802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(437,'CSDLI08025 Cordless screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSDLI08025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(438,'CSGLI2001 L-I spray gun 20v - C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSGLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(439,'CSGLI2003 Cordless spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSGLI2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(440,'CSGLI2004 Cordless spray gun 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSGLI2004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(441,'CSGLI20406 Cordless spray gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSGLI20406','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(442,'CSHSLI2014 Cordless sheet sander',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSHSLI2014','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(443,'CSLI1401 Cordless Circular Saw 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSLI1401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(444,'CSLI1402 Cordless circular saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSLI1402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(445,'CSLI14021 Cordless circular saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSLI14021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(446,'CSLI1651 Cordless Circular Saw 20v\'',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSLI1651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(447,'CSLI16521 Cordless circular saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSLI16521','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(448,'CSLI1851 Cordless circular saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSLI1851','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(449,'CSLI18511 Cordless circular saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSLI18511','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(450,'csli18513 cordless circular 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'csli18513','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(451,'CSPLI2001 Cordless Sprayer 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSPLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(452,'CSPLI20162 Cordless knapsack sprayer 20V 16L + Battery',1,'single',1,NULL,NULL,1,NULL,NULL,NULL,'exclusive',1,0.0000,'CSPLI20162','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(453,'CSSLI20258 Lithium-Ion gauge straight shear 20V - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSSLI20258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(454,'CSSLI202581 Cordless gauge straight shear 20V + Battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSSLI202581','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(455,'CSTLI20018 Cordless string trimmer and brush cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSTLI20018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(456,'CSTLI202522 Cordless string trimmer and brush cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSTLI202522','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(457,'CSTLI3805 Cordless brick nailer 20V 18mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSTLI3805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(458,'CSTLI3808 Cordless brick nailer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CSTLI3808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(459,'CTLI2002 Cordless hydraulic crimping tool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CTLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(460,'CTVLI20101 Cordless tile vibration machine',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CTVLI20101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(461,'CVLI2001 L-I Vacuum Cleaner 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CVLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(462,'CVLI2005E Lithium-Ion Vacuum Cleaner 20V',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CVLI2005E','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(463,'CVLI201261 Cordless vacuum cleaner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CVLI201261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(464,'CVLI2026 Lithium-ion vacuum cleaner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CVLI2026','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(465,'CWLI1201 L-I flashlight 12v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CWLI1201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(466,'CWLI2001 L-I work lamp 20v',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CWLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(467,'CWLI2002 L-I floodlight 20v - P1C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CWLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(468,'CWLI2025 Cordless portable lamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'CWLI2025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(469,'DBBPL0802 Heavy duty brass block padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBBPL0802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(470,'DBBPL0902 Heavy duty brass block padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBBPL0902','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(471,'DBC0112501 SDS plus chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0112501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(472,'DBC0122501 SDS plus chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0122501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(473,'DBC0122502 SDS plus chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0122502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(474,'DBC0214001 SDS max chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0214001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(475,'DBC0224001 SDS max chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0224001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(476,'DBC0224002 SDS max chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0224002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(477,'DBC0304375 Hex chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0304375','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(478,'DBC0314101 Hex chisel 30X 410mm pointed - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0314101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(479,'DBC0324102 Hex chisel 30 X410X 40mm Flat - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0324102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(480,'DBC0324103 Hex chisel 30x410x100mm flat - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0324103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(481,'DBC03340011 Hex chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC03340011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(482,'DBC03440012 Hex chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC03440012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(483,'DBC03440013 Hex chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC03440013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(484,'DBC0415301 Hex chisel 28X 530mm pointed P5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0415301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(485,'DBC0425302 Hex chisel 28X35X 530mm - flat - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0425302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(486,'DBC04352011 Hex chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC04352011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(487,'DBC04352012 Hex chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC04352012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(488,'DBC0512801 Hex chisel 17*280mm-pointed',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0512801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(489,'DBC0522801 Hex chisel 17*280*22mm-flat',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBC0522801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(490,'DBCK0303 3 Digit brass combination padlock 3x30mm - P12C72',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBCK0303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(491,'DBH1210601 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(492,'DBH1210602 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(493,'DBH1210602C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210602C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(494,'DBH1210603 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(495,'DBH1210603C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210603C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(496,'DBH1210604 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(497,'DBH1210801 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(498,'DBH1210802 SDS plus hammer drill 8*160mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(499,'DBH1210802C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210802C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(500,'DBH1210803C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210803C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(501,'DBH1210804 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(502,'DBH1210804C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1210804C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(503,'DBH1211002 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(504,'DBH1211002C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211002C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(505,'DBH1211003 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(506,'DBH1211003C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211003C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(507,'DBH1211004 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(508,'DBH1211004C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211004C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(509,'DBH1211201 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(510,'DBH1211201C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211201C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(511,'DBH1211202 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(512,'DBH1211202C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211202C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(513,'DBH1211203 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(514,'DBH1211402 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(515,'DBH1211403 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211403','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(516,'DBH1211403C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211403C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(517,'DBH1211404 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(518,'DBH1211404C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211404C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(519,'DBH1211602 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(520,'DBH1211603 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(521,'DBH1211604 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(522,'DBH1211604C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211604C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:43','2025-05-23 06:00:43'),
(523,'DBH1211801 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(524,'DBH1211803C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211803C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(525,'DBH1211804 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1211804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(526,'DBH1212001 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(527,'DBH1212003C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212003C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(528,'DBH1212004 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(529,'DBH1212202 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(530,'DBH1212202C SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212202C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(531,'DBH1212203 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(532,'DBH1212402 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(533,'DBH1212404 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(534,'DBH1212803 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1212803','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(535,'DBH1213003 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1213003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(536,'DBH1213203 SDS plus hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1213203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(537,'DBH1241001 SDS max hammer drill 10*260mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1241001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(538,'DBH1241401 SDS max hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1241401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(539,'DBH1241805 SDS max hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1241805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(540,'DBH1242205 SDS max hammer drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBH1242205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(541,'DBIK4651 Weatherproof iron padlock 65mm - P6C36',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBIK4651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(542,'DBK21012 4 Digit Combination bicycle lock (with lock frame)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBK21012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(543,'DBM111041 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM111041','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(544,'DBM111061 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM111061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(545,'DBM111081 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM111081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(546,'DBM111102 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM111102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(547,'DBM111121 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM111121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(548,'DBM2110360 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM2110360','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(549,'DBM2110475 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM2110475','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(550,'DBM2110610 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM2110610','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(551,'DBM2110815 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM2110815','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(552,'DBM2111015 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM2111015','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(553,'DBM2111220 Masonry drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBM2111220','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(554,'DBPL0402 Heavy duty brass padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBPL0402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(555,'DBPL0502 Heavy duty brass padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBPL0502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(556,'DBPL0602 Heavy duty brass padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBPL0602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(557,'DBPL0702 Heavy duty brass padlock 70mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBPL0702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(558,'DBPL0702L Heavy duty long shackle brass padlock 70mm - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBPL0702L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(559,'DBPLK4402 4Pcs key-alike brass padlock set 40mm - C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBPLK4402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(560,'DBT01130121 HSS-CO M35 drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT01130121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(561,'DBT01130301 HSS-CO M35 drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT01130301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(562,'DBT01130401 HSS-CO M35 drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT01130401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(563,'DBT01130501 HSS-CO M35 drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT01130501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(564,'DBT01130601 HSS-CO M35 drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT01130601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(565,'DBT01130801 HSS-CO M35 drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT01130801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(566,'DBT01131001 HSS-CO M35 drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT01131001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(567,'DBT1100303 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1100303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(568,'DBT1100403 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1100403','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(569,'DBT1100503 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1100503','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(570,'DBT1100553 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1100553','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(571,'DBT1100603 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1100603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(572,'DBT1100803 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1100803','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(573,'DBT1101003 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1101003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(574,'DBT1101203 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1101203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(575,'DBT1101303 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1101303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(576,'DBT1200034 4341 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1200034','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(577,'DBT1200404 4341 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1200404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(578,'DBT1200504 4341 HSS drill bit 5mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1200504','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(579,'DBT1200604 4341 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1200604','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(580,'DBT1200804 4341 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1200804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(581,'DBT1201004 4341 HSS drill bit 10mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1201004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(582,'DBT1201204 4341 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1201204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(583,'DBT1201304 4341 HSS drill bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBT1201304','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(584,'DBW1220601 Wood Drill Bit 6mm - P100C400',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBW1220601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(585,'DBW1220801 Wood Drill Bit 8mm - P200',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBW1220801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(586,'DBW1221001 Wood Drill Bit 10mm - P50',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBW1221001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(587,'DBW1221201 Wood Drill Bit 12mm - P10C200',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DBW1221201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(588,'DC13501 Diesel tiller',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DC13501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(589,'DCB580288 Diamond core bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCB580288','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(590,'DCB580528 Diamond core bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCB580528','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(591,'DCB580658 Diamond core bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCB580658','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(592,'DCB580828 Diamond core bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCB580828','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(593,'DCB581028 Diamond core bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCB581028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(594,'DCB581228 Diamond core bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCB581228','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(595,'DCB581528 Diamond core bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCB581528','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(596,'DCM100015 DC/AC clamp meter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM100015','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(597,'DCM2001 Digital AC clamp meter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(598,'DCM6003 Digital AC clamp meter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM6003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(599,'DCM610001 Digital AC clamp meter 1000A 6000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM610001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(600,'DCM610002 DC/AC clamp meter 1000A 6000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM610002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(601,'DCM62001 Digital AC clamp meter 400A 4000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM62001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(602,'DCM62002 DC/AC clamp meter 400A 4000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM62002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(603,'DCM66001 Digital AC clamp meter 600A 4000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM66001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(604,'DCM66002 DC/AC clamp meter 600A 6000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DCM66002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(605,'DDM28001 Diamond drilling machine',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DDM28001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(606,'DDM38001 Diamond drilling machine',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DDM38001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(607,'DIPL0301 Iron padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DIPL0301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(608,'DIPL0501 Iron padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DIPL0501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(609,'DIPL0601 Iron padlock',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DIPL0601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(610,'DIPL0631L Long shackle iron padlock 63mm - C48',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DIPL0631L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(611,'DIPL0701 Iron padlock 75mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DIPL0701','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(612,'DIPLK4382 4Pcs key-alike Iron padlock set 38mm - C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DIPLK4382','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(613,'DLPK0401 Laminated padlock 40mm - C72',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DLPK0401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(614,'DLPK05004 4Pcs key-alike laminated padlock set 50mm - P6C18',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DLPK05004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(615,'DM200 Digital multimeter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(616,'DM2002 Digital multimeter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(617,'DM3028 Electrical test kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM3028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(618,'DM310004 Digital multimeter 1000V 6000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM310004','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(619,'DM36002 Digital multimeter 600V 4000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM36002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(620,'DM410003 Digital multimeter 1000V 20000 Counts',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM410003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(621,'DM6012 Digital multimeter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM6012','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(622,'DM7502 Digital multimeter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DM7502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(623,'DMD011102 Dry diamond disc 4 3/8\"x10mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(624,'DMD0111513 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD0111513','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(625,'DMD011152 Dry diamond disc 4.5\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(626,'DMD0111523 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD0111523','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(627,'DMD011152M Diamond disc set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011152M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(628,'DMD011251 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(629,'DMD011252 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011252','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(630,'DMD011252M Diamond disc set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011252M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(631,'DMD011254 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011254','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(632,'DMD011301 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(633,'DMD011801 Dry Diamond Disk 7\" - Ind - P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(634,'DMD0118013 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD0118013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(635,'DMD011802 Dry diamond disc 7\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(636,'DMD011802M Diamond disc set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD011802M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(637,'DMD012301 Dry Diamond Disc 9\" - Ind - P10C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD012301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(638,'DMD0123013 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD0123013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(639,'DMD012302 Dry diamond disc 9\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD012302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(640,'DMD0123023 Dry diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD0123023','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(641,'DMD012302M Diamond disc set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD012302M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(642,'DMD022002 Wet diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD022002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(643,'DMD022501 Wet diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD022501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(644,'DMD023002 Wet diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD023002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(645,'DMD031152 Turbo diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD031152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(646,'DMD031252 Turbo diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD031252','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(647,'DMD031802 Turbo diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD031802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(648,'DMD032301 Turbo diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD032301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(649,'DMD032302 Turbo diamond disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD032302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(650,'DMD033551 Diamond disc for asphalt and concrete cutting',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD033551','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(651,'DMD044052 Diamond disc for concrete cutting laser welded rim',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD044052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(652,'DMD063115 3Pcs diamond disc combo set - P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD063115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(653,'DMD064051 Diamond disc for asphalt cutting laser welded rim',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD064051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(654,'DMD081151HT Ultrathin diamond disc Mesh rim 4.5\" 10mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD081151HT','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(655,'DMD081251HT Ultrathin diamond disc Mesh rim 5\" 10mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD081251HT','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(656,'DMD081801HT Ultrathin diamond disc（Mesh rim）',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD081801HT','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:44','2025-05-23 06:00:44'),
(657,'DMD082301HT Ultrathin diamond disc（Mesh rim）',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DMD082301HT','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(658,'DP133505 Drill press',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DP133505','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(659,'DP207502 Drill Press 750w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DP207502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(660,'DP207505 Drill press',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DP207505','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(661,'DP3211001 Drill Press 1100w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DP3211001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(662,'DP3211005 Drill press',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DP3211005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(663,'DSTK2701 Anti-prying steel padlock 70mm - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DSTK2701','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(664,'DWP11001 4\" Deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP11001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(665,'DWP11001-SB Control box for deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP11001-SB','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(666,'DWP15001 4\" Deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP15001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(667,'DWP15001-SB Control box for deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP15001-SB','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(668,'DWP22001 4\" Deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP22001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(669,'DWP22001-SB Control box for deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP22001-SB','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(670,'DWP3701 4\" Deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP3701','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(671,'DWP3701-SB Control box for deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP3701-SB','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(672,'DWP5501 4\" Deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP5501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(673,'DWP5501-SB Control box for deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP5501-SB','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(674,'DWP7501 4\" Deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP7501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(675,'DWP7501-SB Control box for deep well pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWP7501-SB','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(676,'DWS10501 Drywall sander',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'DWS10501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(677,'ED2808 Electric drill 280w - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ED2808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(678,'ED4508 Electric drill 450w - P1C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ED4508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(679,'ED45658 Electric drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ED45658','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(680,'ED50028 Electric drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ED50028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(681,'ED500282 Electric drill',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ED500282','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(682,'EF1561 Exhaust fan',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EF1561','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(683,'EF2081 Exhaust fan',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EF2081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(684,'EF3081 Exhaust fan',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EF3081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(685,'EF38101 Exhaust fan',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EF38101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(686,'EF48121 Exhaust fan',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EF48121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(687,'EH5001 Electric hoist',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EH5001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(688,'EPB820121 Planer blade',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EPB820121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(689,'EPB820301 Planer blade',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EPB820301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(690,'ESF2002 Electronic safe',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ESF2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(691,'ESF2502 Electronic safe',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ESF2502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(692,'ESF3502 Electronic safe',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ESF3502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(693,'ESF5002 Electronic safe',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'ESF5002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(694,'EWSFC081001 Flux-cored wire',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'EWSFC081001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(695,'FBCPK1214 P20S Lithium-Ion battery and charger kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBCPK1214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(696,'FBCPK1222 P20S Lithium-Ion battery and charger kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBCPK1222','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(697,'FBCPK1424 P20S Lithium-Ion battery and charger kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBCPK1424','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(698,'FBCPK2425 P20S Lithium-Ion battery and charger kit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBCPK2425','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(699,'FBLI12151 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI12151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(700,'FBLI12152 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI12152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(701,'FBLI12153 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI12153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(702,'FBLI1620 Lithium-Ion battery pack 16v 2Ah',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI1620','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(703,'FBLI2001 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(704,'FBLI20011 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI20011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(705,'FBLI2002 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(706,'FBLI20021 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI20021','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(707,'FBLI2003 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(708,'FBLI20031 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI20031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(709,'FBLI2030 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI2030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(710,'FBLI2075 Lithium-Ion battery pack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FBLI2075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(711,'FCLI120502 Charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI120502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(712,'FCLI12071 S12 battery charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI12071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(713,'FCLI1613 M16 battery charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI1613','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(714,'FCLI2001 P20S battery charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(715,'FCLI2003 Fast Charger 20V - 4A',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(716,'FCLI2034 P20S battery charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI2034','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(717,'FCLI20411 P20S battery charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI20411','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(718,'FCLI2064 P20S battery charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI2064','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(719,'FCLI2082 P20S battery charger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FCLI2082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(720,'FD1151 Flap disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FD1151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(721,'FD1152 Flap disc 115mm*22mm- P60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FD1152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(722,'FD1153 Flap disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FD1153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(723,'FDZ1151 Zirconium flap disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FDZ1151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(724,'FDZ1152 Zirconium flap disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FDZ1152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(725,'FDZ1153 Zirconium flap disc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FDZ1153','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(726,'FPM501 Fountain pump 50w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FPM501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(727,'FS3208 Finishing sander 320w - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FS3208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(728,'FS3216 Finishing Sander 320W',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FS3216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(729,'FS35028 Finishing sander 350w - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'FS35028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(730,'GB543201 Gasoline blower 1.25KW - C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GB543201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(731,'GBC31264 Gasoline grass trimmer and bush cutter 0.81kw - C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GBC31264','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(732,'GBC45441 Gasoline Grass Trimmer & Bush Cutter- Old Model',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GBC45441','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(733,'GBC53144241 Gasoline grass trimmer and brush cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GBC53144241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(734,'GBC5434411 Gasoline grass trimmer and brush cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GBC5434411','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(735,'GBC5434421 Gasoline grass trimmer and brush cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GBC5434421','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(736,'GC6101 Gasoline tiller',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GC6101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(737,'GCP060-2 Gasoline plate compactor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCP060-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(738,'GCP100-1 Gasoline plate compactor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCP100-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(739,'GCP100-2 Gasoline plate compactor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCP100-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(740,'GCP125-2 Gasoline reversible plate compactor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCP125-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(741,'GCP160-2 Gasoline reversible plate compactor',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCP160-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(742,'GCS45182 Gasoline Chainsaw 18\" 45cc - P1C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCS45182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(743,'GCS45185 Gasoline chain saw 45.8cc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCS45185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(744,'GCS5261011 Gasoline chain saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCS5261011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(745,'GCS5451811 Gasoline chain saw 18\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCS5451811','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(746,'GCS5602411 Gasoline chain saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCS5602411','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(747,'GCS62241 Gasoline chain saw 62cc',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GCS62241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(748,'GDE30001 Diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GDE30001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(749,'GDE50001 Diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GDE50001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(750,'GDW65001 Diesel welder generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GDW65001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(751,'GE15005 Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE15005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(752,'GE30005 Gasoline generator 2.8kw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE30005','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(753,'GE30005-1 Gasoline Generator 2.8kw with Key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE30005-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(754,'GE35006 Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE35006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(755,'GE35006ES Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE35006ES','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(756,'GE55003 Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE55003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(757,'GE65006 Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE65006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(758,'GE75006 Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE75006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(759,'GE8002 Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE8002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(760,'GE90006 Gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GE90006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(761,'GEA55221-1 Earth auger',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEA55221-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(762,'GEA55221-2 Earth auger bits',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEA55221-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(763,'GEI23006 Inverter gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEI23006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(764,'GEI35006 Inverter gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEI35006','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(765,'GEI47506E Inverter gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEI47506E','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(766,'GEIF40001 Inverter gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEIF40001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(767,'GEIF55001 Inverter gasoline generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEIF55001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(768,'GEN1682 Gasoline engine',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEN1682','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(769,'GEN1882 Gasoline engine',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEN1882','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(770,'GEP201 Diesel water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEP201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(771,'GEP301 Diesel water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEP301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(772,'GEP401 Diesel water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GEP401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(773,'GG148 Glue gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GG148','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(774,'GG258 Glue gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GG258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(775,'GG308 Glue gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GG308','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(776,'GHPW2003 Gasoline pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GHPW2003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(777,'GHPW2103 Gasoline pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GHPW2103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(778,'GHPW2203 Gasoline pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GHPW2203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(779,'GHT5265511 Gasoline hedge trimmer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GHT5265511','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(780,'GLM141181 Gasoline lawn mower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GLM141181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(781,'GLM141182 Gasoline lawn mower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GLM141182','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(782,'GLM196201 Gasoline lawn mower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GLM196201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(783,'GLM196202 Gasoline lawn mower',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GLM196202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(784,'GMT55231 4-in-1 Gasoline Hedge trimmer multi tool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GMT55231','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(785,'GPT241-2 Gasoline power trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GPT241-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(786,'GPT361-2 Gasoline power trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GPT361-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(787,'GRG015001 Grease gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GRG015001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(788,'GRT75-2 Gasoline tamping rammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GRT75-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(789,'GSE100K1 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE100K1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(790,'GSE100K1.1 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE100K1.1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(791,'GSE100K3-1 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE100K3-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(792,'GSE150K1-1 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE150K1-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(793,'GSE150K3.1 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE150K3.1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(794,'GSE300K3.1 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE300K3.1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(795,'GSE50001 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE50001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(796,'GSE50003 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE50003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(797,'GSE500K3-1 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE500K3-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(798,'GSE65001 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE65001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(799,'GSE80001 Silent diesel generator',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSE80001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(800,'GSF16-2 Gasoline floor saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GSF16-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(801,'GVR-2 Gasoline concrete vibrator(Claw type)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GVR-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(802,'GWP202 Gasoline water pump 2\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GWP202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(803,'GWP302 Gasoline water pump 3\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GWP302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(804,'GWP402 Gasoline water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GWP402','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(805,'GWPLI201801 Cordless water pump',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'GWPLI201801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(806,'HAB2A01 Alkaline battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HAB2A01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(807,'HAB3A01 Alkaline battery',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HAB3A01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(808,'HADW131068 Adjustable wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HADW131068','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(809,'HADW131082 Adjustable wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HADW131082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(810,'HADW131088 Adjustable wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HADW131088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(811,'HADW131102 Adjustable wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HADW131102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(812,'HADW131108 Adjustable wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HADW131108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(813,'HADW131128 Adjustable wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HADW131128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:45','2025-05-23 06:00:45'),
(814,'HADWK031 3 Pcs Adjustable wrench set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HADWK031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(815,'HAS123002 Angle square',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HAS123002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(816,'HASS01 Acetic Silicone Sealant（White）',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HASS01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(817,'HASS02 Acetic Silicone Sealant（Transparent）',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HASS02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(818,'HASS03 Acetic Silicone Sealant（Black）',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HASS03','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(819,'HAX02012508 Axe 1250g',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HAX02012508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(820,'HAX0206008 Axe 600g',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HAX0206008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(821,'HBC0812 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(822,'HBC0814 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0814','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(823,'HBC0818 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(824,'HBC0824 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0824','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(825,'HBC0830 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0830','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(826,'HBC0836 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0836','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(827,'HBC0842 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0842','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(828,'HBC0848 Bolt cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC0848','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(829,'HBC1812 Bolt Cutter 12\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC1812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(830,'HBC1814 Bolt Cutter 14\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC1814','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(831,'HBC1818 Bolt Cutter 18\" - P1C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC1818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(832,'HBC1824 Bolt cutter 24\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC1824','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(833,'HBC1830 Bolt cutter 30\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBC1830','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(834,'HBJ1202 Hydraulic bottle jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBJ1202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(835,'HBJ202 Hydraulic bottle jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBJ202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(836,'HBJ5002 Hydraulic bottle jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBJ5002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(837,'HBJ602 Hydraulic bottle jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBJ602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(838,'HBP0101 Tools Backpack - P1C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBP0101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(839,'HBP01028 Tool backpack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBP01028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(840,'HBPH81016 Ball pein hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBPH81016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(841,'HBPHS8016 Ball pein hammer 16oz - P6C18',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBPHS8016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(842,'HBSL08060 Heavy-duty mason\'s level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBSL08060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(843,'HBT1018 Bricklaying trowel 10\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBT1018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(844,'HBT618 Bricklaying trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBT618','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(845,'HBT818 Bricklaying trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBT818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(846,'HBTCP2001 Booster cable',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBTCP2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(847,'HBTCP6008 Booster cable',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBTCP6008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(848,'HBTCP6008L Booster cable with lamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBTCP6008L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(849,'HBV084 Bench vice',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBV084','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(850,'HBV086 Bench vice',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBV086','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(851,'HBV088 Bench vice',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HBV088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(852,'HCB0501 Hole core bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCB0501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(853,'HCB0651 Hole core bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCB0651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(854,'HCB0801 Hole core bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCB0801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(855,'HCB1001 Hole core bit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCB1001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(856,'HCBK0101 Chain block',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCBK0101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(857,'HCBK0102 Chain block',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCBK0102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(858,'HCBK0103 Chain block',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCBK0103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(859,'HCBK0105 Chain block',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCBK0105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(860,'HCC0841016 Concrete chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCC0841016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(861,'HCC0841218 Concrete chisel 300mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCC0841218','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(862,'HCC850419 Concrete chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCC850419','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(863,'HCCB0124 Cable cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCB0124','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(864,'HCCB0136 Cable cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCB0136','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(865,'HCCL082210 Cold chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCL082210','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(866,'HCCL082412 Cold Chisel Flat',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCL082412','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 16:15:11'),
(867,'HCCL852519 Cold chisel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCL852519','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(868,'HCCP58180 Compound action combination pliers 7\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCP58180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(869,'HCCP58200 Compound action combination pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCP58200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(870,'HCCPS01180 4 Pcs circlip pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCPS01180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(871,'HCCPS26180 4 Pcs circlip pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCCPS26180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(872,'HCDCP58200 Compound action diagonal cutting pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCDCP58200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(873,'HCFL186503 Rechargable Flashlight - P6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCFL186503','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(874,'HCFL1865051 Flashlight',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCFL1865051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(875,'HCG0109 Aluminum caulking gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCG0109','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(876,'HCG0309 Caulking Gun - P12C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCG0309','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(877,'HCG1809 Caulking gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCG1809','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(878,'HCH0416 Claw hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH0416','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(879,'HCH80808 Claw hammer 8oz p6C36 - Old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH80808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(880,'HCH80816 Claw hammer 16oz - P6C18 - old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH80816','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(881,'HCH80820 Claw Hammer 20oz- P6C18',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH80820','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(882,'HCH81008 Claw hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH81008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(883,'HCH81016 Claw hammer 16oz 450g',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH81016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(884,'HCH81016L Claw hammer 16oz metal front',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH81016L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(885,'HCH81020 Claw hammer 20oz',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCH81020','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 16:13:55'),
(886,'HCHS8008 Claw Hammer 8oz - P6C36',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCHS8008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(887,'HCHS8016 Claw Hammer 16oz - P6C18',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCHS8016','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(888,'HCJLW0210 Curved jaw locking plier',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCJLW0210','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(889,'HCLNP58200 Compound action long nose pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCLNP58200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(890,'HCLR0130 Chalk line reel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCLR0130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(891,'HCP08168 Combination pliers 6\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCP08168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(892,'HCP08188 Combination pliers 7\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCP08188','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(893,'HCP08208 Combination pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCP08208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(894,'HCP12160 Combination pliers 6\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCP12160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(895,'HCP12200 Combination pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCP12200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(896,'HCSPA081 Combination spanner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCSPA081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(897,'HCSPA101 Combination spanner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCSPA101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(898,'HCSPA121 Combination spanner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCSPA121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(899,'HCSPA141 Combination spanner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCSPA141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(900,'HCSPA161 Combination spanner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCSPA161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(901,'HCT1001 Cable ties',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCT1001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(902,'HCT3002 Cable ties',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCT3002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(903,'HCT5001 Cable ties',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCT5001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(904,'HCT8001 Cable ties',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HCT8001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(905,'HDAR20701 Digital angle ruler',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDAR20701','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(906,'HDCD28150 Digital caliper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDCD28150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(907,'HDCD28200 Digital caliper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDCD28200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(908,'HDCP00101 Digital tread depth gauge 25.4mm - P25C100',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDCP00101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(909,'HDCP08168 Diagonal cutting pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDCP08168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(910,'HDCP12160 Diagonal cutting pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDCP12160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(911,'HDCP16150 Plastic digital caliper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDCP16150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(912,'HDL105081 Down light',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDL105081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(913,'HDLR225241 Round LED panel light',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDLR225241','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(914,'HDM01 Dust mask',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDM01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(915,'HDM02 Dust mask',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDM02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(916,'HDM04 Dust mask - C50C1000',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDM04','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(917,'HDM07 Dust mask with valve - ind - P20C240',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDM07','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(918,'HDM31 Non-medical mask',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDM31','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(919,'HDMW23 Digital display measuring wheel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDMW23','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(920,'HDMW45 Measuring wheel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDMW45','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(921,'HDTC02071P Roller cabinet',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HDTC02071P','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:46','2025-05-23 06:00:46'),
(922,'HEC21 Engine crane',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HEC21','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(923,'HEC21-1 Engine crane for base part',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HEC21-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(924,'HEC21-2 Engine crane for hydraulic part',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HEC21-2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(925,'HECP28160 End cutting pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HECP28160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(926,'HEM01 Earmuff - P15C60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HEM01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(927,'HEP02 Earplug',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HEP02','C128',NULL,NULL,0,NULL,'','','','','','','','','','','','','','','','','','','','','',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 16:13:14'),
(928,'HEPS25281 Extendable pole saw & pruner',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HEPS25281','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(929,'HES0188 Electrician\'s scissors',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HES0188','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(930,'HES03041V Extension socket',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HES03041V','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(931,'HESA31003 Electronic scale',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA31003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(932,'HESA3203 Spring scale 20Kg',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA3203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(933,'HESA33003 Electronic scale',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA33003','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(934,'HESA3303 Electronic scale',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA3303','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(935,'HESA3404 Electronic scale',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA3404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(936,'HESA41801 Body Scale - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA41801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(937,'HESA41802 Body Scale 180kg - SS',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA41802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(938,'HESA51501 Spring scale',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA51501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(939,'HESA5601 Spring scale',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESA5601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(940,'HESFC02501 Fan controller',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESFC02501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(941,'HESSH01103 Switch (2-Way)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESSH01103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(942,'HESSH02103 Switch (2-Way)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESSH02103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(943,'HESST0213A Socket',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESST0213A','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(944,'HESST1116A Universal socket with switch',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESST1116A','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(945,'HESST30001 Socket tester',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HESST30001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(946,'HETAN01 Digital anemometer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HETAN01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(947,'HETGA01 Digital gas indicators',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HETGA01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(948,'HETHT01 Digital humidity&temperature meter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HETHT01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(949,'HETSL01 Digital sound level meter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HETSL01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(950,'HETWM01 Wood moisture meters',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HETWM01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(951,'HFB4301 Fix brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFB4301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(952,'HFC020501 F clamp with plastic handle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC020501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(953,'HFC020502 F clamp 5x20cm 8\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC020502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(954,'HFC020503 F clamp with plastic handle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC020503','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(955,'HFC020802 F clamp 8x30cm 12\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC020802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(956,'HFC021202 F clamp with plastic handle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC021202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(957,'HFC021203 F clamp with plastic handle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC021203','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(958,'HFC021204 F clamp with plastic handle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC021204','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(959,'HFC021205 F clamp 12x60cm 24\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC021205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(960,'HFC021401 F clamp 14x120cm 48\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC021401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(961,'HFC021404 F clamp with plastic handle',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFC021404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(962,'HFJ201 Hydraulic floor jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFJ201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(963,'HFJ251 Hydraulic floor jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFJ251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(964,'HFJ301 Hdraulic Floor Jack 3ton - Old - P1C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFJ301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(965,'HFJ302 Hydraulic floor jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFJ302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(966,'HFL013AAA1 Flashlight',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFL013AAA1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(967,'HFL013AAA58 Flashlight',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFL013AAA58','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(968,'HFMFT0115 Foldable multi-function tool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMFT0115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(969,'HFMT8130 Fibreglass measuring tape 30mx12.5mm - P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMT8130','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(970,'HFMT82100 Fibreglass Measuring Tape 100m - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMT82100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(971,'HFMT8250 Fibreglass measuring tape 50mx12.5mm - P10C30',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMT8250','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(972,'HFMT83100 Fibreglass measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMT83100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(973,'HFMT8320 Fibreglass measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMT8320','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(974,'HFMT8330 Fibreglass measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMT8330','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(975,'HFMT8350 Fibreglass measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFMT8350','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(976,'HFOR321 Folding hand riveter 32\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFOR321','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(977,'HFSPC01 Face Shield - C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFSPC01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(978,'HFSPC32 Face shield',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFSPC32','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(979,'HFSW18028C Folding saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HFSW18028C','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(980,'HG200028 Heat gun 2000w - C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG200028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(981,'HG200028-1 Heat gun 2000w set - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG200028-1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(982,'HG200038 Heat Gun 2000w - 3 - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG200038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(983,'HG2000385 Heat Gun - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG2000385','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(984,'HG200047 Heat gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG200047','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(985,'HG200058 Heat gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG200058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(986,'HG2000581 Heat gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG2000581','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(987,'HG200078 Heat gun 2000w with accessories',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG200078','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(988,'HG20008 Heat Gun 2000w - 2 - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HG20008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(989,'HGA0131 Heat gun accessories',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGA0131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(990,'HGC0104 G clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGC0104','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(991,'HGC0105 G clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGC0105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(992,'HGC0106 G clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGC0106','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:47','2025-05-23 06:00:47'),
(993,'HGC0108 G clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGC0108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(994,'HGCG01-L Cut-resistance gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGCG01-L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(995,'HGCG01-XL Cut-resistance gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGCG01-XL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(996,'HGCG02-XL Cut-resistance gloves XL',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGCG02-XL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(997,'HGCT02 Glass cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGCT02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(998,'HGCT03 Heavy duty glass cutter 178mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGCT03','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(999,'HGCT16001 Compasses glass cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGCT16001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1000,'HGLI2002 Cordless heat gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGLI2002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1001,'HGLI20025 Cordless heat gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGLI20025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1002,'HGMG01-XL Mechanic gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGMG01-XL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1003,'HGNF03 Nitrile frosted coated gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGNF03','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1004,'HGNG01 Nitrile gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGNG01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1005,'HGNG01.L Nitrile gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGNG01.L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1006,'HGNG02-L Disposable nitrile gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGNG02-L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1007,'HGNG04 Nitrile gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGNG04','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1008,'HGPUG01 PU Coated Gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGPUG01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1009,'HGPUG02 PU Coated Gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGPUG02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1010,'HGVC01 Leather gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVC01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1011,'HGVK05 Knitted&PVC dots gloves XL',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVK05','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1012,'HGVL05 Latex gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVL05','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1013,'HGVL06 Latex gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVL06','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1014,'HGVL08-XL Latex gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVL08-XL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1015,'HGVP01 PVC gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVP01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1016,'HGVP02 PVC gloves L',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVP02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1017,'HGVW01 Welding leather gloves 14\" - C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVW01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1018,'HGVW02 Welding leather gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVW02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1019,'HGVW04 Welding leather gloves',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HGVW04','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1020,'HHAS08400 Hand saw 16\" - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS08400','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1021,'HHAS08450 Hand Saw 18\" - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS08450','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1022,'HHAS08500 Hand saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS08500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1023,'HHAS08550 Hand saw 22\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS08550','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1024,'HHAS15400 Hand saw 16\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS15400','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1025,'HHAS15450 Hand saw 18\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS15450','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1026,'HHAS38400 Hand saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS38400','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1027,'HHAS38500 Hand saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHAS38500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1028,'HHCP28180 High leverage combination pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHCP28180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1029,'HHCS01121 Plastic hose connector',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHCS01121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1030,'HHCS01341 Plastic hose connector',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHCS01341','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1031,'HHCS03122 3 Pcs hose quick connectors set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHCS03122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1032,'HHCS05122 5 Piece twist nozzle set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHCS05122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1033,'HHCT01240 Hydraulic crimping tool  16-300mm2 70kN',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHCT01240','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1034,'HHCT0170 Hydraulic crimping tool',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHCT0170','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1035,'HHF3008 Hacksaw frame 12\"-ind',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHF3008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1036,'HHF3028 Hacksaw Frame 12\" - 2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHF3028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1037,'HHF3038 Hacksaw frame 12\" - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHF3038','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1038,'HHF3088 Hacksaw frame',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHF3088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1039,'HHFS3068 Hacksaw frame 12\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHFS3068','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1040,'HHK11091 Hex key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK11091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1041,'HHK11092 Hex key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK11092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1042,'HHK12091 Ball point hex key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK12091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1043,'HHK12092 Ball point hex key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK12092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1044,'HHK13091 Torx key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK13091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1045,'HHK13092 Torx key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK13092','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1046,'HHK14081 Hex key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK14081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1047,'HHK14082 Ball point hex key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK14082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1048,'HHK14083 Torx key',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHK14083','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1049,'HHKSET0181 18 Pcs hex key and torx key set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHKSET0181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1050,'HHKT80818 8 Pcs T-handle hex wrench set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHKT80818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1051,'HHL013AAA2 Headlamp - P6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHL013AAA2','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1052,'HHL013AAA5 Head Lamp 100 Lumens - C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHL013AAA5','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1053,'HHL013AAA8 Headlamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHL013AAA8','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1054,'HHLDCP28180 High leverage diagonal cutting pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHLDCP28180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1055,'HHLNP28200 High leverage long nose pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHLNP28200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1056,'HHPT01251 Hand pallet truck',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHPT01251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1057,'HHPT01301 Hand pallet truck',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHPT01301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1058,'HHR40122 Hose reel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHR40122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1059,'HHS6001 Hedge shear',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHS6001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1060,'HHS62011 Hedge shear 550mm - P10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHS62011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1061,'HHS6301 Hedge shear',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHS6301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1062,'HHSC0112 Hydraulic steel cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHSC0112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1063,'HHSC0112B Hydraulic steel cutter blades',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHSC0112B','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1064,'HHWB64018G Wheel barrow pneumatic 150kg',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHWB64018G','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1065,'HHWB64018G-W Pneumatic wheel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHWB64018G-W','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1066,'HHWM102 Welding mask',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HHWM102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1067,'HICP28208 Insulated combination pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HICP28208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1068,'HIHLDCP28160 Insulated high leverage diagonal cutting pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HIHLDCP28160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1069,'HIKPS28318 3 Pcs insulated pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HIKPS28318','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1070,'HILNP28168 Insulated long nose pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HILNP28168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1071,'HISD814100 Insulated screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HISD814100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1072,'HISD815125 Insulated screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HISD815125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1073,'HISD81PH2100 Insulated screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HISD81PH2100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1074,'HIT010381 Infrared Thermometer - P5C30',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HIT010381','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1075,'HIT0155028 Infrared thermometer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HIT0155028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1076,'HJATL2281.L Jackets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HJATL2281.L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1077,'HJATL2281.XL Jackets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HJATL2281.XL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1078,'HJATL2281.XXL Jackets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HJATL2281.XXL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1079,'HJS0301 Jack stand',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HJS0301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1080,'HKCPS5831 3 Pcs compound action pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKCPS5831','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1081,'HKCPS5841 4 Pcs compound action pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKCPS5841','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1082,'HKETS0111 11Pcs Electricians Tools Set - P10C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKETS0111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1083,'HKETS0261 26Pcs Electricians Tools Set - P4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKETS0261','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:48','2025-05-23 06:00:48'),
(1084,'HKHLPS2831 3 Pcs high leverage pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKHLPS2831','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1085,'HKISD0608 6 Pcs insulated screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKISD0608','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1086,'HKISD0908 9 Pcs insulated screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKISD0908','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1087,'HKISSD12101 10 Pcs 1/2\"DR. impact socket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKISSD12101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1088,'HKISSD12102L 10 Pcs 1/2\" deep impact socket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKISSD12102L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1089,'HKITH1601 16 Pcs insulated hand tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKITH1601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1090,'HKITH2601 26 Pcs insulated hand tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKITH2601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1091,'HKITH4101 41PCS insulated hand tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKITH4101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1092,'HKNCB181 10 Pcs 18mm knife blades set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNCB181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1093,'HKNS110915 Snap-off blade knife - P12C144',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS110915','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1094,'HKNS112505 Snap-off blade knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS112505','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1095,'HKNS11807 Snap-off blade knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS11807','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1096,'HKNS11815 Snap-off blade knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS11815','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1097,'HKNS16001 Snap-off blade knife 18x100mm - P50C300',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS16001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1098,'HKNS16518 Snap-off blade knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS16518','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1099,'HKNS1806 Snap-off blade knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS1806','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1100,'HKNS28035 Snap-off blade knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNS28035','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1101,'HKNSB112 10 Pcs 18mm knife blades set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNSB112','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1102,'HKNSB181 10pcs blades set - P30C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNSB181','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1103,'HKNSB2501 10 Pcs blades set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKNSB2501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1104,'HKPS08311 3Pcs pliers set - P5C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKPS08311','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1105,'HKPS08318 3 Pcs pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKPS08318','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1106,'HKPT0101 Kneepads',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKPT0101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1107,'HKSD0428 4 Pcs screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD0428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1108,'HKSD0458 4 Pcs screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD0458','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1109,'HKSD0618 6Pcs precision screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD0618','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1110,'HKSD0628 6 Pcs screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD0628','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1111,'HKSD0658 6 Pcs screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD0658','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1112,'HKSD0718 7Pcs precision screwdriver set - P6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD0718','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1113,'HKSD10028 100 Pcs screwdriver  set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD10028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1114,'HKSD1058 10 Pcs screwdriver and precision screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD1058','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1115,'HKSD1428 14 Pcs screwdriver and precision screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD1428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1116,'HKSD2658 26 Pcs screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSD2658','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1117,'HKSDB0268 26 Pcs screwdriver bit set - P12',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSDB0268','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1118,'HKSDB0348 32Pcs precision screwdriver set - P10C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSDB0348','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1119,'HKSDB0558 55 Pcs screwdriver bits set S2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSDB0558','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1120,'HKSDS0428 4 Pcs screwdriver set S2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSDS0428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1121,'HKSDS0628 6 Pcs screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSDS0628','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1122,'HKSDS0828 8 Pcs screwdriver set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSDS0828','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1123,'HKSPA1068 6Pcs Combination spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPA1068','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1124,'HKSPA1088 8Pcs Combination spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPA1088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1125,'HKSPA1143 12Pcs Combination spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPA1143','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1126,'HKSPA2088 8Pcs Double open end spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPA2088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1127,'HKSPA2142 12Pcs Double open end spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPA2142','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1128,'HKSPA3088 8Pcs Offset ring spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPA3088','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1129,'HKSPA3142 12Pcs Offset ring spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPA3142','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1130,'HKSPAR1061 Ratchet spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPAR1061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1131,'HKSPAR1082 8 Pcs ratchet spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPAR1082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1132,'HKSPAR1083 8 Pcs flexible ratchet spanner set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKSPAR1083','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1133,'HKTAC010671 67 Pcs accessories set - P1C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTAC010671','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1134,'HKTAC010861 86 Pcs accessories set - P10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTAC010861','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1135,'HKTAC011201 120 Pcs accessories set - P5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTAC011201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1136,'HKTCB121001 Cylinder brush 11 in 1 set(Inner wall)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTCB121001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1137,'HKTF63 6 Pcs file set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTF63','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1138,'HKTFS0508 5 Pcs steel file set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTFS0508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1139,'HKTFS1308 3 Pcs steel file set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTFS1308','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1140,'HKTFW0308 3 Pcs wood file set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTFW0308','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1141,'HKTH10258 25pcs handtools set - P5C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTH10258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1142,'HKTH10807 7 Pcs hand tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTH10807','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1143,'HKTH20809 9 Pcs hand tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTH20809','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1144,'HKTHP10321 32 pcs handtools set - P1C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP10321','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1145,'HKTHP10811 81 Pcs Tools Set - C5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP10811','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1146,'HKTHP10891 89 Pcs Tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP10891','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1147,'HKTHP11022 101 Pcs tools set - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP11022','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1148,'HKTHP11081 108PCS Tools SET - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP11081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1149,'HKTHP11111 111 Pcs household tools set - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP11111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1150,'HKTHP11151 115 Pcs tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP11151','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1151,'HKTHP11271 127 Pcs Household Tools Set - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP11271','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1152,'HKTHP11651 165 Pcs Tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP11651','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1153,'HKTHP21001 100 Pcs tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP21001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1154,'HKTHP21171 117 Pcs tools set - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP21171','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1155,'HKTHP21201 120Pcs Handtools Set - P1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP21201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1156,'HKTHP21421 142 Pcs combination tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP21421','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1157,'HKTHP21471 147 Pcs handtools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP21471','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1158,'HKTHP21681 168 Pcs handtools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP21681','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1159,'HKTHP22161 216 Pcs combination tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTHP22161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1160,'HKTS0243 24 Pcs 1/2\" socket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTS0243','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1161,'HKTS12122 12 Pcs 1/2\" socket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTS12122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1162,'HKTS12201 20 Pcs 1/2\" socket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTS12201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1163,'HKTS12251 25 Pcs 1/2\" socket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTS12251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1164,'HKTS12602 62 Pcs 1/2\" socket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTS12602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1165,'HKTTS0511 51 Pcs Telecom Tools set - C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTTS0511','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1166,'HKTTS1108 Tiling tools set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTTS1108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1167,'HKTV01H091 9 Pcs Insulated Hantools Set - P5C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTV01H091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1168,'HKTV01H111 11 Pcs Household Tools Set - P5C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTV01H111','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1169,'HKTV01H291 29 Pcs household tools set- P5C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTV01H291','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1170,'HKTWC0401 4 Pcs wood chisel set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTWC0401','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1171,'HKTWCS301 3 Pcs wood chisel set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HKTWCS301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1172,'HLAD01051 Double side ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD01051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1173,'HLAD01061 Double side ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD01061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1174,'HLAD01071 Double side ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD01071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1175,'HLAD01081 Double side ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD01081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1176,'HLAD03391 3 Section extention ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD03391','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1177,'HLAD04431 Multi-purpose aluminum ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD04431','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1178,'HLAD04441 Multi-purpose aluminum ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD04441','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1179,'HLAD06031 Household ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD06031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1180,'HLAD06041 Household ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD06041','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1181,'HLAD06051 Household ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD06051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1182,'HLAD06061 Household ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD06061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1183,'HLAD06071 Household ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD06071','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1184,'HLAD06081 Household ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD06081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1185,'HLAD06091 Household ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD06091','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1186,'HLAD08061 Telescopic ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD08061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1187,'HLAD08101 Telescopic ladder',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLAD08101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1188,'HLBACD2141 Led bulb(Day light）',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLBACD2141','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1189,'HLBACD291 Led bulb(Day light）',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLBACD291','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1190,'HLBACD3201T LED T lamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLBACD3201T','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1191,'HLBACD3301T LED T lamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLBACD3301T','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1192,'HLBACD3401T LED T lamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLBACD3401T','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1193,'HLDD0608 Laser distance detector',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLDD0608','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1194,'HLDD0708 Laser distance detector 70m - P1C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLDD0708','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1195,'HLFJ0501 Hydraulic long floor jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLFJ0501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1196,'HLFJ1001 Hydraulic long floor jack',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLFJ1001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1197,'HLFL3301 LED Floodlight 30w - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLFL3301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:49','2025-05-23 06:00:49'),
(1198,'HLFL3501 LED Floodlight 50w - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLFL3501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1199,'HLL156508 Self-leveling line laser',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLL156508','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1200,'HLL156601 Self-leveling line laser green 2 lines 35m',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLL156601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1201,'HLL255267 3D Green Beam Self-Leveling Laser Level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLL255267','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1202,'HLL305205 Self-leveling line laser(Green laser beams)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLL305205','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1203,'HLL306505 Self-leveling line laser(Red laser beams)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLL306505','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1204,'HLLT01152 Tripods for laser levels',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLLT01152','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1205,'HLNP08168 Long nose pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLNP08168','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1206,'HLNP12160 Long nose pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLNP12160','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1207,'HLPLS215301 LED panel light',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLPLS215301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1208,'HLRL30051 Self-leveling rotary laser level - P1C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLRL30051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1209,'HLT72011 Lopper 27\" - P10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLT72011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1210,'HLT78033 3 Pcs garden shears set - P6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HLT78033','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1211,'HMFCP28200 8-in-1 Multi-function combination pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMFCP28200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1212,'HMFH0121 Multi-function hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMFH0121','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1213,'HMFK8158 Multi-function knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMFK8158','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1214,'HMFLNP28200 6-in-1 Multi-function long nose pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMFLNP28200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1215,'HMH040300 Machinist hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMH040300','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1216,'HMH821500 Machinist hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMH821500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1217,'HMH82300 Machinist hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMH82300','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1218,'HMH82500 Machinist hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMH82500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1219,'HMH880300 Machinist hammer 300g - old - P6C36',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMH880300','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1220,'HMH880500 Machinist hammer 500g - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMH880500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1221,'HMH881500 Machinist hammer 1500g - P4C12',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMH881500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1222,'HMHS83001 Machinist hammer 300g - P6C36',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMHS83001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1223,'HMK23036 2 Measuring tapes and 3 utility knives set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMK23036','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1224,'HMPC1468P Modular plug crimper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMPC1468P','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1225,'HMPCN2468R Modular plug crimper',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMPCN2468R','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1226,'HMPS06115 6 Pcs mini pliers set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMPS06115','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1227,'HMSL01030 Mini spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMSL01030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1228,'HMSL03101 Hand level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HMSL03101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1229,'HPB36201 Patio brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPB36201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1230,'HPC0232 Pipe cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPC0232','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1231,'HPCS05428 PVC pipe cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPCS05428','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1232,'HPET1013 PVC insulating tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPET1013','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1233,'HPET1103 PVC insulating tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPET1103','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1234,'HPFT71 Pipe flaring tool set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPFT71','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1235,'HPH2001 1/2\" PVC hose',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPH2001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1236,'HPH5001 3/4\" PVC hose',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPH5001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1237,'HPHT13002 Foldable platform hand truck',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPHT13002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1238,'HPK01981 Pocket knife 198mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPK01981','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1239,'HPK02101 Pocket knife 210mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPK02101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1240,'HPK82001 Cable stripping knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPK82001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1241,'HPK82101 Cable stripping knife',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPK82101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1242,'HPL01300 Iron planer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPL01300','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1243,'HPP04400 Pump pliers 16\"/400mm - P4C16',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPP04400','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1244,'HPP28251 Pump pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPP28251','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1245,'HPP28258 Pump pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPP28258','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1246,'HPS0109 Pruning shear',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPS0109','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1247,'HPS0601 Pruning shear',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPS0601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1248,'HPS13601 Plastic auto gear sprinkler',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPS13601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1249,'HPS23602 Plastic 3 arm rotatory sprinkler',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPS23602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1250,'HPT231025 Plastering Trowel 230x100mm - P10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPT231025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1251,'HPT23108 Plastering trowel 230x100mm - P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPT23108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1252,'HPT28138 Plastering trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPT28138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1253,'HPTT231025 Plastering trowel with teeth\' P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPTT231025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1254,'HPTT23108 Plastering Trowel with Teeth - P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPTT23108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1255,'HPTT28138 Plastering trowel with teeth',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPTT28138','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1256,'HPTW200N1 Torque wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPTW200N1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1257,'HPUT08060 Putty trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT08060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1258,'HPUT08080 Putty trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT08080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1259,'HPUT08100 Putty trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT08100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1260,'HPUT08125 Putty trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT08125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1261,'HPUT08150 Putty trowel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT08150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1262,'HPUT20011 Drywall taping knives 8\" - P10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT20011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1263,'HPUT25011 Drywall taping knives 10\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT25011','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1264,'HPUT38200 Drywall taping knives 8\" - P10C60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT38200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1265,'HPUT68050 Putty trowel 2\" - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT68050','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1266,'HPUT68075 Putty trowel 3\" - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT68075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1267,'HPUT68100 Putty trowel 4\" - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT68100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1268,'HPUT68125 Putty trowel 5\" - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT68125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1269,'HPUT6860125 Putty Trowel 5\'\' - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT6860125','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1270,'HPUT686063 Putty Trowel 2.5\" - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT686063','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1271,'HPUT686075 Putty Trowel 3\" 75mm - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT686075','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1272,'HPUT686100 Putty trowel 4\' - P12C120',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT686100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1273,'HPUT78200 Drywall taping knives',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT78200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1274,'HPUT78250 Drywall taping knives',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPUT78250','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1275,'HPW0808 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1276,'HPW0810 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0810','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1277,'HPW0812 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1278,'HPW0814 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0814','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1279,'HPW0818 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0818','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1280,'HPW0824 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0824','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1281,'HPW0836 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0836','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1282,'HPW0848 Pipe wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW0848','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1283,'HPW18082 Pipe Wrench 8\" C36',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW18082','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1284,'HPW18102 Pipe Wrench 10\" - P6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPW18102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1285,'HPWR12008 High pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR12008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1286,'HPWR14008 High pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR14008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1287,'HPWR15028 High pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR15028','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1288,'HPWR16008 High pressure washer 1600W',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR16008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1289,'HPWR18008 High pressure washer 1800w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR18008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1290,'HPWR20008 High pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR20008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1291,'HPWR20018 High pressure washer 2000w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR20018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1292,'HPWR25008 High pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR25008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1293,'HPWR28008 High pressure washer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR28008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1294,'HPWR30008 High pressure washer 3000w',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR30008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1295,'HPWR30018 High pressure washer(For commercial use)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HPWR30018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1296,'HQBC01601 Quick bar clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HQBC01601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1297,'HQBC01602 Quick bar clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HQBC01602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1298,'HQBC01603 Quick bar clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HQBC01603','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1299,'HQBC24802 Quick bar clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HQBC24802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1300,'HQSC0206 Spring clamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HQSC0206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1301,'HR104 Hand riveter 10.5\"- P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HR104','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1302,'HR105 Hand riveter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HR105','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1303,'HR131 Hand riveter 13\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HR131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1304,'HR171 Hand riveter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HR171','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:50','2025-05-23 06:00:50'),
(1305,'HRB8702 Rotary brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRB8702','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1306,'HRCEP0201 Telescopic rod',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCEP0201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1307,'HRCPG05210 Ratchet crimping plier',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCPG05210','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1308,'HRCTL031.L Rain coat',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTL031.L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1309,'HRCTL031.M Rain coat',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTL031.M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1310,'HRCTL031.XL Rain coat',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTL031.XL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1311,'HRCTL031.XXL Rain coat',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTL031.XXL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1312,'HRCTL031.XXXL Rain coat',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTL031.XXXL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1313,'HRCTSKT031.L Rain suit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTSKT031.L','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1314,'HRCTSKT031.M Rain suit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTSKT031.M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1315,'HRCTSKT031.XL Rain suit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTSKT031.XL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1316,'HRCTSKT031.XXL Rain suit',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRCTSKT031.XXL','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1317,'HRHT042301 Cylinder brush Inner Wall 9\" - P20C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT042301','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1318,'HRHT042301D Cylinder brush(Inner wall)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT042301D','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1319,'HRHT042302 Cylinder brush Outer Wall 9\" - P20C400',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT042302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1320,'HRHT042302D Cylinder brush(Outer wall)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT042302D','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1321,'HRHT061001 Cylinder brush Inner wall - 4\" - P50C100',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT061001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1322,'HRHT061001D Mini cylinder brush(Inner wall)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT061001D','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1323,'HRHT093051 Cylinder Brush(Inner wall)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT093051','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1324,'HRHT281002 Mini cylinder brush(Inner wall)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT281002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1325,'HRHT282302 Cylinder brush(Inner wall)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT282302','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1326,'HRHT442302T Telescoping cylinder brush',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRHT442302T','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1327,'HRLF4415 Cordless portable lamp',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRLF4415','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1328,'HRP02200 Rabbet pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRP02200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1329,'HRP02230 Rabbet pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRP02230','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1330,'HRP02250 Rabbet pliers',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRP02250','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1331,'HRPH8140 Rubber and plastic hammer 40mm - P10C30',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRPH8140','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1332,'HRRTB2015 Rolling rigid tool bag',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRRTB2015','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1333,'HRS108 Hand riveter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRS108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1334,'HRSP2101 Ratchet straps',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRSP2101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1335,'HRSP2107 Ratchet straps 2 Ton - C16',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRSP2107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1336,'HRSP3101 Ratchet straps',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRSP3101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1337,'HRSP3107 Ratchet straps 3 Ton - C6',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRSP3107','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1338,'HRSP5101 Ratchet straps',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRSP5101','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1339,'HRTH0812 Ratchet wrench',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRTH0812','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1340,'HRUH8208 Rubber hammer 8oz - P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8208','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1341,'HRUH8216 Rubber Hammer 16oz - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8216','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1342,'HRUH8308 Rubber hammer 8oz White - P10C40',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8308','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1343,'HRUH8316 Rubber hammer 16oz White - P6C24',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8316','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1344,'HRUH8808 Rubber hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1345,'HRUH8816 Rubber hammer black 16oz 450g',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8816','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1346,'HRUH8908 Rubber hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8908','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1347,'HRUH8916 Rubber hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8916','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1348,'HRUH8940 Rubber and plastic hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HRUH8940','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1349,'HS285100 Slotted screwdriver 100 mm - ind',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS285100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1350,'HS286150 Slotted screwdriver 150 mm - ind',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS286150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1351,'HS28PH1100 PH screwdriver 100 mm - ind - P12C144',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS28PH1100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1352,'HS28PH2150 PH screwdriver 150 mm - ind P12C144',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS28PH2150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1353,'HS585100 Slotted screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS585100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1354,'HS586150 Slotted screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS586150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1355,'HS58PH1100 Phillips screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS58PH1100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1356,'HS58PH2150 Phillips screwdriver',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HS58PH2150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1357,'HSA01 Arbor for hole saw',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSA01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1358,'HSB10810 Shelf bracket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSB10810','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1359,'HSB11214 Shelf bracket set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSB11214','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1360,'HSB4061 6Pcs Carbide gritted hole saw set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSB4061','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1361,'HSBB12186 Bi-Metal hacksaw blade',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSBB12186','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1362,'HSBB12246 Bi-Metal hacksaw blade',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSBB12246','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1363,'HSBB12326 Bi-Metal Hacksaw Blade 32T - P100C500',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSBB12326','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1364,'HSBKT12185 Bi-Metal hacksaw blade set 18T 12\"',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSBKT12185','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1365,'HSCRS811002 Scissors 8.5\" 215mm - C100',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSCRS811002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1366,'HSCRS812108 Rubber grip long-blade scissors',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSCRS812108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1367,'HSCRS832558 Rubber grip long-blade heavy duty scissors',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSCRS832558','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1368,'HSDT1408 Test pencil',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSDT1408','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1369,'HSDT1908 Test pencil',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSDT1908','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1370,'HSDT2201 Test pencil Digital 12-220v - C96',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSDT2201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1371,'HSFR24008 Fine rubber float',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSFR24008','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1372,'HSFR24108 Rubber grout float',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSFR24108','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1373,'HSG02 Safety goggles',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1374,'HSG04 Safety goggles plain',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG04','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1375,'HSG05 Safety goggles',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG05','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1376,'HSG06 Safety goggles',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG06','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1377,'HSG07 Safety goggles(Only for welding)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG07','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1378,'HSG10 Safety goggles Full Cover 180 - P20C100',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG10','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1379,'HSG14018 Staple gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG14018','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1380,'HSG1403 Staple gun - P5',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG1403','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1381,'HSG1404 Heavy duty staple gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG1404','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1382,'HSG1405 3 In 1 staple gun',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG1405','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1383,'HSG142 Safety goggles - P30',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSG142','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1384,'HSGU3122 Super glue(Included 12pcs)',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSGU3122','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1385,'HSGW01 Welding goggles',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSGW01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1386,'HSH201 Safety helmet',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH201','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1387,'HSH202 Safety helmet',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1388,'HSH206 Safety helmet - yellow - C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH206','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1389,'HSH207 Safety helmet - blue - C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH207','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1390,'HSH209 Safety helmet - white - C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH209','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1391,'HSH210 Safety helmet - red - C20',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH210','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1392,'HSH501415 Safety harness',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH501415','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1393,'HSH501420 Safety harness',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH501420','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1394,'HSH501502 Safety Harness - C10',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH501502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1395,'HSH501802 Safety harness - 3 Attachment point',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSH501802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1396,'HSJP0110 Straight jaw plier',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSJP0110','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1397,'HSL08060D Digital level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL08060D','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1398,'HSL08120 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL08120','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1399,'HSL08150 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL08150','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1400,'HSL08180 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL08180','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1401,'HSL08200 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL08200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1402,'HSL10403 Spirit level set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL10403','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1403,'HSL18040 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL18040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1404,'HSL18060 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL18060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1405,'HSL18080 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL18080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1406,'HSL18100 Spirit level 100cm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL18100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1407,'HSL28080 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL28080','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1408,'HSL28100 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL28100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1409,'HSL38040M Spirit level with powerful magnets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL38040M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1410,'HSL38060M Spirit level with powerful magnets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL38060M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1411,'HSL38080M Spirit level with powerful magnets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL38080M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1412,'HSL38100M Spirit level with powerful magnets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL38100M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1413,'HSL38120M Spirit level with powerful magnets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL38120M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1414,'HSL38150M Spirit level with powerful magnets',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL38150M','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1415,'HSL58040 Spirit level 40cm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL58040','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1416,'HSL58060 Spirit level 60cm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL58060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1417,'HSL58100 Spirit level',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSL58100','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1418,'HSLB0030 Lever block',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSLB0030','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1419,'HSLB0060 Lever block',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSLB0060','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1420,'HSMT0803 Steel measuring tape 3mx16mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT0803','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1421,'HSMT0803.1 Steel measuring tape 3mx16mm - metric',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT0803.1','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1422,'HSMT0805 Steel measuring tape 5mx25mm - P12C60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT0805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1423,'HSMT08052 Steel measuring tape 5mx19mm - P12C60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT08052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1424,'HSMT0808 Steel measuring tape 8mx25mm - P12C48',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT0808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1425,'HSMT0810 Steel measuring tape 10mx25mm - P6C36',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT0810','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1426,'HSMT081025 Steel measuring tape 10m',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT081025','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1427,'HSMT08316 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT08316','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1428,'HSMT0833 Steel measuring tape 3mx16mm - econ - P12C60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT0833','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1429,'HSMT0835 Steel measuring tape 5mx25mm - econ - P12C60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT0835','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1430,'HSMT08352 Steel measuring tape 5mx19mm - econ - P12C60',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT08352','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1431,'HSMT08519 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT08519','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1432,'HSMT08525 Steel measuring tape 5*25mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT08525','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1433,'HSMT08825 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT08825','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1434,'HSMT39316 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT39316','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1435,'HSMT39519 Steel measuring tape 5*19mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT39519','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1436,'HSMT39525 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT39525','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1437,'HSMT39825 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT39825','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1438,'HSMT8420 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT8420','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1439,'HSMT8430 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT8430','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1440,'HSMT8550 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT8550','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1441,'HSMT8805 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT8805','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:51','2025-05-23 06:00:51'),
(1442,'HSMT88052 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT88052','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1443,'HSMT8808 Steel measuring tape',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSMT8808','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1444,'HSPP20202 Pressure sprayer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSPP20202','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1445,'HSPP30102 Pump sprayer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSPP30102','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1446,'HSPP30502 Pressure sprayer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSPP30502','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1447,'HSPP30802 Pressure sprayer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSPP30802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1448,'HSPP41602 Knapsack sprayer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSPP41602','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1449,'HSPP42002 Knapsack sprayer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSPP42002','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1450,'HSSL09 Steel shovel head',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSSL09','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1451,'HSSLH05 Steel shovel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSSLH05','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1452,'HSSLH06 Steel shovel',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSSLH06','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1453,'HSTH03598 Stoning hammer 5kg - p1C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH03598','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1454,'HSTH041000 Stoning hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH041000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1455,'HSTH81000 Stoning hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH81000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1456,'HSTH81500 Stoning hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH81500','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1457,'HSTH82000 Stoning hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH82000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1458,'HSTH83598 Stoning hammer',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH83598','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1459,'HSTH8802 Stoning hammer 1000g - P6C12 - old',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH8802','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1460,'HSTH8803 Stoning Hammer 1500g - P4C12',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH8803','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1461,'HSTH8804 Stoning hammer 2000g - P4C8',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTH8804','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1462,'HSTHS81000 Stoning hammer 1000g - P6C12',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSTHS81000','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1463,'HSU012501 Sucker',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSU012501','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1464,'HSU025001 Sucker',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HSU025001','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1465,'HTB02 Tool box',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTB02','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1466,'HTB03 Tool box',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTB03','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1467,'HTB06 Drawer portable tool box',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTB06','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1468,'HTBG03 Tools Bag 16\" - 20kg',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBG03','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1469,'HTBG09 Tools bag',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBG09','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1470,'HTBG28131 Tools bag 13\" - P20C40 OLD',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBG28131','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1471,'HTBG281328 Tool bag',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBG281328','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1472,'HTBG28161 Tools Bag 16\" - P10C20 OLD',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBG28161','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1473,'HTBG281628 Tool bag',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBG281628','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1474,'HTBGL01 Industrial Tools Bag - P2C4',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBGL01','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1475,'HTBP02031 Tool bag',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBP02031','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1476,'HTBP020328 Tool bag',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBP020328','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1477,'HTBP030128 Drill holster',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTBP030128','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1478,'HTC041200 Tile cutter 1200mm - C2',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC041200','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1479,'HTC04600 Tile cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC04600','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1480,'HTC04600B Tile Cutter Blade for 600mm Cutter - P1C50',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC04600B','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1481,'HTC04601 Tile cutter 600mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC04601','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1482,'HTC04601B Tile cutter blade for HTC04601 & HTC04801',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC04601B','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1483,'HTC04800AG Tile cutter',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC04800AG','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1484,'HTC04800B Tile Cutter Blade for Cutter 800mm - P1C50',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC04800B','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1485,'HTC04801 Tile cutter 800mm',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTC04801','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1486,'HTCS151081 108 Pcs tool chest set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTCS151081','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1487,'HTCS15591 59 Pcs tool chest set - P1C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTCS15591','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1488,'HTCS220971 97pcs Tool Chest Set - P1C1',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTCS220971','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1489,'HTCS221321 132 Pcs tool chest set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTCS221321','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,1,NULL,NULL,0,0,'2025-05-23 06:00:52','2025-05-23 06:00:52'),
(1490,'HTCS271621 162 Pcs Tool Chest Set',1,'single',1,NULL,NULL,1,26,NULL,NULL,'exclusive',1,0.0000,'HTCS271621','C128',NULL,NULL,0,'','','','','',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,N