<?php
	// ZEBRA ZP888 SAFE CONSTANTS
	$printable_width = 3.27;   // inches (Zebra printable)
	$gap_x = 0.08;             // column gap
	$gap_y = 0.08;             // row gap
	$sticker_width = 1.6;      // (3.27 - gap) / 2
	$sticker_height= 1.02;
?>

<table align="center"
	style="
		width: <?php echo e($printable_width, false); ?>in;
		border-spacing: <?php echo e($gap_x, false); ?>in <?php echo e($gap_y, false); ?>in;
		table-layout: fixed;
	">

<?php $__currentLoopData = $page_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

	<?php if($loop->index % 2 == 0): ?>
	<tr>
	<?php endif; ?>

	<td style="
		width: <?php echo e($sticker_width, false); ?>in;
		vertical-align: center;
		padding: 0;
	">

		
		<div style="
			width: <?php echo e($sticker_width, false); ?>in;
			height: <?php echo e($sticker_height, false); ?>in;
			padding-top: 0.04in;
			box-sizing: border-box;
			text-align: center;
			overflow: hidden;
		">

			
			<div style="page-break-inside: avoid;">

				
				<?php if(!empty($print['business_name'])): ?>
					<div style="font-size:<?php echo e($print['business_name_size'], false); ?>px;font-weight:bold;">
						<?php echo e($business_name, false); ?>

					</div>
				<?php endif; ?>

				
				<?php if(!empty($print['name'])): ?>
					<div style="font-size:<?php echo e($print['name_size'], false); ?>px;">
						<?php echo e($page_product->product_actual_name, false); ?>

						<?php if(!empty($print['lot_number']) && !empty($page_product->lot_number)): ?>
							<span style="font-size:10px;">
								(<?php echo e($page_product->lot_number, false); ?>)
							</span>
						<?php endif; ?>
					</div>
				<?php endif; ?>

				
				<?php if(!empty($print['variations']) && $page_product->is_dummy != 1): ?>
					<div style="font-size:<?php echo e($print['variations_size'], false); ?>px;">
						<?php echo e($page_product->product_variation_name, false); ?>:
						<b><?php echo e($page_product->variation_name, false); ?></b>
					</div>
				<?php endif; ?>

				
				<?php
					$custom_labels = json_decode(session('business.custom_labels'), true);
					$product_custom_fields = $custom_labels['product'] ?? [];
				?>

				<?php $__currentLoopData = $product_custom_fields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<?php $field = 'product_custom_field'.$loop->iteration; ?>
					<?php if(!empty($cf) && !empty($page_product->$field) && !empty($print[$field])): ?>
						<div style="font-size:<?php echo e($print[$field.'_size'], false); ?>px;">
							<b><?php echo e($cf, false); ?>:</b> <?php echo e($page_product->$field, false); ?>

						</div>
					<?php endif; ?>
				<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

				
				<?php if(!empty($print['price'])): ?>
					<div style="font-size:<?php echo e($print['price_size'], false); ?>px;">
						<?php echo app('translator')->get('lang_v1.price'); ?>:
						<b>
							<?php echo e(session('currency')['symbol'] ?? '', false); ?>

							<?php if($print['price_type'] === 'inclusive'): ?>
								<?php echo e(number_format($page_product->sell_price_inc_tax, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>

							<?php else: ?>
								<?php echo e(number_format($page_product->default_sell_price, session('business.currency_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?>

							<?php endif; ?>
						</b>
					</div>
				<?php endif; ?>

				
				<?php if(!empty($print['exp_date']) && !empty($page_product->exp_date)): ?>
					<div style="font-size:<?php echo e($print['exp_date_size'], false); ?>px;">
						<b><?php echo app('translator')->get('product.exp_date'); ?>:</b> <?php echo e($page_product->exp_date, false); ?>

					</div>
				<?php endif; ?>

				
				<?php if(!empty($print['packing_date']) && !empty($page_product->packing_date)): ?>
					<div style="font-size:<?php echo e($print['packing_date_size'], false); ?>px;">
						<b><?php echo app('translator')->get('lang_v1.packing_date'); ?>:</b> <?php echo e($page_product->packing_date, false); ?>

					</div>
				<?php endif; ?>

				
				<div style="margin-top:0.04in;page-break-inside:avoid; padding-right:0.04in;">
					<img
						src="data:image/png;base64,<?php echo e(DNS1D::getBarcodePNG(
							$page_product->sub_sku,
							$page_product->barcode_type,
							2,
							80,
							[0,0,0],
							false
						), false); ?>"
						style="
							width:98%;
							
							display:block;
							margin:0 auto;
							image-rendering:pixelated;
						"
					>
					<span style="display:block;font-size:6px;margin-top:2px;">
						<?php echo e($page_product->sub_sku, false); ?>

					</span>
				</div>

			</div>
		</div>
	</td>

	<?php if($loop->iteration % 2 == 0): ?>
	</tr>
	<?php endif; ?>

<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</table>

<style>
	td {
		border: 1px dotted lightgray;
	}

	@media print {

		@page {
			size: 3.35in auto;
			margin: 0;
		}

		table {
			page-break-after: always;
		}

		img {
			image-rendering: pixelated;
		}
	}
</style>
<?php /**PATH /home/uklcablr/royalefansenterprise.com/resources/views/labels/partials/preview_2.blade.php ENDPATH**/ ?>