<?php $__env->startSection('title', __('lang_v1.product_stock_details')); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black"><?php echo e(__('lang_v1.product_stock_details'), false); ?></h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-primary" id="accordion">
              <div class="box-header with-border">
                <h3 class="box-title">
                  <a data-toggle="collapse" data-parent="#accordion" href="#collapseFilter">
                    <i class="fa fa-filter" aria-hidden="true"></i> <?php echo app('translator')->get('report.filters'); ?>
                  </a>
                </h3>
              </div>
              <div id="collapseFilter" class="panel-collapse active collapse in" aria-expanded="true">
                <div class="box-body">
                    <div class="row">
                        <?php echo Form::open(['url' => action([\App\Http\Controllers\ReportController::class, 'productStockDetails']), 'method' => 'get' ]); ?>

                        <div class="col-md-4">
                            <div class="form-group">
                            <?php echo Form::label('search_product', __('lang_v1.search_product') . ':'); ?>

                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-search"></i>
                                    </span>
                                    <?php echo Form::select('variation_id', [], null, ['class' => 'form-control', 'id' => 'variation_id', 'placeholder' => __('lang_v1.search_product_placeholder')]); ?>

                                </div>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <?php echo Form::label('location_id', __('purchase.business_location').':'); ?>

                                <div class="input-group">
                                    <span class="input-group-addon">
                                        <i class="fa fa-map-marker"></i>
                                    </span>
                                    <?php echo Form::select('location_id', $business_locations, (!empty($location) ? $location->id: null), ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'required']); ?>

                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <br>
                                <button type="submit" class="tw-dw-btn tw-dw-btn-primary tw-text-white"><?php echo app('translator')->get('lang_v1.search'); ?></button>
                            </div>
                        </div>
                        <?php echo Form::close(); ?>

                    </div>

                    <?php if(!empty($stock_details)): ?>
                        <div class="col-md-12">
                        <hr>
                        <div class="row">
                            <div class="table-responsive">
                            <table class="table">
                                <tr>
                                    <th>
                                        Product
                                    </th>
                                    <th>
                                        <?php echo e(__('report.opening_stock'), false); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('home.total_purchase'), false); ?>:
                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_purchase_return'), false); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('report.total_stock_adjustment'), false); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_stock_transfered_to_the_location'), false); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_sold'), false); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_sell_return'), false); ?>

                                    </th>
                                    <th>
                                        <?php echo e(__('lang_v1.total_stock_transfered_from_the_location'), false); ?>

                                    </th>
                                    <th>
                                        Total Manufactured
                                    </th>
                                    <th>
                                        Total Used For Production
                                    </th>
                                    <th>
                                        Correct Stock
                                        <small>(<?php echo e(__('lang_v1.total_stock_calculated'), false); ?>)</small>
                                    </th>
                                    <th>
                                        Incorrect Stock
                                        <small>(<?php echo e(__('lang_v1.total_stock_available'), false); ?>)</small>
                                    </th>
                                    <th>
                                        Fix
                                    </th>
                                </tr>

                            <?php $__currentLoopData = $stock_details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $stock_mismatch = round($row->stock) - round($row->total_stock_calculated);
                                ?>
                                <?php if($stock_mismatch == 0): ?>
                                    <?php continue; ?>
                                <?php endif; ?>

                                <tr>
                                    <td>
                                        <?php echo e($row->product, false); ?> 
                                        <?php if($row->type == "variable"): ?>     
                                            <?php echo e($row->product_variation, false); ?> - <?php echo e($row->variation_name, false); ?> (<?php echo e($row->sub_sku, false); ?>) 
                                        <?php else: ?> 
                                            (<?php echo e($row->sku, false); ?>) 
                                        <?php endif; ?>
                                    </td>

                                    <td>
                                        <?php echo e($row->total_opening_stock, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_purchased, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_purchase_return, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_adjusted, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sell_transfered, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sold, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sell_return, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_sell_transfered, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_manufactured, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_ingredients_used, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->total_stock_calculated, false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($row->stock, false); ?>

                                    </td>
                                    <td>
                                        <a href="<?php echo e(action([\App\Http\Controllers\ReportController::class, 'adjustProductStock']), false); ?>?location_id=<?php echo e($location->id, false); ?>&variation_id=<?php echo e($row->variation_id, false); ?>&stock=<?php echo e($row->total_stock_calculated, false); ?>" class="btn btn-primary">Fix</a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </table>
                        </div>
                        </div>
                        </div>
                    <?php endif; ?>
                </div>
              </div>
            </div>
        </div>
    </div>
</section>
<!-- /.content -->
<div class="modal fade view_register" tabindex="-1" role="dialog" 
    aria-labelledby="gridSystemModalLabel">
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script src="<?php echo e(asset('js/report.js?v=' . $asset_v), false); ?>"></script>
    <script type="text/javascript">
        $(document).ready( function () {
            //get customer
            $('#variation_id').select2({
                ajax: {
                    url: '/purchases/get_products',
                    dataType: 'json',
                    delay: 250,
                    data: function (params) {
                        return {
                          term: params.term, // search term
                        };
                    },
                    processResults: function (data) {
                        var data_formated = [];
                        data.forEach(function (item) {
                            var temp = {
                                'id': item.variation_id,
                                'text': item.text
                            }
                            data_formated.push(temp);
                        });
                        return {
                            results: data_formated
                        };
                    }
                },
                minimumInputLength: 1,
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/uklcablr/royalefansenterprise.com/resources/views/report/product_stock_details.blade.php ENDPATH**/ ?>