@php
	// ZEBRA ZP888 SAFE CONSTANTS
	$printable_width = 3.25;   // inches
	$gap_x = 0.1;             // column gap
	$gap_y = 0.1;             // row gap
	$sticker_width = 1.6;
	$sticker_height = 1.0;
@endphp

<table
	align="center"
	style="
		width: {{$printable_width}}in;
		table-layout: fixed;
		border-collapse: collapse;
	"
>

@foreach($page_products as $page_product)

	@if($loop->index % 2 === 0)
	<tr>
	@endif

	<td style="
		width: {{$sticker_width}}in;
		height: {{$sticker_height}}in;
		padding: {{$gap_y}}in {{$gap_x}}in;
		vertical-align: top;
	">

		{{-- STICKER --}}
		<div style="
			width: {{$sticker_width}}in;
			height: {{$sticker_height}}in;
			box-sizing: border-box;
			padding-top: 0.04in;
			overflow: hidden;
		">

			<div style="page-break-inside: avoid; text-align:center;">

				{{-- BUSINESS NAME --}}
				@if(!empty($print['business_name']))
					<div style="font-size:{{$print['business_name_size']}}px;font-weight:bold;">
						{{$business_name}}
					</div>
				@endif

				{{-- PRODUCT NAME --}}
				@if(!empty($print['name']))
					<div style="font-size:10px;">
						{{$page_product->product_actual_name}}
						@if(!empty($print['lot_number']) && !empty($page_product->lot_number))
							<span style="font-size:10px;">
								({{$page_product->lot_number}})
							</span>
						@endif
					</div>
				@endif

				{{-- VARIATION --}}
				@if(!empty($print['variations']) && $page_product->is_dummy != 1)
					<div style="font-size:{{$print['variations_size']}}px;">
						{{$page_product->product_variation_name}}:
						<b>{{$page_product->variation_name}}</b>
					</div>
				@endif

				{{-- CUSTOM FIELDS --}}
				@php
					$custom_labels = json_decode(session('business.custom_labels'), true);
					$product_custom_fields = $custom_labels['product'] ?? [];
				@endphp

				@foreach($product_custom_fields as $cf)
					@php $field = 'product_custom_field'.$loop->iteration; @endphp
					@if(!empty($cf) && !empty($page_product->$field) && !empty($print[$field]))
						<div style="font-size:{{$print[$field.'_size']}}px;">
							<b>{{$cf}}:</b> {{$page_product->$field}}
						</div>
					@endif
				@endforeach

				{{-- PRICE --}}
				@if(!empty($print['price']))
					<div style="font-size:{{$print['price_size']}}px;">
						@lang('lang_v1.price'):
						<b>
							{{session('currency')['symbol'] ?? ''}}
							@if($print['price_type'] === 'inclusive')
								{{@num_format($page_product->sell_price_inc_tax)}}
							@else
								{{@num_format($page_product->default_sell_price)}}
							@endif
						</b>
					</div>
				@endif

				{{-- EXPIRY --}}
				@if(!empty($print['exp_date']) && !empty($page_product->exp_date))
					<div style="font-size:{{$print['exp_date_size']}}px;">
						<b>@lang('product.exp_date'):</b> {{$page_product->exp_date}}
					</div>
				@endif

				{{-- PACKING DATE --}}
				@if(!empty($print['packing_date']) && !empty($page_product->packing_date))
					<div style="font-size:{{$print['packing_date_size']}}px;">
						<b>@lang('lang_v1.packing_date'):</b> {{$page_product->packing_date}}
					</div>
				@endif

				{{-- BARCODE --}}
				<div style="
					margin-top: 0.04in;
					display: flex;
					justify-content: center;
					transform: translateX(-0.03in);
				">
					<img
						src="data:image/png;base64,{{ DNS1D::getBarcodePNG(
							$page_product->sub_sku,
							$page_product->barcode_type,
							3.0,
							90,
							[0,0,0],
							false
						)}}"
						style="
						width: 1.45in;
						height: 0.6in;
						image-rendering: pixelated;
						"
					>
				</div>

				<span style="display:block;font-size:10px;margin-top:2px;">
					{{$page_product->sub_sku}}
				</span>

			</div>
		</div>
	</td>

	@if($loop->iteration % 2 === 0)
	</tr>
	@endif

@endforeach

</table>

<style>
	td {
		border: 1px dotted lightgray;
	}

	@media print {

		@page {
			size: 3.25in auto;
			margin: 0;
		}

		body {
			margin: 0;
		}

		table {
			page-break-after: always;
		}

		img {
			image-rendering: pixelated;
		}
	}
</style>
